% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EmpiricalDistribution.R
\docType{class}
\name{EmpiricalDistribution}
\alias{EmpiricalDistribution}
\title{An empirical distribution}
\description{
An R6 class representing an empirical (1D) distribution.
}
\details{
An object representing an empirical distribution. It inherits
from class \code{Distribution}.
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:Distribution]{rdecision::Distribution}} -> \code{EmpiricalDistribution}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{EmpiricalDistribution$new()}}
\item \href{#method-distribution}{\code{EmpiricalDistribution$distribution()}}
\item \href{#method-mean}{\code{EmpiricalDistribution$mean()}}
\item \href{#method-mode}{\code{EmpiricalDistribution$mode()}}
\item \href{#method-SD}{\code{EmpiricalDistribution$SD()}}
\item \href{#method-sample}{\code{EmpiricalDistribution$sample()}}
\item \href{#method-quantile}{\code{EmpiricalDistribution$quantile()}}
\item \href{#method-clone}{\code{EmpiricalDistribution$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Distribution" data-id="order">}\href{../../rdecision/html/Distribution.html#method-order}{\code{rdecision::Distribution$order()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Distribution" data-id="r">}\href{../../rdecision/html/Distribution.html#method-r}{\code{rdecision::Distribution$r()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Distribution" data-id="varcov">}\href{../../rdecision/html/Distribution.html#method-varcov}{\code{rdecision::Distribution$varcov()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an object of class \code{EmpiricalDistribution}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EmpiricalDistribution$new(x, interpolate.sample = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{a sample of at least 1 numerical value from the population
of interest.}

\item{\code{interpolate.sample}}{Logical; if true, each call to \code{sample()}
make a random draw from \eqn{U_{0,1}} to find a \eqn{p} value, then
finds that quantile of the sample, using the \code{quantile} function
in R, via interpolation from the eCDF. If false, the \code{sample()}
function makes a random draw from \code{x}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Empirical distributions based on very small sample sizes are
supported, but not recommended.
}

\subsection{Returns}{
An object of class \code{EmpiricalDistribution}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-distribution"></a>}}
\if{latex}{\out{\hypertarget{method-distribution}{}}}
\subsection{Method \code{distribution()}}{
Accessor function for the name of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EmpiricalDistribution$distribution()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Distribution name as character string.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mean"></a>}}
\if{latex}{\out{\hypertarget{method-mean}{}}}
\subsection{Method \code{mean()}}{
Return the expected value of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EmpiricalDistribution$mean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Expected value as a numeric value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mode"></a>}}
\if{latex}{\out{\hypertarget{method-mode}{}}}
\subsection{Method \code{mode()}}{
Return the mode of the distribution,
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EmpiricalDistribution$mode()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
NA because an empirical distribution is not guaranteed to be
unimodal.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SD"></a>}}
\if{latex}{\out{\hypertarget{method-SD}{}}}
\subsection{Method \code{SD()}}{
Return the standard deviation of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EmpiricalDistribution$SD()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Standard deviation as a numeric value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sample"></a>}}
\if{latex}{\out{\hypertarget{method-sample}{}}}
\subsection{Method \code{sample()}}{
Draw and hold a random sample from the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EmpiricalDistribution$sample(expected = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expected}}{If TRUE, sets the next value retrieved by a call to
\code{r()} to be the mean of the distribution.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Samples with interpolation or by random draw from the
supplied distribution (see parameter \code{interpolate.sample} in
\code{new()}).
}

\subsection{Returns}{
Updated distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-quantile"></a>}}
\if{latex}{\out{\hypertarget{method-quantile}{}}}
\subsection{Method \code{quantile()}}{
Return the quantiles of the empirical uncertainty distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EmpiricalDistribution$quantile(probs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{probs}}{Vector of probabilities, in range [0,1].}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector of quantiles.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EmpiricalDistribution$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
