% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModVar.R
\docType{class}
\name{ModVar}
\alias{ModVar}
\title{\verb{ModVar} class}
\description{
An R6 class for a variable in an health economic model
}
\details{
Base class for a variable used in a health economic model. The base 
class, which is not intended to be directly instantiated by model
applications, wraps a numerical value which is used in calculations.
The base class provides a framework for creating classes of model
variables whose uncertainties are described by statistical distributions
parametrized with hyperparameters.
}
\author{
Andrew Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ModVar$new()}}
\item \href{#method-is_expression}{\code{ModVar$is_expression()}}
\item \href{#method-is_probabilistic}{\code{ModVar$is_probabilistic()}}
\item \href{#method-description}{\code{ModVar$description()}}
\item \href{#method-units}{\code{ModVar$units()}}
\item \href{#method-distribution}{\code{ModVar$distribution()}}
\item \href{#method-r}{\code{ModVar$r()}}
\item \href{#method-mean}{\code{ModVar$mean()}}
\item \href{#method-mode}{\code{ModVar$mode()}}
\item \href{#method-SD}{\code{ModVar$SD()}}
\item \href{#method-quantile}{\code{ModVar$quantile()}}
\item \href{#method-set}{\code{ModVar$set()}}
\item \href{#method-get}{\code{ModVar$get()}}
\item \href{#method-clone}{\code{ModVar$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an object of type \verb{ModVar}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModVar$new(description, units)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{description}}{A character string description of the variable
and its role in the model. This description will be used in a
tabulation of the variables linked to a model.}

\item{\code{units}}{A character string description of the units, e.g. 
\code{GBP}, \code{per year}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \verb{ModVar} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_expression"></a>}}
\if{latex}{\out{\hypertarget{method-is_expression}{}}}
\subsection{Method \code{is_expression()}}{
Is this \verb{ModVar} an expression?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModVar$is_expression()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if it inherits from \verb{ExprModVar}, \verb{FALSE}
otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_probabilistic"></a>}}
\if{latex}{\out{\hypertarget{method-is_probabilistic}{}}}
\subsection{Method \code{is_probabilistic()}}{
Tests whether the model variable is probabilistic, i.e. a random
variable that follows a distribution, or an expression involving
random variables, some of which follow distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModVar$is_probabilistic()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if probabilistic
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-description"></a>}}
\if{latex}{\out{\hypertarget{method-description}{}}}
\subsection{Method \code{description()}}{
Accessor function for the description.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModVar$description()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Description of model variable as character string.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-units"></a>}}
\if{latex}{\out{\hypertarget{method-units}{}}}
\subsection{Method \code{units()}}{
Accessor function for units.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModVar$units()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Description of units as character string.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-distribution"></a>}}
\if{latex}{\out{\hypertarget{method-distribution}{}}}
\subsection{Method \code{distribution()}}{
Accessor function for the name of the uncertainty distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModVar$distribution()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Distribution name as character string.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-r"></a>}}
\if{latex}{\out{\hypertarget{method-r}{}}}
\subsection{Method \code{r()}}{
Draw a random sample from the model variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModVar$r(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of samples to draw.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A sample drawn at random.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mean"></a>}}
\if{latex}{\out{\hypertarget{method-mean}{}}}
\subsection{Method \code{mean()}}{
Return the mean value of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModVar$mean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Mean value as a numeric value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mode"></a>}}
\if{latex}{\out{\hypertarget{method-mode}{}}}
\subsection{Method \code{mode()}}{
Return the mode of the variable. By default returns NA, which will be
the case for most \verb{ExprModVar} variables, because an arbitrary
expression is not guaranteed to be unimodal.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModVar$mode()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Mode as a numeric value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SD"></a>}}
\if{latex}{\out{\hypertarget{method-SD}{}}}
\subsection{Method \code{SD()}}{
Return the standard deviation of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModVar$SD()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Standard deviation as a numeric value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-quantile"></a>}}
\if{latex}{\out{\hypertarget{method-quantile}{}}}
\subsection{Method \code{quantile()}}{
Find quantiles of the uncertainty distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModVar$quantile(probs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{probs}}{Numeric vector of probabilities, each in range [0,1].}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector of numeric values of the same length as \verb{probs}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set"></a>}}
\if{latex}{\out{\hypertarget{method-set}{}}}
\subsection{Method \code{set()}}{
Sets the value of the \verb{ModVar} that will be returned by subsequent
calls to \code{get()} until \code{set()} is called again.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModVar$set(what = "random")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{what}}{Character: one of "random" (samples from the uncertainty
distribution), "expected" (mean), "q2.5" (lower 95% confidence limit),
"q50" (median), "q97.5" (upper 95% confidence limit), "current" (leaves
the value unchanged). The "current" option is provided to support having
common functions to set (or leave alone) sets of model variables, 
depending on their use case.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Updated \verb{ModVar}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get"></a>}}
\if{latex}{\out{\hypertarget{method-get}{}}}
\subsection{Method \code{get()}}{
Gets the value of the \verb{ModVar} that was set by the most recent call
to \code{set()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModVar$get()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value determined by last \code{set()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModVar$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
