% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reaction.R
\docType{class}
\name{Reaction}
\alias{Reaction}
\title{\verb{Reaction} class}
\description{
An R6 class to represent a reaction (chance) edge in a decision tree.
}
\details{
A specialism of class Arrow which is used in a decision tree to
represent edges with source nodes joined to \verb{ChanceNode}s.
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super classes}{
\code{\link[rdecision:Edge]{rdecision::Edge}} -> \code{\link[rdecision:Arrow]{rdecision::Arrow}} -> \code{Reaction}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Reaction$new()}}
\item \href{#method-modvars}{\code{Reaction$modvars()}}
\item \href{#method-p}{\code{Reaction$p()}}
\item \href{#method-cost}{\code{Reaction$cost()}}
\item \href{#method-benefit}{\code{Reaction$benefit()}}
\item \href{#method-clone}{\code{Reaction$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="endpoints">}\href{../../rdecision/html/Edge.html#method-endpoints}{\code{rdecision::Edge$endpoints()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="is_same_edge">}\href{../../rdecision/html/Edge.html#method-is_same_edge}{\code{rdecision::Edge$is_same_edge()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="label">}\href{../../rdecision/html/Edge.html#method-label}{\code{rdecision::Edge$label()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Arrow" data-id="source">}\href{../../rdecision/html/Arrow.html#method-source}{\code{rdecision::Arrow$source()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Arrow" data-id="target">}\href{../../rdecision/html/Arrow.html#method-target}{\code{rdecision::Arrow$target()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an object of type \verb{Reaction}. A probability must be assigned
to the edge. Optionally, a cost and a benefit may be associated
with traversing the edge. A \dfn{pay-off} (benefit-cost) is sometimes
used in edges of decision trees; the parametrization used here is more
general.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reaction$new(source, target, p, cost = 0, benefit = 0, label = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{Chance node from which the arrow leaves.}

\item{\code{target}}{Node which the arrow enters.}

\item{\code{p}}{Probability}

\item{\code{cost}}{Cost associated with traversal of this edge.}

\item{\code{benefit}}{Benefit associated with traversal of the edge.}

\item{\code{label}}{Character string containing the arrow label.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \verb{Reaction} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-modvars"></a>}}
\if{latex}{\out{\hypertarget{method-modvars}{}}}
\subsection{Method \code{modvars()}}{
Find all the model variables of type \verb{ModVar} that have been 
specified
as values associated with this Action. Includes operands of these
\verb{ModVar}s, if they are expressions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reaction$modvars()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of \verb{ModVar}s.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-p"></a>}}
\if{latex}{\out{\hypertarget{method-p}{}}}
\subsection{Method \code{p()}}{
Return the current value of the edge probability, i.e. the conditional
probability of traversing the edge.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reaction$p()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Numeric value in range [0,1].
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cost"></a>}}
\if{latex}{\out{\hypertarget{method-cost}{}}}
\subsection{Method \code{cost()}}{
Return the cost associated with traversing the edge.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reaction$cost()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Cost.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-benefit"></a>}}
\if{latex}{\out{\hypertarget{method-benefit}{}}}
\subsection{Method \code{benefit()}}{
Return the benefit associated with traversing the edge.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reaction$benefit()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Benefit.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reaction$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
