% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{nest2ring}
\alias{nest2ring}
\title{Convert nest to ring ordering}
\usage{
nest2ring(nside, pix)
}
\arguments{
\item{nside}{is the HEALPix nside parameter.}

\item{pix}{is the set or subset of pixel indices at nside.
If pix is left blank then all pixels are converted.}
}
\value{
the output is the corresponding set of pixel in
the ring ordering scheme.
}
\description{
Convert from "nested" to "ring" ordering

\code{nest2ring} computes the HEALPix pixel index
in the "ring" ordering scheme from the pixel index
in the "nested" ordering scheme.
}
\examples{
# compute HEALPix indices in the ring ordering scheme
nside <- 8
pix <-c(1,2,23)
nest2ring(nside,pix)

}
