% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efronRSquared.r
\name{efronRSquared}
\alias{efronRSquared}
\title{Efron's pseudo r-squared}
\usage{
efronRSquared(
  actual = NULL,
  predicted = NULL,
  residual = NULL,
  statistic = "EfronRSquared",
  plotit = FALSE,
  digits = 3,
  ...
)
}
\arguments{
\item{actual}{A vector of actual y values}

\item{predicted}{A vector of predicted values}

\item{residual}{A vector of residuals}

\item{statistic}{The statistic to produce
One of \code{"EfronRSquared"},
       \code{"MinMaxAccuracy"},
       \code{"MAE"},
       \code{"MAPE"},
       \code{"MSE"},
       \code{"RMSE"},
       \code{"NRMSE.Mean"},
       \code{"CV"}.}

\item{plotit}{If \code{TRUE}, produces plots of the predicted values
vs. the actual values.}

\item{digits}{The number of significant digits in the output.}

\item{...}{Other arguments passed to \code{plot}.}
}
\value{
A single statistic
}
\description{
Produces Efron's pseudo r-squared from vectors of
             residuals, predicted values, and actual values.
             Alternately produces minimum maximum accuracy, 
             mean absolute percent error, 
             root mean square error, or coefficient of variation.
}
\details{
Efron's pseudo r-squared is calculated as 1 minus the residual sum 
          of squares divided by the total sum of squares.  For linear models
          (\code{lm} model objects), Efron's pseudo r-squared will be equal  
          to r-squared.
          
          This function produces the same statistics as does the
          \code{accuracy} function.
          While the \code{accuracy} function extracts values from a model
          object, this function allows for the manual entry
          of values.
          
          It is recommended that the user consults the \code{accuracy}
          function
          for further details on these statistics, such as if the reported
          value is presented as a percentage or fraction.
          
          Two of the following need to passed to the function:
          \code{actual}, \code{predicted}, \code{residual}.

          Note that, for some model objects, to extract residuals
          and predicted values on the original scale,
          a \code{type="response"}
          option needs to be added to the call, e.g.
          \code{residuals(model.object, type="response")}.
}
\examples{
data(BrendonSmall)
BrendonSmall$Calories = as.numeric(BrendonSmall$Calories)
BrendonSmall$Calories2 = BrendonSmall$Calories ^ 2
model.1 = lm(Sodium ~ Calories + Calories2, data = BrendonSmall)

efronRSquared(actual=BrendonSmall$Sodium, residual=model.1$residuals)
efronRSquared(residual=model.1$residuals, predicted=model.1$fitted.values)
efronRSquared(actual=BrendonSmall$Sodium, predicted=model.1$fitted.values)
summary(model.1)$r.squared

efronRSquared(actual=BrendonSmall$Sodium, residual=model.1$residuals, 
              statistic="MAPE")

}
\references{
\url{https://rcompanion.org/handbook/F_16.html}
}
\seealso{
\code{\link{accuracy}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{pseudo r-squared}
