% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{rcmdcheck}
\alias{rcmdcheck}
\alias{rcmdcheck-package}
\title{Run R CMD check from R and Capture Results}
\usage{
rcmdcheck(path = ".", quiet = FALSE, args = character(),
  libpath = .libPaths(), repos = getOption("repos"))
}
\arguments{
\item{path}{Path to a package tarball or a directory.}

\item{quiet}{Whether to print check output during checking.}

\item{args}{Character vector of arguments to pass to
\code{R CMD check}.}

\item{libpath}{The library path to set for the check.
The default uses the current library path.}

\item{repos}{The \code{repos} option to set for the check.
This is needed for cyclic dependency checks if you use the
\code{--as-cran} argument. The default uses the current value.}
}
\value{
An S3 object (list) with fields \code{errors},
  \code{warnings} and \code{nodes}. These are all character
  vectors containing the output for the failed check.
}
\description{
Run R CMD check form R programatically, and capture the results of the
individual checks.

Run \code{R CMD check} on a package or a directory
}

