% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spp_distributions.R
\name{spp_distributions}
\alias{spp_distributions}
\title{Get distributions data available for a given taxon concept}
\usage{
spp_distributions(
  taxon_id,
  language = "en",
  raw = FALSE,
  token = NULL,
  verbose = TRUE,
  pause = 1,
  ...
)
}
\arguments{
\item{taxon_id}{a vector of character strings containing species'
taxon concept identifiers (see \code{\link[=spp_taxonconcept]{spp_taxonconcept()}}).}

\item{language}{vector of character strings indicating the language for the
names of distributions, values are taken among \code{en} (English),
\code{fr} (French) and \code{es} (Spanish). Default is \code{en}.}

\item{raw}{a logical. Should raw data be returned?}

\item{token}{a character string containing the authentification token, see
\url{https://api.speciesplus.net/documentation}. Default is set to
\code{NULL} and requires the environment variable \code{SPECIESPLUS_TOKEN} to be
set directly in \code{Renviron}. Alternatively, \code{set_token()} can
be used to set \code{SPECIESPLUS_TOKEN} for the current session.}

\item{verbose}{a logical. Should extra information be reported on progress?}

\item{pause}{a duration (in second) to suspend execution for (see
\code{\link[=Sys.sleep]{Sys.sleep()}}). This was added cause the web API returns a 404 error too many
requests in a short time interval.}

\item{...}{Further named parameters, see \code{\link[httr:GET]{httr::GET()}}.}
}
\value{
If \code{raw} is set to \code{TRUE} then an object of class \code{spp_raw} (or
\code{spp_raw_multi} if \code{length(taxon_id)>1}) is returned which is essentially
a list of lists (see option \code{as = 'parsed'} in \code{\link[httr:content]{httr::content()}}).
Otherwise, an object of class \code{spp_distr} (or \code{spp_distr_multi} if
\code{length(taxon_id) > 1}) is returned which is a list of two data frames:
\enumerate{
\item \code{distributions}: lists distributions for a given taxon concept,
\item \code{references}: lists the corresponding references.
In case \code{taxon_id} includes several elements
}
}
\description{
Retrieve distributions data available for a given taxon concept for which the
the taxon identifier is known.
}
\examples{
\donttest{
 res1 <- spp_distributions(taxon_id = '4521')
 res2 <- spp_distributions(taxon_id = c('4521', '3210', '10255'))
 res3 <- spp_distributions(taxon_id = '4521', raw = TRUE)
 res4 <- spp_distributions(taxon_id = '4521', language = 'fr',
 verbose = FALSE, config = httr::progress())
}
}
\references{
\url{https://api.speciesplus.net/documentation/v1/distributions/index.html}
}
