% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcheology.R
\docType{package}
\name{rcheology-package}
\alias{rcheology-package}
\title{Data on base packages from current and previous versions of R}
\description{
rcheology is a data package providing two data frames:
}
\details{
\itemize{
\item \link{rcheology} lists objects in versions of R from 0.50 onwards.
\item \link{Rversions} lists R versions and their release dates. NB: For a more complete
and "canonical" solution, see the
\href{https://cran.r-project.org/package=rversions}{rversions} package.
}

The version of the rcheology package reflects the latest R version to be included in the data,
e.g. 3.5.1.x contains data up to and including R 3.5.1.

An online app for data exploration is available at \url{https://hughjonesd.shinyapps.io/rcheology/}.

\if{html}{\out{
<!-- this is .Rmd so it can be easily included by README.Rmd -->
}}

\subsection{Where the data comes from}{

R versions are built using the
\href{https://github.com/r-hub/evercran}{evercran} project.

Results are found from running \code{ls(all.names = TRUE)} on all installed
packages. For more details, see \code{guest-list-objects.R}.

The \code{Rversions} data frame lists versions of R and release dates.
}
}
\section{Limitations}{

\itemize{
\item Functions not built on the relevant platform - e.g. Windows functions - are not included.
\item R 0.60 data is not yet included.
\item Functions in package tcltk are not yet included before R 2.0.0.
}
}

\section{Historical quirks}{

\itemize{
\item In 2.9.0, package Matrix was mistakenly given priority \code{"Recommended"} not
\code{"recommended"} in the output of \code{\link[=installed.packages]{installed.packages()}}.
\item In 2.5.0, package rcompgen was given priority \code{NA}. The NEWS file records
it as a recommended package.
}

Both these errors have been corrected in the rcheology data.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/hughjonesd/rcheology}
  \item Report bugs at \url{https://github.com/hughjonesd/rcheology/issues}
}

}
\author{
\strong{Maintainer}: David Hugh-Jones \email{davidhughjones@gmail.com}

}
