% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new.r
\name{new_challenge}
\alias{new_challenge}
\title{Install a new challenge.}
\usage{
new_challenge(path = ".", out_rmdfile = "challenge.rmd",
  recursive = FALSE, overwrite = recursive, quiet = FALSE,
  showWarnings = FALSE, template = c("en", "fr"), data_dir = "data",
  submissions_dir = "submissions", hist_dir = "history",
  install_data = TRUE, baseline = "baseline", add_baseline = install_data,
  clear_history = overwrite, title = "Challenge", author = "",
  date = "", email = "EDIT_EMAIL@DOMAIN.com",
  date_start = format(Sys.Date(), "\%d \%b \%Y"),
  deadline = paste(Sys.Date() + 90, "23:59:59"),
  data_list = data_split(get_data("german")))
}
\arguments{
\item{path}{string. install path of the challenge (should be somewhere in your Dropbox).}

\item{out_rmdfile}{string. name of the output R Markdown file.}

\item{recursive}{logical. should elements of the path other than the last be created? see \code{\link{dir.create}}.}

\item{overwrite}{logical. should existing destination files be overwritten? see \code{\link{file.copy}}.}

\item{quiet}{logical. deactivate text output.}

\item{showWarnings}{logical. should the warnings on failure be shown? see \code{\link{dir.create}}.}

\item{template}{string. name of the template R Markdown script to be installed.
Two choices are available: \code{"en"} (english) and \code{"fr"} (french).}

\item{data_dir}{string. subdirectory of the data.}

\item{submissions_dir}{string. subdirectory of the submissions. see \code{\link{store_new_submissions}}.}

\item{hist_dir}{string. subdirectory of the history. see \code{\link{store_new_submissions}}.}

\item{install_data}{logical. activate installation of the data files of the template challenge.}

\item{baseline}{string. name of the team considered as the baseline.}

\item{add_baseline}{logical. activate installation of baseline submission files of the template challenge.}

\item{clear_history}{logical. activate deletion of the existing history folder.}

\item{title}{string. title displayed on the webpage.}

\item{author}{string. author displayed on the webpage.}

\item{date}{string. date displayed on the webpage.}

\item{email}{string. email of the challenge administrator.}

\item{date_start}{string. start date of the challenge.}

\item{deadline}{string. deadline of the challenge.}

\item{data_list}{list with members \code{train}, \code{test}, \code{y_test} and
\code{ind_quiz} such as returned by the \code{\link{data_split}} function.}
}
\value{
The path of the created challenge is returned.
}
\description{
Install a new challenge.
}
\examples{
path <- tempdir()
wd <- setwd(path)
# english version
new_challenge()
# french version
new_challenge(template = "fr")
setwd(wd)
unlink(path)
}

