% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdo-bottomvalue.R, R/cdo-isosurface.R,
%   R/cdo-topvalue.R, R/family-selsurface.R
\name{cdo_bottomvalue}
\alias{cdo_bottomvalue}
\alias{cdo_isosurface}
\alias{cdo_topvalue}
\alias{selsurface}
\title{Extract surface}
\usage{
cdo_bottomvalue(ifile, isovalue = NULL, ofile = NULL)

cdo_isosurface(ifile, isovalue = NULL, ofile = NULL)

cdo_topvalue(ifile, isovalue = NULL, ofile = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{isovalue}{FLOAT - Isosurface value}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
This module computes a surface from all 3D variables. The result is a horizonal 2D field.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{bottomvalue  Extract bottom level
             This operator selects the valid values at the bottom level.
             The NetCDF CF compliant attribute positive is used to determine where top and bottom are.
             If this attribute is missing, low values are bottom and high values are top.
topvalue     Extract top level
             This operator selects the valid values at the top level.
             The NetCDF CF compliant attribute positive is used to determine where top and bottom are.
             If this attribute is missing, low values are bottom and high values are top.
isosurface   Extract isosurface
             This operator computes an isosurface. The value of the isosurfce is specified by the parameter isovalue.
             The isosurface is calculated by linear interpolation between two layers.
}\if{html}{\out{</div>}}
}
