% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdo-aexpr.R, R/cdo-aexprf.R, R/cdo-expr.R,
%   R/cdo-exprf.R, R/family-expr.R
\name{cdo_aexpr}
\alias{cdo_aexpr}
\alias{cdo_aexprf}
\alias{cdo_expr}
\alias{cdo_exprf}
\alias{expr}
\title{Evaluate expressions}
\usage{
cdo_aexpr(ifile, instr = NULL, filename = NULL, ofile = NULL)

cdo_aexprf(ifile, instr = NULL, filename = NULL, ofile = NULL)

cdo_expr(ifile, instr = NULL, filename = NULL, ofile = NULL)

cdo_exprf(ifile, instr = NULL, filename = NULL, ofile = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{instr}{STRING - Processing instructions (need to be 'quoted' in most cases)}

\item{filename}{STRING - File with processing instructions}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
This module arithmetically processes every timestep of the input dataset. Each individual assignment statement have to end with a semi-colon. The special key \emph{ALL} is used as a template. A statement with a template is replaced for all variable names. Unlike regular variables, temporary variables are never written to the output stream. To define a temporary variable simply prefix the variable name with an underscore (e.g. _varname) when the variable is declared.  The following operators are supported:  Operator   & Meaning             & Example   & Result =      & assignment          & x = y     & Assigns y to x +      & addition            & x + y     & Sum of x and y -      & subtraction         & x - y     & Difference of x and y *      & multiplication      & x * y     & Product of x and y /      & division            & x / y     & Quotient of x and y ^      & exponentiation      & x ^y      & Exponentiates x with y ==     & equal to            & x == y    &  1, if x equal to y; else 0 !=     & not equal to        & x != y    &  1, if x not equal to y; else 0 >      & greater than        & x > y     &  1, if x greater than y; else 0 <      & less than           & x < y     &  1, if x less than y; else 0 >=     & greater equal       & x >= y    &  1, if x greater equal y; else 0 <=     & less equal          & x <= y    &  1, if x less equal y; else 0 <=>    & less equal greater  & x <=> y   & -1, if x less y; 1, if x greater y; else 0 &&     & logical AND         & x && y    &  1, if x and y not equal 0; else 0 ||     & logical OR          & x || y    &  1, if x or y not equal 0; else 0 !      & logical NOT         & !x        &  1, if x equal 0; else 0 ?:     & ternary conditional & x ? y : z & y, if x not equal 0, else z  The following functions are supported:  Math intrinsics:  abs(x)      "    "    Absolute value of x floor(x)    "    "    Round to largest integral value not greater than x ceil(x)     "    "    Round to smallest integral value not less than x float(x)    "    "    32-bit float value of x int(x)      "    "    Integer value of x nint(x)     "    "    Nearest integer value of x sqr(x)      "    "    Square of x sqrt(x)     "    "    Square Root of x exp(x)      "    "    Exponential of x ln(x)       "    "    Natural logarithm of x log10(x)    "    "    Base 10 logarithm of x sin(x)      "    "    Sine of x, where x is specified in radians cos(x)      "    "    Cosine of x, where x is specified in radians tan(x)      "    "    Tangent of x, where x is specified in radians asin(x)     "    "    Arc-sine of x, where x is specified in radians acos(x)     "    "    Arc-cosine of x, where x is specified in radians atan(x)     "    "    Arc-tangent of x, where x is specified in radians sinh(x)     "    "    Hyperbolic sine of x, where x is specified in radians cosh(x)     "    "    Hyperbolic cosine of x, where x is specified in radians tanh(x)     "    "    Hyperbolic tangent of x, where x is specified in radians asinh(x)    "    "    Inverse hyperbolic sine of x, where x is specified in radians acosh(x)    "    "    Inverse hyperbolic cosine of x, where x is specified in radians atanh(x)    "    "    Inverse hyperbolic tangent of x, where x is specified in radians rad(x)      "    "    Convert x from degrees to radians deg(x)      "    "    Convert x from radians to degrees rand(x)     "    "    Replace x by pseudo-random numbers in the range of 0 to 1 isMissval(x)"    "    Returns 1 where x is missing  mod(x,y)    "    "    Floating-point remainder of x/ y min(x,y)    "    "    Minimum value of x and y max(x,y)    "    "    Maximum value of x and y pow(x,y)    "    "    Power function hypot(x,y)  "    "    Euclidean distance function, sqrt(x\emph{x + y}y) atan2(x,y)  "    "    Arc tangent function of y/x, using signs to determine quadrants  Coordinates:  clon(x)      "    "    Longitude coordinate of x (available only if x has geographical coordinates) clat(x)      "    "    Latitude coordinate of x (available only if x has geographical coordinates) gridarea(x)  "    "    Grid cell area of x (available only if x has geographical coordinates) gridindex(x) "    "    Grid cell indices of x clev(x)      "    "    Level coordinate of x (0, if x is a 2D surface variable) clevidx(x)   "    "    Level index of x (0, if x is a 2D surface variable) cthickness(x)"    "    Layer thickness, upper minus lower level bound of x (1, if level bounds are missing) ctimestep()  "    "    Timestep number (1 to N) cdate()      "    "    Verification date as YYYYMMDD ctime()      "    "    Verification time as HHMMSS.millisecond cdeltat()    "    "    Difference between current and last timestep in seconds cday()       "    "    Day as DD cmonth()     "    "    Month as MM cyear()      "    "    Year as YYYY csecond()    "    "    Second as SS.millisecond cminute()    "    "    Minute as MM chour()      "    "    Hour as HH  Constants:  ngp(x)    "    "    Number of horizontal grid points nlev(x)   "    "    Number of vertical levels size(x)   "    "    Total number of elements (ngp(x)*nlev(x)) missval(x)"    "    Returns the missing value of variable x  Statistics over a field:  fldmin(x), fldmax(x), fldrange(x), fldsum(x), fldmean(x), fldavg(x), fldstd(x), fldstd1(x), fldvar(x), fldvar1(x), fldskew(x), fldkurt(x), fldmedian(x)  Zonal statistics for regular 2D grids:  zonmin(x), zonmax(x), zonrange(x), zonsum(x), zonmean(x), zonavg(x), zonstd(x), zonstd1(x), zonvar(x), zonvar1(x), zonskew(x), zonkurt(x), zonmedian(x)  Vertical statistics:  vertmin(x), vertmax(x), vertrange(x), vertsum(x), vertmean(x), vertavg(x), vertstd(x), vertstd1(x), vertvar(x), vertvar1(x)  Miscellaneous:  sellevel(x,k)          "    "    Select level k of variable x sellevidx(x,k)         "    "    Select level index k of variable x sellevelrange(x,k1,k2) "    "    Select all levels of variable x in the range k1 to k2 sellevidxrange(x,k1,k2)"    "    Select all level indices of variable x in the range k1 to k2 remove(x)              "    "    Remove variable x from output stream
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{expr    Evaluate expressions
        The processing instructions are read from the parameter.
exprf   Evaluate expressions script
        Contrary to expr the processing instructions are read from a file.
aexpr   Evaluate expressions and append results
        Same as expr, but keep input variables and append results
aexprf  Evaluate expression script and append results
        Same as exprf, but keep input variables and append results
}\if{html}{\out{</div>}}
}
\section{Note}{

If the input stream contains duplicate entries of the same variable name then the last one is used.
}

