/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;

final class DfState
implements Iterable<int[]> {
    private static final int UNMAPPED = -1;
    private final IAtomContainer query;
    private final IQueryBond[] qbonds;
    private final int numAtoms;
    private int numBonds;
    private int numMapped;
    private final int[] amap;
    private IAtomContainer mol;
    private boolean[] avisit;
    private int sptr;
    private StackFrame[] stack;
    private static IChemObjectBuilder BUILDER;

    DfState(IQueryAtomContainer query2) {
        IChemObjectBuilder builder = query2.getBuilder();
        if (builder == null && (builder = DfState.findBuilder()) == null) {
            throw new IllegalArgumentException("Please ensure query moleculehas a IChemObjectBuilder set!");
        }
        IAtomContainer tmp = builder.newAtomContainer();
        tmp.add(query2);
        this.qbonds = new IQueryBond[tmp.getBondCount()];
        this.amap = new int[query2.getAtomCount()];
        int stackSize = 0;
        for (IAtom atom : tmp.atoms()) {
            if (atom instanceof IQueryAtom) {
                if (this.amap[atom.getIndex()] != 0) continue;
                stackSize += this.prepare(atom, null) + 1;
                continue;
            }
            throw new IllegalArgumentException("All atoms must be IQueryAtoms!");
        }
        this.stack = new StackFrame[stackSize + 2];
        for (int i = 0; i < this.stack.length; ++i) {
            this.stack[i] = new StackFrame();
        }
        this.numAtoms = this.amap.length;
        this.query = tmp;
    }

    DfState(DfState state) {
        this.qbonds = Arrays.copyOf(state.qbonds, state.qbonds.length);
        this.query = state.query;
        this.numBonds = state.numBonds;
        this.numAtoms = state.numAtoms;
        this.numMapped = state.numMapped;
        this.amap = (int[])state.amap.clone();
        this.avisit = state.avisit != null ? (boolean[])state.avisit.clone() : null;
        this.mol = state.mol;
        this.stack = new StackFrame[state.stack.length];
        for (int i = 0; i < this.stack.length; ++i) {
            this.stack[i] = new StackFrame(state.stack[i]);
        }
        this.sptr = state.sptr;
    }

    private static IChemObjectBuilder findBuilder() {
        if (BUILDER != null) {
            return BUILDER;
        }
        for (String name : new String[]{"org.openscience.cdk.silent.SilentChemObjectBuilder", "org.openscience.cdk.DefaultChemObjectBuilder"}) {
            try {
                Class<?> cls = Class.forName(name);
                Method method = cls.getMethod("getInstance", new Class[0]);
                BUILDER = (IChemObjectBuilder)method.invoke(cls, new Object[0]);
                return BUILDER;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private int prepare(IAtom atom, IBond prev) {
        int count = 0;
        this.amap[atom.getIndex()] = 1;
        for (IBond bond : atom.bonds()) {
            if (bond == prev) continue;
            IAtom nbr = bond.getOther(atom);
            if (this.amap[nbr.getIndex()] == 0) {
                this.qbonds[this.numBonds++] = (IQueryBond)bond;
                count += this.prepare(nbr, bond) + 1;
                continue;
            }
            if (nbr.getIndex() >= atom.getIndex()) continue;
            ++count;
            this.qbonds[this.numBonds++] = (IQueryBond)bond;
        }
        return count;
    }

    void setMol(IAtomContainer mol) {
        this.mol = mol;
        Arrays.fill(this.amap, -1);
        this.numMapped = 0;
        this.avisit = new boolean[mol.getAtomCount()];
        this.sptr = 0;
        this.store(0, null);
    }

    void setRoot(IAtom atom) {
        this.setMol(atom.getContainer());
        this.numMapped = 1;
        int aidx = atom.getIndex();
        this.avisit[aidx] = true;
        this.amap[0] = aidx;
    }

    private int currBondIdx() {
        return this.stack[this.sptr].bidx;
    }

    private Iterator<IAtom> atoms() {
        if (this.stack[this.sptr].iter == null) {
            this.stack[this.sptr].iter = this.mol.atoms().iterator();
        }
        return this.stack[this.sptr].iter;
    }

    private Iterator<IBond> bonds(IAtom atom) {
        if (this.stack[this.sptr].iter == null) {
            this.stack[this.sptr].iter = atom.bonds().iterator();
        }
        return this.stack[this.sptr].iter;
    }

    private void store(int bidx, IQueryAtom queryatom) {
        ++this.sptr;
        this.stack[this.sptr].bidx = bidx;
        this.stack[this.sptr].iter = null;
        if (queryatom != null) {
            this.stack[this.sptr].atom = queryatom;
        } else {
            this.stack[this.sptr].atom = null;
        }
    }

    private void backtrack() {
        IAtom qatom = this.stack[this.sptr].atom;
        --this.sptr;
        if (qatom != null) {
            --this.numMapped;
            this.avisit[this.amap[qatom.getIndex()]] = false;
            this.amap[qatom.getIndex()] = -1;
        } else if (this.sptr != 0) {
            this.backtrack();
        }
    }

    private boolean feasible(int bidx, IQueryAtom qatom, IAtom atom) {
        int aidx = atom.getIndex();
        if (this.avisit[aidx] || !qatom.matches(atom)) {
            return false;
        }
        ++this.numMapped;
        this.amap[qatom.getIndex()] = aidx;
        this.avisit[aidx] = true;
        this.store(bidx, qatom);
        return true;
    }

    private boolean feasible(IQueryBond qbond, IBond bond) {
        if (bond == null || !qbond.matches(bond)) {
            return false;
        }
        this.store(this.currBondIdx() + 1, null);
        return true;
    }

    boolean matchNext() {
        if (this.numAtoms == 0) {
            return false;
        }
        if (this.sptr > 1) {
            this.backtrack();
        }
        block0: while (this.sptr != 0) {
            IBond bond;
            Iterator<IBond> biter;
            int bidx = this.currBondIdx();
            if (bidx == this.numBonds) {
                if (this.numMapped == this.numAtoms) {
                    return true;
                }
                for (IAtom qatom : this.query.atoms()) {
                    if (this.amap[qatom.getIndex()] != -1) continue;
                    Iterator<IAtom> iter = this.atoms();
                    while (iter.hasNext()) {
                        IAtom atom = iter.next();
                        if (!this.feasible(bidx, (IQueryAtom)qatom, atom)) continue;
                        continue block0;
                    }
                    break block1;
                }
                this.backtrack();
                continue;
            }
            IQueryBond qbond = this.qbonds[bidx];
            IQueryAtom qbeg = (IQueryAtom)qbond.getBegin();
            IQueryAtom qend = (IQueryAtom)qbond.getEnd();
            int begIdx = this.amap[qbeg.getIndex()];
            int endIdx = this.amap[qend.getIndex()];
            if (begIdx != -1 && endIdx != -1) {
                IBond bond2 = this.mol.getAtom(begIdx).getBond(this.mol.getAtom(endIdx));
                if (this.feasible(qbond, bond2)) {
                    continue;
                }
            } else if (begIdx != -1) {
                IAtom beg = this.mol.getAtom(begIdx);
                biter = this.bonds(beg);
                while (biter.hasNext()) {
                    bond = biter.next();
                    IAtom end = bond.getOther(beg);
                    if (!qbond.matches(bond) || !this.feasible(bidx + 1, qend, end)) continue;
                    continue block0;
                }
            } else if (endIdx != -1) {
                IAtom end = this.mol.getAtom(endIdx);
                biter = this.bonds(end);
                while (biter.hasNext()) {
                    bond = biter.next();
                    IAtom beg = bond.getOther(end);
                    if (!qbond.matches(bond) || !this.feasible(bidx + 1, qbeg, beg)) continue;
                    continue block0;
                }
            } else {
                Iterator<IAtom> aiter = this.atoms();
                while (aiter.hasNext()) {
                    if (!this.feasible(bidx, qbeg, aiter.next())) continue;
                    continue block0;
                }
            }
            this.backtrack();
        }
        return false;
    }

    @Override
    public Iterator<int[]> iterator() {
        final DfState lstate = new DfState(this);
        return new Iterator<int[]>(){
            boolean hasNext;

            @Override
            public boolean hasNext() {
                return this.hasNext || (this.hasNext = lstate.matchNext());
            }

            @Override
            public int[] next() {
                if (!this.hasNext()) {
                    return new int[0];
                }
                this.hasNext = false;
                return lstate.amap;
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException();
            }
        };
    }

    private static final class StackFrame {
        private int bidx;
        private IAtom atom;
        private Iterator iter;

        private StackFrame(StackFrame frame) {
            this.bidx = frame.bidx;
            this.atom = frame.atom;
            this.iter = frame.iter;
        }

        private StackFrame() {
        }
    }
}

