/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.inchi;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import net.sf.jniinchi.INCHI_BOND_STEREO;
import net.sf.jniinchi.INCHI_BOND_TYPE;
import net.sf.jniinchi.INCHI_PARITY;
import net.sf.jniinchi.INCHI_RET;
import net.sf.jniinchi.INCHI_STEREOTYPE;
import net.sf.jniinchi.JniInchiAtom;
import net.sf.jniinchi.JniInchiBond;
import net.sf.jniinchi.JniInchiException;
import net.sf.jniinchi.JniInchiInputInchi;
import net.sf.jniinchi.JniInchiOutputStructure;
import net.sf.jniinchi.JniInchiStereo0D;
import net.sf.jniinchi.JniInchiWrapper;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.DoubleBondStereochemistry;
import org.openscience.cdk.stereo.ExtendedTetrahedral;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class InChIToStructure {
    protected JniInchiInputInchi input;
    protected JniInchiOutputStructure output;
    protected IAtomContainer molecule;
    private static final int ISOTOPIC_SHIFT_FLAG = 10000;

    protected InChIToStructure(String inchi, IChemObjectBuilder builder) throws CDKException {
        try {
            this.input = new JniInchiInputInchi(inchi, "");
        }
        catch (JniInchiException jie) {
            throw new CDKException("Failed to convert InChI to molecule: " + jie.getMessage(), jie);
        }
        this.generateAtomContainerFromInchi(builder);
    }

    protected InChIToStructure(String inchi, IChemObjectBuilder builder, String options) throws CDKException {
        try {
            this.input = new JniInchiInputInchi(inchi, options);
        }
        catch (JniInchiException jie) {
            throw new CDKException("Failed to convert InChI to molecule: " + jie.getMessage(), jie);
        }
        this.generateAtomContainerFromInchi(builder);
    }

    protected InChIToStructure(String inchi, IChemObjectBuilder builder, List<String> options) throws CDKException {
        try {
            this.input = new JniInchiInputInchi(inchi, options);
        }
        catch (JniInchiException jie) {
            throw new CDKException("Failed to convert InChI to molecule: " + jie.getMessage());
        }
        this.generateAtomContainerFromInchi(builder);
    }

    protected void generateAtomContainerFromInchi(IChemObjectBuilder builder) throws CDKException {
        int i;
        try {
            this.output = JniInchiWrapper.getStructureFromInchi(this.input);
        }
        catch (JniInchiException jie) {
            throw new CDKException("Failed to convert InChI to molecule: " + jie.getMessage(), jie);
        }
        this.molecule = builder.newInstance(IAtomContainer.class, new Object[0]);
        HashMap<JniInchiAtom, IAtom> inchiCdkAtomMap = new HashMap<JniInchiAtom, IAtom>();
        for (i = 0; i < this.output.getNumAtoms(); ++i) {
            IBond bond;
            int j;
            JniInchiAtom iAt = this.output.getAtom(i);
            IAtom cAt = builder.newInstance(IAtom.class, new Object[0]);
            inchiCdkAtomMap.put(iAt, cAt);
            cAt.setID("a" + i);
            cAt.setSymbol(iAt.getElementType());
            cAt.setAtomicNumber(PeriodicTable.getAtomicNumber(cAt.getSymbol()));
            cAt.setFormalCharge(iAt.getCharge());
            cAt.setImplicitHydrogenCount(iAt.getImplicitH());
            int isotopicMass = iAt.getIsotopicMass();
            if (isotopicMass != 0) {
                if (10000 == (isotopicMass & 0x2710)) {
                    try {
                        int massNumber = Isotopes.getInstance().getMajorIsotope(cAt.getAtomicNumber()).getMassNumber();
                        cAt.setMassNumber(massNumber + (isotopicMass - 10000));
                    }
                    catch (IOException e) {
                        throw new CDKException("Could not load Isotopes data", e);
                    }
                } else {
                    cAt.setMassNumber(isotopicMass);
                }
            }
            this.molecule.addAtom(cAt);
            cAt = this.molecule.getAtom(this.molecule.getAtomCount() - 1);
            for (j = 0; j < iAt.getImplicitDeuterium(); ++j) {
                IAtom deut = builder.newInstance(IAtom.class, new Object[0]);
                deut.setAtomicNumber(1);
                deut.setSymbol("H");
                deut.setMassNumber(2);
                deut.setImplicitHydrogenCount(0);
                this.molecule.addAtom(deut);
                deut = this.molecule.getAtom(this.molecule.getAtomCount() - 1);
                bond = builder.newInstance(IBond.class, new Object[]{cAt, deut, IBond.Order.SINGLE});
                this.molecule.addBond(bond);
            }
            for (j = 0; j < iAt.getImplicitTritium(); ++j) {
                IAtom trit = builder.newInstance(IAtom.class, new Object[0]);
                trit.setAtomicNumber(1);
                trit.setSymbol("H");
                trit.setMassNumber(3);
                trit.setImplicitHydrogenCount(0);
                this.molecule.addAtom(trit);
                trit = this.molecule.getAtom(this.molecule.getAtomCount() - 1);
                bond = builder.newInstance(IBond.class, new Object[]{cAt, trit, IBond.Order.SINGLE});
                this.molecule.addBond(bond);
            }
        }
        for (i = 0; i < this.output.getNumBonds(); ++i) {
            JniInchiBond iBo = this.output.getBond(i);
            IBond cBo = builder.newInstance(IBond.class, new Object[0]);
            IAtom atO = (IAtom)inchiCdkAtomMap.get(iBo.getOriginAtom());
            IAtom atT = (IAtom)inchiCdkAtomMap.get(iBo.getTargetAtom());
            IAtom[] atoms = new IAtom[]{atO, atT};
            cBo.setAtoms(atoms);
            INCHI_BOND_TYPE type = iBo.getBondType();
            if (type == INCHI_BOND_TYPE.SINGLE) {
                cBo.setOrder(IBond.Order.SINGLE);
            } else if (type == INCHI_BOND_TYPE.DOUBLE) {
                cBo.setOrder(IBond.Order.DOUBLE);
            } else if (type == INCHI_BOND_TYPE.TRIPLE) {
                cBo.setOrder(IBond.Order.TRIPLE);
            } else if (type == INCHI_BOND_TYPE.ALTERN) {
                cBo.setFlag(32, true);
            } else {
                throw new CDKException("Unknown bond type: " + (Object)((Object)type));
            }
            INCHI_BOND_STEREO stereo = iBo.getBondStereo();
            if (stereo == INCHI_BOND_STEREO.NONE) {
                cBo.setStereo(IBond.Stereo.NONE);
            } else if (stereo == INCHI_BOND_STEREO.SINGLE_1DOWN) {
                cBo.setStereo(IBond.Stereo.DOWN);
            } else if (stereo == INCHI_BOND_STEREO.SINGLE_1UP) {
                cBo.setStereo(IBond.Stereo.UP);
            } else if (stereo == INCHI_BOND_STEREO.SINGLE_2DOWN) {
                cBo.setStereo(IBond.Stereo.DOWN_INVERTED);
            } else if (stereo == INCHI_BOND_STEREO.SINGLE_2UP) {
                cBo.setStereo(IBond.Stereo.UP_INVERTED);
            } else if (stereo == INCHI_BOND_STEREO.SINGLE_1EITHER || stereo == INCHI_BOND_STEREO.DOUBLE_EITHER) {
                cBo.setStereo((IBond.Stereo)((Object)CDKConstants.UNSET));
            }
            this.molecule.addBond(cBo);
        }
        for (i = 0; i < this.output.getNumStereo0D(); ++i) {
            JniInchiStereo0D stereo0d = this.output.getStereo0D(i);
            if (stereo0d.getStereoType() == INCHI_STEREOTYPE.TETRAHEDRAL || stereo0d.getStereoType() == INCHI_STEREOTYPE.ALLENE) {
                ITetrahedralChirality.Stereo stereo;
                JniInchiAtom central = stereo0d.getCentralAtom();
                JniInchiAtom[] neighbours = stereo0d.getNeighbors();
                IAtom focus = (IAtom)inchiCdkAtomMap.get(central);
                IAtom[] neighbors = new IAtom[]{(IAtom)inchiCdkAtomMap.get(neighbours[0]), (IAtom)inchiCdkAtomMap.get(neighbours[1]), (IAtom)inchiCdkAtomMap.get(neighbours[2]), (IAtom)inchiCdkAtomMap.get(neighbours[3])};
                if (stereo0d.getParity() == INCHI_PARITY.ODD) {
                    stereo = ITetrahedralChirality.Stereo.ANTI_CLOCKWISE;
                } else {
                    if (stereo0d.getParity() != INCHI_PARITY.EVEN) continue;
                    stereo = ITetrahedralChirality.Stereo.CLOCKWISE;
                }
                IStereoElement stereoElement = null;
                if (stereo0d.getStereoType() == INCHI_STEREOTYPE.TETRAHEDRAL) {
                    stereoElement = builder.newInstance(ITetrahedralChirality.class, new Object[]{focus, neighbors, stereo});
                } else if (stereo0d.getStereoType() == INCHI_STEREOTYPE.ALLENE) {
                    IAtom[] terminals;
                    IAtom[] peripherals = neighbors;
                    for (IAtom terminal : terminals = ExtendedTetrahedral.findTerminalAtoms(this.molecule, focus)) {
                        if (peripherals[1].equals(terminal)) {
                            peripherals[1] = InChIToStructure.findOtherSinglyBonded(this.molecule, terminal, peripherals[0]);
                            continue;
                        }
                        if (peripherals[2].equals(terminal)) {
                            peripherals[2] = InChIToStructure.findOtherSinglyBonded(this.molecule, terminal, peripherals[3]);
                            continue;
                        }
                        if (peripherals[0].equals(terminal)) {
                            peripherals[0] = InChIToStructure.findOtherSinglyBonded(this.molecule, terminal, peripherals[1]);
                            continue;
                        }
                        if (!peripherals[3].equals(terminal)) continue;
                        peripherals[3] = InChIToStructure.findOtherSinglyBonded(this.molecule, terminal, peripherals[2]);
                    }
                    stereoElement = new ExtendedTetrahedral(focus, peripherals, stereo);
                }
                assert (stereoElement != null);
                this.molecule.addStereoElement(stereoElement);
                continue;
            }
            if (stereo0d.getStereoType() != INCHI_STEREOTYPE.DOUBLEBOND) continue;
            JniInchiAtom[] neighbors = stereo0d.getNeighbors();
            IAtom x = (IAtom)inchiCdkAtomMap.get(neighbors[0]);
            IAtom a = (IAtom)inchiCdkAtomMap.get(neighbors[1]);
            IAtom b = (IAtom)inchiCdkAtomMap.get(neighbors[2]);
            IAtom y = (IAtom)inchiCdkAtomMap.get(neighbors[3]);
            IBond stereoBond = this.molecule.getBond(a, b);
            stereoBond.setAtoms(new IAtom[]{a, b});
            IDoubleBondStereochemistry.Conformation conformation = null;
            switch (stereo0d.getParity()) {
                case ODD: {
                    conformation = IDoubleBondStereochemistry.Conformation.TOGETHER;
                    break;
                }
                case EVEN: {
                    conformation = IDoubleBondStereochemistry.Conformation.OPPOSITE;
                }
            }
            if (conformation == null) continue;
            this.molecule.addStereoElement(new DoubleBondStereochemistry(stereoBond, new IBond[]{this.molecule.getBond(x, a), this.molecule.getBond(b, y)}, conformation));
        }
    }

    private static IAtom findOtherSinglyBonded(IAtomContainer container, IAtom atom, IAtom exclude) {
        for (IBond bond : container.getConnectedBondsList(atom)) {
            if (!IBond.Order.SINGLE.equals((Object)bond.getOrder()) || bond.contains(exclude)) continue;
            return bond.getOther(atom);
        }
        return atom;
    }

    public IAtomContainer getAtomContainer() {
        return this.molecule;
    }

    public INCHI_RET getReturnStatus() {
        return this.output.getReturnStatus();
    }

    public String getMessage() {
        return this.output.getMessage();
    }

    public String getLog() {
        return this.output.getLog();
    }

    public long[][] getWarningFlags() {
        return this.output.getWarningFlags();
    }
}

