/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IStrand;
import org.openscience.cdk.silent.AtomContainer;
import org.openscience.cdk.silent.Monomer;

public class Strand
extends AtomContainer
implements Serializable,
IStrand {
    private static final long serialVersionUID = 4200943086350928356L;
    private Map<String, IMonomer> monomers = new Hashtable<String, IMonomer>();
    private String strandName;
    private String strandType;

    public Strand() {
        Monomer oMonomer = new Monomer();
        oMonomer.setMonomerName("");
        oMonomer.setMonomerType("UNKNOWN");
        this.monomers.put("", oMonomer);
        this.strandName = "";
    }

    @Override
    public String getStrandName() {
        return this.strandName;
    }

    @Override
    public String getStrandType() {
        return this.strandType;
    }

    @Override
    public void setStrandName(String cStrandName) {
        this.strandName = cStrandName;
    }

    @Override
    public void setStrandType(String cStrandType) {
        this.strandType = cStrandType;
    }

    @Override
    public void addAtom(IAtom oAtom) {
        this.addAtom(oAtom, this.getMonomer(""));
    }

    @Override
    public void addAtom(IAtom oAtom, IMonomer oMonomer) {
        int atomCount = super.getAtomCount();
        super.addAtom(oAtom);
        if (atomCount != super.getAtomCount()) {
            if (oMonomer == null) {
                oMonomer = this.getMonomer("");
            }
            oMonomer.addAtom(oAtom);
            if (!this.monomers.containsKey(oMonomer.getMonomerName())) {
                this.monomers.put(oMonomer.getMonomerName(), oMonomer);
            }
        }
    }

    @Override
    public int getMonomerCount() {
        return this.monomers.size() - 1;
    }

    @Override
    public IMonomer getMonomer(String cName) {
        return (Monomer)this.monomers.get(cName);
    }

    @Override
    public Collection<String> getMonomerNames() {
        return this.monomers.keySet();
    }

    @Override
    public void removeMonomer(String name) {
        if (this.monomers.containsKey(name)) {
            Monomer monomer = (Monomer)this.monomers.get(name);
            this.remove(monomer);
            this.monomers.remove(name);
        }
    }

    @Override
    public Map<String, IMonomer> getMonomers() {
        return this.monomers;
    }

    @Override
    public String toString() {
        StringBuffer stringContent = new StringBuffer(32);
        stringContent.append("Strand(");
        stringContent.append(this.hashCode());
        if (this.getStrandName() != null) {
            stringContent.append(", N:").append(this.getStrandName());
        }
        if (this.getStrandType() != null) {
            stringContent.append(", T:").append(this.getStrandType()).append(", ");
        }
        stringContent.append(super.toString());
        stringContent.append(')');
        return stringContent.toString();
    }

    @Override
    public IStrand clone() throws CloneNotSupportedException {
        Strand clone = (Strand)super.clone();
        clone.monomers.clear();
        Iterator<String> iter = clone.getMonomerNames().iterator();
        while (iter.hasNext()) {
            Monomer monomerClone = (Monomer)clone.getMonomer(iter.next().toString()).clone();
            Iterator<IAtom> atoms = monomerClone.atoms().iterator();
            while (atoms.hasNext()) {
                clone.addAtom(atoms.next(), monomerClone);
            }
        }
        return clone;
    }
}

