/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerArrayResult;

public class SmallRingDescriptor
implements IMolecularDescriptor {
    private static final String[] NAMES = new String[]{"nSmallRings", "nAromRings", "nRingBlocks", "nAromBlocks", "nRings3", "nRings4", "nRings5", "nRings6", "nRings7", "nRings8", "nRings9"};
    private IAtomContainer mol;
    private int[][] atomAdj;
    private int[][] bondAdj;
    private int[] ringBlock;
    private int[][] smallRings;
    private int[] bondOrder;
    private boolean[] atomArom;
    private boolean[] bondArom;
    private boolean[] piAtom;
    private int[] implicitH;

    @Override
    public void initialise(IChemObjectBuilder builder) {
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#smallRings", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerArrayResult(NAMES.length);
    }

    @Override
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    public Object getParameterType(String name) {
        return true;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer mol) {
        this.mol = mol;
        try {
            this.excavateMolecule();
        }
        catch (CDKException cDKException) {
            // empty catch block
        }
        int nSmallRings = this.smallRings.length;
        int nAromRings = 0;
        int nRingBlocks = 0;
        int nAromBlocks = this.countAromaticComponents();
        int nRings3 = 0;
        int nRings4 = 0;
        int nRings5 = 0;
        int nRings6 = 0;
        int nRings7 = 0;
        int nRings8 = 0;
        int nRings9 = 0;
        for (int[] r : this.smallRings) {
            int sz = r.length;
            if (sz == 3) {
                ++nRings3;
            } else if (sz == 4) {
                ++nRings4;
            } else if (sz == 5) {
                ++nRings5;
            } else if (sz == 6) {
                ++nRings6;
            } else if (sz == 7) {
                ++nRings7;
            } else if (sz == 8) {
                ++nRings8;
            } else if (sz == 9) {
                ++nRings9;
            }
            boolean aromatic = true;
            for (int n = 0; n < r.length; ++n) {
                if (this.bondArom[this.findBond(r[n], r[n < sz - 1 ? n + 1 : 0])]) continue;
                aromatic = false;
                break;
            }
            if (!aromatic) continue;
            ++nAromRings;
        }
        for (int n = this.ringBlock.length - 1; n >= 0; --n) {
            nRingBlocks = Math.max(nRingBlocks, this.ringBlock[n]);
        }
        IntegerArrayResult result = new IntegerArrayResult();
        result.add(nSmallRings);
        result.add(nAromRings);
        result.add(nRingBlocks);
        result.add(nAromBlocks);
        result.add(nRings3);
        result.add(nRings4);
        result.add(nRings5);
        result.add(nRings6);
        result.add(nRings7);
        result.add(nRings8);
        result.add(nRings9);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, NAMES);
    }

    private void excavateMolecule() throws CDKException {
        int n;
        int na = this.mol.getAtomCount();
        int nb = this.mol.getBondCount();
        this.atomAdj = new int[na][];
        this.bondAdj = new int[na][];
        this.bondOrder = new int[nb];
        for (n = 0; n < this.mol.getBondCount(); ++n) {
            IBond bond = this.mol.getBond(n);
            if (bond.getAtomCount() != 2) continue;
            int a1 = this.mol.indexOf(bond.getBegin());
            int a2 = this.mol.indexOf(bond.getEnd());
            this.atomAdj[a1] = this.appendInteger(this.atomAdj[a1], a2);
            this.bondAdj[a1] = this.appendInteger(this.bondAdj[a1], n);
            this.atomAdj[a2] = this.appendInteger(this.atomAdj[a2], a1);
            this.bondAdj[a2] = this.appendInteger(this.bondAdj[a2], n);
            if (bond.getOrder() == IBond.Order.SINGLE) {
                this.bondOrder[n] = 1;
                continue;
            }
            if (bond.getOrder() == IBond.Order.DOUBLE) {
                this.bondOrder[n] = 2;
                continue;
            }
            if (bond.getOrder() == IBond.Order.TRIPLE) {
                this.bondOrder[n] = 3;
                continue;
            }
            if (bond.getOrder() != IBond.Order.QUADRUPLE) continue;
            this.bondOrder[n] = 4;
        }
        for (n = 0; n < na; ++n) {
            if (this.atomAdj[n] != null) continue;
            this.atomAdj[n] = new int[0];
            this.bondAdj[n] = this.atomAdj[n];
        }
        this.implicitH = new int[na];
        String[] HYVALENCE_EL = new String[]{"C", "N", "O", "S", "P"};
        int[] HYVALENCE_VAL = new int[]{4, 3, 2, 2, 3};
        for (int n2 = 0; n2 < na; ++n2) {
            IAtom atom = this.mol.getAtom(n2);
            String el = atom.getSymbol();
            int hy = 0;
            for (int i = 0; i < HYVALENCE_EL.length; ++i) {
                if (!el.equals(HYVALENCE_EL[i])) continue;
                hy = HYVALENCE_VAL[i];
                break;
            }
            if (hy == 0) continue;
            int ch = atom.getFormalCharge();
            if (el.equals("C")) {
                ch = -Math.abs(ch);
            }
            boolean unpaired = false;
            hy += ch - 0;
            for (int i = 0; i < this.bondAdj[n2].length; ++i) {
                hy -= this.bondOrder[this.bondAdj[n2][i]];
            }
            this.implicitH[n2] = Math.max(0, hy);
        }
        this.markRingBlocks();
        ArrayList<int[]> rings = new ArrayList<int[]>();
        for (int rsz = 3; rsz <= 7; ++rsz) {
            int[] path = new int[rsz];
            for (int n3 = 0; n3 < na; ++n3) {
                if (this.ringBlock[n3] <= 0) continue;
                path[0] = n3;
                this.recursiveRingFind(path, 1, rsz, this.ringBlock[n3], rings);
            }
        }
        this.smallRings = (int[][])rings.toArray((T[])new int[rings.size()][]);
        this.detectStrictAromaticity();
        this.detectRelaxedAromaticity();
    }

    private void markRingBlocks() {
        int i;
        int na = this.mol.getAtomCount();
        this.ringBlock = new int[na];
        boolean[] visited = new boolean[na];
        int[] path = new int[na + 1];
        int plen = 0;
        while (true) {
            int current;
            int last;
            if (plen == 0) {
                last = -1;
                for (current = 0; current < na && visited[current]; ++current) {
                }
                if (current >= na) {
                    break;
                }
            } else {
                last = path[plen - 1];
                current = -1;
                for (int n = 0; n < this.atomAdj[last].length; ++n) {
                    if (visited[this.atomAdj[last][n]]) continue;
                    current = this.atomAdj[last][n];
                    break;
                }
            }
            if (current >= 0 && plen >= 2) {
                int back = path[plen - 1];
                for (int n = 0; n < this.atomAdj[current].length; ++n) {
                    int join = this.atomAdj[current][n];
                    if (join == back || !visited[join]) continue;
                    path[plen] = current;
                    for (int i2 = plen; i2 == plen || path[i2 + 1] != join; --i2) {
                        int id = this.ringBlock[path[i2]];
                        if (id == 0) {
                            this.ringBlock[path[i2]] = last;
                            continue;
                        }
                        if (id == last) continue;
                        for (int j = 0; j < na; ++j) {
                            if (this.ringBlock[j] != id) continue;
                            this.ringBlock[j] = last;
                        }
                    }
                }
            }
            if (current >= 0) {
                visited[current] = true;
                path[plen++] = current;
                continue;
            }
            --plen;
        }
        int nextID = 0;
        for (i = 0; i < na; ++i) {
            if (this.ringBlock[i] <= 0) continue;
            --nextID;
            for (int j = na - 1; j >= i; --j) {
                if (this.ringBlock[j] != this.ringBlock[i]) continue;
                this.ringBlock[j] = nextID;
            }
        }
        for (i = 0; i < na; ++i) {
            this.ringBlock[i] = -this.ringBlock[i];
        }
    }

    private void recursiveRingFind(int[] path, int psize, int capacity, int rblk, ArrayList<int[]> rings) {
        boolean flip;
        int n;
        if (psize < capacity) {
            int last = path[psize - 1];
            for (int n2 = 0; n2 < this.atomAdj[last].length; ++n2) {
                int adj = this.atomAdj[last][n2];
                if (this.ringBlock[adj] != rblk) continue;
                boolean fnd = false;
                for (int i = 0; i < psize; ++i) {
                    if (path[i] != adj) continue;
                    fnd = true;
                    break;
                }
                if (fnd) continue;
                int[] newPath = new int[capacity];
                for (int i = 0; i < psize; ++i) {
                    newPath[i] = path[i];
                }
                newPath[psize] = adj;
                this.recursiveRingFind(newPath, psize + 1, capacity, rblk, rings);
            }
            return;
        }
        int last = path[psize - 1];
        boolean fnd = false;
        for (n = 0; n < this.atomAdj[last].length; ++n) {
            if (this.atomAdj[last][n] != path[0]) continue;
            fnd = true;
            break;
        }
        if (!fnd) {
            return;
        }
        for (n = 0; n < path.length; ++n) {
            int count = 0;
            int p = path[n];
            block5: for (int i = 0; i < this.atomAdj[p].length; ++i) {
                for (int j = 0; j < path.length; ++j) {
                    if (this.atomAdj[p][i] != path[j]) continue;
                    ++count;
                    continue block5;
                }
            }
            if (count == 2) continue;
            return;
        }
        int first = 0;
        for (int n3 = 1; n3 < psize; ++n3) {
            if (path[n3] >= path[first]) continue;
            first = n3;
        }
        int fm = (first - 1 + psize) % psize;
        int fp = (first + 1) % psize;
        boolean bl = flip = path[fm] < path[fp];
        if (first != 0 || flip) {
            int[] newPath = new int[psize];
            for (int n4 = 0; n4 < psize; ++n4) {
                newPath[n4] = path[(first + (flip ? psize - n4 : n4)) % psize];
            }
            path = newPath;
        }
        for (int n5 = 0; n5 < rings.size(); ++n5) {
            int[] look = rings.get(n5);
            boolean same = true;
            for (int i = 0; i < psize; ++i) {
                if (look[i] == path[i]) continue;
                same = false;
                break;
            }
            if (!same) continue;
            return;
        }
        rings.add(path);
    }

    private void detectStrictAromaticity() {
        boolean anyChange;
        int na = this.mol.getAtomCount();
        int nb = this.mol.getBondCount();
        this.atomArom = new boolean[na];
        this.bondArom = new boolean[nb];
        if (this.smallRings.length == 0) {
            return;
        }
        this.piAtom = new boolean[na];
        for (int n = 0; n < nb; ++n) {
            if (this.bondOrder[n] != 2) continue;
            Object bond = this.mol.getBond(n);
            this.piAtom[this.mol.indexOf((IAtom)bond.getBegin())] = true;
            this.piAtom[this.mol.indexOf((IAtom)bond.getEnd())] = true;
        }
        ArrayList<Object> maybe = new ArrayList<Object>();
        for (int[] r : this.smallRings) {
            if (r.length != 6) continue;
            boolean consider = true;
            for (int n = 0; n < 6; ++n) {
                Object a = r[n];
                if (!this.piAtom[a]) {
                    consider = false;
                    break;
                }
                int b = this.findBond((int)a, (int)r[n == 5 ? 0 : n + 1]);
                if (this.bondOrder[b] == 1 || this.bondOrder[b] == 2) continue;
                consider = false;
                break;
            }
            if (!consider) continue;
            maybe.add(r);
        }
        do {
            anyChange = false;
            for (int n = maybe.size() - 1; n >= 0; --n) {
                int i;
                int[] r = (int[])maybe.get(n);
                boolean phase1 = true;
                boolean phase2 = true;
                for (i = 0; i < 6; ++i) {
                    int b = this.findBond(r[i], r[i == 5 ? 0 : i + 1]);
                    if (this.bondArom[b]) continue;
                    phase1 = phase1 && this.bondOrder[b] == 2 - (i & 1);
                    phase2 = phase2 && this.bondOrder[b] == 1 + (i & 1);
                }
                if (!phase1 && !phase2) continue;
                for (i = 0; i < r.length; ++i) {
                    this.atomArom[r[i]] = true;
                    this.bondArom[this.findBond((int)r[i], (int)r[i == 5 ? 0 : i + 1])] = true;
                }
                maybe.remove(n);
                anyChange = true;
            }
        } while (anyChange);
    }

    private void detectRelaxedAromaticity() {
        int n;
        int na = this.mol.getAtomCount();
        int nb = this.mol.getBondCount();
        int[] ELEMENT_BLOCKS = new int[]{0, 1, 2, 1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
        int[] ELEMENT_VALENCE = new int[]{0, 1, 2, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 3, 4, 5, 6, 7, 8, 1, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 3, 4, 5, 6, 7, 8, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        int[] electrons = new int[na];
        for (n = 0; n < na; ++n) {
            IAtom atom = this.mol.getAtom(n);
            int atno = atom.getAtomicNumber();
            electrons[n] = (ELEMENT_BLOCKS[atno] == 2 ? ELEMENT_VALENCE[atno] : 0) - atom.getFormalCharge() - this.implicitH[n];
        }
        for (n = 0; n < nb; ++n) {
            if (this.bondOrder[n] <= 0) continue;
            Object bond = this.mol.getBond(n);
            int n2 = this.mol.indexOf(bond.getBegin());
            electrons[n2] = electrons[n2] - this.bondOrder[n];
            int n3 = this.mol.indexOf(bond.getEnd());
            electrons[n3] = electrons[n3] - this.bondOrder[n];
        }
        ArrayList<Object> rings = new ArrayList<Object>();
        for (int[] r : this.smallRings) {
            if (r.length > 7) continue;
            boolean alreadyArom = true;
            boolean isInvalid = false;
            for (int n4 = 0; n4 < r.length; ++n4) {
                if (!this.piAtom[r[n4]] && electrons[r[n4]] < 2) {
                    isInvalid = true;
                    break;
                }
                int b = this.findBond((int)r[n4], (int)r[n4 < r.length - 1 ? n4 + 1 : 0]);
                int bo = this.bondOrder[b];
                if (bo != 1 && bo != 2) {
                    isInvalid = true;
                    break;
                }
                alreadyArom = alreadyArom && this.bondArom[b];
            }
            if (alreadyArom || isInvalid) continue;
            rings.add(r);
        }
        while (rings.size() > 0) {
            boolean anyChange = false;
            for (int n5 = 0; n5 < rings.size(); ++n5) {
                int[] r = (int[])rings.get(n5);
                int pairs = 0;
                int maybe = 0;
                for (int i = 0; i < r.length; ++i) {
                    int a = r[i];
                    int b1 = this.findBond(r[i], r[i < r.length - 1 ? i + 1 : 0]);
                    int b2 = this.findBond(r[i], r[i > 0 ? i - 1 : r.length - 1]);
                    if (this.bondArom[b1]) {
                        maybe += 2;
                        continue;
                    }
                    if (this.bondOrder[b1] == 2) {
                        pairs += 2;
                        continue;
                    }
                    if (electrons[a] < 2 || this.bondOrder[b2] == 2) continue;
                    pairs += 2;
                }
                boolean arom = false;
                while (maybe >= 0) {
                    if ((pairs + maybe - 2) % 4 == 0) {
                        arom = true;
                        break;
                    }
                    maybe -= 2;
                }
                if (!arom) continue;
                for (int i = 0; i < r.length; ++i) {
                    int a = r[i];
                    int b = this.findBond(r[i], r[i < r.length - 1 ? i + 1 : 0]);
                    this.atomArom[a] = true;
                    this.bondArom[b] = true;
                }
                rings.remove(n5);
                --n5;
                anyChange = true;
            }
            if (anyChange) continue;
            break;
        }
    }

    private int countAromaticComponents() {
        int na = this.mol.getAtomCount();
        int[][] graph = new int[na][];
        for (int n = 0; n < na; ++n) {
            for (int i = 0; i < this.atomAdj[n].length; ++i) {
                if (!this.bondArom[this.bondAdj[n][i]]) continue;
                graph[n] = this.appendInteger(graph[n], this.atomAdj[n][i]);
            }
        }
        int[] cc = new int[na];
        int first = -1;
        int high = 1;
        for (int n = 0; n < na; ++n) {
            if (graph[n] == null) {
                cc[n] = -1;
                continue;
            }
            if (first >= 0) continue;
            first = n;
            cc[n] = 1;
        }
        if (first < 0) {
            return 0;
        }
        while (true) {
            if (first < na && (cc[first] > 0 || cc[first] < 0)) {
                ++first;
                continue;
            }
            if (first >= na) break;
            boolean anything = false;
            for (int i = first; i < na; ++i) {
                if (cc[i] != 0) continue;
                for (int j = 0; j < graph[i].length; ++j) {
                    if (cc[graph[i][j]] == 0) continue;
                    cc[i] = cc[graph[i][j]];
                    anything = true;
                }
            }
            if (anything) continue;
            cc[first] = ++high;
        }
        return high;
    }

    private int[] appendInteger(int[] a, int v) {
        if (a == null || a.length == 0) {
            return new int[]{v};
        }
        int[] b = new int[a.length + 1];
        for (int n = a.length - 1; n >= 0; --n) {
            b[n] = a[n];
        }
        b[a.length] = v;
        return b;
    }

    private int findBond(int a1, int a2) {
        for (int n = this.atomAdj[a1].length - 1; n >= 0; --n) {
            if (this.atomAdj[a1][n] != a2) continue;
            return this.bondAdj[a1][n];
        }
        return -1;
    }
}

