/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.Set;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;

@TestClass(value="org.openscience.cdk.isomorphism.MappingPredicatesTest")
final class UniqueAtomMatches
implements Predicate<int[]> {
    private final Set<BitSet> unique;

    private UniqueAtomMatches(int expectedHits) {
        this.unique = Sets.newHashSetWithExpectedSize((int)expectedHits);
    }

    public UniqueAtomMatches() {
        this(10);
    }

    @TestMethod(value="uniqueAtoms")
    public boolean apply(int[] input) {
        return this.unique.add(this.toBitSet(input));
    }

    private BitSet toBitSet(int[] mapping) {
        BitSet hits = new BitSet();
        for (int v : mapping) {
            hits.set(v);
        }
        return hits;
    }
}

