/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.EigenDecompositionImpl;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.log4j.Logger;
import org.xmlcml.euclid.Diagonalise;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.RealMatrix;
import org.xmlcml.euclid.Vector3;

public class RealSquareMatrix
extends RealMatrix {
    static final Logger logger = Logger.getLogger(RealSquareMatrix.class);
    private EigenDecompositionImpl eigenDecompositionImpl;
    private RealSquareMatrix inverse;
    private RealArray eigenvalues;
    private RealSquareMatrix eigenvectors;

    public RealSquareMatrix() {
    }

    public RealSquareMatrix(int rows) {
        super(rows, rows);
    }

    public static RealSquareMatrix outerProduct(RealArray f) {
        int rows = f.size();
        RealSquareMatrix temp = new RealSquareMatrix(rows);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < rows; ++j) {
                temp.flmat[i][j] = f.elementAt(i) * f.elementAt(j);
            }
        }
        return temp;
    }

    public static RealSquareMatrix diagonal(RealArray f) {
        int rows = f.size();
        RealSquareMatrix temp = new RealSquareMatrix(rows);
        for (int i = 0; i < rows; ++i) {
            temp.flmat[i][i] = f.elementAt(i);
        }
        return temp;
    }

    public RealSquareMatrix(int rows, double[] array) throws EuclidRuntimeException {
        super(rows, rows, array);
    }

    public RealSquareMatrix(int rows, double f) {
        super(rows, rows, f);
    }

    public RealSquareMatrix(RealMatrix m, int lowrow, int lowcol, int rows) throws EuclidRuntimeException {
        super(m, lowrow, lowrow + rows - 1, lowcol, lowcol + rows - 1);
    }

    public RealSquareMatrix(RealSquareMatrix m) {
        super(m);
    }

    public RealSquareMatrix(RealMatrix m) throws EuclidRuntimeException {
        super(m.rows, m.cols);
        if (m.cols != m.rows) {
            throw new EuclidRuntimeException("non square matrix");
        }
        this.flmat = m.flmat;
    }

    public RealSquareMatrix(double[][] matrix) throws EuclidRuntimeException {
        super(matrix);
        if (this.cols != this.rows) {
            throw new EuclidRuntimeException("non square matrix");
        }
    }

    public void shallowCopy(RealSquareMatrix m) throws EuclidRuntimeException {
        super.shallowCopy(m);
    }

    public static RealSquareMatrix fromLowerTriangle(RealArray f) {
        int n = f.size();
        int rows = (int)Math.round((Math.sqrt(8 * n + 1) - 1.0 + 0.001) / 2.0);
        if (rows * (rows + 1) / 2 != n) {
            throw new RuntimeException("band number of values (" + n + ") for lower Triangle");
        }
        RealSquareMatrix temp = new RealSquareMatrix(rows);
        int count = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j <= i; ++j) {
                temp.flmat[i][j] = f.elementAt(count);
                if (i != j) {
                    temp.flmat[j][i] = 0.0;
                }
                ++count;
            }
        }
        return temp;
    }

    public static RealSquareMatrix fromUpperTriangle(RealArray f) {
        int n = f.size();
        int rows = (int)Math.round((Math.sqrt(8 * n + 1) - 1.0 + 0.001) / 2.0);
        if (rows * (rows + 1) / 2 != n) {
            throw new RuntimeException("band number of values (" + n + ") for lower Triangle");
        }
        RealSquareMatrix temp = new RealSquareMatrix(rows);
        int count = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = i; j < rows; ++j) {
                temp.flmat[i][j] = f.elementAt(count);
                if (i != j) {
                    temp.flmat[j][i] = 0.0;
                }
                ++count;
            }
        }
        return temp;
    }

    public boolean isEqualTo(RealSquareMatrix r) {
        return super.isEqualTo(r);
    }

    public RealSquareMatrix plus(RealSquareMatrix m) throws EuclidRuntimeException {
        RealMatrix temp = super.plus(m);
        RealSquareMatrix sqm = new RealSquareMatrix(temp);
        return sqm;
    }

    public RealSquareMatrix subtract(RealSquareMatrix m) throws EuclidRuntimeException {
        RealMatrix temp = super.subtract(m);
        RealSquareMatrix sqm = new RealSquareMatrix(temp);
        return sqm;
    }

    public RealSquareMatrix multiply(RealSquareMatrix m) throws EuclidRuntimeException {
        RealMatrix temp = super.multiply(m);
        RealSquareMatrix sqm = new RealSquareMatrix(temp);
        return sqm;
    }

    public double determinant() {
        double det = 0.0;
        if (this.rows == 1) {
            det = this.flmat[0][0];
        } else if (this.rows == 2) {
            det = this.flmat[0][0] * this.flmat[1][1] - this.flmat[1][0] * this.flmat[0][1];
        } else if (this.rows == 3) {
            det = this.flmat[0][0] * (this.flmat[1][1] * this.flmat[2][2] - this.flmat[1][2] * this.flmat[2][1]) + this.flmat[0][1] * (this.flmat[1][2] * this.flmat[2][0] - this.flmat[1][0] * this.flmat[2][2]) + this.flmat[0][2] * (this.flmat[1][0] * this.flmat[2][1] - this.flmat[1][1] * this.flmat[2][0]);
        } else {
            int sign = 1;
            for (int j = 0; j < this.cols; ++j) {
                det += (double)sign * this.flmat[0][j] * this.minorDet(j);
                sign = -sign;
            }
        }
        return det;
    }

    private double minorDet(int ii) {
        int r = this.rows - 1;
        double[] array = new double[r * r];
        int countN = 0;
        for (int i = 1; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                if (j == ii) continue;
                array[countN++] = this.flmat[i][j];
            }
        }
        RealSquareMatrix mm = null;
        try {
            mm = new RealSquareMatrix(r, array);
        }
        catch (Exception e) {
            throw new EuclidRuntimeException(e.toString());
        }
        double d = mm.determinant();
        return d;
    }

    public double trace() {
        double trace = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            trace += this.flmat[i][i];
        }
        return trace;
    }

    public boolean isUnit() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                double f = this.flmat[i][j];
                if ((Real.isZero(f, Real.getEpsilon()) || i == j) && (Real.isEqual(f, 1.0, Real.getEpsilon()) || i != j)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSymmetric() {
        for (int i = 0; i < this.rows - 1; ++i) {
            for (int j = i + 1; j < this.rows; ++j) {
                if (Real.isEqual(this.flmat[i][j], this.flmat[j][i])) continue;
                return false;
            }
        }
        return true;
    }

    public RealSquareMatrix orthonormalize() {
        if (this.cols == 1) {
            this.flmat[0][0] = 1.0;
        } else if (this.cols == 2) {
            Vector3 v1 = new Vector3(this.flmat[0][0], this.flmat[0][1], 0.0);
            v1 = v1.normalize();
            Vector3 v2 = new Vector3(this.flmat[1][0], this.flmat[1][1], 0.0);
            v2 = v2.normalize();
            Vector3 v3 = v1.cross(v2);
            v2 = v3.cross(v1);
            v2 = v2.normalize();
            this.flmat[0][0] = v1.flarray[0];
            this.flmat[0][1] = v1.flarray[1];
            this.flmat[1][0] = v2.flarray[0];
            this.flmat[1][1] = v2.flarray[1];
        } else if (this.cols == 3) {
            Vector3 v0 = new Vector3(this.extractRowData(0));
            Vector3 v1 = new Vector3(this.extractRowData(1));
            Vector3 v2 = new Vector3(this.extractRowData(2));
            double det = v0.getScalarTripleProduct(v1, v2);
            v0.normalize();
            v2 = v0.cross(v1);
            v2.normalize();
            v1 = v2.cross(v0);
            if (det < 0.0) {
                v2.negative();
            }
            this.replaceRowData(0, v0.getArray());
            this.replaceRowData(1, v1.getArray());
            this.replaceRowData(2, v2.getArray());
        } else {
            throw new EuclidRuntimeException("Sorry: orthonormalise only up to 3x3 matrices: had " + this.cols + " columns");
        }
        return this;
    }

    public boolean isOrthonormal() {
        return this.isUnitary();
    }

    public boolean isUpperTriangular() {
        for (int i = 1; i < this.rows; ++i) {
            for (int j = 0; j < i; ++j) {
                if (Real.isZero(this.flmat[i][j], Real.getEpsilon())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerTriangular() {
        for (int i = 0; i < this.rows - 1; ++i) {
            for (int j = i + 1; j < this.rows; ++j) {
                if (Real.isZero(this.flmat[i][j], Real.getEpsilon())) continue;
                return false;
            }
        }
        return true;
    }

    double rowDotproduct(int row1, int row2) {
        double sum = 0.0;
        for (int i = 0; i < this.cols; ++i) {
            sum += this.flmat[row1][i] * this.flmat[row2][i];
        }
        return sum;
    }

    public boolean isOrthogonal() {
        for (int i = 0; i < this.rows - 1; ++i) {
            for (int j = i + 1; j < this.rows; ++j) {
                double dp = this.rowDotproduct(i, j);
                if (Real.isZero(dp, Real.getEpsilon())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isImproperRotation() {
        double f = this.determinant();
        return Real.isEqual(f, -1.0) && this.isOrthogonal();
    }

    public boolean isUnitary() {
        double f = this.determinant();
        double fa = Math.abs(f);
        return Real.isEqual(fa, 1.0) && this.isOrthogonal();
    }

    public RealSquareMatrix copyUpperToLower() {
        for (int i = 0; i < this.cols - 1; ++i) {
            for (int j = i + 1; j < this.cols; ++j) {
                this.flmat[j][i] = this.flmat[i][j];
            }
        }
        return this;
    }

    public RealSquareMatrix copyLowerToUpper() {
        for (int i = 0; i < this.cols - 1; ++i) {
            for (int j = i + 1; j < this.cols; ++j) {
                this.flmat[i][j] = this.flmat[j][i];
            }
        }
        return this;
    }

    public RealArray lowerTriangle() {
        int n = this.rows;
        RealArray triangle = new RealArray(n * (n + 1) / 2);
        int count = 0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j <= i; ++j) {
                triangle.setElementAt(count++, this.flmat[i][j]);
            }
        }
        return triangle;
    }

    public void transpose() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < i; ++j) {
                double t = this.flmat[i][j];
                this.flmat[i][j] = this.flmat[j][i];
                this.flmat[j][i] = t;
            }
        }
    }

    public int diagonaliseAndReturnRank(RealArray eigenvalues, RealSquareMatrix eigenvectors, EuclidRuntimeException illCond) throws EuclidRuntimeException {
        RealArray lowert = this.lowerTriangle();
        double[] lower77 = new double[lowert.size() + 1];
        System.arraycopy(lowert.getArray(), 0, lower77, 1, lowert.size());
        int order = this.rows;
        if (this.rows < 2) {
            throw new EuclidRuntimeException("need at least 2 rows");
        }
        double[] eigenval77 = new double[this.rows + 1];
        double[] eigenvect77 = new double[this.rows * this.rows + 1];
        illCond = null;
        int rank = Diagonalise.vneigl(order, lower77, eigenval77, eigenvect77, illCond);
        double[] eigenval = new double[this.rows];
        System.arraycopy(eigenval77, 1, eigenval, 0, this.rows);
        double[] eigenvect = new double[this.rows * this.rows];
        System.arraycopy(eigenvect77, 1, eigenvect, 0, this.rows * this.rows);
        eigenvalues.shallowCopy(new RealArray(eigenval));
        eigenvectors.shallowCopy(new RealSquareMatrix(this.rows, eigenvect));
        return rank;
    }

    public void orthogonalise() throws EuclidRuntimeException {
        double l2;
        double l1;
        double l0;
        Vector3 v2;
        Vector3 v1;
        Vector3 v0;
        if (this.cols == 3) {
            v0 = new Vector3(this.extractRowData(0));
            v1 = new Vector3(this.extractRowData(1));
            v2 = new Vector3(this.extractRowData(2));
            l0 = v0.getLength();
            l1 = v1.getLength();
            l2 = v2.getLength();
            double det = v0.getScalarTripleProduct(v1, v2);
            v0.normalize();
            v2 = v0.cross(v1);
            v2.normalize();
            v1 = v2.cross(v0);
            if (det < 0.0) {
                v2 = v2.negative();
            }
        } else {
            throw new EuclidRuntimeException("Sorry: orthogonalise only up to 3x3 matrices");
        }
        v0 = v0.multiplyBy(l0);
        v1 = v1.multiplyBy(l1);
        v2 = v2.multiplyBy(l2);
        this.replaceRowData(0, v0.getArray());
        this.replaceRowData(1, v1.getArray());
        this.replaceRowData(2, v2.getArray());
    }

    public RealArray calculateEigenvalues() {
        this.solveDecomposition();
        return this.eigenvalues;
    }

    public RealSquareMatrix calculateInverse() {
        this.solveDecomposition();
        return this.inverse;
    }

    private void solveDecomposition() {
        if (this.eigenDecompositionImpl == null) {
            Array2DRowRealMatrix realMatrix = new Array2DRowRealMatrix(this.getMatrix());
            try {
                this.eigenDecompositionImpl = new EigenDecompositionImpl(realMatrix, 0.0);
                this.inverse = new RealSquareMatrix(this.eigenDecompositionImpl.getSolver().getInverse().getData());
                this.eigenvalues = new RealArray(this.eigenDecompositionImpl.getRealEigenvalues());
                this.eigenvectors = new RealSquareMatrix(this.eigenDecompositionImpl.getV().getData());
            }
            catch (InvalidMatrixException ime) {
                this.inverse = null;
                this.eigenvalues = null;
                this.eigenvectors = null;
            }
        }
    }

    public RealSquareMatrix calculateEigenvectors() {
        this.solveDecomposition();
        return this.eigenvectors;
    }

    public void resetEigenDecomposition() {
        this.eigenDecompositionImpl = null;
        this.inverse = null;
    }

    public static RealSquareMatrix getCrystallographicOrthogonalisation(double[] celleng, double[] angle) {
        RealSquareMatrix orthMat = new RealSquareMatrix(3);
        double dtor = Math.PI / 180;
        double sina = Math.sin(dtor * angle[0]);
        double cosa = Math.cos(dtor * angle[0]);
        double sinb = Math.sin(dtor * angle[1]);
        double cosb = Math.cos(dtor * angle[1]);
        double cosg = Math.cos(dtor * angle[2]);
        double cosgstar = (cosa * cosb - cosg) / (sina * sinb);
        double singstar = Math.sqrt(1.0 - cosgstar * cosgstar);
        double[][] omat = orthMat.getMatrix();
        omat[0][0] = celleng[0] * sinb * singstar;
        omat[0][1] = 0.0;
        omat[0][2] = 0.0;
        omat[1][0] = -celleng[0] * sinb * cosgstar;
        omat[1][1] = celleng[1] * sina;
        omat[1][2] = 0.0;
        omat[2][0] = celleng[0] * cosb;
        omat[2][1] = celleng[1] * cosa;
        omat[2][2] = celleng[2];
        return orthMat;
    }

    public RealSquareMatrix getInverse() throws EuclidRuntimeException {
        double[][] inv = new double[this.rows][this.rows];
        double[][] temp = this.getMatrix();
        double det = this.determinant();
        if (det == 0.0) {
            throw new EuclidRuntimeException("Cannot invert matrix: determinant=0");
        }
        double detr = 1.0 / det;
        if (this.rows == 1) {
            inv[0][0] = detr;
        } else if (this.rows == 2) {
            inv[0][0] = detr * temp[1][1];
            inv[1][0] = 0.0 - detr * temp[0][1];
            inv[0][1] = 0.0 - detr * temp[1][0];
            inv[1][1] = detr * temp[0][0];
        } else if (this.rows == 3) {
            inv[0][0] = detr * (temp[1][1] * temp[2][2] - temp[1][2] * temp[2][1]);
            inv[0][1] = detr * (temp[0][2] * temp[2][1] - temp[0][1] * temp[2][2]);
            inv[0][2] = detr * (temp[0][1] * temp[1][2] - temp[0][2] * temp[1][1]);
            inv[1][0] = detr * (temp[1][2] * temp[2][0] - temp[1][0] * temp[2][2]);
            inv[1][1] = detr * (temp[0][0] * temp[2][2] - temp[0][2] * temp[2][0]);
            inv[1][2] = detr * (temp[0][2] * temp[1][0] - temp[0][0] * temp[1][2]);
            inv[2][0] = detr * (temp[1][0] * temp[2][1] - temp[1][1] * temp[2][0]);
            inv[2][1] = detr * (temp[0][1] * temp[2][0] - temp[0][0] * temp[2][1]);
            inv[2][2] = detr * (temp[0][0] * temp[1][1] - temp[0][1] * temp[1][0]);
        } else {
            throw new EuclidRuntimeException("Inverse of larger than 3x3 matricies: NYI");
        }
        RealSquareMatrix imat = new RealSquareMatrix(inv);
        return imat;
    }

    private boolean dopivot(double[][] A, double[][] I, int diag, int nelem) {
        int i;
        if (A[diag][diag] != 0.0) {
            return true;
        }
        for (i = diag + 1; i < nelem; ++i) {
            if (A[i][diag] == 0.0) continue;
            double[] t = A[diag];
            A[diag] = A[i];
            A[i] = t;
            t = I[diag];
            I[diag] = I[i];
            I[i] = t;
            break;
        }
        return i < nelem;
    }

    private void matinv(double[][] A, double[][] I, int nelem) throws EuclidRuntimeException {
        for (int i = 0; i < nelem; ++i) {
            for (int j = 0; j < nelem; ++j) {
                I[i][j] = 0.0;
            }
            I[i][i] = 1.0;
        }
        for (int diag = 0; diag < nelem; ++diag) {
            if (!this.dopivot(A, I, diag, nelem)) {
                throw new EuclidRuntimeException("singular matrix");
            }
            double div = A[diag][diag];
            if (div != 1.0) {
                A[diag][diag] = 1.0;
                int j = diag + 1;
                while (j < nelem) {
                    double[] dArray = A[diag];
                    int n = j++;
                    dArray[n] = dArray[n] / div;
                }
                j = 0;
                while (j < nelem) {
                    double[] dArray = I[diag];
                    int n = j++;
                    dArray[n] = dArray[n] / div;
                }
            }
            for (int i = 0; i < nelem; ++i) {
                int j;
                double sub;
                if (i == diag || (sub = A[i][diag]) == 0.0) continue;
                A[i][diag] = 0.0;
                for (j = diag + 1; j < nelem; ++j) {
                    double[] dArray = A[i];
                    int n = j;
                    dArray[n] = dArray[n] - sub * A[diag][j];
                }
                for (j = 0; j < nelem; ++j) {
                    double[] dArray = I[i];
                    int n = j;
                    dArray[n] = dArray[n] - sub * I[diag][j];
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        UPPER_TRIANGLE(1),
        LOWER_TRIANGLE(2),
        SYMMETRIC(3),
        DIAGONAL(4),
        OUTER_PRODUCT(5),
        UNKNOWN(6);

        public int i;

        private Type(int i) {
            this.i = i;
        }
    }
}

