/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.tools.manipulator.AtomContainerSetManipulator;

@TestClass(value="org.openscience.cdk.tools.manipulator.MoleculeSetManipulatorTest")
public class MoleculeSetManipulator {
    @TestMethod(value="testGetAtomCount_IAtomContainerSet")
    public static int getAtomCount(IAtomContainerSet set) {
        return AtomContainerSetManipulator.getAtomCount(set);
    }

    @TestMethod(value="testGetBondCount_IAtomContainerSet")
    public static int getBondCount(IAtomContainerSet set) {
        return AtomContainerSetManipulator.getBondCount(set);
    }

    @TestMethod(value="testRemoveAtomAndConnectedElectronContainers_IMoleculeSet_IAtom")
    public static void removeAtomAndConnectedElectronContainers(IAtomContainerSet set, IAtom atom) {
        AtomContainerSetManipulator.removeAtomAndConnectedElectronContainers(set, atom);
    }

    @TestMethod(value="testRemoveElectronContainer_IMoleculeSet_IElectronContainer")
    public static void removeElectronContainer(IAtomContainerSet set, IElectronContainer electrons) {
        AtomContainerSetManipulator.removeElectronContainer(set, electrons);
    }

    @TestMethod(value="testGetAllAtomContainers_IMoleculeSet")
    public static List<IAtomContainer> getAllAtomContainers(IAtomContainerSet set) {
        return AtomContainerSetManipulator.getAllAtomContainers(set);
    }

    @TestMethod(value="testGetTotalCharge_IMoleculeSet")
    public static double getTotalCharge(IAtomContainerSet set) {
        return AtomContainerSetManipulator.getTotalCharge(set);
    }

    @TestMethod(value="testGetTotalFormalCharge_IMoleculeSet")
    public static double getTotalFormalCharge(IAtomContainerSet set) {
        return AtomContainerSetManipulator.getTotalFormalCharge(set);
    }

    @TestMethod(value="testGetTotalHydrogenCount_IMoleculeSet")
    public static int getTotalHydrogenCount(IAtomContainerSet set) {
        return AtomContainerSetManipulator.getTotalHydrogenCount(set);
    }

    @TestMethod(value="testGetAllIDs_IMoleculeSet")
    public static List<String> getAllIDs(IAtomContainerSet set) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(AtomContainerSetManipulator.getAllIDs(set));
        return list;
    }

    @TestMethod(value="testSetAtomProperties_IMoleculeSet_Object_Object")
    public static void setAtomProperties(IAtomContainerSet set, Object propKey, Object propVal) {
        AtomContainerSetManipulator.setAtomProperties(set, propKey, propVal);
    }

    @TestMethod(value="testGetRelevantAtomContainer_IMoleculeSet_IAtom")
    public static IAtomContainer getRelevantAtomContainer(IAtomContainerSet moleculeSet, IAtom atom) {
        return AtomContainerSetManipulator.getRelevantAtomContainer(moleculeSet, atom);
    }

    @TestMethod(value="testGetRelevantAtomContainer_IMoleculeSet_IBond")
    public static IAtomContainer getRelevantAtomContainer(IAtomContainerSet moleculeSet, IBond bond) {
        return AtomContainerSetManipulator.getRelevantAtomContainer(moleculeSet, bond);
    }

    @TestMethod(value="testGetAllChemObjects_IMoleculeSet")
    public static List<IChemObject> getAllChemObjects(IAtomContainerSet set) {
        return AtomContainerSetManipulator.getAllChemObjects(set);
    }
}

