/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import java.util.Iterator;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.isomorphism.State;

@TestClass(value="org.openscience.cdk.isomorphism.StateStreamTest")
final class StateStream
implements Iterator<int[]> {
    private final State state;
    private final CandidateStack stack;
    private int n = 0;
    private int m = -1;
    private int[] next;

    StateStream(State state) {
        this.state = state;
        this.stack = new CandidateStack(state.nMax());
        this.next = state.nMax() == 0 || state.mMax() == 0 ? null : this.findNext();
    }

    @Override
    @TestMethod(value="hasNext")
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    @TestMethod(value="next")
    public int[] next() {
        int[] ret = this.next;
        this.next = this.findNext();
        return ret;
    }

    @Override
    @TestMethod(value="remove")
    public void remove() {
        throw new UnsupportedOperationException("a graph matching cannot be removed");
    }

    private int[] findNext() {
        while (this.map()) {
        }
        if (this.state.size() == this.state.nMax()) {
            return this.state.mapping();
        }
        return null;
    }

    private boolean map() {
        if (!(this.n != this.state.nMax() && this.m != this.state.mMax() || this.stack.empty())) {
            this.n = this.stack.popN();
            this.m = this.stack.popM();
            this.state.remove(this.n, this.m);
        }
        while ((this.m = this.state.nextM(this.n, this.m)) < this.state.mMax()) {
            if (!this.state.add(this.n, this.m)) continue;
            this.stack.push(this.n, this.m);
            this.n = this.state.nextN(-1);
            this.m = -1;
            return this.n < this.state.nMax();
        }
        return this.state.size() > 0 || this.m < this.state.mMax();
    }

    private final class CandidateStack {
        private final int[] ns;
        private final int[] ms;
        private int nSize;
        private int mSize;

        private CandidateStack(int capacity) {
            this.ns = new int[capacity];
            this.ms = new int[capacity];
        }

        void push(int n, int m) {
            this.ns[this.nSize++] = n;
            this.ms[this.mSize++] = m;
        }

        int popN() {
            return this.ns[--this.nSize];
        }

        int popM() {
            return this.ms[--this.mSize];
        }

        boolean empty() {
            return this.nSize == 0 && this.mSize == 0;
        }
    }
}

