/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.graph.SimpleGraph;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.BFSShortestPath;
import org.openscience.cdk.graph.MoleculeGraphs;
import org.openscience.cdk.graph.invariant.ConjugatedPiSystemsDetector;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.qsar.descriptors.atomic.RDFProtonDescriptor_GHR_topolTest")
public class RDFProtonDescriptor_GHR_topol
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private boolean checkAromaticity = false;
    private IAtomContainer acold = null;
    private IRingSet varRingSet = null;
    private IAtomContainerSet varAtomContainerSet = null;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(RDFProtonDescriptor_GHR_topol.class);
    private final int ghr_topol_desc_length = 15;

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#rdfProtonCalculatedValues", this.getClass().getName(), "$Id: 8e340c27394c4484c1db9ef1e75e0422d7a5212e $", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("RDFProtonDescriptor only expects one parameters");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The second parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity};
        return params;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        String[] descriptorNames = new String[15];
        for (int i = 0; i < 15; ++i) {
            descriptorNames[i] = "gHrTop_" + (i + 1);
        }
        return descriptorNames;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        DoubleArrayResult result = new DoubleArrayResult(15);
        for (int i = 0; i < 15; ++i) {
            result.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, this.getDescriptorNames(), e);
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom atom, IAtomContainer varAtomContainerSet) {
        return this.calculate(atom, varAtomContainerSet, null);
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom atom, IAtomContainer atomContainer, IRingSet precalculatedringset) {
        IAtomContainer varAtomContainer = null;
        try {
            varAtomContainer = atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(e);
        }
        int atomPosition = atomContainer.getAtomNumber(atom);
        IAtom clonedAtom = varAtomContainer.getAtom(atomPosition);
        DoubleArrayResult rdfProtonCalculatedValues = new DoubleArrayResult(15);
        if (!atom.getSymbol().equals("H")) {
            return this.getDummyDescriptorValue(new CDKException("Invalid atom specified"));
        }
        IAtomContainer mol = varAtomContainer.getBuilder().newInstance(IAtomContainer.class, varAtomContainer);
        if (varAtomContainer != this.acold) {
            this.acold = varAtomContainer;
            this.varAtomContainerSet = ConjugatedPiSystemsDetector.detect(mol);
            if (precalculatedringset == null) {
                try {
                    this.varRingSet = new AllRingsFinder().findAllRings(varAtomContainer);
                }
                catch (CDKException e) {
                    return this.getDummyDescriptorValue(e);
                }
            } else {
                this.varRingSet = precalculatedringset;
            }
            try {
                GasteigerMarsiliPartialCharges peoe = new GasteigerMarsiliPartialCharges();
                peoe.assignGasteigerMarsiliSigmaPartialCharges(mol, true);
            }
            catch (Exception ex1) {
                return this.getDummyDescriptorValue(ex1);
            }
        }
        if (this.checkAromaticity) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(varAtomContainer);
                CDKHueckelAromaticityDetector.detectAromaticity(varAtomContainer);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(e);
            }
        }
        for (IBond bond : varAtomContainer.bonds()) {
            IRingSet ringsWithThisBond = this.varRingSet.getRings(bond);
            if (ringsWithThisBond.getAtomContainerCount() <= 0) continue;
            bond.setFlag(2, true);
        }
        for (int w = 0; w < varAtomContainer.getAtomCount(); ++w) {
            IRingSet ringsWithThisAtom = this.varRingSet.getRings(varAtomContainer.getAtom(w));
            if (ringsWithThisAtom.getAtomContainerCount() <= 0) continue;
            varAtomContainer.getAtom(w).setFlag(2, true);
        }
        IAtomContainer detected = this.varAtomContainerSet.getAtomContainer(0);
        List<IAtom> neighboors = mol.getConnectedAtomsList(clonedAtom);
        IAtom neighbour0 = neighboors.get(0);
        List<IAtom> atomsInSecondSphere = mol.getConnectedAtomsList(neighbour0);
        List<IAtom> atomsInThirdSphere = null;
        List<IAtom> atomsInFourthSphere = null;
        List<IAtom> atomsInFifthSphere = null;
        List<IAtom> atomsInSixthSphere = null;
        List<IAtom> atomsInSeventhSphere = null;
        ArrayList<Integer> singles = new ArrayList<Integer>();
        ArrayList<Integer> doubles = new ArrayList<Integer>();
        ArrayList<Integer> atoms = new ArrayList<Integer>();
        ArrayList<Integer> bondsInCycloex = new ArrayList<Integer>();
        Iterator<IAtom> i$ = atomsInSecondSphere.iterator();
        while (i$.hasNext()) {
            IAtom anAtomsInSecondSphere;
            IAtom curAtomSecond = anAtomsInSecondSphere = i$.next();
            IBond secondBond = mol.getBond(neighbour0, curAtomSecond);
            if (mol.getAtomNumber(curAtomSecond) == atomPosition || !this.getIfBondIsNotRotatable(mol, secondBond, detected)) continue;
            int sphere = 2;
            IBond.Order bondOrder = secondBond.getOrder();
            int bondNumber = mol.getBondNumber(secondBond);
            boolean theBondIsInA6MemberedRing = false;
            this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.getAtomNumber(curAtomSecond), atoms, sphere, theBondIsInA6MemberedRing);
            atomsInThirdSphere = mol.getConnectedAtomsList(curAtomSecond);
            if (atomsInThirdSphere.size() <= 0) continue;
            Iterator<IAtom> i$2 = atomsInThirdSphere.iterator();
            while (i$2.hasNext()) {
                IAtom anAtomsInThirdSphere;
                IAtom curAtomThird = anAtomsInThirdSphere = i$2.next();
                IBond thirdBond = mol.getBond(curAtomThird, curAtomSecond);
                if (mol.getAtomNumber(curAtomThird) == atomPosition || !this.getIfBondIsNotRotatable(mol, thirdBond, detected)) continue;
                sphere = 3;
                bondOrder = thirdBond.getOrder();
                bondNumber = mol.getBondNumber(thirdBond);
                theBondIsInA6MemberedRing = false;
                if (!thirdBond.getFlag(32) && !curAtomThird.equals(neighbour0)) {
                    IRingSet rsAtom = this.varRingSet.getRings(thirdBond);
                    for (IAtomContainer aRsAtom : rsAtom.atomContainers()) {
                        IRing ring = (IRing)aRsAtom;
                        if (ring.getRingSize() <= 4 || !ring.contains(thirdBond)) continue;
                        theBondIsInA6MemberedRing = true;
                    }
                }
                this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.getAtomNumber(curAtomThird), atoms, sphere, theBondIsInA6MemberedRing);
                theBondIsInA6MemberedRing = false;
                atomsInFourthSphere = mol.getConnectedAtomsList(curAtomThird);
                if (atomsInFourthSphere.size() <= 0) continue;
                Iterator<IChemObject> i$3 = atomsInFourthSphere.iterator();
                while (i$3.hasNext()) {
                    IAtom anAtomsInFourthSphere;
                    IAtom curAtomFourth = anAtomsInFourthSphere = (IAtom)i$3.next();
                    IBond fourthBond = mol.getBond(curAtomThird, curAtomFourth);
                    if (mol.getAtomNumber(curAtomFourth) == atomPosition || !this.getIfBondIsNotRotatable(mol, fourthBond, detected)) continue;
                    sphere = 4;
                    bondOrder = fourthBond.getOrder();
                    bondNumber = mol.getBondNumber(fourthBond);
                    theBondIsInA6MemberedRing = false;
                    this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.getAtomNumber(curAtomFourth), atoms, sphere, theBondIsInA6MemberedRing);
                    atomsInFifthSphere = mol.getConnectedAtomsList(curAtomFourth);
                    if (atomsInFifthSphere.size() <= 0) continue;
                    Iterator<IAtom> i$4 = atomsInFifthSphere.iterator();
                    while (i$4.hasNext()) {
                        IAtom anAtomsInFifthSphere;
                        IAtom curAtomFifth = anAtomsInFifthSphere = i$4.next();
                        IBond fifthBond = mol.getBond(curAtomFifth, curAtomFourth);
                        if (mol.getAtomNumber(curAtomFifth) == atomPosition || !this.getIfBondIsNotRotatable(mol, fifthBond, detected)) continue;
                        sphere = 5;
                        bondOrder = fifthBond.getOrder();
                        bondNumber = mol.getBondNumber(fifthBond);
                        theBondIsInA6MemberedRing = false;
                        this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.getAtomNumber(curAtomFifth), atoms, sphere, theBondIsInA6MemberedRing);
                        atomsInSixthSphere = mol.getConnectedAtomsList(curAtomFifth);
                        if (atomsInSixthSphere.size() <= 0) continue;
                        Iterator<IAtom> i$5 = atomsInSixthSphere.iterator();
                        while (i$5.hasNext()) {
                            IAtom anAtomsInSixthSphere;
                            IAtom curAtomSixth = anAtomsInSixthSphere = i$5.next();
                            IBond sixthBond = mol.getBond(curAtomFifth, curAtomSixth);
                            if (mol.getAtomNumber(curAtomSixth) == atomPosition || !this.getIfBondIsNotRotatable(mol, sixthBond, detected)) continue;
                            sphere = 6;
                            bondOrder = sixthBond.getOrder();
                            bondNumber = mol.getBondNumber(sixthBond);
                            theBondIsInA6MemberedRing = false;
                            this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.getAtomNumber(curAtomSixth), atoms, sphere, theBondIsInA6MemberedRing);
                            atomsInSeventhSphere = mol.getConnectedAtomsList(curAtomSixth);
                            if (atomsInSeventhSphere.size() <= 0) continue;
                            Iterator<IAtom> i$6 = atomsInSeventhSphere.iterator();
                            while (i$6.hasNext()) {
                                IAtom anAtomsInSeventhSphere;
                                IAtom curAtomSeventh = anAtomsInSeventhSphere = i$6.next();
                                IBond seventhBond = mol.getBond(curAtomSeventh, curAtomSixth);
                                if (mol.getAtomNumber(curAtomSeventh) == atomPosition || !this.getIfBondIsNotRotatable(mol, seventhBond, detected)) continue;
                                sphere = 7;
                                bondOrder = seventhBond.getOrder();
                                bondNumber = mol.getBondNumber(seventhBond);
                                theBondIsInA6MemberedRing = false;
                                this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.getAtomNumber(curAtomSeventh), atoms, sphere, theBondIsInA6MemberedRing);
                            }
                        }
                    }
                }
            }
        }
        double smooth = -20.0;
        double limitInf = 1.4;
        double limitSup = 4.0;
        double step = (limitSup - limitInf) / 15.0;
        double distance = 0.0;
        double sum = 0.0;
        smooth = -20.0;
        int position = 0;
        IAtom atom2 = null;
        SimpleGraph mygraph = MoleculeGraphs.getMoleculeGraph(mol);
        IAtom startVertex = clonedAtom;
        double partial = 0.0;
        limitInf = 1.4;
        limitSup = 4.0;
        step = (limitSup - limitInf) / 15.0;
        if (atoms.size() > 0) {
            int counter = 0;
            for (double ghrt = limitInf; ghrt < limitSup; ghrt += step) {
                sum = 0.0;
                for (int at = 0; at < atoms.size(); ++at) {
                    partial = 0.0;
                    distance = 0.0;
                    Integer thisAtom = atoms.get(at);
                    position = thisAtom;
                    IAtom endVertex = mol.getAtom(position);
                    atom2 = mol.getAtom(position);
                    List<Edge> mylist = BFSShortestPath.findPathBetween(mygraph, startVertex, endVertex);
                    for (int u = 0; u < mylist.size(); ++u) {
                        Edge edg = mylist.get(u);
                        IAtom atomTarget = (IAtom)edg.getTarget();
                        IAtom atomSource = (IAtom)edg.getSource();
                        distance += this.calculateDistanceBetweenTwoAtoms(atomTarget, atomSource);
                    }
                    partial = atom2.getCharge() * Math.exp(smooth * Math.pow(ghrt - distance, 2.0));
                    sum += partial;
                }
                rdfProtonCalculatedValues.add(sum);
                logger.debug("RDF gr-topol distance prob.: " + sum + " at distance " + ghrt);
                ++counter;
            }
        } else {
            return this.getDummyDescriptorValue(new CDKException("Some error occurred. Please report"));
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), rdfProtonCalculatedValues, this.getDescriptorNames());
    }

    private boolean getIfBondIsNotRotatable(IAtomContainer mol, IBond bond, IAtomContainer detected) {
        boolean isBondNotRotatable = false;
        int counter = 0;
        IAtom atom0 = bond.getAtom(0);
        IAtom atom1 = bond.getAtom(1);
        if (detected != null && detected.contains(bond)) {
            ++counter;
        }
        if (atom0.getFlag(2)) {
            counter = atom1.getFlag(2) ? ++counter : (atom1.getSymbol().equals("H") ? ++counter : (counter += 0));
        }
        if (atom0.getSymbol().equals("N") && atom1.getSymbol().equals("C") && this.getIfACarbonIsDoubleBondedToAnOxygen(mol, atom1)) {
            ++counter;
        }
        if (atom0.getSymbol().equals("C") && atom1.getSymbol().equals("N") && this.getIfACarbonIsDoubleBondedToAnOxygen(mol, atom0)) {
            ++counter;
        }
        if (counter > 0) {
            isBondNotRotatable = true;
        }
        return isBondNotRotatable;
    }

    private boolean getIfACarbonIsDoubleBondedToAnOxygen(IAtomContainer mol, IAtom carbonAtom) {
        boolean isDoubleBondedToOxygen = false;
        List<IAtom> neighToCarbon = mol.getConnectedAtomsList(carbonAtom);
        int counter = 0;
        for (int nei = 0; nei < neighToCarbon.size(); ++nei) {
            IBond tmpBond;
            IAtom neighbour = neighToCarbon.get(nei);
            if (!neighbour.getSymbol().equals("O") || (tmpBond = mol.getBond(neighbour, carbonAtom)).getOrder() != IBond.Order.DOUBLE) continue;
            ++counter;
        }
        if (counter > 0) {
            isDoubleBondedToOxygen = true;
        }
        return isDoubleBondedToOxygen;
    }

    private double calculateAngleBetweenTwoLines(Vector3d a, Vector3d b, Vector3d c, Vector3d d) {
        Vector3d firstLine = new Vector3d();
        firstLine.sub(a, b);
        Vector3d secondLine = new Vector3d();
        secondLine.sub(c, d);
        Vector3d firstVec = new Vector3d(firstLine);
        Vector3d secondVec = new Vector3d(secondLine);
        return firstVec.angle(secondVec);
    }

    private void checkAndStore(int bondToStore, IBond.Order bondOrder, ArrayList<Integer> singleVec, ArrayList<Integer> doubleVec, ArrayList<Integer> cycloexVec, int a1, ArrayList<Integer> atomVec, int sphere, boolean isBondInCycloex) {
        if (!atomVec.contains(a1) && sphere < 6) {
            atomVec.add(a1);
        }
        if (!cycloexVec.contains(bondToStore) && isBondInCycloex) {
            cycloexVec.add(bondToStore);
        }
        if (bondOrder == IBond.Order.DOUBLE && !doubleVec.contains(bondToStore)) {
            doubleVec.add(bondToStore);
        }
        if (bondOrder == IBond.Order.SINGLE && !singleVec.contains(bondToStore)) {
            singleVec.add(bondToStore);
        }
    }

    private double calculateDistanceBetweenTwoAtoms(IAtom atom1, IAtom atom2) {
        Point3d firstPoint = atom1.getPoint3d();
        Point3d secondPoint = atom2.getPoint3d();
        double distance = firstPoint.distance(secondPoint);
        return distance;
    }

    private int getNearestBondtoAGivenAtom(IAtomContainer mol, IAtom atom, IBond bond) {
        int nearestBond = 0;
        double distance = 0.0;
        IAtom atom0 = bond.getAtom(0);
        IAtom atom1 = bond.getAtom(1);
        List<IBond> bondsAtLeft = mol.getConnectedBondsList(atom0);
        for (int i = 0; i < bondsAtLeft.size(); ++i) {
            IBond curBond = bondsAtLeft.get(i);
            double[] values = this.calculateDistanceBetweenAtomAndBond(atom, curBond);
            int partial = mol.getBondNumber(curBond);
            if (i == 0) {
                nearestBond = mol.getBondNumber(curBond);
                distance = values[0];
                continue;
            }
            if (!(values[0] < distance)) continue;
            nearestBond = partial;
        }
        return nearestBond;
    }

    private double[] calculateDistanceBetweenAtomAndBond(IAtom proton, IBond theBond) {
        Point3d middlePoint = theBond.get3DCenter();
        Point3d protonPoint = proton.getPoint3d();
        double[] values = new double[]{middlePoint.distance(protonPoint), middlePoint.x, middlePoint.y, middlePoint.z};
        return values;
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity"};
        return params;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        if (name.equals("checkAromaticity")) {
            return Boolean.TRUE;
        }
        return null;
    }
}

