/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.invariant;

import com.google.common.primitives.Ints;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class MorganNumbersTools {
    private static final int INITIAL_DEGREE = 4;

    public static long[] getMorganNumbers(IAtomContainer molecule) {
        int order = molecule.getAtomCount();
        long[] currentInvariants = new long[order];
        long[] previousInvariants = new long[order];
        int[][] graph = new int[order][4];
        int[] degree = new int[order];
        int[] nonHydrogens = new int[order];
        for (int v = 0; v < order; ++v) {
            nonHydrogens[v] = "H".equals(molecule.getAtom(v).getSymbol()) ? 0 : 1;
        }
        for (IBond bond : molecule.bonds()) {
            int u = molecule.getAtomNumber(bond.getAtom(0));
            int v = molecule.getAtomNumber(bond.getAtom(1));
            graph[u] = Ints.ensureCapacity(graph[u], degree[u] + 1, 4);
            graph[v] = Ints.ensureCapacity(graph[v], degree[v] + 1, 4);
            int n = u;
            int n2 = degree[n];
            degree[n] = n2 + 1;
            graph[u][n2] = v;
            int n3 = v;
            int n4 = degree[n3];
            degree[n3] = n4 + 1;
            graph[v][n4] = u;
            int n5 = u;
            currentInvariants[n5] = currentInvariants[n5] + (long)nonHydrogens[v];
            int n6 = v;
            currentInvariants[n6] = currentInvariants[n6] + (long)nonHydrogens[u];
        }
        for (int i = 0; i < order; ++i) {
            System.arraycopy(currentInvariants, 0, previousInvariants, 0, order);
            for (int u = 0; u < order; ++u) {
                currentInvariants[u] = 0L;
                int[] neighbors = graph[u];
                for (int j = 0; j < degree[u]; ++j) {
                    int v = neighbors[j];
                    int n = u;
                    currentInvariants[n] = currentInvariants[n] + previousInvariants[v] * (long)nonHydrogens[v];
                }
            }
        }
        return currentInvariants;
    }

    public static String[] getMorganNumbersWithElementSymbol(IAtomContainer atomContainer) {
        long[] morgannumbers = MorganNumbersTools.getMorganNumbers(atomContainer);
        String[] morgannumberswithelement = new String[morgannumbers.length];
        for (int i = 0; i < morgannumbers.length; ++i) {
            morgannumberswithelement[i] = atomContainer.getAtom(i).getSymbol() + "-" + morgannumbers[i];
        }
        return morgannumberswithelement;
    }
}

