/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.io.Serializable;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.math.Primes;

@TestClass(value="org.openscience.cdk.smiles.InvPairTest")
public class InvPair
implements Serializable {
    private static final long serialVersionUID = -1397634098919863122L;
    public static final String INVARIANCE_PAIR = "InvariancePair";
    public static final String CANONICAL_LABEL = "CanonicalLabel";
    private long last = 0L;
    private long curr = 0L;
    private IAtom atom;
    private int prime;

    public InvPair() {
    }

    public InvPair(long current, IAtom atom) {
        this.curr = current;
        this.atom = atom;
        atom.setProperty(INVARIANCE_PAIR, this);
    }

    @TestMethod(value="testGetLast")
    public long getLast() {
        return this.last;
    }

    @TestMethod(value="testSetCurr_long")
    public void setCurr(long newCurr) {
        this.curr = newCurr;
    }

    @TestMethod(value="testGetCurr")
    public long getCurr() {
        return this.curr;
    }

    @TestMethod(value="testEquals_Object")
    public boolean equals(Object object) {
        if (object instanceof InvPair) {
            InvPair o = (InvPair)object;
            return this.last == o.getLast() && this.curr == o.getCurr();
        }
        return false;
    }

    @TestMethod(value="testSetLast_long")
    public void setLast(long newLast) {
        this.last = newLast;
    }

    @TestMethod(value="testSetAtom_IAtom")
    public void setAtom(IAtom newAtom) {
        this.atom = newAtom;
    }

    @TestMethod(value="testGetAtom")
    public IAtom getAtom() {
        return this.atom;
    }

    @TestMethod(value="testCommit")
    public void commit() {
        this.atom.setProperty(CANONICAL_LABEL, this.curr);
    }

    @TestMethod(value="testToString")
    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.curr);
        buff.append("\t");
        return buff.toString();
    }

    @TestMethod(value="testGetPrime")
    public int getPrime() {
        return this.prime;
    }

    @TestMethod(value="testSetPrime")
    public void setPrime() {
        this.prime = Primes.getPrimeAt((int)this.curr - 1);
    }
}

