/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.similarity;

import java.util.BitSet;
import java.util.Map;
import java.util.TreeSet;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.similarity.TanimotoTest")
public class Tanimoto {
    private Tanimoto() {
    }

    @TestMethod(value="testTanimoto1,testTanimoto2")
    public static float calculate(BitSet bitset1, BitSet bitset2) throws CDKException {
        float _bitset1_cardinality = bitset1.cardinality();
        float _bitset2_cardinality = bitset2.cardinality();
        if (bitset1.size() != bitset2.size()) {
            throw new CDKException("Bitsets must have the same bit length");
        }
        BitSet one_and_two = (BitSet)bitset1.clone();
        one_and_two.and(bitset2);
        float _common_bit_count = one_and_two.cardinality();
        return _common_bit_count / (_bitset1_cardinality + _bitset2_cardinality - _common_bit_count);
    }

    @TestMethod(value="testTanimoto3")
    public static float calculate(double[] features1, double[] features2) throws CDKException {
        if (features1.length != features2.length) {
            throw new CDKException("Features vectors must be of the same length");
        }
        int n = features1.length;
        double ab = 0.0;
        double a2 = 0.0;
        double b2 = 0.0;
        for (int i = 0; i < n; ++i) {
            ab += features1[i] * features2[i];
            a2 += features1[i] * features1[i];
            b2 += features2[i] * features2[i];
        }
        return (float)ab / (float)(a2 + b2 - ab);
    }

    @TestMethod(value="testTanimoto4")
    public static float calculate(Map<String, Integer> features1, Map<String, Integer> features2) {
        TreeSet<String> common = new TreeSet<String>(features1.keySet());
        common.retainAll(features2.keySet());
        double xy = 0.0;
        double x = 0.0;
        double y = 0.0;
        for (String s : common) {
            int c1 = features1.get(s);
            int c2 = features2.get(s);
            xy += (double)Math.max(c1, c2);
        }
        for (Integer c : features1.values()) {
            x += (double)c.intValue();
        }
        for (Integer c : features2.values()) {
            y += (double)c.intValue();
        }
        return (float)(xy / (x + y - xy));
    }
}

