/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.charges.Polarizability;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.matrix.AdjacencyMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.AutocorrelationDescriptorPolarizabilityTest")
public class AutocorrelationDescriptorPolarizability
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"ATSp1", "ATSp2", "ATSp3", "ATSp4", "ATSp5"};

    private static double[] listpolarizability(IAtomContainer container, int[][] dmat) throws CDKException {
        int natom = container.getAtomCount();
        double[] polars = new double[natom];
        Polarizability polar = new Polarizability();
        for (int i = 0; i < natom; ++i) {
            IAtom atom = container.getAtom(i);
            try {
                polars[i] = polar.calculateGHEffectiveAtomPolarizability(container, atom, false, dmat);
                continue;
            }
            catch (Exception ex1) {
                throw new CDKException("Problems with assign Polarizability due to " + ex1.toString(), ex1);
            }
        }
        return polars;
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer container) {
        IAtomContainer molecule;
        try {
            molecule = (IAtomContainer)container.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(new CDKException("Error occured during clone " + e));
        }
        try {
            CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(molecule.getBuilder());
            for (IAtom atom : molecule.atoms()) {
                IAtomType type = matcher.findMatchingAtomType(molecule, atom);
                AtomTypeManipulator.configure(atom, type);
            }
            CDKHydrogenAdder hAdder = CDKHydrogenAdder.getInstance(molecule.getBuilder());
            hAdder.addImplicitHydrogens(molecule);
            AtomContainerManipulator.convertImplicitToExplicitHydrogens(molecule);
        }
        catch (Exception e) {
            return this.getDummyDescriptorValue(new CDKException("Could not add hydrogens: " + e.getMessage(), e));
        }
        try {
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(molecule);
        }
        catch (CDKException e) {
            return this.getDummyDescriptorValue(new CDKException("Could not percieve atom types: " + e.getMessage(), e));
        }
        try {
            CDKHueckelAromaticityDetector.detectAromaticity(molecule);
        }
        catch (CDKException e) {
            return this.getDummyDescriptorValue(new CDKException("Could not percieve aromaticity: " + e.getMessage(), e));
        }
        int[][] distancematrix = PathTools.computeFloydAPSP(AdjacencyMatrix.getMatrix(molecule));
        try {
            double[] w = AutocorrelationDescriptorPolarizability.listpolarizability(molecule, distancematrix);
            int natom = molecule.getAtomCount();
            double[] PolarizabilitySum = new double[5];
            for (int k = 0; k < 5; ++k) {
                for (int i = 0; i < natom; ++i) {
                    if (molecule.getAtom(i).getSymbol().equals("H")) continue;
                    for (int j = 0; j < natom; ++j) {
                        if (molecule.getAtom(j).getSymbol().equals("H")) continue;
                        if (distancematrix[i][j] == k) {
                            int n = k;
                            PolarizabilitySum[n] = PolarizabilitySum[n] + w[i] * w[j];
                            continue;
                        }
                        int n = k;
                        PolarizabilitySum[n] = PolarizabilitySum[n] + 0.0;
                    }
                }
                if (k <= 0) continue;
                PolarizabilitySum[k] = PolarizabilitySum[k] / 2.0;
            }
            DoubleArrayResult result = new DoubleArrayResult(5);
            for (double aPolarizabilitySum : PolarizabilitySum) {
                result.add(aPolarizabilitySum);
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, this.getDescriptorNames());
        }
        catch (Exception ex) {
            return this.getDummyDescriptorValue(new CDKException("Error while calculating the ATSpolarizabilty descriptor: " + ex.getMessage(), ex));
        }
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        DoubleArrayResult results = new DoubleArrayResult(5);
        for (int i = 0; i < 5; ++i) {
            results.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames(), e);
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#autoCorrelationPolarizability", this.getClass().getName(), "$Id: 1fc52a1562663e39af64e1b4af4c23b9a103e526 $", "The Chemistry Development Kit");
    }

    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(5);
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }
}

