/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.SmilesGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.fingerprint.LingoFingerprinterTest")
public class LingoFingerprinter
implements IFingerprinter {
    int q = 4;
    SmilesGenerator gen = new SmilesGenerator(true);
    Pattern ringClosurePattern = Pattern.compile("[0-9]+");

    @TestMethod(value="testFingerprint")
    public LingoFingerprinter() {
    }

    @TestMethod(value="testFingerprint")
    public LingoFingerprinter(int q) {
        this.q = q;
    }

    @Override
    public BitSet getFingerprint(IAtomContainer iAtomContainer) throws CDKException {
        throw new UnsupportedOperationException();
    }

    @Override
    @TestMethod(value="testFingerprint")
    public Map<String, Integer> getRawFingerprint(IAtomContainer atomContainer) throws CDKException {
        String smiles = this.refactorSmiles(this.gen.createSMILES(atomContainer));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < smiles.length() - this.q + 1; ++i) {
            String subsmi = smiles.substring(i, i + this.q);
            if (map.containsKey(subsmi)) {
                map.put(subsmi, (Integer)map.get(subsmi) + 1);
                continue;
            }
            map.put(subsmi, 1);
        }
        return map;
    }

    @Override
    @TestMethod(value="testGetSize")
    public int getSize() {
        return -1;
    }

    private String refactorSmiles(String smiles) {
        Matcher matcher = this.ringClosurePattern.matcher(smiles);
        return matcher.replaceAll("0");
    }
}

