/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingVector;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETENode;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETERuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETESinkNode;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETESourceNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RETEQueue
implements RETESinkNode,
RETESourceNode {
    protected HashMap<BindingVector, Count> queue = new HashMap();
    protected byte[] matchIndices;
    protected RETEQueue sibling;
    protected RETESinkNode continuation;

    public RETEQueue(byte[] matchIndices) {
        this.matchIndices = matchIndices;
    }

    public RETEQueue(List<? extends Byte> matchIndexList) {
        int len = matchIndexList.size();
        this.matchIndices = new byte[len];
        for (int i = 0; i < len; ++i) {
            this.matchIndices[i] = matchIndexList.get(i);
        }
    }

    public void setSibling(RETEQueue sibling) {
        this.sibling = sibling;
    }

    @Override
    public void setContinuation(RETESinkNode continuation) {
        this.continuation = continuation;
        if (this.sibling != null) {
            this.sibling.continuation = continuation;
        }
    }

    @Override
    public void fire(BindingVector env, boolean isAdd) {
        Count count = this.queue.get(env);
        if (count == null) {
            if (!isAdd) {
                return;
            }
            this.queue.put(env, new Count(1));
        } else if (isAdd) {
            count.inc();
        } else {
            count.dec();
            if (count.getCount() == 0) {
                this.queue.remove(env);
            }
        }
        Iterator<BindingVector> i = this.sibling.queue.keySet().iterator();
        while (i.hasNext()) {
            Node[] candidate = i.next().getEnvironment();
            Node[] envNodes = env.getEnvironment();
            boolean matchOK = true;
            for (int j = 0; j < this.matchIndices.length; ++j) {
                byte index = this.matchIndices[j];
                if (candidate[index].sameValueAs(envNodes[index])) continue;
                matchOK = false;
                break;
            }
            if (!matchOK) continue;
            Node[] newNodes = new Node[candidate.length];
            for (int j = 0; j < candidate.length; ++j) {
                Node n = candidate[j];
                newNodes[j] = n == null ? envNodes[j] : n;
            }
            BindingVector newEnv = new BindingVector(newNodes);
            this.continuation.fire(newEnv, isAdd);
        }
    }

    @Override
    public RETENode clone(Map<RETENode, RETENode> netCopy, RETERuleContext context) {
        RETEQueue clone = (RETEQueue)netCopy.get(this);
        if (clone == null) {
            clone = new RETEQueue(this.matchIndices);
            netCopy.put(this, clone);
            clone.setSibling((RETEQueue)this.sibling.clone(netCopy, context));
            clone.setContinuation((RETESinkNode)this.continuation.clone(netCopy, context));
            clone.queue.putAll(this.queue);
        }
        return clone;
    }

    protected static class Count {
        int count;

        public Count(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public void inc() {
            ++this.count;
        }

        public void dec() {
            --this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

