/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomParity;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;
import org.openscience.cdk.tools.manipulator.BondManipulator;

@TestClass(value="org.openscience.cdk.tools.manipulator.AtomContainerManipulatorTest")
public class AtomContainerManipulator {
    @TestMethod(value="testGetAtomById_IAtomContainer_String")
    public static IAtom getAtomById(IAtomContainer ac, String id) throws CDKException {
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            if (ac.getAtom(i).getID() == null || !ac.getAtom(i).getID().equals(id)) continue;
            return ac.getAtom(i);
        }
        throw new CDKException("no suc atom");
    }

    @TestMethod(value="testReplaceAtom")
    public static boolean replaceAtomByAtom(IAtomContainer container, IAtom atom, IAtom newAtom) {
        if (!container.contains(atom)) {
            return false;
        }
        container.setAtom(container.getAtomNumber(atom), newAtom);
        for (IElectronContainer eContainer : container.electronContainers()) {
            ILonePair lonePair;
            if (eContainer instanceof IBond) {
                IBond bond = (IBond)eContainer;
                if (!bond.contains(atom)) continue;
                for (int j = 0; j < bond.getAtomCount(); ++j) {
                    if (!atom.equals(bond.getAtom(j))) continue;
                    bond.setAtom(newAtom, j);
                }
                continue;
            }
            if (!(eContainer instanceof ILonePair) || !atom.equals((lonePair = (ILonePair)eContainer).getAtom())) continue;
            lonePair.setAtom(newAtom);
        }
        return true;
    }

    @TestMethod(value="testGetTotalCharge")
    public static double getTotalCharge(IAtomContainer atomContainer) {
        double charge = 0.0;
        for (IAtom atom : atomContainer.atoms()) {
            Double thisCharge = atom.getCharge();
            if (thisCharge == CDKConstants.UNSET) continue;
            charge += thisCharge.doubleValue();
        }
        return charge;
    }

    @TestMethod(value="testGetTotalExactMass_IAtomContainer")
    public static double getTotalExactMass(IAtomContainer atomContainer) {
        double mass = 0.0;
        for (IAtom atom : atomContainer.atoms()) {
            mass += atom.getExactMass().doubleValue();
        }
        return mass;
    }

    @TestMethod(value="testGetNaturalExactMass_IAtomContainer")
    public static double getNaturalExactMass(IAtomContainer atomContainer) {
        IsotopeFactory factory;
        double mass = 0.0;
        try {
            factory = IsotopeFactory.getInstance(atomContainer.getBuilder());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not instantiate the IsotopeFactory.");
        }
        for (IAtom atom : atomContainer.atoms()) {
            IElement isotopesElement = atom.getBuilder().newInstance(IElement.class, atom.getSymbol());
            mass += factory.getNaturalMass(isotopesElement);
        }
        return mass;
    }

    @TestMethod(value="testGetTotalNaturalAbundance_IAtomContainer")
    public static double getTotalNaturalAbundance(IAtomContainer atomContainer) {
        double abundance = 1.0;
        for (IAtom iAtom : atomContainer.atoms()) {
            abundance *= iAtom.getNaturalAbundance().doubleValue();
        }
        return abundance / Math.pow(100.0, atomContainer.getAtomCount());
    }

    @TestMethod(value="testGetTotalFormalCharge_IAtomContainer")
    public static int getTotalFormalCharge(IAtomContainer atomContainer) {
        int chargeP = AtomContainerManipulator.getTotalNegativeFormalCharge(atomContainer);
        int chargeN = AtomContainerManipulator.getTotalPositiveFormalCharge(atomContainer);
        return chargeP + chargeN;
    }

    @TestMethod(value="testGetTotalNegativeFormalCharge_IAtomContainer")
    public static int getTotalNegativeFormalCharge(IAtomContainer atomContainer) {
        int charge = 0;
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            double chargeI = atomContainer.getAtom(i).getFormalCharge().intValue();
            if (!(chargeI < 0.0)) continue;
            charge = (int)((double)charge + chargeI);
        }
        return charge;
    }

    @TestMethod(value="testGetTotalPositiveFormalCharge_IAtomContainer")
    public static int getTotalPositiveFormalCharge(IAtomContainer atomContainer) {
        int charge = 0;
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            double chargeI = atomContainer.getAtom(i).getFormalCharge().intValue();
            if (!(chargeI > 0.0)) continue;
            charge = (int)((double)charge + chargeI);
        }
        return charge;
    }

    @TestMethod(value="testGetTotalHydrogenCount_IAtomContainer,testGetTotalHydrogenCount_IAtomContainer_zeroImplicit,testGetTotalHydrogenCount_IAtomContainer_nullImplicit,testGetTotalHydrogenCount_ImplicitHydrogens")
    public static int getTotalHydrogenCount(IAtomContainer atomContainer) {
        int hCount = 0;
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            Integer ihcount = atomContainer.getAtom(i).getImplicitHydrogenCount();
            if (ihcount == CDKConstants.UNSET) continue;
            hCount += ihcount.intValue();
        }
        return hCount;
    }

    @TestMethod(value="testCountExplicitH")
    public static int countExplicitHydrogens(IAtomContainer atomContainer, IAtom atom) {
        int hCount = 0;
        for (IAtom iAtom : atomContainer.getConnectedAtomsList(atom)) {
            IAtom connectedAtom = iAtom;
            if (!connectedAtom.getSymbol().equals("H")) continue;
            ++hCount;
        }
        return hCount;
    }

    @TestMethod(value="testConvertImplicitToExplicitHydrogens_IAtomContainer")
    public static void convertImplicitToExplicitHydrogens(IAtomContainer atomContainer) {
        for (IAtom atom : atomContainer.atoms()) {
            Integer hCount;
            if (atom.getSymbol().equals("H") || (hCount = atom.getImplicitHydrogenCount()) == null) continue;
            for (int i = 0; i < hCount; ++i) {
                IAtom hydrogen = atom.getBuilder().newInstance(IAtom.class, "H");
                hydrogen.setAtomTypeName("H");
                atomContainer.addAtom(hydrogen);
                atomContainer.addBond(atom.getBuilder().newInstance(IBond.class, new Object[]{atom, hydrogen, CDKConstants.BONDORDER_SINGLE}));
            }
            atom.setImplicitHydrogenCount(0);
        }
    }

    @TestMethod(value="testCountH")
    public static int countHydrogens(IAtomContainer atomContainer, IAtom atom) {
        int hCount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
        return hCount += AtomContainerManipulator.countExplicitHydrogens(atomContainer, atom);
    }

    @TestMethod(value="testGetAllIDs_IAtomContainer")
    public static List<String> getAllIDs(IAtomContainer mol) {
        ArrayList<String> idList = new ArrayList<String>();
        if (mol != null) {
            if (mol.getID() != null) {
                idList.add(mol.getID());
            }
            for (IAtom atom : mol.atoms()) {
                if (atom.getID() == null) continue;
                idList.add(atom.getID());
            }
            for (IBond bond : mol.bonds()) {
                if (bond.getID() == null) continue;
                idList.add(bond.getID());
            }
        }
        return idList;
    }

    @TestMethod(value="testRemoveHydrogens_IAtomContainer")
    public static IAtomContainer removeHydrogens(IAtomContainer atomContainer) {
        int i;
        HashMap<IAtom, IAtom> map = new HashMap<IAtom, IAtom>();
        ArrayList<IAtom> remove = new ArrayList<IAtom>();
        IMolecule mol = atomContainer.getBuilder().newInstance(IMolecule.class, new Object[0]);
        int count = atomContainer.getAtomCount();
        for (i = 0; i < count; ++i) {
            IAtom atom = atomContainer.getAtom(i);
            if (!atom.getSymbol().equals("H")) {
                IAtom clonedAtom = null;
                try {
                    clonedAtom = (IAtom)atom.clone();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                mol.addAtom(clonedAtom);
                map.put(atom, clonedAtom);
                continue;
            }
            remove.add(atom);
        }
        count = atomContainer.getBondCount();
        for (i = 0; i < count; ++i) {
            IBond bond = atomContainer.getBond(i);
            boolean removedBond = false;
            int length = bond.getAtomCount();
            for (int k = 0; k < length; ++k) {
                if (!remove.contains(bond.getAtom(k))) continue;
                removedBond = true;
                break;
            }
            if (removedBond) continue;
            IBond clone = null;
            try {
                clone = (IBond)atomContainer.getBond(i).clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            assert (clone != null);
            clone.setAtoms(new IAtom[]{(IAtom)map.get(bond.getAtom(0)), (IAtom)map.get(bond.getAtom(1))});
            mol.addBond(clone);
        }
        for (IAtom aRemove : remove) {
            for (IAtom iAtom : atomContainer.getConnectedAtomsList(aRemove)) {
                IAtom neighb = (IAtom)map.get(iAtom);
                if (neighb == null) continue;
                neighb.setImplicitHydrogenCount((neighb.getImplicitHydrogenCount() == null ? 0 : neighb.getImplicitHydrogenCount()) + 1);
            }
        }
        for (IAtom atom : mol.atoms()) {
            if (atom.getImplicitHydrogenCount() != null) continue;
            atom.setImplicitHydrogenCount(0);
        }
        mol.setProperties(atomContainer.getProperties());
        mol.setFlags(atomContainer.getFlags());
        return mol;
    }

    @TestMethod(value="testRemoveHydrogensPreserveMultiplyBonded")
    public static IAtomContainer removeHydrogensPreserveMultiplyBonded(IAtomContainer ac) {
        ArrayList h = new ArrayList();
        ArrayList<IAtom> multi_h = new ArrayList<IAtom>();
        int count = ac.getBondCount();
        for (int i = 0; i < count; ++i) {
            for (IAtom atom : ac.getBond(i).atoms()) {
                if (!atom.getSymbol().equals("H")) continue;
                (h.contains(atom) ? multi_h : h).add(atom);
            }
        }
        return AtomContainerManipulator.removeHydrogens(ac, multi_h);
    }

    private static IAtomContainer removeHydrogens(IAtomContainer ac, List<IAtom> preserve) {
        int i;
        HashMap<IAtom, IAtom> map = new HashMap<IAtom, IAtom>();
        ArrayList<IAtom> remove = new ArrayList<IAtom>();
        IMolecule mol = ac.getBuilder().newInstance(IMolecule.class, new Object[0]);
        int count = ac.getAtomCount();
        for (i = 0; i < count; ++i) {
            IAtom atom = ac.getAtom(i);
            if (!atom.getSymbol().equals("H") || preserve.contains(atom)) {
                IAtom a = null;
                try {
                    a = (IAtom)atom.clone();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                a.setImplicitHydrogenCount(0);
                mol.addAtom(a);
                map.put(atom, a);
                continue;
            }
            remove.add(atom);
        }
        count = ac.getBondCount();
        for (i = 0; i < count; ++i) {
            IBond bond = ac.getBond(i);
            IAtom atom0 = bond.getAtom(0);
            IAtom atom1 = bond.getAtom(1);
            boolean remove_bond = false;
            for (IAtom atom : bond.atoms()) {
                if (!remove.contains(atom)) continue;
                remove_bond = true;
                break;
            }
            if (remove_bond) continue;
            IBond clone = null;
            try {
                clone = (IBond)ac.getBond(i).clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            clone.setAtoms(new IAtom[]{(IAtom)map.get(atom0), (IAtom)map.get(atom1)});
            mol.addBond(clone);
        }
        for (IAtom removeAtom : remove) {
            for (IAtom neighbor : ac.getConnectedAtomsList(removeAtom)) {
                IAtom neighb = (IAtom)map.get(neighbor);
                neighb.setImplicitHydrogenCount(neighb.getImplicitHydrogenCount() + 1);
            }
        }
        return mol;
    }

    public static void setAtomProperties(IAtomContainer container, Object propKey, Object propVal) {
        if (container != null) {
            for (IAtom atom : container.atoms()) {
                atom.setProperty(propKey, propVal);
            }
        }
    }

    public static void unregisterElectronContainerListeners(IAtomContainer container) {
        for (IElectronContainer electronContainer : container.electronContainers()) {
            electronContainer.removeListener(container);
        }
    }

    public static void unregisterAtomListeners(IAtomContainer container) {
        for (IAtom atom : container.atoms()) {
            atom.removeListener(container);
        }
    }

    @TestMethod(value="testGetIntersection_IAtomContainer_IAtomContainer")
    public static IAtomContainer getIntersection(IAtomContainer container1, IAtomContainer container2) {
        int i;
        IAtomContainer intersection = container1.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (i = 0; i < container1.getAtomCount(); ++i) {
            if (!container2.contains(container1.getAtom(i))) continue;
            intersection.addAtom(container1.getAtom(i));
        }
        for (i = 0; i < container1.getElectronContainerCount(); ++i) {
            if (!container2.contains(container1.getElectronContainer(i))) continue;
            intersection.addElectronContainer(container1.getElectronContainer(i));
        }
        return intersection;
    }

    @TestMethod(value="testGetAtomArray_IAtomContainer")
    public static IAtom[] getAtomArray(IAtomContainer container) {
        IAtom[] ret = new IAtom[container.getAtomCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = container.getAtom(i);
        }
        return ret;
    }

    @TestMethod(value="testGetAtomArray_List")
    public static IAtom[] getAtomArray(List<IAtom> list) {
        IAtom[] ret = new IAtom[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    @TestMethod(value="testGetBondArray_IAtomContainer")
    public static IBond[] getBondArray(IAtomContainer container) {
        IBond[] ret = new IBond[container.getBondCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = container.getBond(i);
        }
        return ret;
    }

    @TestMethod(value="testGetBondArray_List")
    public static IBond[] getBondArray(List<IBond> list) {
        IBond[] ret = new IBond[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public static IElectronContainer[] getElectronContainerArray(IAtomContainer container) {
        IElectronContainer[] ret = new IElectronContainer[container.getElectronContainerCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = container.getElectronContainer(i);
        }
        return ret;
    }

    public static IElectronContainer[] getElectronContainerArray(List<IElectronContainer> list) {
        IElectronContainer[] ret = new IElectronContainer[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    @TestMethod(value="testPerceiveAtomTypesAndConfigureAtoms")
    public static void percieveAtomTypesAndConfigureAtoms(IAtomContainer container) throws CDKException {
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(container.getBuilder());
        for (IAtom atom : container.atoms()) {
            IAtomType matched;
            if (atom instanceof IPseudoAtom || (matched = matcher.findMatchingAtomType(container, atom)) == null) continue;
            AtomTypeManipulator.configure(atom, matched);
        }
    }

    @TestMethod(value="testPerceiveAtomTypesAndConfigureAtoms")
    public static void percieveAtomTypesAndConfigureUnsetProperties(IAtomContainer container) throws CDKException {
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(container.getBuilder());
        for (IAtom atom : container.atoms()) {
            IAtomType matched = matcher.findMatchingAtomType(container, atom);
            if (matched == null) continue;
            AtomTypeManipulator.configureUnsetProperties(atom, matched);
        }
    }

    @TestMethod(value="testClearConfig")
    public static void clearAtomConfigurations(IAtomContainer container) {
        for (IAtom atom : container.atoms()) {
            atom.setAtomTypeName((String)CDKConstants.UNSET);
            atom.setMaxBondOrder((IBond.Order)((Object)CDKConstants.UNSET));
            atom.setBondOrderSum((Double)CDKConstants.UNSET);
            atom.setCovalentRadius((Double)CDKConstants.UNSET);
            atom.setValency((Integer)CDKConstants.UNSET);
            atom.setFormalCharge((Integer)CDKConstants.UNSET);
            atom.setHybridization((IAtomType.Hybridization)((Object)CDKConstants.UNSET));
            atom.setFormalNeighbourCount((Integer)CDKConstants.UNSET);
            atom.setFlag(9, false);
            atom.setFlag(8, false);
            atom.setProperty("cdk:Chemical Group", CDKConstants.UNSET);
            atom.setFlag(5, false);
            atom.setProperty("org.openscience.cdk.renderer.color", CDKConstants.UNSET);
            atom.setAtomicNumber((Integer)CDKConstants.UNSET);
            atom.setExactMass((Double)CDKConstants.UNSET);
        }
    }

    @TestMethod(value="testGetSBE")
    public static int getSingleBondEquivalentSum(IAtomContainer container) {
        int sum = 0;
        for (IBond bond : container.bonds()) {
            if (bond.getOrder() == CDKConstants.BONDORDER_SINGLE) {
                ++sum;
                continue;
            }
            if (bond.getOrder() == CDKConstants.BONDORDER_DOUBLE) {
                sum += 2;
                continue;
            }
            if (bond.getOrder() == CDKConstants.BONDORDER_TRIPLE) {
                sum += 3;
                continue;
            }
            if (bond.getOrder() != CDKConstants.BONDORDER_QUADRUPLE) continue;
            sum += 4;
        }
        return sum;
    }

    @TestMethod(value="testGetMaxBondOrder_IAtomContainer")
    public static IBond.Order getMaximumBondOrder(IAtomContainer container) {
        return BondManipulator.getMaximumBondOrder(container.bonds().iterator());
    }

    @TestMethod(value="testGetHeavyAtoms_IAtomContainer")
    public static List<IAtom> getHeavyAtoms(IAtomContainer container) {
        ArrayList<IAtom> newAc = new ArrayList<IAtom>();
        for (int f = 0; f < container.getAtomCount(); ++f) {
            if (container.getAtom(f).getSymbol().equals("H")) continue;
            newAc.add(container.getAtom(f));
        }
        return newAc;
    }

    public static IAtomContainer createAllCarbonAllSingleNonAromaticBondAtomContainer(IAtomContainer atomContainer) throws CloneNotSupportedException {
        IAtomContainer query = (IAtomContainer)atomContainer.clone();
        for (int i = 0; i < query.getBondCount(); ++i) {
            query.getBond(i).setOrder(IBond.Order.SINGLE);
            query.getBond(i).setFlag(5, false);
            query.getBond(i).getAtom(0).setSymbol("C");
            query.getBond(i).getAtom(0).setHybridization(null);
            query.getBond(i).getAtom(1).setSymbol("C");
            query.getBond(i).getAtom(1).setHybridization(null);
            query.getBond(i).getAtom(0).setFlag(5, false);
            query.getBond(i).getAtom(1).setFlag(5, false);
        }
        return query;
    }

    @TestMethod(value="testBondOrderSum")
    public static double getBondOrderSum(IAtomContainer container, IAtom atom) {
        double count = 0.0;
        for (IBond bond : container.getConnectedBondsList(atom)) {
            if (bond.getOrder() == IBond.Order.SINGLE) {
                count += 1.0;
                continue;
            }
            if (bond.getOrder() == IBond.Order.DOUBLE) {
                count += 2.0;
                continue;
            }
            if (bond.getOrder() == IBond.Order.TRIPLE) {
                count += 3.0;
                continue;
            }
            if (bond.getOrder() != IBond.Order.QUADRUPLE) continue;
            count += 4.0;
        }
        return count;
    }

    @TestMethod(value="testGetAtomParity")
    public static IAtomParity getAtomParity(IAtomContainer container, IAtom atom) {
        for (IStereoElement element : container.stereoElements()) {
            IAtomParity parity;
            if (!(element instanceof IAtomParity) || (parity = (IAtomParity)element).getAtom() != atom) continue;
            return parity;
        }
        return null;
    }
}

