/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.edit;

import java.util.Set;
import javax.vecmath.Point2d;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.controller.edit.IEdit;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.layout.RingPlacer;

public class CreateRing
extends AbstractEdit
implements IEdit {
    Point2d pos;
    int ringSize;
    IRing ringToAdd;

    public static CreateRing addRing(Point2d pos, int ringSize) {
        return new CreateRing(null, pos, ringSize);
    }

    public static CreateRing addRing(IRing ring) {
        return new CreateRing(ring, null, -1);
    }

    private CreateRing(IRing ring, Point2d pos, int ringSize) {
        this.ringToAdd = ring;
        this.pos = pos;
        this.ringSize = ringSize;
    }

    @Override
    public Set<Changed> getTypeOfChanges() {
        return CreateRing.changed(Changed.Structure);
    }

    @Override
    public void redo() {
        if (this.ringToAdd == null) {
            this.ringToAdd = (IRing)this.model.getBuilder().newInstance(IRing.class, new Object[]{this.ringSize});
            RingPlacer placer = new RingPlacer();
            placer.placeRing(this.ringToAdd, this.pos, 1.4);
        }
        this.model.add((IAtomContainer)this.ringToAdd);
    }

    @Override
    public void undo() {
        this.model.remove((IAtomContainer)this.ringToAdd);
    }
}

