/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers.smarts;

import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSAtom;
import org.openscience.cdk.isomorphism.mcss.RMap;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class RecursiveSmartsAtom
extends SMARTSAtom {
    private static final long serialVersionUID = 1L;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(RecursiveSmartsAtom.class);
    private IAtomContainer atomContainer = null;
    private IQueryAtomContainer recursiveQuery = null;
    private BitSet bitSet = null;

    public RecursiveSmartsAtom(IQueryAtomContainer query) {
        this.recursiveQuery = query;
    }

    @Override
    public boolean matches(IAtom atom) {
        if (this.recursiveQuery.getAtomCount() == 1) {
            return ((IQueryAtom)this.recursiveQuery.getAtom(0)).matches(atom);
        }
        if (this.atomContainer == null) {
            logger.error("In RecursiveSmartsAtom, atomContainer can't be null! You must set it before matching");
            return false;
        }
        if (this.bitSet == null) {
            try {
                this.initilizeBitSets();
            }
            catch (CDKException cex) {
                logger.error("Error found when matching recursive smarts: " + cex.getMessage());
                return false;
            }
        }
        int atomNumber = this.atomContainer.getAtomNumber(atom);
        return this.bitSet.get(atomNumber);
    }

    private void initilizeBitSets() throws CDKException {
        List<List<RMap>> bondMappings = null;
        bondMappings = UniversalIsomorphismTester.getSubgraphMaps(this.atomContainer, this.recursiveQuery);
        this.bitSet = new BitSet(this.atomContainer.getAtomCount());
        for (List<RMap> bondMapping : bondMappings) {
            Collections.sort(bondMapping, new Comparator<RMap>(){

                @Override
                public int compare(RMap r1, RMap r2) {
                    if (r1.getId2() > r2.getId2()) {
                        return 1;
                    }
                    if (r1.getId2() == r2.getId2()) {
                        return 0;
                    }
                    return -1;
                }
            });
            RMap rmap0 = bondMapping.get(0);
            IBond bond0 = this.atomContainer.getBond(rmap0.getId1());
            IAtom atom0 = bond0.getAtom(0);
            IAtom atom1 = bond0.getAtom(1);
            IBond qbond0 = this.recursiveQuery.getBond(rmap0.getId2());
            IQueryAtom qatom0 = (IQueryAtom)qbond0.getAtom(0);
            IQueryAtom qatom1 = (IQueryAtom)qbond0.getAtom(1);
            if (qatom0.matches(atom0) && qatom1.matches(atom1) && qatom0.matches(atom1) && qatom1.matches(atom0)) {
                if (bondMapping.size() > 1) {
                    IBond bond1 = this.atomContainer.getBond(bondMapping.get(1).getId1());
                    IBond qbond1 = this.recursiveQuery.getBond(bondMapping.get(1).getId2());
                    if (this.recursiveQuery.getAtomNumber(qatom0) == 0) {
                        if (qbond1.contains(qatom0) && bond1.contains(atom0)) {
                            this.bitSet.set(this.atomContainer.getAtomNumber(atom0), true);
                            continue;
                        }
                        if (qbond1.contains(qatom0) && bond1.contains(atom1)) {
                            this.bitSet.set(this.atomContainer.getAtomNumber(atom1), true);
                            continue;
                        }
                        if (!qbond1.contains(qatom0) && bond1.contains(atom0)) {
                            this.bitSet.set(this.atomContainer.getAtomNumber(atom1), true);
                            continue;
                        }
                        this.bitSet.set(this.atomContainer.getAtomNumber(atom0), true);
                        continue;
                    }
                    if (qbond1.contains(qatom1) && bond1.contains(atom0)) {
                        this.bitSet.set(this.atomContainer.getAtomNumber(atom0), true);
                        continue;
                    }
                    if (qbond1.contains(qatom1) && bond1.contains(atom1)) {
                        this.bitSet.set(this.atomContainer.getAtomNumber(atom1), true);
                        continue;
                    }
                    if (!qbond1.contains(qatom1) && bond1.contains(atom1)) {
                        this.bitSet.set(this.atomContainer.getAtomNumber(atom0), true);
                        continue;
                    }
                    this.bitSet.set(this.atomContainer.getAtomNumber(atom1), true);
                    continue;
                }
                this.bitSet.set(this.atomContainer.getAtomNumber(atom1), true);
                this.bitSet.set(this.atomContainer.getAtomNumber(atom0), true);
                continue;
            }
            if (this.recursiveQuery.getAtomNumber(qatom0) == 0) {
                if (qatom0.matches(atom0) && qatom1.matches(atom1)) {
                    this.bitSet.set(this.atomContainer.getAtomNumber(atom0), true);
                    continue;
                }
                this.bitSet.set(this.atomContainer.getAtomNumber(atom1), true);
                continue;
            }
            if (qatom0.matches(atom1) && qatom1.matches(atom0)) {
                this.bitSet.set(this.atomContainer.getAtomNumber(atom0), true);
                continue;
            }
            this.bitSet.set(this.atomContainer.getAtomNumber(atom1), true);
        }
    }

    public IQueryAtomContainer getRecursiveQuery() {
        return this.recursiveQuery;
    }

    public void setRecursiveQuery(IQueryAtomContainer query) {
        this.recursiveQuery = query;
    }

    public IAtomContainer getAtomContainer() {
        return this.atomContainer;
    }

    public void setAtomContainer(IAtomContainer atomContainer) {
        this.atomContainer = atomContainer;
        this.bitSet = null;
    }
}

