/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer;

import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;

public class BoundsCalculator {
    public static Rectangle2D calculateBounds(IChemModel chemModel) {
        IMoleculeSet moleculeSet = chemModel.getMoleculeSet();
        IReactionSet reactionSet = chemModel.getReactionSet();
        Rectangle2D totalBounds = null;
        if (moleculeSet != null) {
            totalBounds = BoundsCalculator.calculateBounds(moleculeSet);
        }
        if (reactionSet != null) {
            totalBounds = totalBounds == null ? BoundsCalculator.calculateBounds(reactionSet) : totalBounds.createUnion(BoundsCalculator.calculateBounds(reactionSet));
        }
        return totalBounds;
    }

    public static Rectangle2D calculateBounds(IReactionSet reactionSet) {
        Rectangle2D totalBounds = new Rectangle2D.Double();
        for (IReaction reaction : reactionSet.reactions()) {
            Rectangle2D reactionBounds = BoundsCalculator.calculateBounds(reaction);
            if (((RectangularShape)totalBounds).isEmpty()) {
                totalBounds = reactionBounds;
                continue;
            }
            Rectangle2D.union(totalBounds, reactionBounds, totalBounds);
        }
        return totalBounds;
    }

    public static Rectangle2D calculateBounds(IReaction reaction) {
        IMoleculeSet reactants = reaction.getReactants();
        IMoleculeSet products = reaction.getProducts();
        if (reactants == null || products == null) {
            return null;
        }
        Rectangle2D reactantsBounds = BoundsCalculator.calculateBounds(reactants);
        return reactantsBounds.createUnion(BoundsCalculator.calculateBounds(products));
    }

    public static Rectangle2D calculateBounds(IMoleculeSet moleculeSet) {
        Rectangle2D totalBounds = new Rectangle2D.Double();
        for (int i = 0; i < moleculeSet.getAtomContainerCount(); ++i) {
            IAtomContainer ac = moleculeSet.getAtomContainer(i);
            Rectangle2D acBounds = BoundsCalculator.calculateBounds(ac);
            if (((RectangularShape)totalBounds).isEmpty()) {
                totalBounds = acBounds;
                continue;
            }
            Rectangle2D.union(totalBounds, acBounds, totalBounds);
        }
        return totalBounds;
    }

    public static Rectangle2D calculateBounds(IAtomContainer ac) {
        if (ac.getAtomCount() == 0) {
            return new Rectangle2D.Double();
        }
        if (ac.getAtomCount() == 1) {
            Point2d p = ac.getAtom(0).getPoint2d();
            return new Rectangle2D.Double(p.x, p.y, 0.0, 0.0);
        }
        double xmin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        for (IAtom atom : ac.atoms()) {
            Point2d p = atom.getPoint2d();
            xmin = Math.min(xmin, p.x);
            xmax = Math.max(xmax, p.x);
            ymin = Math.min(ymin, p.y);
            ymax = Math.max(ymax, p.y);
        }
        double w = xmax - xmin;
        double h = ymax - ymin;
        return new Rectangle2D.Double(xmin, ymin, w, h);
    }
}

