/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.io.ISimpleChemObjectReader;
import org.openscience.cdk.io.MDLWriter;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;

public class Misc {
    public static void writeMoleculesInOneFile(IAtomContainer[] molecules, String filename, int writeProps) throws Exception {
        MDLWriter writer = new MDLWriter((Writer)new FileWriter(new File(filename)));
        for (IAtomContainer molecule : molecules) {
            if (writeProps == 1) {
                Map propMap = molecule.getProperties();
                writer.setSdFields(propMap);
            }
            writer.write((IChemObject)molecule);
        }
    }

    public static void writeMolecules(IAtomContainer[] molecules, String prefix, int writeProps) throws Exception {
        int counter = 1;
        for (IAtomContainer molecule : molecules) {
            String filename = prefix + counter + ".sdf";
            MDLWriter writer = new MDLWriter((Writer)new FileWriter(new File(filename)));
            if (writeProps == 1) {
                Map propMap = molecule.getProperties();
                writer.setSdFields(propMap);
            }
            writer.write((IChemObject)molecule);
            writer.close();
            ++counter;
        }
    }

    public static void setProperty(IAtomContainer molecule, String key, Object value) {
        molecule.setProperty((Object)key, value);
    }

    public static void setProperty(IAtomContainer molecule, String key, int value) {
        Misc.setProperty(molecule, key, new Integer(value));
    }

    public static void setProperty(IAtomContainer molecule, String key, double value) {
        Misc.setProperty(molecule, key, new Double(value));
    }

    public static Object getProperty(IAtomContainer molecule, String key) {
        return molecule.getProperty((Object)key);
    }

    public static void removeProperty(IAtomContainer molecule, String key) {
        molecule.removeProperty((Object)key);
    }

    public static String getSmiles(IAtomContainer container) {
        SmilesGenerator sg = new SmilesGenerator();
        sg.setUseAromaticityFlag(true);
        return sg.createSMILES((IMolecule)container);
    }

    public static IAtomContainer[] loadMolecules(String[] filenames, boolean doAromaticity, boolean doTyping, boolean doIsotopes) throws CDKException, IOException {
        int i;
        Vector v = new Vector();
        DefaultChemObjectBuilder builder = DefaultChemObjectBuilder.getInstance();
        try {
            for (int i2 = 0; i2 < filenames.length; ++i2) {
                ReaderFactory readerFactory = new ReaderFactory();
                File input = new File(filenames[i2]);
                ISimpleChemObjectReader reader = readerFactory.createReader((Reader)new FileReader(input));
                IChemFile content = (IChemFile)reader.read((IChemObject)builder.newChemFile());
                if (content == null) continue;
                List c = ChemFileManipulator.getAllAtomContainers((IChemFile)content);
                v.addAll(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CDKException(e.toString());
        }
        IAtomContainer[] retValues = new IAtomContainer[v.size()];
        for (i = 0; i < v.size(); ++i) {
            retValues[i] = (IAtomContainer)v.get(i);
        }
        if (doAromaticity) {
            for (i = 0; i < retValues.length; ++i) {
                try {
                    CDKHueckelAromaticityDetector.detectAromaticity((IAtomContainer)retValues[i]);
                    continue;
                }
                catch (CDKException e) {
                    retValues[i] = null;
                }
            }
        }
        if (doTyping) {
            for (i = 0; i < retValues.length; ++i) {
                try {
                    AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)retValues[i]);
                    continue;
                }
                catch (CDKException e) {
                    retValues[i] = null;
                }
            }
        }
        if (doIsotopes) {
            IsotopeFactory ifac = IsotopeFactory.getInstance((IChemObjectBuilder)DefaultChemObjectBuilder.getInstance());
            for (IAtomContainer retValue : retValues) {
                ifac.configureAtoms(retValue);
            }
        }
        return retValues;
    }

    public static IAtomContainer getMoleculeWithCoordinates(IAtomContainer molecule) throws Exception {
        StructureDiagramGenerator sdg = new StructureDiagramGenerator();
        sdg.setMolecule((IMolecule)molecule);
        sdg.generateCoordinates();
        return sdg.getMolecule();
    }
}

