/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.FontMetrics;
import javax.vecmath.Point3i;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Axes;
import org.jmol.viewer.ShapeRenderer;

class AxesRenderer
extends ShapeRenderer {
    String[] axisLabels = new String[]{"+X", "+Y", "+Z", null, null, null, "a", "b", "c"};
    final Point3i[] axisScreens = new Point3i[6];
    final Point3i originScreen;

    AxesRenderer() {
        int i = 6;
        while (--i >= 0) {
            this.axisScreens[i] = new Point3i();
        }
        this.originScreen = new Point3i();
    }

    void render() {
        short colix;
        Axes axes = (Axes)this.shape;
        short mad = axes.mad;
        if (mad == 0) {
            return;
        }
        if (this.viewer.areAxesTainted()) {
            axes.initShape();
        }
        int nPoints = 6;
        int labelPtr = 0;
        if (this.viewer.getAxesMode() == 2 && this.frame.cellInfos != null) {
            int modelIndex = this.viewer.getDisplayModelIndex();
            if (modelIndex < 0 || this.frame.cellInfos[modelIndex].getUnitCell() == null) {
                return;
            }
            nPoints = 3;
            labelPtr = 6;
        }
        this.viewer.transformPoint(axes.originPoint, this.originScreen);
        int i = nPoints;
        while (--i >= 0) {
            this.viewer.transformPoint(axes.axisPoints[i], this.axisScreens[i]);
        }
        short widthPixels = mad;
        if (mad >= 20) {
            widthPixels = this.viewer.scaleToScreen(this.originScreen.z, mad);
        }
        if ((colix = axes.colix) == 0) {
            colix = 17;
        }
        int i2 = nPoints;
        while (--i2 >= 0) {
            String label;
            if (mad < 0) {
                this.g3d.drawDottedLine(colix, this.originScreen, this.axisScreens[i2]);
            } else {
                this.g3d.fillCylinder(colix, (byte)2, widthPixels, this.originScreen, this.axisScreens[i2]);
            }
            if ((label = this.axisLabels[i2 + labelPtr]) == null) continue;
            this.renderLabel(label, colix, axes.font3d, this.axisScreens[i2].x, this.axisScreens[i2].y, this.axisScreens[i2].z, this.g3d);
        }
    }

    void renderLabel(String str, short colix, Font3D font3d, int x, int y, int z, Graphics3D g3d) {
        int yStrCenter;
        int xStrCenter;
        FontMetrics fontMetrics = font3d.fontMetrics;
        int strAscent = fontMetrics.getAscent();
        int strWidth = fontMetrics.stringWidth(str);
        int xCenter = this.viewer.getBoundBoxCenterX();
        int yCenter = this.viewer.getBoundBoxCenterY();
        int dx = x - xCenter;
        int dy = y - yCenter;
        if (dx == 0 && dy == 0) {
            xStrCenter = x;
            yStrCenter = y;
        } else {
            int dist = (int)Math.sqrt(dx * dx + dy * dy);
            xStrCenter = xCenter + (dist + 2 + (strWidth + 1) / 2) * dx / dist;
            yStrCenter = yCenter + (dist + 3 + (strAscent + 1) / 2) * dy / dist;
        }
        int xStrBaseline = xStrCenter - strWidth / 2;
        int yStrBaseline = yStrCenter + strAscent / 2;
        g3d.drawString(str, font3d, colix, xStrBaseline, yStrBaseline, z, z);
    }
}

