/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Shade3D;

class Sphere3D {
    Graphics3D g3d;
    private static final int maxSphereCache = 128;
    private static final int maxOddSizeSphere = 49;
    private static int[][] sphereShapeCache = new int[128][];
    private static final int SHADE_SLAB_CLIPPED = Shade3D.shadeNormal - 5;
    private static boolean sphereShadingCalculated = false;
    private static final byte[] sphereIntensities = new byte[65536];

    Sphere3D(Graphics3D g3d) {
        this.g3d = g3d;
    }

    static void flushImageCache() {
        sphereShapeCache = new int[128][];
    }

    void render(int[] shades, boolean tScreened, int diameter, int x, int y, int z) {
        if (diameter > 49) {
            diameter &= 0xFFFFFFFE;
        }
        int radius = diameter + 1 >> 1;
        int minX = x - radius;
        int maxX = x + radius;
        if (maxX < 0 || minX >= this.g3d.width) {
            return;
        }
        int minY = y - radius;
        int maxY = y + radius;
        if (maxY < 0 || minY >= this.g3d.height) {
            return;
        }
        int minZ = z - radius;
        int maxZ = z + radius;
        if (maxZ < this.g3d.slab || minZ > this.g3d.depth) {
            return;
        }
        if (diameter >= 128) {
            this.renderLargeSphere(shades, tScreened, diameter, x, y, z);
            return;
        }
        int[] ss = this.getSphereShape(diameter);
        if (minX < 0 || maxX >= this.g3d.width || minY < 0 || maxY >= this.g3d.height || minZ < this.g3d.slab || z > this.g3d.depth) {
            this.renderShapeClipped(shades, tScreened, ss, diameter, x, y, z);
        } else {
            this.renderShapeUnclipped(shades, tScreened, ss, diameter, x, y, z);
        }
    }

    private void renderShapeUnclipped(int[] shades, boolean tScreened, int[] sphereShape, int diameter, int x, int y, int z) {
        int[] pbuf = this.g3d.pbuf;
        int[] zbuf = this.g3d.zbuf;
        int offsetSphere = 0;
        int width = this.g3d.width;
        int evenSizeCorrection = 1 - (diameter & 1);
        int offsetSouthCenter = width * y + x;
        int offsetNorthCenter = offsetSouthCenter - evenSizeCorrection * width;
        int nLines = (diameter + 1) / 2;
        if (!tScreened) {
            do {
                int packed;
                int offsetSE = offsetSouthCenter;
                int offsetSW = offsetSouthCenter - evenSizeCorrection;
                int offsetNE = offsetNorthCenter;
                int offsetNW = offsetNorthCenter - evenSizeCorrection;
                do {
                    int zPixel;
                    if ((zPixel = z - ((packed = sphereShape[offsetSphere++]) & 0x7F)) < zbuf[offsetSE]) {
                        zbuf[offsetSE] = zPixel;
                        pbuf[offsetSE] = shades[packed >> 7 & 0x3F];
                    }
                    if (zPixel < zbuf[offsetSW]) {
                        zbuf[offsetSW] = zPixel;
                        pbuf[offsetSW] = shades[packed >> 13 & 0x3F];
                    }
                    if (zPixel < zbuf[offsetNE]) {
                        zbuf[offsetNE] = zPixel;
                        pbuf[offsetNE] = shades[packed >> 19 & 0x3F];
                    }
                    if (zPixel < zbuf[offsetNW]) {
                        zbuf[offsetNW] = zPixel;
                        pbuf[offsetNW] = shades[packed >> 25 & 0x3F];
                    }
                    ++offsetSE;
                    --offsetSW;
                    ++offsetNE;
                    --offsetNW;
                } while (packed >= 0);
                offsetSouthCenter += width;
                offsetNorthCenter -= width;
            } while (--nLines > 0);
            return;
        }
        int flipflopSouthCenter = (x ^ y) & 1;
        int flipflopNorthCenter = flipflopSouthCenter ^ evenSizeCorrection;
        int flipflopSE = flipflopSouthCenter;
        int flipflopSW = flipflopSouthCenter ^ evenSizeCorrection;
        int flipflopNE = flipflopNorthCenter;
        int flipflopNW = flipflopNorthCenter ^ evenSizeCorrection;
        int flipflopsCenter = flipflopSE | flipflopSW << 1 | flipflopNE << 2 | flipflopNW << 3;
        do {
            int packed;
            int offsetSE = offsetSouthCenter;
            int offsetSW = offsetSouthCenter - evenSizeCorrection;
            int offsetNE = offsetNorthCenter;
            int offsetNW = offsetNorthCenter - evenSizeCorrection;
            int flipflops = flipflopsCenter ^= 0xFFFFFFFF;
            do {
                packed = sphereShape[offsetSphere++];
                int zPixel = z - (packed & 0x7F);
                if ((flipflops & 1) != 0 && zPixel < zbuf[offsetSE]) {
                    zbuf[offsetSE] = zPixel;
                    pbuf[offsetSE] = shades[packed >> 7 & 0x3F];
                }
                if ((flipflops & 2) != 0 && zPixel < zbuf[offsetSW]) {
                    zbuf[offsetSW] = zPixel;
                    pbuf[offsetSW] = shades[packed >> 13 & 0x3F];
                }
                if ((flipflops & 4) != 0 && zPixel < zbuf[offsetNE]) {
                    zbuf[offsetNE] = zPixel;
                    pbuf[offsetNE] = shades[packed >> 19 & 0x3F];
                }
                if ((flipflops & 8) != 0 && zPixel < zbuf[offsetNW]) {
                    zbuf[offsetNW] = zPixel;
                    pbuf[offsetNW] = shades[packed >> 25 & 0x3F];
                }
                ++offsetSE;
                --offsetSW;
                ++offsetNE;
                --offsetNW;
                flipflops ^= 0xFFFFFFFF;
            } while (packed >= 0);
            offsetSouthCenter += width;
            offsetNorthCenter -= width;
        } while (--nLines > 0);
    }

    private void renderShapeClipped(int[] shades, boolean tScreened, int[] sphereShape, int diameter, int x, int y, int z) {
        int[] pbuf = this.g3d.pbuf;
        int[] zbuf = this.g3d.zbuf;
        int offsetSphere = 0;
        int width = this.g3d.width;
        int height = this.g3d.height;
        int slab = this.g3d.slab;
        int depth = this.g3d.depth;
        int evenSizeCorrection = 1 - (diameter & 1);
        int offsetSouthCenter = width * y + x;
        int offsetNorthCenter = offsetSouthCenter - evenSizeCorrection * width;
        int nLines = (diameter + 1) / 2;
        int ySouth = y;
        int yNorth = y - evenSizeCorrection;
        int randu = (x << 16) + (y << 1) ^ 0x33333333;
        int flipflopSouthCenter = (x ^ y) & 1;
        int flipflopNorthCenter = flipflopSouthCenter ^ evenSizeCorrection;
        int flipflopSE = flipflopSouthCenter;
        int flipflopSW = flipflopSouthCenter ^ evenSizeCorrection;
        int flipflopNE = flipflopNorthCenter;
        int flipflopNW = flipflopNorthCenter ^ evenSizeCorrection;
        int flipflopsCenter = flipflopSE | flipflopSW << 1 | flipflopNE << 2 | flipflopNW << 3;
        do {
            int packed;
            boolean tSouthVisible = ySouth >= 0 && ySouth < height;
            boolean tNorthVisible = yNorth >= 0 && yNorth < height;
            int offsetSE = offsetSouthCenter;
            int offsetSW = offsetSouthCenter - evenSizeCorrection;
            int offsetNE = offsetNorthCenter;
            int offsetNW = offsetNorthCenter - evenSizeCorrection;
            int flipflops = flipflopsCenter ^= 0xFFFFFFFF;
            int xEast = x;
            int xWest = x - evenSizeCorrection;
            do {
                boolean isCore;
                int zPixel;
                boolean tWestVisible = xWest >= 0 && xWest < width;
                boolean tEastVisible = xEast >= 0 && xEast < width;
                packed = sphereShape[offsetSphere++];
                int zOffset = packed & 0x7F;
                if (z < slab) {
                    zPixel = z + zOffset;
                    isCore = zPixel >= slab;
                } else {
                    zPixel = z - zOffset;
                    boolean bl = isCore = zPixel < slab;
                }
                if (isCore) {
                    zPixel = slab;
                }
                if (zPixel >= slab && zPixel <= depth) {
                    int i;
                    if (tSouthVisible) {
                        if (tEastVisible && (!tScreened || (flipflops & 1) != 0) && zPixel < zbuf[offsetSE]) {
                            zbuf[offsetSE] = zPixel;
                            i = packed >> 7 & 0x3F;
                            if (isCore) {
                                i = SHADE_SLAB_CLIPPED - 3 + (randu >> 7 & 7);
                            }
                            pbuf[offsetSE] = shades[i];
                        }
                        if (tWestVisible && (!tScreened || (flipflops & 2) != 0) && zPixel < zbuf[offsetSW]) {
                            zbuf[offsetSW] = zPixel;
                            i = packed >> 13 & 0x3F;
                            if (isCore) {
                                i = SHADE_SLAB_CLIPPED - 3 + (randu >> 13 & 7);
                            }
                            pbuf[offsetSW] = shades[i];
                        }
                    }
                    if (tNorthVisible) {
                        if (tEastVisible && (!tScreened || (flipflops & 4) != 0) && zPixel < zbuf[offsetNE]) {
                            zbuf[offsetNE] = zPixel;
                            i = packed >> 19 & 0x3F;
                            if (isCore) {
                                i = SHADE_SLAB_CLIPPED - 3 + (randu >> 19 & 7);
                            }
                            pbuf[offsetNE] = shades[i];
                        }
                        if (tWestVisible && (!tScreened || (flipflops & 8) != 0) && zPixel < zbuf[offsetNW]) {
                            zbuf[offsetNW] = zPixel;
                            i = packed >> 25 & 0x3F;
                            if (isCore) {
                                i = SHADE_SLAB_CLIPPED - 3 + (randu >> 25 & 7);
                            }
                            pbuf[offsetNW] = shades[i];
                        }
                    }
                }
                ++offsetSE;
                --offsetSW;
                ++offsetNE;
                --offsetNW;
                ++xEast;
                --xWest;
                flipflops ^= 0xFFFFFFFF;
                if (!isCore) continue;
                randu = (randu << 16) + (randu << 1) + randu & Integer.MAX_VALUE;
            } while (packed >= 0);
            offsetSouthCenter += width;
            offsetNorthCenter -= width;
            ++ySouth;
            --yNorth;
        } while (--nLines > 0);
    }

    private int[] getSphereShape(int diameter) {
        int[] ss;
        if (diameter > 128) {
            diameter = 128;
        }
        if ((ss = sphereShapeCache[diameter - 1]) != null) {
            return ss;
        }
        int[] nArray = this.createSphereShape(diameter);
        Sphere3D.sphereShapeCache[diameter - 1] = nArray;
        ss = nArray;
        return ss;
    }

    private int[] createSphereShape(int diameter) {
        int countSE = 0;
        boolean oddDiameter = (diameter & 1) != 0;
        float radiusF = (float)diameter / 2.0f;
        float radiusF2 = radiusF * radiusF;
        int radius = (diameter + 1) / 2;
        float y = oddDiameter ? 0.0f : 0.5f;
        int i = 0;
        while (i < radius) {
            float y2 = y * y;
            float x = oddDiameter ? 0.0f : 0.5f;
            int j = 0;
            while (j < radius) {
                float x2 = x * x;
                float z2 = radiusF2 - y2 - x2;
                if (z2 >= 0.0f) {
                    ++countSE;
                }
                ++j;
                x += 1.0f;
            }
            ++i;
            y += 1.0f;
        }
        int[] sphereShape = new int[countSE];
        int offset = 0;
        y = oddDiameter ? 0.0f : 0.5f;
        int i2 = 0;
        while (i2 < radius) {
            float y2 = y * y;
            float x = oddDiameter ? 0.0f : 0.5f;
            int j = 0;
            while (j < radius) {
                float x2 = x * x;
                float z2 = radiusF2 - y2 - x2;
                if (z2 >= 0.0f) {
                    float z = (float)Math.sqrt(z2);
                    int height = (int)z;
                    byte intensitySE = Shade3D.calcDitheredNoisyIntensity(x, y, z, radiusF);
                    byte intensitySW = Shade3D.calcDitheredNoisyIntensity(-x, y, z, radiusF);
                    byte intensityNE = Shade3D.calcDitheredNoisyIntensity(x, -y, z, radiusF);
                    byte intensityNW = Shade3D.calcDitheredNoisyIntensity(-x, -y, z, radiusF);
                    int packed = height | intensitySE << 7 | intensitySW << 13 | intensityNE << 19 | intensityNW << 25;
                    sphereShape[offset++] = packed;
                }
                ++j;
                x += 1.0f;
            }
            int n = offset - 1;
            sphereShape[n] = sphereShape[n] | Integer.MIN_VALUE;
            ++i2;
            y += 1.0f;
        }
        return sphereShape;
    }

    private void calcSphereShading() {
        if (!sphereShadingCalculated) {
            float xF = -127.5f;
            for (int i = 0; i < 256; ++i) {
                float yF = -127.5f;
                for (int j = 0; j < 256; ++j) {
                    byte intensity = 0;
                    float z2 = 16900.0f - xF * xF - yF * yF;
                    if (z2 > 0.0f) {
                        float z = (float)Math.sqrt(z2);
                        intensity = Shade3D.calcDitheredNoisyIntensity(xF, yF, z, 130.0f);
                    }
                    Sphere3D.sphereIntensities[(j << 8) + i] = intensity;
                    yF += 1.0f;
                }
                xF += 1.0f;
            }
            sphereShadingCalculated = true;
        }
    }

    private void renderLargeSphere(int[] shades, boolean tScreened, int diameter, int x, int y, int z) {
        if (!sphereShadingCalculated) {
            this.calcSphereShading();
        }
        int radius = diameter / 2;
        this.renderQuadrant(shades, tScreened, radius, x, y, z, -1, -1);
        this.renderQuadrant(shades, tScreened, radius, x, y, z, -1, 1);
        this.renderQuadrant(shades, tScreened, radius, x, y, z, 1, -1);
        this.renderQuadrant(shades, tScreened, radius, x, y, z, 1, 1);
    }

    private void renderQuadrant(int[] shades, boolean tScreened, int radius, int x, int y, int z, int xSign, int ySign) {
        boolean zStatus;
        int t;
        int xStatus = (x < 0 ? -1 : (x < this.g3d.width ? 0 : 1)) + ((t = x + radius * xSign) < 0 ? -2 : (t < this.g3d.width ? 0 : 2));
        if (xStatus == -3 || xStatus == 3) {
            return;
        }
        int yStatus = (y < 0 ? -1 : (y < this.g3d.height ? 0 : 1)) + ((t = y + radius * ySign) < 0 ? -2 : (t < this.g3d.height ? 0 : 2));
        if (yStatus == -3 || yStatus == 3) {
            return;
        }
        boolean bl = zStatus = z - radius >= this.g3d.slab && z <= this.g3d.depth;
        if (xStatus == 0 && yStatus == 0 && zStatus) {
            this.renderQuadrantUnclipped(shades, tScreened, radius, x, y, z, xSign, ySign);
        } else {
            this.renderQuadrantClipped(shades, tScreened, radius, x, y, z, xSign, ySign);
        }
    }

    private void renderQuadrantUnclipped(int[] shades, boolean tScreened, int radius, int x, int y, int z, int xSign, int ySign) {
        int r2 = radius * radius;
        int dDivisor = radius * 2 + 1;
        int[] pbuf = this.g3d.pbuf;
        int[] zbuf = this.g3d.zbuf;
        int width = this.g3d.width;
        boolean flipflopBeginLine = ((x ^ y) & 1) == 0;
        int offsetPbufBeginLine = width * y + x;
        if (ySign < 0) {
            width = -width;
        }
        offsetPbufBeginLine -= width;
        int i = 0;
        int i2 = 0;
        while (i2 <= r2) {
            int offsetPbuf = (offsetPbufBeginLine += width) - xSign;
            flipflopBeginLine = !flipflopBeginLine;
            boolean flipflop = flipflopBeginLine;
            int s2 = r2 - i2;
            int z0 = z - radius;
            int y8 = (i * ySign + radius << 8) / dDivisor;
            int j = 0;
            int j2 = 0;
            while (j2 <= s2) {
                int k;
                if ((!tScreened || (flipflop = !flipflop)) && zbuf[offsetPbuf += xSign] > z0 && zbuf[offsetPbuf] > (z0 = z - (k = (int)Math.sqrt(s2 - j2)))) {
                    int x8 = (j * xSign + radius << 8) / dDivisor;
                    pbuf[offsetPbuf] = shades[sphereIntensities[(y8 << 8) + x8]];
                    zbuf[offsetPbuf] = z0;
                }
                j2 += j + j + 1;
                ++j;
            }
            i2 += i + i + 1;
            ++i;
        }
    }

    private void renderQuadrantClipped(int[] shades, boolean tScreened, int radius, int x, int y, int z, int xSign, int ySign) {
        int r2 = radius * radius;
        int dDivisor = radius * 2 + 1;
        int[] pbuf = this.g3d.pbuf;
        int[] zbuf = this.g3d.zbuf;
        int slab = this.g3d.slab;
        int depth = this.g3d.depth;
        int height = this.g3d.height;
        int width = this.g3d.width;
        int offsetPbufBeginLine = width * y + x;
        int lineIncrement = width;
        int randu = (x << 16) + (y << 1) ^ 0x33333333;
        if (ySign < 0) {
            lineIncrement = -width;
        }
        int yCurrent = y - ySign;
        int i = 0;
        int i2 = 0;
        while (i2 <= r2) {
            if ((yCurrent += ySign) < 0) {
                if (ySign < 0) {
                    return;
                }
            } else if (yCurrent >= height) {
                if (ySign > 0) {
                    return;
                }
            } else {
                int offsetPbuf = offsetPbufBeginLine;
                int s2 = r2 - i2;
                int xCurrent = x - xSign;
                int y8 = (i * ySign + radius << 8) / dDivisor;
                randu = (randu << 16) + (randu << 1) + randu & Integer.MAX_VALUE;
                int j = 0;
                int j2 = 0;
                while (j2 <= s2) {
                    if ((xCurrent += xSign) < 0) {
                        if (xSign < 0) {
                            break;
                        }
                    } else if (xCurrent >= width) {
                        if (xSign > 0) {
                            break;
                        }
                    } else if (!tScreened || ((xCurrent ^ yCurrent) & 1) == 0) {
                        boolean isCore;
                        int zPixel;
                        int zOffset = (int)Math.sqrt(s2 - j2);
                        if (z < slab) {
                            zPixel = z + zOffset;
                            isCore = zPixel >= slab;
                        } else {
                            zPixel = z - zOffset;
                            boolean bl = isCore = zPixel < slab;
                        }
                        if (isCore) {
                            zPixel = slab;
                        }
                        if (zPixel >= slab && zPixel <= depth && zbuf[offsetPbuf] > zPixel) {
                            int s;
                            if (isCore) {
                                s = SHADE_SLAB_CLIPPED - 3 + (randu >> 8 & 7);
                                randu = (randu << 16) + (randu << 1) + randu & Integer.MAX_VALUE;
                            } else {
                                int x8 = (j * xSign + radius << 8) / dDivisor;
                                s = sphereIntensities[(y8 << 8) + x8];
                            }
                            pbuf[offsetPbuf] = shades[s];
                            zbuf[offsetPbuf] = zPixel;
                        }
                    }
                    j2 += j + j + 1;
                    ++j;
                    offsetPbuf += xSign;
                }
                randu = (randu + xCurrent + yCurrent | 1) & Integer.MAX_VALUE;
            }
            i2 += i + i + 1;
            ++i;
            offsetPbufBeginLine += lineIncrement;
        }
    }
}

