/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class MappedRandomAccessFile {
    private MappedByteBuffer mappedByteBuffer = null;
    private FileChannel channel = null;

    public MappedRandomAccessFile(String filename, String mode) throws FileNotFoundException, IOException {
        if (mode.equals("rw")) {
            this.init(new RandomAccessFile(filename, mode).getChannel(), FileChannel.MapMode.READ_WRITE);
        } else {
            this.init(new FileInputStream(filename).getChannel(), FileChannel.MapMode.READ_ONLY);
        }
    }

    private void init(FileChannel channel, FileChannel.MapMode mapMode) throws IOException {
        this.channel = channel;
        this.mappedByteBuffer = channel.map(mapMode, 0L, channel.size());
        this.mappedByteBuffer.load();
    }

    public int read() throws IOException {
        try {
            byte b = this.mappedByteBuffer.get();
            int n = b & 0xFF;
            return n;
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    public int read(byte[] bytes, int off, int len) throws IOException {
        int limit;
        int pos = this.mappedByteBuffer.position();
        if (pos == (limit = this.mappedByteBuffer.limit())) {
            return -1;
        }
        int newlimit = pos + len - off;
        if (newlimit > limit) {
            len = limit - pos;
        }
        this.mappedByteBuffer.get(bytes, off, len);
        return len;
    }

    public long getFilePointer() throws IOException {
        return this.mappedByteBuffer.position();
    }

    public void seek(long pos) throws IOException {
        this.mappedByteBuffer.position((int)pos);
    }

    public long length() throws IOException {
        return this.mappedByteBuffer.limit();
    }

    public void close() throws IOException {
        MappedRandomAccessFile.clean(this.mappedByteBuffer);
        this.mappedByteBuffer = null;
        this.channel.close();
        this.channel = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public static boolean clean(final ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect()) {
            return false;
        }
        Boolean b = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Boolean success = Boolean.FALSE;
                try {
                    Method getCleanerMethod = buffer.getClass().getMethod("cleaner", null);
                    getCleanerMethod.setAccessible(true);
                    Object cleaner = getCleanerMethod.invoke((Object)buffer, null);
                    Method clean = cleaner.getClass().getMethod("clean", null);
                    clean.invoke(cleaner, null);
                    success = Boolean.TRUE;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return success;
            }
        });
        return b;
    }
}

