% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_rcdf.R
\name{read_rcdf}
\alias{read_rcdf}
\title{Read and decrypt RCDF data}
\usage{
read_rcdf(
  path,
  decryption_key,
  ...,
  password = NULL,
  metadata = list(),
  ignore_duplicates = TRUE,
  recursive = FALSE,
  return_meta = FALSE
)
}
\arguments{
\item{path}{A string specifying the path to the RCDF archive (zip file). If a directory is provided, all \code{.rcdf} files within that directory will be processed.}

\item{decryption_key}{The key used to decrypt the RCDF contents. This can be an RSA or AES key, depending on how the RCDF was encrypted.}

\item{...}{Additional parameters passed to other functions, if needed.}

\item{password}{A password used for RSA decryption (optional).}

\item{metadata}{An optional list of metadata object containing data dictionaries, value sets, and primary key constraints for data integrity measure (a \code{data.frame} or \code{tibble} that includes at least two columns: \code{file} and \code{pk_field_name}. This metadata is applied to the data if provided.}

\item{ignore_duplicates}{A \code{logical} flag. If \code{TRUE}, a warning is issued when duplicates are found, based on the primary key/s defined during creation of RCDF file. If \code{FALSE}, the function stops with an error.}

\item{recursive}{Logical. If \code{TRUE} and \code{path} is a directory, the function will search recursively for \code{.rcdf} files.}

\item{return_meta}{Logical. If \code{TRUE}, the metadata will be returned as an attribute of the RCDF object.}
}
\value{
An RCDF object, which is a list of Parquet files (one for each record) along with attached metadata.
}
\description{
This function reads an RCDF (Reusable Data Container Format) archive, decrypts its contents using the specified decryption key,
and loads it into R as an RCDF object. The data files within the archive (usually Parquet files) are decrypted and, if provided,
metadata (such as data dictionary and value sets) are applied to the data.
}
\examples{
dir <- system.file("extdata", package = "rcdf")
rcdf_path <- file.path(dir, 'mtcars.rcdf')
private_key <- file.path(dir, 'sample-private-key.pem')

rcdf_data <- read_rcdf(path = rcdf_path, decryption_key = private_key)
rcdf_data

# Using encrypted/password protected private key
rcdf_path_pw <- file.path(dir, 'mtcars-pw.rcdf')
private_key_pw <- file.path(dir, 'sample-private-key-pw.pem')
pw <- '1234'

rcdf_data_with_pw <- read_rcdf(
  path = rcdf_path_pw,
  decryption_key = private_key_pw,
  password = pw
)

rcdf_data_with_pw

}
