% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.SpdModelTest}
\alias{plot.SpdModelTest}
\title{Plot result of Monte-Carlo simulation of observed versus modelled SPDs}
\usage{
\method{plot}{SpdModelTest}(x, calendar = "BP", ylim = NA, xlim = NA,
  col.obs = "black", lwd.obs = 0.5, xaxs = "i", yaxs = "i",
  bbty = "f", drawaxes = TRUE, ...)
}
\arguments{
\item{x}{A \code{SpdModelTest} class object generated using the \code{\link{modelTest}} function.}

\item{calendar}{Either \code{'BP'} or \code{'BCAD'}. Indicate whether the calibrated date should be displayed in BP or BC/AD. Default is  \code{'BP'}.}

\item{ylim}{the y limits of the plot.}

\item{xlim}{the x limits of the plot. In BP or in BC/AD depending on the choice of the parameter \code{calender}. Notice that if BC/AD is selected BC ages should have a minus sign (e.g. \code{c(-5000,200)} for 5000 BC to 200 AD).}

\item{col.obs}{Line colour for the observed SPD}

\item{lwd.obs}{Line width for the observed SPD}

\item{xaxs}{The style of x-axis interval calculation (see \code{\link{par}})}

\item{yaxs}{The style of y-axis interval calculation (see \code{\link{par}})}

\item{bbty}{Display options; one between \code{'b'},\code{'n'},and \code{'f'}. See details below.}

\item{drawaxes}{A logical value determining whether the axes should be displayed or not. Default is TRUE.}

\item{...}{Additional arguments affecting the plot}
}
\description{
The function visualises the observed summed probability distribution of radiocarbon dates along with a simulation envelope for the null model and regions of positive and negative deviation.
}
\details{
The argument \code{bbty} controls the display options of the Monte-Carlo Test. Default settings (\code{bbty='f'}) displays the observed SPD (solid black line), the simulation envelope of the fitted model (shaded grey polygon) and regions of significance positive (red semi-transparent rectangle) and negative (blue semi-transparent rectangle) deviation. The option \code{bbty='b'} removes the regions of positive/negative deviations, whilst the option \code{bbty='n'} displays the simulation envelope on existing plot.
}
\seealso{
\code{\link{modelTest}}
}
