% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{spd2gg}
\alias{spd2gg}
\title{Compute geometric growth rates from SPDs}
\usage{
spd2gg(spd, breaks)
}
\arguments{
\item{spd}{Summed Probability Distribution obtained using the \code{\link{spd}} function.}

\item{breaks}{A vector giving the breakpoints between the time-blocks.}
}
\value{
An object of class \code{spdGG} containing the total summed probability for each time-block and the geometric growth rate between abutting blocks.
}
\description{
Function for computing the geometric growth rates between abutting user-defined time-blocks.
}
\details{
The function computes the growth rate between abutting phases as \eqn{(X_{t}/X_{t+1})^{(1/d)}-1}, where \eqn{X_{t}} is the summed probability of radiocarbon dates in the block \eqn{t}, and \eqn{d} is the duration of the time-blocks.
}
\examples{
\dontrun{
data(emedyd)
caldates <- calibrate(x=emedyd$CRA, errors=emedyd$Error, normalised=FALSE, calMatrix=TRUE)
bins <- binPrep(sites=emedyd$SiteName, ages=emedyd$CRA, h=50)
emedyd.spd <- spd(caldates,bins,timeRange=c(16000,9000))
emedyd.gg <- spd2gg(emedyd.spd,breaks=seq(16000,9000,-1000))
plot(emedyd.gg)
}
}
