rbraries
========



[![Build Status](https://travis-ci.org/ropenscilabs/rbraries.svg?branch=master)](https://travis-ci.org/ropenscilabs/rbraries)
[![codecov.io](https://codecov.io/github/ropenscilabs/rbraries/coverage.svg?branch=master)](https://codecov.io/github/ropenscilabs/rbraries?branch=master)
[![rstudio mirror downloads](http://cranlogs.r-pkg.org/badges/grand-total/rbraries?color=2ECC71)](https://github.com/metacran/cranlogs.app)
[![cran version](http://www.r-pkg.org/badges/version/rbraries)](https://cran.r-project.org/package=rbraries)


`rbraries` is a client for interacting with the Libraries.io API <https://libraries.io/api>


Package API:

 - `lio_project_contribs`
 - `lio_subscriptions`
 - `lio_platforms`
 - `lio_project_dependents`
 - `lio_project_sourcerank`
 - `lio_repo_projects`
 - `lio_user_repositories`
 - `lio_user_repo_contributions`
 - `lio_user_pkg_contributions`
 - `lio_user_dependencies`
 - `lio_repo_dependencies`
 - `lio_project_dependent_repos`
 - `lio_user_pkgs`
 - `lio_subscribed`
 - `lio_repo`
 - `lio_project_dependencies`
 - `lio_subscription_delete`
 - `lio_subscription_update`
 - `lio_project_search`
 - `lio_subscribe`
 - `lio_project`
 - `lio_user`

As you can see all functions are prefixed with `lio_` to avoid namespace conflicts with other R packages.

## Authentication

You need an API key to use this package. Get one by logging in to 
Libraries.io (they have GitHub login and others), then go to your 
Settings page, then scroll down to API key section and grab your
key. 

You can pass the key into function calls, but that's not recommended.
Store your key by putting in your .Renviron file or similar file like
e.g. .zshrc or .bash_profile, etc. We'll grab that key so that you 
don't have to pass it into each function call.

## Installation

CRAN version


```r
install.packages("rbraries")
```

Development version


```r
remotes::install_github("ropenscilabs/rbraries")
```


```r
library('rbraries')
```

## platforms


```r
lio_platforms()$name
#>  [1] "Go"         "NPM"        "Packagist"  "Rubygems"   "Maven"     
#>  [6] "Pypi"       "NuGet"      "Bower"      "Wordpress"  "CocoaPods" 
#> [11] "CPAN"       "Clojars"    "Cargo"      "Meteor"     "CRAN"      
#> [16] "Hackage"    "Atom"       "Hex"        "Puppet"     "PlatformIO"
#> [21] "Homebrew"   "Emacs"      "SwiftPM"    "Pub"        "Carthage"  
#> [26] "Julia"      "Sublime"    "Dub"        "Elm"        "Racket"    
#> [31] "Haxelib"    "Nimble"     "Alcatraz"   "PureScript" "Inqlude"
```

## projects


```r
lio_project_dependents('npm', 'grunt', per_page = 3)
#>     name platform
#> 1 eslint      NPM
#> 2 moment      NPM
#> 3    vue      NPM
#>                                                          description
#> 1                       An AST-based pattern checker for JavaScript.
#> 2                     Parse, validate, manipulate, and display dates
#> 3 Reactive, component-oriented view layer for modern web interfaces.
#>                       homepage                   repository_url
#> 1           https://eslint.org https://github.com/eslint/eslint
#> 2          http://momentjs.com https://github.com/moment/moment
#> 3 https://github.com/vuejs/vue     https://github.com/vuejs/vue
#>   normalized_licenses rank latest_release_published_at
#> 1                 MIT   31    2018-04-13T19:24:34.598Z
#> 2                 MIT   30    2018-04-15T06:06:50.664Z
#> 3                 MIT   29    2018-03-23T23:29:13.819Z
#>   latest_release_number   language status
#> 1         5.0.0-alpha.1 JavaScript       
#> 2                2.22.1 JavaScript   <NA>
#> 3         2.5.17-beta.0 JavaScript   <NA>
#>                    package_manager_url stars forks
#> 1 https://www.npmjs.com/package/eslint 11061  1907
#> 2 https://www.npmjs.com/package/moment 36430  5425
#> 3    https://www.npmjs.com/package/vue 90262 13249
#>                                                                          keywords
#> 1 ast, lint, javascript, ecmascript, espree, eslint, linter, static-code-analysis
#> 2                  moment, date, time, parse, format, validate, i18n, l10n, ender
#> 3                                            vue, framework, frontend, javascript
#>   dependents_count dependent_repos_count
#> 1            90058                277545
#> 2            17902                125955
#> 3             8209                 89765
#>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                versions
#> 1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1.5.1, 1.6.0, 3.14.0, 3.13.1, 0.14.0, 0.14.1, 0.15.0, 0.15.1, 0.16.0, 0.16.1, 0.16.2, 0.17.0, 0.17.1, 0.18.0, 0.19.0, 0.20.0, 0.21.0, 0.21.1, 0.21.2, 0.22.0, 0.22.1, 0.23.0, 0.24.0, 0.24.1, 1.7.0, 1.7.1, 1.0.0-rc-1, 1.0.0-rc-2, 1.0.0-rc-3, 1.0.0, 1.1.0, 1.7.2, 1.2.0, 1.7.3, 1.2.1, 1.8.0, 1.3.0, 1.3.1, 1.9.0, 1.4.0, 1.4.1, 1.4.2, 1.4.3, 1.5.0, 1.10.0, 1.10.1, 2.0.0-alpha-2, 2.0.0-beta.1, 1.10.2, 2.0.0-beta.2, 1.10.3, 2.0.0-beta.3, 5.0.0-alpha.1, 2.0.0-rc.0, 2.0.0-rc.1, 2.0.0, 2.0.0-alpha-1, 2.2.0, 2.1.0, 2.3.0, 2.5.0, 2.4.0, 2.5.1, 2.13.1, 2.5.2, 2.5.3, 2.13.0, 2.6.0, 2.7.0, 3.1.0, 3.1.1, 3.2.0, 3.0.0, 3.0.1, 3.2.1, 3.2.2, 2.8.0, 3.4.0, 3.3.0, 3.3.1, 2.9.0, 2.10.0, 2.10.1, 2.10.2, 2.11.0, 2.11.1, 2.12.0, 3.11.1, 3.11.0, 3.5.0, 3.12.1, 3.12.0, 3.13.0, 3.6.0, 3.6.1, 3.12.2, 3.7.0, 3.7.1, 3.14.1, 3.15.0, 3.17.1, 3.16.0, 3.16.1, 3.8.0, 3.8.1, 3.17.0, 4.0.0-beta.0, 3.19.0, 3.18.0, 4.0.0-alpha.0, 3.9.0, 4.0.0-alpha.1, 3.9.1, 4.0.0-alpha.2, 4.1.0, 4.1.1, 3.10.0, 4.0.0-rc.0, 4.0.0, 3.10.1, 3.10.2, 4.2.0, 4.3.0, 4.5.0, 4.7.0, 4.6.1, 4.8.0, 4.7.2, 4.4.0, 4.4.1, 4.7.1, 4.6.0, 4.9.0, 4.11.0, 4.19.0, 4.19.1, 4.12.0, 5.0.0-alpha.0, 4.12.1, 4.13.0, 4.13.1, 4.14.0, 4.15.0, 4.16.0, 0.10.0, 0.10.0-alpha, 0.10.0-alpha.1, 0.10.0-alpha.2, 0.10.1, 0.10.2, 0.1.0-dev, 0.1.1, 0.11.0, 0.11.0-alpha.0, 0.1.2, 0.12.0, 0.1.3, 0.13.0, 0.3.0, 0.4.5, 0.5.0, 0.5.1, 0.6.0, 0.6.1, 0.0.4, 0.0.5, 0.0.6, 0.0.7, 0.1.0, 0.1.4, 0.2.0, 0.4.0, 0.4.1, 0.4.2, 0.4.3, 0.4.4, 0.6.2, 0.7.0, 0.7.1, 0.7.2, 0.7.3, 0.7.4, 0.8.0, 0.8.1, 0.8.2, 0.9.0, 0.9.1, 0.9.2, 4.10.0, 4.17.0, 4.18.0, 4.18.1, 4.18.2, 2015-09-22T18:07:08.861Z, 2015-10-02T17:23:08.710Z, 2017-01-20T21:25:43.695Z, 2017-01-09T22:19:09.542Z, 2015-02-07T23:05:07.774Z, 2015-02-08T18:11:31.666Z, 2015-02-21T21:42:37.026Z, 2015-02-26T19:42:32.584Z, 2015-03-07T20:50:41.270Z, 2015-03-08T17:19:44.910Z, 2015-03-11T00:41:23.544Z, 2015-03-14T20:26:17.811Z, 2015-03-18T00:31:26.357Z, 2015-03-28T17:26:43.107Z, 2015-04-11T20:43:22.010Z, 2015-04-24T18:30:35.823Z, 2015-05-09T17:56:16.881Z, 2015-05-15T16:13:51.117Z, 2015-05-18T18:45:29.265Z, 2015-05-30T23:16:22.224Z, 2015-05-31T01:22:08.817Z, 2015-06-15T00:30:50.437Z, 2015-06-26T16:34:53.049Z, 2015-07-10T17:50:06.566Z, 2015-10-16T17:31:05.311Z, 2015-10-16T21:54:09.400Z, 2015-07-15T18:38:22.041Z, 2015-07-23T18:05:32.843Z, 2015-07-24T17:25:12.591Z, 2015-07-31T17:19:53.563Z, 2015-08-07T21:45:16.830Z, 2015-10-19T21:12:51.741Z, 2015-08-18T20:36:29.627Z, 2015-10-21T17:12:13.196Z, 2015-08-20T17:35:16.949Z, 2015-10-30T17:38:44.232Z, 2015-08-28T20:11:14.836Z, 2015-08-29T14:50:42.798Z, 2015-11-06T17:43:47.266Z, 2015-09-11T15:30:20.351Z, 2015-09-11T19:44:08.859Z, 2015-09-15T19:40:22.103Z, 2015-09-15T21:19:56.083Z, 2015-09-18T17:11:39.321Z, 2015-11-20T18:25:36.382Z, 2015-11-20T23:04:56.190Z, 2015-12-23T17:32:58.096Z, 2016-01-11T20:11:41.035Z, 2015-11-27T18:31:00.782Z, 2016-01-22T18:34:55.543Z, 2015-12-01T20:14:47.717Z, 2016-01-29T18:18:15.332Z, 2018-04-13T19:24:34.598Z, 2016-02-02T19:15:51.891Z, 2016-02-09T20:57:13.512Z, 2016-02-12T17:50:19.703Z, 2015-12-11T18:37:23.147Z, 2016-02-19T17:41:20.343Z, 2016-02-15T18:35:37.090Z, 2016-03-05T00:36:20.039Z, 2016-03-25T19:33:12.108Z, 2016-03-11T21:33:58.196Z, 2016-03-25T22:31:02.809Z, 2016-06-20T18:00:41.856Z, 2016-03-28T17:24:21.496Z, 2016-03-28T18:00:32.194Z, 2016-06-17T17:07:25.568Z, 2016-04-01T17:50:23.423Z, 2016-04-04T23:23:42.505Z, 2016-07-15T19:49:56.836Z, 2016-07-18T17:56:07.232Z, 2016-07-29T18:08:31.039Z, 2016-07-01T18:08:45.703Z, 2016-07-05T17:55:17.229Z, 2016-08-01T18:17:06.257Z, 2016-08-01T18:58:16.290Z, 2016-04-15T17:35:29.825Z, 2016-08-26T17:56:13.910Z, 2016-08-12T18:38:02.610Z, 2016-08-15T21:24:24.232Z, 2016-04-29T17:02:37.776Z, 2016-05-13T22:00:08.233Z, 2016-05-14T15:35:25.536Z, 2016-05-16T20:16:17.629Z, 2016-05-27T19:00:03.158Z, 2016-05-30T19:33:22.773Z, 2016-06-10T17:37:21.387Z, 2016-11-28T17:08:21.321Z, 2016-11-25T22:22:58.883Z, 2016-09-09T19:58:24.156Z, 2016-12-12T22:24:36.777Z, 2016-12-09T16:53:18.118Z, 2017-01-06T20:40:29.679Z, 2016-09-23T21:56:28.617Z, 2016-09-26T22:37:52.999Z, 2016-12-14T19:22:22.521Z, 2016-09-30T18:26:52.855Z, 2016-10-03T22:17:57.015Z, 2017-01-25T18:47:54.955Z, 2017-02-03T21:54:07.596Z, 2017-03-06T23:06:58.540Z, 2017-02-20T16:25:06.846Z, 2017-02-22T22:15:43.002Z, 2016-10-14T21:37:10.823Z, 2016-10-17T20:35:56.300Z, 2017-03-03T22:18:27.845Z, 2017-05-19T18:39:19.098Z, 2017-03-31T20:05:30.283Z, 2017-03-17T21:47:14.257Z, 2017-04-07T20:29:09.440Z, 2016-10-28T20:23:12.108Z, 2017-04-21T20:27:14.966Z, 2016-10-31T19:05:47.643Z, 2017-05-05T21:02:33.718Z, 2017-06-24T00:54:34.811Z, 2017-06-26T00:47:57.660Z, 2016-11-11T20:03:41.297Z, 2017-06-02T21:22:13.800Z, 2017-06-12T01:21:22.942Z, 2016-11-14T19:14:58.701Z, 2016-11-15T23:20:48.009Z, 2017-07-09T01:53:24.734Z, 2017-07-21T16:12:40.566Z, 2017-08-19T02:28:15.367Z, 2017-09-15T20:07:20.572Z, 2017-09-03T21:05:34.930Z, 2017-09-29T20:05:33.293Z, 2017-09-21T18:44:51.082Z, 2017-08-05T17:01:00.236Z, 2017-08-07T15:59:26.052Z, 2017-09-18T21:06:25.727Z, 2017-09-01T22:24:44.084Z, 2017-10-14T18:40:58.597Z, 2017-11-10T21:10:31.975Z, 2018-03-16T19:58:59.309Z, 2018-03-22T00:24:49.060Z, 2017-11-26T03:34:15.041Z, 2018-03-30T21:14:24.649Z, 2017-11-30T05:31:16.775Z, 2017-12-08T21:49:02.735Z, 2017-12-11T23:13:43.879Z, 2017-12-23T22:54:23.960Z, 2018-01-07T02:00:39.537Z, 2018-01-20T04:03:40.351Z, 2014-11-27T23:42:43.946Z, 2014-11-15T19:03:57.180Z, 2014-11-16T17:35:23.776Z, 2014-11-23T17:31:08.154Z, 2014-12-06T22:59:20.004Z, 2014-12-12T23:52:14.172Z, 2013-10-05T22:13:13.862Z, 2013-11-10T01:31:19.209Z, 2014-12-30T21:33:26.750Z, 2014-11-29T00:49:13.713Z, 2013-11-24T02:33:59.084Z, 2015-01-17T17:00:19.607Z, 2013-11-26T01:52:10.083Z, 2015-01-24T22:22:05.545Z, 2014-01-20T23:17:58.480Z, 2014-03-29T22:22:56.023Z, 2014-04-10T21:25:17.699Z, 2014-04-17T20:25:26.444Z, 2014-05-17T18:57:54.272Z, 2014-05-17T19:08:22.367Z, 2013-07-04T17:01:31.141Z, 2013-07-06T00:54:44.444Z, 2013-07-17T04:04:55.944Z, 2013-07-22T23:46:57.612Z, 2013-11-04T01:58:26.120Z, 2013-12-06T02:07:13.148Z, 2014-01-01T20:28:28.167Z, 2014-02-12T18:01:38.728Z, 2014-02-27T19:15:48.517Z, 2014-03-04T02:07:11.091Z, 2014-03-19T00:25:04.015Z, 2014-03-25T19:56:07.203Z, 2014-05-23T21:24:40.856Z, 2014-05-23T21:21:04.170Z, 2014-07-07T23:24:30.078Z, 2014-07-08T17:27:44.240Z, 2014-07-09T19:51:41.180Z, 2014-07-10T18:30:04.865Z, 2014-09-05T18:46:50.941Z, 2014-09-10T00:32:37.315Z, 2014-09-20T16:00:47.850Z, 2014-10-24T22:29:34.100Z, 2014-10-25T16:34:48.487Z, 2014-11-01T17:22:20.201Z, 2017-10-27T20:53:30.028Z, 2018-02-03T02:02:32.359Z, 2018-02-16T22:17:06.945Z, 2018-02-20T21:09:39.542Z, 2018-03-02T20:20:51.390Z
#> 2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           1.4.0, 1.6.2, 2.10.0, 2.10.1, 1.7.0, 1.7.1, 1.7.2, 2.0.0, 2.1.0, 2.2.1, 2.3.0, 2.3.1, 2.4.0, 1.0.0, 1.0.1, 1.1.0, 1.1.1, 1.2.0, 1.3.0, 1.5.0, 1.5.1, 1.6.0, 1.6.1, 2.10.3, 2.5.0, 2.5.1, 2.6.0, 2.7.0, 2.8.0, 2.8.1, 2.8.2, 2.8.3, 2.8.4, 2.9.0, 2.10.2, 2.20.0, 2.10.5, 2.10.6, 2.11.1, 2.11.0, 2.22.1, 2.11.2, 2.12.0, 2.14.0, 2.14.1, 2.13.0, 2.17.0, 2.15.0, 2.17.1, 2.15.1, 2.18.1, 2.15.2, 2.18.0, 2.16.0, 2.19.0, 2.19.1, 2.19.2, 2.22.0, 2.19.3, 2.19.4, 2.20.1, 2.21.0, 2012-02-03T19:16:23.207Z, 2012-05-04T17:20:44.495Z, 2015-04-07T05:47:55.150Z, 2015-04-09T04:35:40.706Z, 2012-07-25T19:10:17.239Z, 2012-10-01T17:33:50.199Z, 2012-10-02T17:17:29.879Z, 2013-02-08T19:13:31.027Z, 2013-07-07T20:33:23.042Z, 2013-09-12T08:39:11.211Z, 2013-10-07T08:30:07.796Z, 2013-10-09T02:38:41.218Z, 2013-10-27T02:26:21.876Z, 2011-12-06T18:33:55.051Z, 2011-12-06T18:33:55.051Z, 2011-10-27T23:21:29.770Z, 2011-11-11T19:16:16.504Z, 2011-12-06T18:33:55.051Z, 2012-01-05T17:51:50.298Z, 2012-03-19T19:44:26.563Z, 2012-04-06T02:08:35.747Z, 2012-04-26T16:50:34.866Z, 2012-04-26T22:30:43.479Z, 2015-05-13T07:54:06.071Z, 2013-12-23T21:09:20.525Z, 2014-01-22T09:28:48.138Z, 2014-04-12T16:39:28.034Z, 2014-06-12T07:05:28.881Z, 2014-07-31T06:14:42.643Z, 2014-08-01T17:21:34.509Z, 2014-08-22T13:55:16.784Z, 2014-09-05T08:06:50.383Z, 2014-11-19T04:47:55.514Z, 2015-01-08T15:01:53.935Z, 2015-04-09T06:39:49.763Z, 2017-12-17T01:15:49.496Z, 2015-07-26T09:33:20.719Z, 2015-07-28T04:45:30.983Z, 2016-01-09T13:17:52.618Z, 2016-01-02T23:38:44.509Z, 2018-04-15T06:06:50.664Z, 2016-02-03T22:47:57.749Z, 2016-03-07T09:23:38.456Z, 2016-07-04T05:11:00.066Z, 2016-07-04T06:44:38.979Z, 2016-04-18T07:41:30.471Z, 2016-11-22T13:48:11.843Z, 2016-09-12T09:27:34.034Z, 2016-12-04T05:48:37.075Z, 2016-09-21T03:39:35.635Z, 2017-03-21T22:58:53.237Z, 2016-10-24T06:49:41.735Z, 2017-03-18T21:14:53.605Z, 2016-11-10T06:54:47.648Z, 2017-10-10T09:40:27.714Z, 2017-10-11T21:02:22.832Z, 2017-11-11T20:34:47.676Z, 2018-03-30T22:06:01.552Z, 2017-11-29T16:28:22.840Z, 2017-12-11T01:11:36.087Z, 2017-12-19T04:44:18.894Z, 2018-03-02T20:41:10.675Z
#> 3 1.0.0-beta.1, 1.0.0-alpha.7, 1.0.0-beta.3, 0.12.16, 0.12.16-csp, 1.0.0-alpha.6, 1.0.0-beta.2, 0.11.5, 0.11.6, 0.11.8, 0.11.9, 0.11.10, 0.12.0-beta1, 0.12.0-beta2, 0.12.0-beta3, 0.12.0-beta4, 0.12.0-beta5, 0.12.0-rc2, 0.12.0, 0.12.0-csp, 0.12.1, 0.12.1-csp, 0.12.1-csp.1, 0.12.1-csp.2, 1.0.0-alpha.8, 1.0.0-beta.4, 0.12.2, 0.12.3, 1.0.2, 1.0.3, 0.12.4, 1.0.5, 0.12.5, 0.12.5-csp, 0.12.6, 0.12.7, 0.12.8, 0.12.8-csp, 1.0.6, 1.0.0-csp, 1.0.4, 1.0.7, 0.12.9, 0.12.9-csp, 0.12.10, 0.12.10-csp, 1.0.1, 0.12.11, 0.12.12, 0.12.12-csp, 1.0.0-alpha.1, 1.0.0-alpha.2, 1.0.0-rc.2-migration, 1.0.0-rc.2, 0.12.13, 0.12.13-csp, 1.0.8, 0.12.14, 0.12.15, 1.0.0-alpha.5, 1.0.12, 1.0.12-csp-1, 1.0.13, 1.0.9, 1.0.10, 1.0.10-csp, 1.0.14-csp, 1.0.14, 1.0.15-csp, 1.0.15, 2.1.10, 1.0.16-csp, 1.0.16, 2.1.9, 1.0.11, 1.0.19, 1.0.17, 1.0.18, 1.0.18-csp, 2.0.0-alpha.4, 2.0.0-alpha.8, 2.0.0-alpha.7, 2.0.0-alpha.1, 2.0.0-alpha.3, 2.0.0-alpha.2, 1.0.25, 1.0.25-csp, 1.0.26-csp, 2.0.0-alpha.6, 2.0.0-beta.5, 1.0.21, 2.0.0-beta.2, 2.0.0-beta.3, 2.0.0-beta.6, 2.0.0-beta.4, 2.0.0-beta.1, 2.0.0-rc.3, 2.0.0-rc.2, 2.0.0-rc.1, 1.0.23, 2.0.0-rc.4, 2.1.0, 2.0.8, 2.1.6, 2.1.8, 2.1.4, 1.0.27-csp, 2.2.0, 2.0.3, 2.2.1, 0.12.14-csp, 1.0.0-alpha.4, 0.12.15-csp, 1.0.12-csp, 2.0.0-alpha.5, 1.0.28, 1.0.28-csp, 2.0.0, 2.0.1, 2.2.0-beta.2, 2.0.2, 2.2.0-beta.1, 2.2.3, 2.2.4, 2.2.2, 0.0.0, 0.6.0, 0.7.0, 0.7.1, 0.9.2, 0.9.3, 0.10.0, 0.7.3, 0.7.4, 0.7.5, 0.7.6, 0.8.0, 0.8.1, 0.8.2, 0.8.3, 0.8.4, 0.8.5, 0.8.6, 0.8.7, 0.8.8, 0.9.0, 0.9.1, 0.10.3, 0.10.4, 0.10.5, 0.10.6, 0.10.1, 0.10.2, 0.11.4, 0.11.7, 0.12.0-rc, 1.0.0-rc.1, 0.12.6-csp, 0.12.7-csp, 1.0.0-migration, 1.0.0, 0.12.11-csp, 1.0.0-alpha.3, 0.11.0-rc, 0.11.0-rc2, 0.11.0-rc3, 0.11.0, 0.11.1, 0.11.2, 0.11.3, 1.0.13-csp, 1.0.11-csp, 1.0.19-csp, 1.0.17-csp, 1.0.20, 1.0.20-csp, 1.0.26, 1.0.21-csp, 2.0.0-beta.7, 2.0.0-beta.8, 1.0.22, 1.0.22-csp, 1.0.23-csp, 1.0.24, 1.0.24-csp, 2.1.2, 2.1.3, 2.1.1, 2.1.7, 2.1.5, 2.0.0-rc.5, 2.0.0-rc.6, 1.0.27, 2.0.0-rc.7, 2.0.0-rc.8, 2.2.5, 2.2.6, 2.3.0, 2.3.2, 2.3.0-beta.1, 2.3.3, 2.0.4, 2.0.5, 2.3.1, 2.3.4, 2.0.6, 2.4.0, 2.4.1, 2.0.7, 2.4.2, 2.4.4, 2.4.3, 2.5.0, 2.5.1, 2.5.2, 2.5.3, 2.5.4, 2.5.5, 2.5.6, 2.5.7, 2.5.8, 2.5.16, 2.5.17-beta.0, 2.5.9, 2.5.10, 2.5.11, 2.5.12, 2.5.13, 2.5.14, 2.5.15, 2015-09-21T19:12:57.424Z, 2015-10-02T20:13:10.203Z, 2015-10-02T20:17:44.825Z, 2015-09-25T20:20:05.130Z, 2015-09-25T20:29:32.399Z, 2015-09-25T20:34:58.129Z, 2015-09-25T20:53:16.825Z, 2015-02-05T21:29:54.653Z, 2015-04-18T07:11:26.742Z, 2015-04-21T20:10:47.755Z, 2015-05-06T20:40:14.353Z, 2015-05-07T19:00:43.870Z, 2015-05-16T17:25:13.491Z, 2015-05-16T18:22:58.104Z, 2015-05-22T20:08:57.836Z, 2015-05-26T16:51:10.607Z, 2015-05-30T02:27:57.264Z, 2015-06-04T19:00:26.474Z, 2015-06-12T17:34:35.326Z, 2015-06-12T20:50:01.816Z, 2015-06-14T05:28:12.433Z, 2015-06-14T05:56:45.870Z, 2015-06-16T17:02:39.526Z, 2015-06-16T17:14:26.645Z, 2015-10-11T00:38:39.712Z, 2015-10-11T00:47:41.951Z, 2015-06-25T14:51:59.565Z, 2015-06-25T17:38:09.802Z, 2015-10-29T01:46:40.533Z, 2015-10-29T02:13:54.069Z, 2015-06-25T22:26:20.944Z, 2015-11-05T19:36:29.856Z, 2015-07-02T15:04:50.935Z, 2015-07-03T01:11:03.345Z, 2015-07-05T07:48:30.721Z, 2015-07-07T18:51:27.275Z, 2015-07-23T15:23:32.611Z, 2015-07-23T18:48:02.193Z, 2015-11-05T19:52:41.356Z, 2015-10-27T01:22:14.988Z, 2015-10-31T20:39:46.788Z, 2015-11-06T16:38:13.280Z, 2015-07-31T20:31:03.040Z, 2015-07-31T21:10:16.053Z, 2015-08-10T03:39:18.266Z, 2015-08-10T03:58:22.274Z, 2015-10-27T17:58:37.258Z, 2015-08-25T16:58:07.841Z, 2015-08-26T08:48:27.269Z, 2015-08-26T09:01:23.742Z, 2015-08-31T20:59:27.696Z, 2015-09-01T20:24:39.769Z, 2015-10-23T00:38:54.546Z, 2015-10-23T00:43:40.605Z, 2015-09-07T20:10:20.284Z, 2015-09-07T20:15:03.743Z, 2015-11-12T21:58:57.930Z, 2015-09-11T18:16:41.183Z, 2015-09-19T21:33:22.503Z, 2015-09-19T22:14:44.591Z, 2015-12-17T23:12:18.653Z, 2015-12-18T21:35:01.682Z, 2015-12-24T22:39:46.324Z, 2015-11-23T19:32:33.193Z, 2015-11-23T19:59:21.772Z, 2015-11-23T21:59:26.254Z, 2016-01-11T20:39:19.998Z, 2016-01-11T20:12:35.173Z, 2016-01-18T19:52:06.412Z, 2016-01-18T19:43:57.031Z, 2017-01-17T17:17:23.075Z, 2016-01-30T10:38:42.919Z, 2016-01-30T09:41:50.987Z, 2017-01-16T23:48:18.241Z, 2015-12-10T05:00:17.976Z, 2016-03-25T07:19:25.592Z, 2016-02-29T01:17:27.612Z, 2016-03-18T00:37:50.511Z, 2016-03-18T00:54:16.541Z, 2016-06-16T17:00:54.200Z, 2016-06-28T09:02:18.167Z, 2016-06-28T02:24:20.794Z, 2016-06-10T23:34:30.472Z, 2016-06-15T18:22:44.981Z, 2016-06-13T23:36:54.955Z, 2016-06-16T22:29:30.877Z, 2016-06-16T22:37:40.390Z, 2016-06-28T21:42:53.706Z, 2016-06-22T19:33:28.089Z, 2016-07-27T04:25:51.572Z, 2016-04-07T22:08:12.136Z, 2016-07-17T05:51:27.401Z, 2016-07-24T02:45:22.313Z, 2016-08-01T19:27:42.081Z, 2016-07-26T02:04:31.349Z, 2016-07-07T21:51:47.724Z, 2016-08-20T18:05:02.596Z, 2016-08-16T03:39:15.211Z, 2016-08-11T05:43:21.414Z, 2016-05-11T16:20:56.995Z, 2016-08-29T19:49:11.992Z, 2016-11-22T16:15:14.206Z, 2016-11-20T03:15:06.652Z, 2016-12-13T17:22:37.865Z, 2016-12-28T05:54:46.485Z, 2016-12-02T03:01:28.900Z, 2016-09-23T19:53:46.613Z, 2017-02-26T04:32:12.374Z, 2016-10-13T09:27:34.643Z, 2017-02-26T13:10:58.636Z, 2015-09-11T18:19:13.220Z, 2015-09-11T18:27:50.726Z, 2015-09-19T21:39:37.485Z, 2015-12-17T23:23:50.790Z, 2016-06-17T18:22:45.156Z, 2016-09-27T20:45:42.280Z, 2016-09-27T20:47:26.372Z, 2016-09-30T18:32:13.071Z, 2016-09-30T21:12:13.389Z, 2017-02-25T00:01:22.141Z, 2016-10-12T04:54:13.325Z, 2017-02-24T04:22:29.318Z, 2017-03-13T08:08:12.196Z, 2017-03-13T15:08:23.692Z, 2017-03-09T04:23:54.613Z, 2013-12-07T06:09:48.297Z, 2013-12-08T00:36:06.595Z, 2013-12-24T02:10:40.441Z, 2013-12-24T21:58:45.125Z, 2014-02-25T22:29:51.748Z, 2014-03-02T23:22:22.113Z, 2014-03-23T18:53:07.403Z, 2014-01-06T19:13:46.961Z, 2014-01-10T21:57:04.827Z, 2014-01-13T21:04:55.424Z, 2014-01-19T03:43:46.191Z, 2014-01-27T05:15:59.620Z, 2014-02-02T05:49:12.091Z, 2014-02-03T22:18:34.108Z, 2014-02-06T02:21:37.894Z, 2014-02-09T02:39:35.620Z, 2014-02-10T22:05:57.196Z, 2014-02-14T07:04:48.933Z, 2014-02-20T19:02:49.368Z, 2014-02-20T22:56:32.861Z, 2014-02-25T06:16:32.434Z, 2014-02-25T15:34:00.231Z, 2014-03-26T23:13:06.427Z, 2014-04-25T19:48:04.430Z, 2014-06-06T19:09:26.096Z, 2014-07-29T02:42:46.414Z, 2014-03-24T08:11:43.379Z, 2014-03-25T04:20:04.786Z, 2014-12-07T20:44:16.730Z, 2015-04-21T03:19:52.363Z, 2015-06-01T20:56:52.316Z, 2015-10-15T21:14:16.364Z, 2015-07-05T08:24:29.694Z, 2015-07-07T18:54:26.904Z, 2015-10-27T01:31:29.819Z, 2015-10-27T01:40:01.625Z, 2015-08-25T17:10:02.340Z, 2015-09-07T20:21:11.010Z, 2014-09-27T01:26:13.384Z, 2014-10-07T17:08:40.846Z, 2014-10-24T16:54:11.017Z, 2014-11-07T01:52:49.130Z, 2014-12-01T00:25:20.710Z, 2014-12-02T02:38:46.620Z, 2014-12-02T17:23:08.144Z, 2015-12-25T03:54:53.045Z, 2015-12-11T13:20:49.744Z, 2016-03-25T07:24:11.639Z, 2016-02-29T02:24:33.094Z, 2016-03-26T21:20:12.830Z, 2016-03-26T21:24:54.499Z, 2016-06-28T20:57:34.028Z, 2016-04-07T22:11:14.714Z, 2016-08-05T22:10:35.353Z, 2016-08-10T04:55:41.561Z, 2016-05-07T21:59:24.459Z, 2016-05-07T22:00:53.845Z, 2016-05-11T16:22:30.910Z, 2016-05-11T21:57:37.358Z, 2016-05-11T21:59:55.010Z, 2016-11-23T23:42:24.420Z, 2016-11-24T00:22:21.218Z, 2016-11-23T21:00:48.669Z, 2016-12-24T16:36:26.289Z, 2016-12-13T03:09:37.917Z, 2016-09-08T11:30:00.014Z, 2016-09-13T13:21:14.193Z, 2016-09-23T19:51:40.267Z, 2016-09-23T22:24:58.125Z, 2016-09-27T21:08:34.332Z, 2017-03-24T04:53:46.566Z, 2017-03-27T02:46:27.224Z, 2017-04-27T06:22:30.251Z, 2017-05-02T10:30:25.167Z, 2017-04-26T10:32:45.472Z, 2017-05-09T16:57:59.102Z, 2016-11-04T20:47:12.563Z, 2016-11-05T03:47:33.287Z, 2017-05-02T07:59:33.809Z, 2017-06-08T04:54:50.550Z, 2016-11-15T23:05:12.674Z, 2017-07-13T05:59:58.195Z, 2017-07-13T06:40:52.424Z, 2016-11-16T21:54:34.348Z, 2017-07-21T04:28:43.739Z, 2017-09-14T15:32:52.487Z, 2017-09-13T07:57:40.361Z, 2017-10-13T03:07:43.841Z, 2017-10-13T14:14:44.817Z, 2017-10-13T20:21:14.556Z, 2017-11-03T21:11:37.399Z, 2017-11-16T19:55:19.757Z, 2017-11-17T16:37:05.558Z, 2017-11-18T19:44:18.720Z, 2017-11-20T19:49:36.077Z, 2017-11-21T14:42:29.228Z, 2018-03-13T22:14:28.959Z, 2018-03-23T23:29:13.819Z, 2017-11-27T17:43:43.727Z, 2017-12-12T23:16:50.457Z, 2017-12-14T16:56:14.790Z, 2017-12-19T14:54:26.793Z, 2017-12-19T19:07:03.185Z, 2018-03-09T21:42:13.463Z, 2018-03-10T23:36:55.780Z
#>   latest_stable_release.id latest_stable_release.project_id
#> 1                 12442587                           145391
#> 2                 12604973                           295628
#> 3                 12366565                           329408
#>   latest_stable_release.number latest_stable_release.published_at
#> 1                       4.19.1           2018-03-22T00:24:49.060Z
#> 2                       2.22.1           2018-04-15T06:06:50.664Z
#> 3                       2.5.16           2018-03-13T22:14:28.959Z
#>   latest_stable_release.created_at latest_stable_release.updated_at
#> 1         2018-03-22T02:03:02.494Z         2018-03-22T02:03:02.494Z
#> 2         2018-04-15T07:11:19.140Z         2018-04-15T07:11:19.140Z
#> 3         2018-03-13T22:19:53.388Z         2018-03-13T22:19:53.388Z
#>   latest_stable_release.runtime_dependencies_count
#> 1                                               38
#> 2                                                0
#> 3                                                0
```

## repositories


```r
lio_repo_projects('gruntjs', 'grunt', per_page = 2)
#>               name platform                description            homepage
#> 1            grunt      NPM The JavaScript Task Runner http://gruntjs.com/
#> 2 my-first-program      NPM The JavaScript Task Runner http://gruntjs.com/
#>                     repository_url normalized_licenses rank
#> 1 https://github.com/gruntjs/grunt                 MIT   27
#> 2 https://github.com/gruntjs/grunt                 ISC   11
#>   latest_release_published_at latest_release_number   language status
#> 1    2018-02-07T21:43:31.858Z                 1.0.2 JavaScript     NA
#> 2    2015-04-08T08:06:47.076Z                 0.4.5 JavaScript     NA
#>                              package_manager_url stars forks
#> 1            https://www.npmjs.com/package/grunt 11762  1536
#> 2 https://www.npmjs.com/package/my-first-program 11762  1536
#>                                                                                                                 keywords
#> 1 task, async, cli, minify, uglify, build, lodash, unit, test, qunit, nodeunit, server, init, scaffold, make, jake, tool
#> 2 task, async, cli, minify, uglify, build, lodash, unit, test, qunit, nodeunit, server, init, scaffold, make, jake, tool
#>   dependents_count dependent_repos_count
#> 1            35398                333103
#> 2                1                     0
#>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              versions
#> 1 0.4.0rc2, 0.1.0, 0.1.1, 0.1.2, 0.2.0, 0.2.1, 0.2.2, 0.2.3, 0.2.4, 0.2.5, 0.2.6, 0.2.7, 0.2.8, 0.2.9, 0.2.10, 0.2.11, 0.2.12, 0.2.13, 0.2.14, 0.2.15, 0.3.0, 0.3.1, 0.3.2, 0.3.3, 0.3.4, 0.3.5, 0.3.6, 0.3.7, 0.3.8, 0.3.9, 0.3.10, 0.3.11, 0.4.0a, 0.3.12, 0.3.13a, 0.3.13, 0.3.14, 0.3.15, 0.3.16, 0.3.17, 0.4.0rc1, 0.4.0rc3, 0.4.0rc4, 0.4.0rc5, 0.4.0rc6, 0.4.0rc7, 0.4.0rc8, 0.4.0, 0.4.1, 0.4.2, 0.4.3, 0.4.4, 0.4.5, 0.4.0-rc3, 0.4.0-rc5, 1.0.0-rc1, 1.0.0, 1.0.1, 0.3.13-a, 0.4.0-rc4, 0.4.0-rc2, 0.4.0-rc7, 0.4.0-rc1, 0.4.0-rc6, 0.4.0-a, 0.4.0-rc8, 1.0.2, 2012-12-10T20:51:01.824Z, 2012-01-12T13:08:51.911Z, 2012-01-19T15:01:53.028Z, 2012-01-19T15:25:39.520Z, 2012-01-22T17:32:05.267Z, 2012-01-23T01:30:52.673Z, 2012-01-23T01:53:20.034Z, 2012-01-23T22:01:15.150Z, 2012-01-23T22:51:11.299Z, 2012-01-29T22:19:53.966Z, 2012-01-30T03:35:13.040Z, 2012-01-30T19:51:24.318Z, 2012-01-30T21:56:15.458Z, 2012-01-31T14:10:02.390Z, 2012-02-01T02:10:18.439Z, 2012-02-01T04:16:44.229Z, 2012-02-01T19:26:26.508Z, 2012-02-02T00:42:32.520Z, 2012-02-03T13:48:26.908Z, 2012-02-07T21:50:00.763Z, 2012-03-23T19:58:45.193Z, 2012-03-25T18:25:20.536Z, 2012-03-26T02:24:32.972Z, 2012-03-27T00:07:11.128Z, 2012-03-27T01:36:43.998Z, 2012-03-28T02:04:08.316Z, 2012-03-29T03:15:51.494Z, 2012-04-01T15:09:34.749Z, 2012-04-06T19:26:25.288Z, 2012-04-18T12:53:50.167Z, 2012-06-25T19:46:29.185Z, 2012-06-29T18:28:55.524Z, 2012-12-05T15:23:27.577Z, 2012-07-30T21:20:05.768Z, 2012-08-27T17:14:22.578Z, 2012-08-27T18:01:05.983Z, 2012-08-29T20:55:40.507Z, 2012-09-04T18:29:52.632Z, 2012-10-02T19:43:40.421Z, 2012-10-15T20:44:39.389Z, 2012-12-07T21:38:47.904Z, 2012-12-12T23:08:15.441Z, 2012-12-17T22:17:51.260Z, 2013-01-09T19:24:46.174Z, 2013-01-18T15:53:19.980Z, 2013-01-21T21:31:58.519Z, 2013-02-14T01:07:06.952Z, 2013-02-18T17:27:05.391Z, 2013-03-13T14:17:46.267Z, 2013-11-21T20:52:02.430Z, 2014-03-07T22:00:06.713Z, 2014-03-12T20:28:51.045Z, 2014-05-12T17:45:09.046Z, 2012-12-12T23:08:15.441Z, 2013-01-09T19:24:46.174Z, 2016-02-11T18:06:41.147Z, 2016-04-04T23:26:54.788Z, 2016-04-05T18:16:49.769Z, 2012-08-27T17:14:22.578Z, 2012-12-17T22:17:51.260Z, 2012-12-10T20:51:01.824Z, 2013-01-21T21:31:58.519Z, 2012-12-07T21:38:47.904Z, 2013-01-18T15:53:19.980Z, 2012-12-05T15:23:27.577Z, 2013-02-14T01:07:06.952Z, 2018-02-07T21:43:31.858Z
#> 2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     0.4.5, 2015-04-08T08:06:47.076Z
#>   latest_stable_release.id latest_stable_release.project_id
#> 1                 12104136                           284257
#> 2                  2932985                           754252
#>   latest_stable_release.number latest_stable_release.published_at
#> 1                        1.0.2           2018-02-07T21:43:31.858Z
#> 2                        0.4.5           2015-04-08T08:06:47.076Z
#>   latest_stable_release.created_at latest_stable_release.updated_at
#> 1         2018-02-12T15:14:37.418Z         2018-02-12T15:14:37.418Z
#> 2         2015-04-08T08:09:36.244Z         2015-04-08T08:09:36.244Z
#>   latest_stable_release.runtime_dependencies_count
#> 1                                               16
#> 2                                               20
```

## subscriptions


```r
lio_subscribe("rubygems", "webmock")
```

## user methods


```r
lio_user('github')
#> $github_id
#> [1] "9919"
#> 
#> $login
#> [1] "github"
#> 
#> $user_type
#> [1] "Organisation"
#> 
#> $created_at
#> [1] "2015-04-07T00:13:24.927Z"
#> 
#> $updated_at
#> [1] "2017-10-07T23:31:27.897Z"
#> 
#> $name
#> [1] "GitHub"
#> 
#> $company
#> NULL
#> 
#> $blog
#> [1] "https://github.com/about"
#> 
#> $location
#> [1] "San Francisco, CA"
#> 
#> $hidden
#> [1] FALSE
#> 
#> $last_synced_at
#> [1] "2017-10-07T23:31:27.325Z"
#> 
#> $email
#> [1] "support@github.com"
#> 
#> $bio
#> [1] "How people build software."
#> 
#> $followers
#> [1] 0
#> 
#> $following
#> [1] 0
#> 
#> $uuid
#> [1] "9919"
#> 
#> $host_type
#> [1] "GitHub"
```

## Meta

* Please [report any issues or bugs](https://github.com/ropenscilabs/rbraries/issues).
* License: MIT
* Get citation information for `rbraries` in R doing `citation(package = 'rbraries')`
* Please note that this project is released with a [Contributor Code of Conduct](CODE_OF_CONDUCT.md).
By participating in this project you agree to abide by its terms.

[![ropensci_footer](https://ropensci.org/public_images/github_footer.png)](https://ropensci.org)
