% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_json.R
\name{print_model_json}
\alias{print_model_json}
\title{Print the JSON of a Bokeh figure}
\usage{
print_model_json(fig, prepare = TRUE, pretty = TRUE, file = "", pbcopy = FALSE)
}
\arguments{
\item{fig}{figure to print}

\item{prepare}{logical - should the figure be sent through preparations that need to be done prior to plotting (TRUE), or printed as-is (FALSE)}

\item{pretty}{parameter passed on to \code{\link[jsonlite]{toJSON}}}

\item{file}{parameter passed on to \code{\link[base]{cat}}}

\item{pbcopy}{logical - if on OSX, should the results be passed to the clipboard (TRUE) instead of printed to the screen (FALSE)?}
}
\description{
Print the JSON of a Bokeh figure
}
\examples{
\dontrun{
p <- figure() \%>\% ly_points(1:10) \%>\%
 tool_pan(dimensions = "height")
print_model_json(p)
}
}
