% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{complete_control_bayes}
\alias{complete_control_bayes}
\title{Completion of the Control Options List}
\usage{
complete_control_bayes(
  control,
  n_samples,
  quiet,
  stan_data,
  mmrm_initial,
  covariance,
  prior_cov
)
}
\arguments{
\item{control}{A list containing part of the control options. Must not contain
\code{iter}, \code{refresh}, \code{object}, \code{data}, or \code{pars}.}

\item{n_samples}{Number of samples to be drawn.}

\item{quiet}{A logical indicating whether to suppress output during sampling.}

\item{stan_data}{A list containing the Stan data.}

\item{mmrm_initial}{A list containing the initial values from the MMRM.}

\item{covariance}{A character string indicating the type of covariance structure.}

\item{prior_cov}{A character string indicating the type of prior for the covariance parameters.}
}
\value{
A completed control options list with the necessary parameters for Bayesian sampling.
}
\description{
This function completes the control options list for Bayesian methods by setting
the number of iterations, refresh rate, and initial values based on the provided arguments.
}
\keyword{internal}
