% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_table.r
\name{bdiv_stats}
\alias{bdiv_stats}
\title{Test beta diversity for associations with metadata.}
\usage{
bdiv_stats(
  biom,
  regr = NULL,
  stat.by = NULL,
  bdiv = "Bray-Curtis",
  weighted = TRUE,
  tree = NULL,
  within = NULL,
  between = NULL,
  split.by = NULL,
  transform = "none",
  test = "emmeans",
  fit = "gam",
  at = NULL,
  level = 0.95,
  alt = "!=",
  mu = 0,
  p.adj = "fdr"
)
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{regr}{Dataset field with the x-axis (independent; predictive)
values. Must be numeric. Default: \code{NULL}}

\item{stat.by}{Dataset field with the statistical groups. Must be
categorical. Default: \code{NULL}}

\item{bdiv}{Beta diversity distance algorithm(s) to use. Options are:
\code{"Bray-Curtis"}, \code{"Manhattan"}, \code{"Euclidean"},
\code{"Jaccard"}, and \code{"UniFrac"}. For \code{"UniFrac"}, a
phylogenetic tree must be present in \code{biom} or explicitly
provided via \verb{tree=}. Multiple/abbreviated values allowed.
Default: \code{"Bray-Curtis"}}

\item{weighted}{Take relative abundances into account. When
\code{weighted=FALSE}, only presence/absence is considered.
Multiple values allowed. Default: \code{TRUE}}

\item{tree}{A \code{phylo} object representing the phylogenetic
relationships of the taxa in \code{biom}. Only required when
computing UniFrac distances. Default: \code{biom$tree}}

\item{within, between}{Dataset field(s) for intra- or inter- sample
comparisons. Alternatively, dataset field names given elsewhere can
be prefixed with \code{'=='} or \code{'!='} to assign them to \code{within} or
\code{between}, respectively. Default: \code{NULL}}

\item{split.by}{Dataset field(s) that the data should be split by prior to
any calculations. Must be categorical. Default: \code{NULL}}

\item{transform}{Transformation to apply. Options are:
\code{c("none", "rank", "log", "log1p", "sqrt", "percent")}. \code{"rank"} is
useful for correcting for non-normally distributions before applying
regression statistics. Default: \code{"none"}}

\item{test}{Method for computing p-values: \code{'wilcox'}, \code{'kruskal'},
\code{'emmeans'}, or \code{'emtrends'}. Default: \code{'emmeans'}}

\item{fit}{How to fit the trendline. \code{'lm'}, \code{'log'}, or \code{'gam'}.
Default: \code{'gam'}}

\item{at}{Position(s) along the x-axis where the means or slopes should be
evaluated. Default: \code{NULL}, which samples 100 evenly spaced positions
and selects the position where the p-value is most significant.}

\item{level}{The confidence level for calculating a confidence interval.
Default: \code{0.95}}

\item{alt}{Alternative hypothesis direction. Options are \code{'!='}
(two-sided; not equal to \code{mu}), \code{'<'} (less than \code{mu}), or \code{'>'}
(greater than \code{mu}). Default: \code{'!='}}

\item{mu}{Reference value to test against. Default: \code{0}}

\item{p.adj}{Method to use for multiple comparisons adjustment of
p-values. Run \code{p.adjust.methods} for a list of available
options. Default: \code{"fdr"}}
}
\value{
A tibble data.frame with fields from the table below. This tibble
object provides the \verb{$code} operator to print the R code used to generate
the statistics.\tabular{ll}{
   \strong{Field} \tab \strong{Description} \cr
   .mean \tab Estimated marginal mean. See \code{\link[emmeans:emmeans]{emmeans::emmeans()}}. \cr
   .mean.diff \tab Difference in means. \cr
   .slope \tab Trendline slope. See \code{\link[emmeans:emtrends]{emmeans::emtrends()}}. \cr
   .slope.diff \tab Difference in slopes. \cr
   .h1 \tab Alternate hypothesis. \cr
   .p.val \tab Probability that null hypothesis is correct. \cr
   .adj.p \tab \code{.p.val} after adjusting for multiple comparisons. \cr
   .effect.size \tab Effect size. See \code{\link[emmeans:eff_size]{emmeans::eff_size()}}. \cr
   .lower \tab Confidence interval lower bound. \cr
   .upper \tab Confidence interval upper bound. \cr
   .se \tab Standard error. \cr
   .n \tab Number of samples. \cr
   .df \tab Degrees of freedom. \cr
   .stat \tab Wilcoxon or Kruskal-Wallis rank sum statistic. \cr
   .t.ratio \tab \code{.mean} / \code{.se} \cr
   .r.sqr \tab Percent of variation explained by the model. \cr
   .adj.r \tab \code{.r.sqr}, taking degrees of freedom into account. \cr
   .aic \tab Akaike Information Criterion (predictive models). \cr
   .bic \tab Bayesian Information Criterion (descriptive models). \cr
   .loglik \tab Log-likelihood goodness-of-fit score. \cr
   .fit.p \tab P-value for observing this fit by chance. \cr
}
}
\description{
A convenience wrapper for \code{\link[=bdiv_table]{bdiv_table()}} + \code{\link[=stats_table]{stats_table()}}.
}
\examples{
    library(rbiom)
    
    biom <- rarefy(hmp50)
      
    bdiv_stats(biom, stat.by = "Sex", bdiv = c("bray", "unifrac"))[,1:7]
    
    bdiv_stats(biom, stat.by = "Body Site", split.by = "==Sex")[,1:6]
}
\seealso{
Other beta_diversity: 
\code{\link{bdiv_boxplot}()},
\code{\link{bdiv_clusters}()},
\code{\link{bdiv_corrplot}()},
\code{\link{bdiv_heatmap}()},
\code{\link{bdiv_ord_plot}()},
\code{\link{bdiv_ord_table}()},
\code{\link{bdiv_table}()},
\code{\link{distmat_stats}()}

Other stats_tables: 
\code{\link{adiv_stats}()},
\code{\link{distmat_stats}()},
\code{\link{stats_table}()},
\code{\link{taxa_stats}()}
}
\concept{beta_diversity}
\concept{stats_tables}
