% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_complex_list}
\alias{rba_reactome_complex_list}
\title{Get Complexes That Include a Molecule}
\usage{
rba_reactome_complex_list(id, resource, ...)
}
\arguments{
\item{id}{Molecule's external Identifier}

\item{resource}{What is the resource of your supplied ID? see:
\href{https://reactome.org/content/schema/objects/ReferenceDatabase}{Reactome External
Identifiers}}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
Data frame where each row is a complex containing your supplied
  molecule and columns are pertinent information.
}
\description{
This function will retrieve a list of complexes that include your supplied
  molecule as a component.
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService/data/complexes/{resource}/
 {identifier}"
}

\examples{
\donttest{
rba_reactome_complex_list(id = "3845", resource = "NCBI Gene")
}
\donttest{
rba_reactome_complex_list(id = "P00533", resource = "UniProt")
}

}
\references{
\itemize{
  \item Jassal B, Matthews L, Viteri G, Gong C, Lorente P, Fabregat A,
  Sidiropoulos K, Cook J, Gillespie M, Haw R, Loney F, May B, Milacic M,
  Rothfels K, Sevilla C, Shamovsky V, Shorser S, Varusai T, Weiser J, Wu G,
  Stein L, Hermjakob H, D'Eustachio P. The reactome pathway knowledgebase.
  Nucleic Acids Res. 2020 Jan 8;48(D1):D498-D503. doi: 10.1093/nar/gkz1031.
  PubMed PMID: 31691815.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  }
}
\seealso{
Other "Reactome Content Service - Physical Entity Queries": 
\code{\link{rba_reactome_complex_subunits}()},
\code{\link{rba_reactome_entity_other_forms}()},
\code{\link{rba_reactome_participant_of}()}
}
\concept{"Reactome Content Service - Physical Entity Queries"}
