/* http://adsabs.harvard.edu/abs_doc/journals1.html
 * download URL source then parse with
 * fgrep setfields journals1.html | awk -F ';' '{Rprintf "%s\n",$2}'
 * | cut -c 7-12,24- | sed 's/"//g'
 * | awk '{ for(i=1;i<=length($0);++i){c=substr($0,i,1);if(c==" "&&i<6) { Rprintf(".");} else {Rprintf("%s",c);}}Rprintf("\n");}'
 * | awk '{Rprintf "\"%s\",\n",$0 }' | sort -n -k2 
 *
 */
const char *journals[] = {
"A&AA. Astronomy and Astrophysics Abstracts Heidelberg",
"AAABS Asociacion Argentina de Astronomia La Plata Argentina Book Series",
"AAAN. Astronomische Abhandlungen als Erganzungshefte zu den Astronomische Nachrichten",
"AAAR. Arctic, Antarctic and Alpine Research",
"A&A.. Astronomy and Astrophysics",
"A&AC. Astronomy &amp",
"AADDR Abhandlungen Akad. Wiss. DDR",
"AAfz. Astrometriia i Astrofizika",
"AAGot Abhandlungen Akad. Wiss. G&ouml",
"AAHam Astronomische Abhandlungen der Hamburger Sternwarte",
"AAIzN Alma Ata Izdatel Nauka",
"AALST Atti Accad. Ligure Sci. Lett.",
"AAM.. Archive of Applied Mechanics",
"AAMOP Advances in Atomic Molecular and Optical Physics",
"AAMS. Adv. Appl. Mech. Suppl.",
"AAN.. AAVSO Alert Notice",
"AAnST Advances in Astronautics Science and Technology",
"AAONw Anglo-Australian Observatory Epping Newsletter",
"AAOPr Anglo-Australian Observatory Epping Preprint",
"AAPon Atti Accad. Pontaniana",
"A&ARv Astronomy and Astrophysics Review",
"A&AS. Astronomy and Astrophysics Supplement Series",
"AASF. Ann. Acad. Sci. Fennicae",
"AASHS AAS Hist. Ser.",
"AASP. Advances in Astronomy and Space Physics",
"AASPB AAS Photo Bulletin",
"AASPP Astrononomy and Astrophysics Series",
"AAST. Atti Accad. Sco. Torino I",
"A&AT. Astronomical and Astrophysical Transactions",
"AAVNw AAVSO Newsletter",
"AAVSB AAVSO Solar Bulletin",
"AAVSC AAVSO Circular",
"AAVSN AAVSO Special Notice",
"AbaOB Abastumanskaia Astrofizicheskaia Observatoriia Byulleten",
"AbApA Abstract and Applied Analysis",
"AbAst Abenteuer Astronomie",
"AbbOO Abbadia Observatory Observations",
"AbhBr Abh. naturwiss. Verein Bremen",
"AbhKP Abh. Konigl. Preuss. Akad. Wissenschaften Jahre 1906,92, Berlin,1907",
"AbhP. Abh. der Preu&szlig",
"AbICA Abstracts of the ICA",
"ABKie Astronomische Beobachtungen auf der Sternwarte der Koeniglichen Christian-Albrechts-Universitaet zu Kiel",
"ABMun Astronomische Beobachtungen angestellt auf der K. Sternwarte zu Bogenhausen bei Muenchen",
"ABSBe Astronomische Beobachtungen auf der Koniglichen Sternwarte zu Berlin",
"ABWG. Abh. Braunschweigische Wissenschaftliche Ges.",
"AcA.. Acta Astronomica",
"AcAAS Acta Aeronautica et Astronautica Sinica",
"AcAau Acta Astronautica",
"AcAcu Acta Acustica",
"AcAer Acta Aerodynamica Sinica",
"AcApS Acta Astrophysica Sinica",
"AcAri Acta Arithmetica",
"AcArm Acta Armamentarii",
"AcASn Acta Astronomica Sinica",
"A&C.. Astronomy and Computing",
"AcAuS Acta Automatica Sinica",
"AcBu. Acoust. Bull.",
"AcC.. Acta Cosmologica",
"AcChR Accounts Chem. Res.",
"AcCrA Acta Crystallographica Section A",
"AcCrD Acta Crystallographica Section D",
"AcEle Acta Electronica",
"AcElS Acta Electronica Sinica",
"ACESJ Applied Computational Electromagnetics Society Journal",
"AcESn Acta Electron. Sinica",
"AcGdG Acta Geodynamica et Geomaterialia",
"AcGeo Acta Geophysica",
"AcGeP Acta Geophysica Polonica",
"AcGG. Acta Geod. Geophys.",
"ACGIS Advances in Cartography and GIScience of the ICA",
"AcGSn Acta Geophys. Sinica",
"AcHA. Acta Historica Astronomiae",
"AcHPh Helvetica Physica Acta",
"AcHPS Helvetica Physica Acta Supplementum",
"ACiCh Astronomical Circular",
"ACIP. Acta Cienc. Indica Phys.",
"AcMa. Acta Mathematica",
"ACMan Astronomical Contributions from the University of Manchester",
"AcMaS Acta Mathematica Sinica",
"AcMat Acta Materialia",
"AcMCS Acta Materiae Compositae Sinica",
"AcMec Acta Mechanica",
"AcMeS Acta Meteorologica Sinica",
"AcMet Acta Metallurgica",
"AcMik Mikrochimica Acta",
"AcM&M Acta Metallurgica et Materialia",
"AcMPh Acta Universitatis Caroliae. Mathematica et Physica",
"AcMPS Acta Universitatis Caroliae. Mathematica et Physica Supplement",
"AcMSn Acta Mechanica Sinica",
"AcMSS Acta Mechanica Solida Sinica",
"AcMSw Acta Mathematica Sweden",
"AcMT. Acta Materialia Transylvanica",
"AcNum Acta Numerica",
"AcO.. Acta Oecologica",
"AcOpS Acta Optica Sinica",
"AcOpt Optica Acta",
"AcOSi Acta Oceanica Sinica",
"AcouL Acoustics Letters",
"AcPAS Acta Physica Austriaca Supplement",
"ACP.. Atmospheric Chemistry & Physics",
"ACPD. Atmospheric Chemistry & Physics Discussions",
"AcPhA Acta Physica Austriaca",
"AcPhC Acta Physica et Chemica",
"AcPhH Acta Physica Hungarica",
"AcPhS Acta Physiologica Scandinavica",
"AcPhy Acta Physica",
"AcPol Acta Polytechnica",
"AcPPA Acta Physica Polonica A",
"AcPP. Acta Physica Polonica",
"AcPPB Acta Physica Polonica B",
"AcPPP Acta Polytechnica CTU Proceedings",
"AcPPS Acta Physica Polonica B, Proceedings Supplement",
"AcPSc Acta Polytechnica Scandinavica Applied Physics Series",
"AcPSi Acta Photonica Sinica",
"AcPSl Acta Physica Slovaca",
"AcPSn Acta Physica Sinica",
"AcRhe Rheologica Acta",
"ACSB. American Ceramic Society Bulletin",
"ACSC. American Ceramic Society Communications",
"ACSJ. American Ceramic Society Journal",
"AcSN. Acta Scientifica Naturalis",
"AcSpA Spectrochimica Acta Part A: Molecular Spectroscopy",
"AcSpe Spectrochimica Acta",
"AcSSn Acta Seismologica Sinica",
"ACTAp Automatic Control Theory Applications",
"AcTC. Theoretica Chimica Acta",
"AcTec Acta Technica",
"Acu.. Acustica",
"AcUnC Acta Universitatis Cibiniensis",
"AcUni Acta Universitaria",
"AdA&A Advances in Astronomy and Astrophysics",
"AdAer Advances in Aeronautics",
"AdAMP Advances in Atomic and Molecular Physics",
"AdAnS Advances in the Astronautical Sciences",
"AdAp. Advances in Astrophysics",
"AdApM Advances in Applied Mathematics",
"adap.pNASA ADAP Proposal",
"AdAs. Ad Astra",
"adass Astronomical Data Analysis Software and Systems",
"AdAst Advances in Astronomy",
"AD... Atomic Data",
"AdAtS Advances in Atmospheric Sciences",
"ADCBu Astronomical Data Center Bulletin",
"AdChP Advances in Chemical Physics",
"AdCIS Advances in Colloid and Interface Science",
"AdCM. Advanced Ceramic Materials",
"AdCMP Advances in Condensed Matter Physics",
"AdCoL Advanced Composites Letters",
"AdEl. Advanced Electromagnetics",
"AdEPS Advances in Earth and Planetary Sciences",
"AdG.. Advances in Geosciences",
"AdGeo Advances in Geophysics",
"AdHEP Advances in High Energy Physics",
"ADIL. Astronomy Data Image Library",
"AdMaP Advances in Mathematical Physics",
"AdMet Advances in Meteorology",
"AdMPC Advances in Materials Physics and Chemistry",
"AdMRe Advances in Magnetic Resonance",
"AdMS. Advances in Materials Science",
"AdMSE Advances in Materials Science and Engineering",
"AdMUM Advances in Mechanics Uspekhi Mekhaniki",
"ADNDT Atomic Data and Nuclear Data Tables",
"AdNOp Advances in Nonlinear Optics",
"AdNuP Advances in Nuclear Physics",
"AdOP. Advances in Optics and Photonics",
"AdOT. Advanced Optical Technologies",
"AdPho Advanced Photonics",
"AdPhy Advances in Physics",
"AdPlP Advances in Plasma Physics",
"AdQC. Advances in Quantum Chemistry",
"AdRS. Advances in Radio Science",
"AdSAC Advanced Series in Astrophysics and Cosmology",
"AdSpR Advances in Space Research",
"AdSR. Advances in Science and Research",
"AdTAM Advances in Theoretical and Applied Mechanics",
"AdThP Advances in Theoretical Physics",
"AdTMP Advances in Theoretical and Mathematical Physics",
"AdWR. Advances in Water Resources",
"AeAm. Aerospace America",
"AeCh. Aerospace China",
"AeCM. Aerospace Composites and Materials",
"AEdRv Astronomy Education Review",
"AeDy. Aerospace Dynamics",
"AeEn. Aerospace Engineering",
"AEEP. Advances in Electronics and Electron Physics",
"AEEPS Advances in Electronics and Electron Physics Supplement",
"AeIBu Aerokosmicheski Izsledvaniia B lgariia",
"AeJ.. Aeronautical Journal",
"Aekv. Aerodinamika kanalov i ventiliatorov",
"AeMat Aerospace Materials",
"AeMed Aerospace Medicine",
"AeMiS Aerotecnica Missili &amp",
"AeoRe Aeolian Research",
"AeQ.. Aeronautical Quarterly",
"AeRaG Aerodinamika Razrezhennykh Gazov",
"AerAs L'Aeronautique et L'Astronautique",
"AerMS L'Aerotecnica Missili e Spazio",
"Aero. Aerospace UK",
"AerRv Revue Aerospatiale",
"AerSE Aerosol Science and Engineering",
"AerST Aerosol Science Technology",
"AerSy Aerospace Systems",
"AerTe Aerojet Technology",
"AeSIJ Aeronautical Society India Journal",
"AeTJa Aerospace Technology Japan",
"AExpr Astronomy Express",
"AFChr Annales Francaises de Chronometrie",
"AFGL. AFGL-TR-0208 Environemental Research papers",
"AFLB. Annales de la Fondation Louis de Broglie",
"AFMa. Air Force Magazine",
"AFOEV Bulletin de l'Association Francaise d'Observateurs d'Etoiles Variables",
"AFRE. Alta Frequenza Rivista di Elettronica",
"AfrSk African Skies",
"AfRvP The African Review of Physics",
"Afz.. Astrofizika",
"A&G.. Astronomy and Geophysics",
"AgFM. Agricultural and Forest Meteorology",
"Agrph The Astrograph",
"AGUA. AGU Advances",
"AGUFM AGU Fall Meeting Abstracts",
"AGUSM AGU Spring Meeting Abstracts",
"AHEEM Archives of Hydro-Engineering and Environmental Mechanics",
"AHES. Archive for History of Exact Sciences",
"AHSJ. American Helicopter Society Journal",
"AIAAJ AIAA Journal",
"AIASJ AIAA Student Journal",
"AIChE AIChE Journal",
"AIH.. Acoustical Imaging and Holography",
"AIHAJ AIHA Journal",
"AIHPA Annales de L'Institut Henri Poincare Section (A) Physique Theorique",
"AIHPB Annales de L'Institut Henri Poincare Section (B) Probability and Statistics",
"AIHPC Annales de L'Institut Henri Poincare Section (C) Non Linear Analysis",
"AiInt Air International",
"AIMSG AIMS Geosciences",
"AIPA. AIP Advances",
"AIQSY Annals of the IQSY",
"AirCo Air et Cosmos",
"AirE. Aircraft Engineering",
"AirSp Air and Space",
"AISAO Astrofizicheskie Issledovaniia Izvestiya Spetsial'noj Astrofizicheskoj Observatorii",
"AISof Astrofizicheskie Issledovaniya Sofia",
"AJB.. Astronomischer Jahresbericht",
"AJCh. Australian Journal of Chemistry",
"AJGeo American Journal of Geoscience",
"AJSE. Arabian Journal of Science Engineering",
"AJSEd Atlas Journal of Science Education",
"AJS.. The Astronomical Journal Supplement",
"AJ... The Astronomical Journal",
"AkAtP Akademia Athenon Praktika",
"AkTek Akustika i Ul trazvukovaia Tekhnika",
"AkZh. Akusticheskii Zhurnal",
"AlFr. Alta Frequenza",
"ALMAN ALMA Newsletter",
"AMat. Applied Mathematics",
"Ambio Ambio",
"AMGBA Archives for Meteorology Geophysics and Bioclimatology Series A Meteorology and Atmopsheric Physics",
"AMGBB Archives for Meteorology Geophysics and Bioclimatology Series B Theoretical and Applied Climatology",
"AMGBK Archiv Meteorologie Geophysik und Bioklimatologie Serie B Klimatologie und Umweltmeteorologie Strahlungsforschung",
"AMGBS Archiv Meteorologie Geophysik und Bioklimatologie Serie Meteorologie und Geophysik",
"AmJC. American Journal of Cardiology",
"AmJM. American Journal of Mathematics",
"AmJPh American Journal of Physics",
"AmJSA American Journal of Science and Arts",
"AmJS. American Journal of Science",
"AMM.. Applied Mechanics and Materials",
"AmMin American Mineralogist",
"AMP.. Advanced Materials and Processes",
"AMR.. Antarctic Meteorite Research",
"AmSci American Scientist",
"AMT.. Atmospheric Measurement Techniques",
"AMTD. Atmospheric Measurement Techniques Discussions",
"AMTM. Archives of Mechanical Technology and Materials",
"AnaCh Analytical Chemistry",
"AnAIK Annales de l'Observatoire astronomique de l'Universit&eacute",
"AnaIn Analytical Instrumentation",
"AnAp. Annales d'Astrophysique",
"AnAPM Annales de l'Observatoire d'astronomie physique de Paris, Section d'astrophysique, &agrave",
"AnApS Annals of Applied Statistics",
"AN... Astronomische Nachrichten",
"Ana.. The Analyst",
"AnBes Annales de l'Observatoire de Besancon",
"AnBog Neue Annalen der Koeniglichen Sternwarte in Bogenhausen bei Muenchen",
"AnBor Annales de l'Observatoire de Bordeaux",
"AnBos Annals of the Bosscha Observatory Lembang (Java) Indonesia",
"AnBru Annales de l'Observatoire Royal de Bruxelles",
"AnCap Annals of the Cape Observatory",
"AnCGH Annals of Royal Observatory, Cape of Good Hope",
"AnCPh Annales de Chimie et de Physique",
"AnDea Annals of the Dearborn Observatory",
"AnDud Annals of the Dudley Observatory",
"AnEdi Annals of the Royal Observatory, Edinburgh",
"AnErg Ergaenzungshefte zu den Astronomischen Nachrichten",
"Anews ASTRON Newsletter",
"AnFis Anales de Fisica",
"AnG.. Annales de Geophysique",
"AnGeo Annales Geophysicae",
"AnGla Annals of Glaciology",
"AnGp. Annals of Geophysics",
"AnGVP Annales du Bureau des Longitudes, Gauthier-Villars, Paris",
"AnHar Annals of Harvard College Observatory",
"AnHP. Annales Henri Poincar&eacute",
"AnIPS Annals of the Israel Physical Society",
"ANLAF Accademia Nazionale dei Lincei Atti Rendiconti Classe di Scienze Fisiche e Naturali",
"ANLAM Accademia Nazionale dei Lincei Atti Rendiconti Classe di Matematica e Applicazioni",
"ANLAR Accademia Nazionale dei Lincei Atti Rendiconti Classe di Scienze Fisiche Matematiche e Naturali",
"AnLei Annalen van de Sterrewacht te Leiden",
"AnLL. Annals of the Observatory of Lucien Libert",
"AnLow Annals of the Lowell Observatory",
"AnLun Annals of the Observatory of Lund",
"AnLuS Annals of the Observatory of Lund Supplement",
"AnMat Annals of Mathematics",
"AnMet Annalen Meteorologie",
"AnMN. Antarctic Meteorite Newsletter",
"AnMP. Analysis and Mathematical Physics",
"AnMun Annalen der Koeniglichen Sternwarte bei Muenchen",
"AnMuS Supplementband zu den Annalen der Munchener Sternwarte",
"AnNic Annales de l'Observatoire de Nice",
"AnOB. Annales de l'Observatoire Royal de Belgique",
"AnOBN Annales de l'Observatoire Royal de Belgique Nouvelle serie",
"AnOLL Annals of the Private Observatory of Lucien Libert",
"AnOSt Annales de l'Observatoire de Strasbourg",
"AnP.. Annalen der Physik",
"AnPar Annales de l'Observatoire de Paris",
"AnPCS Annales de Physique Colloque Supplement",
"AnPh. Annales de Physique",
"AnPhy Annals of Physics",
"AnPOb Annales de l'Observatoire de Paris. Observations",
"AnRE. Annual Review of Energy",
"AnRFM Annual Review of Fluid Mechanics",
"AnRio Annales de l'Observatoire Imperial de Rio de Janeiro",
"AnRMS Annual Review of Materials Science",
"AnRSA Annual Review of Statistics and Its Application",
"AnSAO Annals of the Astrophysical Observatory of the Smithsonian Institution",
"ANS.. Astronomische Nachrichten Supplement",
"AnSci Annals of Science",
"AnShO Shanghai Observatory Annals",
"ANSNN Advances in Natural Sciences: Nanoscience and Nanotechnology",
"AnSPC Annals of the Solar Physics Observatory Cambridge England",
"AnSSM Annals of Solid and Structural Mechanics",
"AnSta Annals of Statistics",
"AnStr Annalen der Kaiserlichen Universitats-Sternwarte in Strassburg",
"AntAs The Antiquarian Astronomer",
"AnTec Annales Tectonicae",
"AnTel Annales des Telecommunications",
"Anten Antenny",
"Antk. Antarktika",
"AnTok Annals of the Tokyo Astronomical Observatory",
"AnTou Annales de l'Observatoire Astron. et Meteo. de Toulouse",
"AntSc Antarctic Science",
"AnUCP Annals of the University of Craiova Physics AUC",
"AnWiD Annalen der Universitaets-Sternwarte Wien, Dritter Folge",
"AnWie Annalen der K.K. Sternwarte Wien",
"ANZi. Beobachtungs-Zirkular der Astronomischen Nachrichten",
"AnZoC Annales de l'Observatoire astronomique de Z&ocirc",
"AOIJ. Academic Open Internet Journal",
"AOTok Annales de l'Observatoire astronomique de Tokyo",
"ApAc. Applied Acoustics",
"ApAN. Apatity Akademiia Nauk SSSR",
"Ap... Astrophysics",
"APCAJ Air Pollution Control Association Journal",
"ApCM. Applied Composite Materials",
"Apei. Apeiron",
"ApEn. Applied Energy",
"ApEnM Applied Environmental Microbiology",
"APExp Applied Physics Express",
"APFUS Annals of the Physics Faculty of the University of Sofia",
"ApGC. pplied Geochemistry",
"ApGeo Applied Geophysics",
"APh.. Astroparticle Physics",
"APHHI Acta Physica Hungarica Heavy Ion Physics",
"APHQE Acta Physica Hungarica Quantum Electronics",
"APhy. Acoustical Physics",
"ApHyd Applied Hydrogeology",
"ApInv Astrophysical Investigations",
"APJAS Asia-Pacific Journal of Atmospheric Sciences",
"ApJS. The Astrophysical Journal Supplement Series",
"ApJ.. The Astrophysical Journal",
"ApKF. Apatity Kol skii Filial AN SSSR",
"ApL.. Astrophysical Letters",
"ApL&C Astrophysical Letters and Communications",
"APLM. APL Materials",
"APLP. APL Photonics",
"ApMaC Applied Mathematics Computation",
"ApMaL Applied Mathematics Letters",
"ApMaM Applied Mathematics Mechanics English Edition",
"ApMaO Applied Mathematics Optimization",
"ApMat Aplikace Matematiky, Applied Mathematics",
"ApMic Applied Microbiology",
"ApMM. Applied Mathematics and Mechanics",
"ApMRv Applied Mechanics Reviews",
"ApMT. Applied Microgravity Technology",
"ApNan Applied Nanoscience",
"ApNM. Applied Numerical Mathematics",
"ApNr. Astrophysica Norvegica",
"ApOpt Applied Optics",
"AppAn Applicable Analysis",
"ApPhA Applied Physics A: Materials Science & Processing",
"ApPhB Applied Physics B: Lasers and Optics",
"ApPhC Applied Physics Communications",
"ApPhL Applied Physics Letters",
"ApPhR Applied Physics Research",
"ApPhy Applied Physics",
"ApPPL Applied Physics B Photophysics Laser Chemistry",
"ApPRv Applied Physics Reviews",
"apra.pNASA APRA Proposal",
"ApScR Applied Scientific Research",
"ApSE. Applied Solar Energy",
"ApSpe Applied Spectroscopy",
"ApSRA Applied Scientific Research Section A",
"ApSRB Applied Scientific Research Section B",
"ApSRv Applied Spectroscopy Reviews",
"ApSS. Applied Surface Science",
"Ap&SS Astrophysics and Space Science",
"ApSSP Astrophysics and Space Science Proceedings",
"ApSSS Astrophysics and Space Science Supplement",
"ApSup Applied Superconductivity",
"ApT.. Astrophysics Today",
"ApWS. Applied Water Science",
"ARA&A Annual Review of Astronomy and Astrophysics",
"ArA.. Arkiv for Astronomi",
"ARAC. Annual Review of Analytical Chemistry",
"ArAco Archives Acoustics",
"ArAku Archiwum Akustyki",
"ARAOJ Annual Report of the National Astronomical Observatory of Japan",
"A&R.. Astronomie und Raumfahrt",
"ArAuT Archiwum Automatyki i Telemechaniki",
"ArBei Astrophysics Reports Publications of the Beijing Astronomical Observatory",
"ARBl. Aerospace Research in Bulgaria",
"ArBuM Archiwum Budowy Maszyn",
"Arch. Archaeoastronomy",
"ArchS Archaeoastronomy Supplement",
"ARCMP Annual Review of Condensed Matter Physics",
"ArCom Archivum Combustionis",
"AReg. Astronomical register",
"ArEle Archiwum Elektrotechniki",
"ArElU Archiv Elektronik und Uebertragungstechnik",
"ARep. Astronomy Reports",
"AREPS Annual Review of Earth and Planetary Sciences",
"ArG.. Arkiv for Geofysik",
"ARIJ. An Interdisciplinary Journal of Physical and Engineering Sciences",
"ARIST Annual Review of Information Science and Technology",
"ArJPh Armenian Journal of Physics",
"ArMAF Arkiv for Matematik, Astronomi och Fysik",
"ArMaN Archiv for Mathematik og Naturvidenskab",
"ArM.. Arkiv for Matematik",
"ArMeS Archiv of Mechanics, Archiwum Mechaniki Stosowanej",
"ArMiS Archives of Mining Sciences",
"ARMS. Annual Review of Marine Science",
"ARNPS Annual Review of Nuclear and Particle Science",
"ArNSc Archives Neerlandaises des Sciences Exactes et Naturelles",
"ARPC. Annual Review of Physical Chemistry",
"ARPM. Adgeziia Rasplavov i Paika Materialov",
"ArPSp Archiwum Procesow Spalania",
"ArRMA Archive for Rational Mechanics and Analysis",
"ArS.. Archives des Sciences",
"ArSPN Archives des Sciences Physiques et Naturelles",
"AR&T. Astronomical Research and Technology",
"ArTh. Archives of Thermodynamics",
"ArTr. Archives of Transport",
"ArtSa Artificial Satellites",
"ArTSp Archiwum Termodynamiki i Spalania",
"arXiv arXiv e-prints",
"AsAc. Astronautica Acta",
"AsAer Astronautics Aeronautics",
"ASAJ. Acoustical Society of America Journal",
"AsBio Astrobiology",
"ASBTV Archenhold-Sternwarte Berlin-Treptow, Vortrage Schr.",
"ascl.sAstrophysics Source Code Library",
"ASCMO Advances in Statistical Climatology Meteorology and Oceanography",
"asc..rSpace Telescope ASC Instrument Science Report",
"asd..sAstrophysics Software Database",
"AsDyn Astrodynamics",
"ASFAS Academia Scientiarum Fennica Annales Series Physica",
"As&Ge Astronomiya i geodeziya",
"ASHRA ASHRAE Journal",
"AsJES Austrian Journal of Earth Sciences",
"AsJPh Asian Journal of Physics",
"ASL.. Advanced Science Letters",
"ASLLR Accademia di Scienze e Lettere Istituto Lombardo Rendiconti Serie della Classe di Scienze Matematiche e Naturali Sezione Scienze Matematiche Fisiche Chimiche e Geologiche",
"ASME. American Society of Mechanical Engineers",
"Asnau Astronautik",
"AsNot Astronomical Notices",
"AsNow Astronomy Now",
"ASNYN News Letter of the Astronomical Society of New York",
"ASPL. Leaflet of the Astronomical Society of the Pacific",
"ASPLS Leaflet of the Astronomical Society of the Pacific (Supplement)",
"ASPRv Astrophysics and Space Physics Reviews",
"ASSAB Academie Serbe des Sciences et des Arts Bulletin Classe des Sciences Techniques",
"ASSB. Annales de la Soci&eacute",
"AsSch Astronomie in der Schule",
"ASSFA Acta Societatis Scientarum Fennicae Series A",
"ASSF. Acta Societatis Scientarum Fennicae",
"ASSP. Astrophysics and Space Science Proceedings",
"AstAp Astronomy and Astro-Physics (formerly The Sidereal Messenger)",
"Ast.. Astronomy",
"AstBa Biblioteca Astrei Basarabene",
"AstBu Astrophysical Bulletin",
"Aster Aster",
"AstHe Astronomical Herald",
"AstL. Astronomy Letters",
"Astnm Astronomia UAI",
"AstPo Astropolitics",
"AstQ. Astronomy Quarterly",
"ASTRA Astrophysics and Space Sciences Transactions",
"astro arXiv Astrophysics e-prints",
"Astro Astronomy",
"ASTRP ASTRA Proceedings",
"Astr. The Astronomer",
"AstRv The Astronomical Review",
"AstSR Astronomical School's Report",
"AsUAI Astronomia. La rivista dell' Unione Astrofili Italiani",
"ATel1 The Astronomer's Telegram",
"ATel. The Astronomer's Telegram",
"AtEn. Atomnaia Energiia",
"AtERv Atomic Energy Review",
"ATi.. Astronomisk Tidsskrift",
"ATJAM ASME Transactions Series E Journal of Applied Mechanics",
"ATJDS ASME Transactions Journal of Dynamic Systems and Measurement Control B",
"ATJEG ASME Transactions Journal of Engineering Gas Turbines and Power",
"ATJEl ASME Transactions Journal of Electronic Packaging",
"ATJEM ASME Transactions Journal Engineering Materials and Technology",
"ATJEP ASME Transactions Journal of Engineering Power",
"ATJFE ASME Transactions Journal of Fluids Engineering",
"ATJHT ASME Transactions Journal of Heat Transfer",
"ATJLT ASME Transactions Journal of Lubrication Technology",
"ATJSE ASME Transactions Journal of Solar Energy and Engineering",
"ATJTr ASME Transactions Journal of Tribology",
"ATJTu ASME Transactions Journal of Turbomachinery",
"ATJVA ASME Transactions Journal of Vibration Acoustics",
"AtKe. Atomkernenergie",
"AtlVS Atlas Poiskovykh Kart Peremennykh Zvezd",
"ATMAB Association Technique Maritime et Aeronautique Bulletin",
"ATMAS Association Technique Maritime et Aeronautique Session Paris France ONERA TP",
"AtmEn Atmospheric Environment",
"Atmos Atmosphere",
"AtmRe Atmospheric Research",
"AtmTe Atmospheric Technology",
"atnf.pATNF Proposal",
"AtO.. Atmosphere Ocean",
"Atoms Atoms",
"AtOO. Atmospheric and Oceanic Optics",
"AtOpt Atmosphere Optics",
"AtPhy Atomic Physics",
"atp..pNASA ATP Proposal",
"ATR.. ATR Australian Telecommunication Research",
"AtSc. Atmospheric Science",
"AtScL Atmospheric Science Letters",
"ATsir Astronomicheskij Tsirkulyar",
"AtST. Atomisation Spray Technology",
"ATTM. AEG Telefunken Technische Mitteilungen",
"ATTTJ AT T Technical Journal",
"AUGGM Annales UMCS, Geographia, Geologia, Mineralogia et Petrographia",
"AuJA. Australian Journal of Astronomy",
"AuJES Australian Journal of Earth Sciences",
"AuJPA Australian Journal of Physics Astrophysical Supplement",
"AuJPh Australian Journal of Physics",
"AuMM. Australian Meteorological Magazine",
"AuMSJ Australian Mathematical Society Journal Series B -- Applied Mathematics",
"AuRob Autonomous Robots",
"AurPh Auroral physics",
"AUSPh Annales UMCS, Sectio AAA: PHYSICA",
"AuSRA Australian Journal of Scientific Research A Physical Sciences",
"Autom Automatica",
"AVest Astronomicheskii Vestnik",
"AVET. Atomno Vodorodnaia Energetika i Tekhnologiia",
"AVISS Astronomicheskii Vestnik Issledovaniia Solnechnoi Sistemy",
"AvKos Aviatsiia i Kosmonavtika",
"AvPE. Avtomatizatsiia Proektirovaniia Elektronike",
"AvSeM Aviation Space and Environmental Medicine",
"AVSOM American Association of Variable Stars Observers Monographs",
"AVSOR American Association of Variable Stars Observers Reports",
"AVSQS AVS Quantum Science",
"AvTek Aviatsionnaia Tekhnika",
"AvTel Avtomatika i Telemekhanika",
"Avtme Avtometriia",
"AvWST Aviation Week Space Technology",
"AWUTP Annals of West University of Timisoara - Physics",
"AzAJ. Azerbaijani Astronomical Journal",
"AZh.. Astronomicheskii Zhurnal",
"AZWis Astronomisches Zirkular der Akademie der Wissenschaften der UdSSR",
"BAAA. Boletin de la Asociacion Argentina de Astronomia La Plata Argentina",
"BAAPG Bulletin of the American Association of Petroleum Geologists",
"BAAS. Bulletin of the American Astronomical Society",
"BAAVC British Astronomical Association Variable Star Section Circular",
"BABel Bulletin Astronomique de Belgrade",
"BADPG Berlin East Germany Akademie Verlag GmbH Ergebnisse Plasmaphysik und Gaselektronik",
"BAFOE Bulletin Association Fran. Obs. Etoiles Variables",
"BAICz Bulletin of the Astronomical Institutes of Czechoslovakia",
"BaltA Baltic Astronomy",
"BAMaS Bulletin of the American Mathematical Society",
"BAMS. Bulletin of the American Meteorological Society",
"BAN.. Bulletin of the Astronomical Institutes of the Netherlands",
"BANS. Bulletin of the Astronomical Institutes of the Netherlands Supplement Series",
"BAOM. Boletin de la Astronomico Observatorio de Madrid",
"BAORB Bulletin of the Astronomical Observatoire Royale de Belgique",
"BaPhL Balkan Physics Letters",
"BAPS. Bulletin of the American Physical Society",
"BAPSS Bulletin de l'Academie Polonaise des Sciences Series des Sciences Mathematiques Astronomiques et Physiques",
"BARB. Bulletin de l'Academie Royale de Belgique",
"BASBr Bulletin of the Astronomical Society of Brazil",
"BASI. Bulletin of the Astronomical Society of India",
"BasR. Basin Research",
"BAth. National Observatory of Athens Greece Bulletin of the Astronomical Institute",
"BAVMM Berlin East Germany Akademie Verlag GmbH Shriftenreihe des Zentralinstituts Mathematik und Mechanik",
"BAVSM Berliner Arbeitsgemeinschaft fuer Veraenderliche Sterne - Mitteilungen",
"BAVSO Bulletin of the American Association of Variable Stars Observers",
"BAVSR BAV Rundbrief - Mitteilungsblatt der Berliner Arbeits-gemeinschaft fuer Veraenderliche Sterne",
"BAWMN Bayerische Akademie Wissenschaften mathematisch naturwissenschaftliche Klasse Sitzungsberichte",
"BayAn Bayesian Analysis",
"BBCEn BBC Engineering",
"BBGPC Berichte der Bunsen-Gesellschaft Physical Chemistry Chemical Physics Berichte",
"BBSAG Bulletin der Bedeckungsveraenderlichen-Beobachter der Schweizerischen Astronomischen Gesellschaft",
"BBUSM Babes Bolyai Universitas Studia Series Physica",
"BBUSS Babes Bolyai Universitas Studia Series Mathematica",
"BCAIC Bulletin of the Central Astronomical Institute of Czechoslovakia",
"BCFHT Bulletin d'information du telescope Canada-France-Hawaii",
"BCNRC Canada National Research Council Division Mechanical Engineering National Aeronautical Establishment Quarterly Bulletin",
"BCNRS Bulletin Signaletique - Centre National de la Recherche Scientifique",
"BCrAO Bulletin Crimean Astrophysical Observatory",
"BCSAB Bulletin Cl. Science Academy Royal de Belgique",
"BDus. Byulleten' Instituta Astrofiziki Dushanbe Akademiya Nauk Tadzhikskoj SSR",
"BdWis Bild der Wissenschaften",
"BeElM Beskontaktnye Elektricheskie Mashiny",
"BeiGe Beitraege zur Geophysik",
"BeiMP Beitraege zur Mineralogie und Petrographie",
"BeiRe Reprints Beijing Astronomical Observatory Academia Sinica",
"BePl. Beitraege Plasmaphysik",
"BEPM. Bielefeld Encounters in Physics and Mathematics",
"BerAJ Berliner Astronomisches Jarbuch",
"Bes1K Observatoire de Besancon",
"BESBe Beobachtungs-Ergebnisse der Koniglichen Sternwarte zu Berlin",
"BeSN. Be Star Newsletter",
"BFWSG Braunschweig Friedr Vieweg und Sohn GmbH",
"BGBGM Berlin Gebrueder Borntraeger Geoexploration Monographs Series",
"BGD.. Biogeosciences Discussions",
"BGeo. Biogeosciences",
"BGeod Bulletin Geodesique",
"BGNS. Bulletin Geodesique, Nouvelle Series",
"BGSA. Bollettino Geod. Scienzi Affini",
"BHarO Harvard College Observatory Bulletin",
"BIAst Bjull. Inst. Astrofizikii",
"BIBGI Bulletin d'Information du Bureau Gravimetrique International",
"BiBi. Bioinspiration and Biomimetics",
"BICDS Bulletin d'Information du Centre de Donnees Stellaires",
"BIEBe Bulletin d'Information d'Etoiles Be",
"BIHCD Bureau Internationale Heure, Paris, Circulaire",
"BiLuf Bildmessung und Luftbildwessen",
"BIMAF Boletin del Instituto de Matematica Astronomica y Fisica Universidad Nacional de Cordoba Argentina",
"BIMIA Bulletin of the Institute of Mathematics and Its Applications",
"BioFa Biofabrication",
"BioMa Biomedical Materials",
"Bion. Bionika",
"Biopk Biophysik",
"BioSc BioScience",
"BIRM. Brussels Institute Royal Meteorologique de Belgique",
"BITA. Byulleten' Instituta Teoreticheskoj Astronomii (Leningrad)",
"BITad Biulletini of the Astronomical Institute Akademiia Nauk Tadzhikskoi",
"BIT.. Behaviour & Information Technology",
"BITon Boletin del Instituto de Tonantzintla",
"BJAP. British Journal of Applied Physics",
"BJHS. The British Journal for the History of Science",
"BKAD. Beobachtungen der Kaiserlichen Universitaets-Sternwarte Dorpat",
"BKoAS Bulletin of Korean Astronomical Society",
"BKobO Bulletin of the Kobe Marine Observatory Kobe Japan",
"BKUJ. Beobachtungen der Kaiserlichen Universitaets-Sternwarte Jurjew",
"BLabR AT&amp",
"BlazD BLAZAR Data",
"BlDok Bolgarska Akademiia Nauk Doklady",
"BlgAJ Bulgarian Astronomical Journal",
"BlGeo Bulgarska Akademiia Naukite Geofizichni Institut Izvestiia",
"BlGJ. Bulgarian Geophysical Journal",
"BlGSp Bulgarsko Geofizichno Spisanie",
"BlJMH Bulgarian Journal of Meteorology and Hydrology",
"BlJPh Bulgarian Journal of Physics",
"BlJPS Bulgarian Journal of Physics Supplement",
"BlMat Bulgarska Akademiia Naukite Matematicheski Institut Izvestiia",
"BLPI. Bulletin of the Lebedev Physics Institute",
"BlSpi Bulgarska Akademiia Naukite Spisanie",
"BlTek Bulgarska Akademiia Naukite Institut Tekhnicheska Kibernetika Izvestiia",
"BlTse Bulgarska Akademiia Naukite Tsentralna Laboratoriia Geodeziia Izvestiia",
"BMai. Bulletin de la Station Astrophotographique de Mainterne",
"BMFRS Biographical Memoirs of Fellows of the Royal Society",
"BMNAS Biographical Memoirs National Academy of Sciences",
"BMOE. Boletin mensual del Observatorio del Ebro",
"BMP.. Biological and Medical Physics",
"BOBeo Bulletin de l'Observatoire Astronomique de Belgrade",
"BoLMe Boundary-Layer Meteorology",
"BOOde Odesskij Gosudarstvennyi Universitet im. I. I. Mechnikova Byulletin Astronomicheskoj Observatorii",
"BOPul Bulletin (Izvestiya) de l'Observatoire Central a Poulkovo",
"BoSAI Bollettino della Societa Astronomica Italiana",
"BOTor Biuletyn Obserwatoium Astronomicznego Uniwersytetu M. Kopernika w Toruniu",
"BOTT. Boletin de los Observatorios Tonantzintla y Tacubaya",
"BPAS. Bulletin of Pure and Applied Science (Physics)",
"BpBeS Biophysics and Bioengineering Series",
"BpJ.. Biophysical Journal",
"BpRL. Biophysical Reviews and Letters",
"BRASP Bulletin of the Russian Academy of Sciences, Physics",
"BrJPh Brazilian Journal of Physics",
"BRMIC Behavior Research Methods Instruments and Computers",
"BROA. Boletin Real Instituto y Observatorio de la Armada (San Fernando, Cadiz)",
"BROGS Belgian Royal Observatory Communications Series Geophysics Series",
"BrWK. Brennstoff Waerme Kraft",
"BSAE. Bulletin of the Soviet Antarctic Expedition",
"BSAF. Bulletin de la Societe Astronomique de France",
"BSAFR Bulletin de la Societe Astronomique de France et Revue Mensuelle d'Astronomie, de Meteorologie et de Physique du Globe",
"BSAL. Bulletin de la Societe Astronomique de Liege",
"BSAO. Bulletin of the Special Astrophysics Observatory",
"BSASP Bulletin de la Societe des Amis des Sciences et des Lettres de Poznan",
"BSAst Bulletin of the Section of Astronomy",
"BSBA. Bulletin de la Societe Belge d'Astronomie",
"BSD.. Hamburger Sternwarte Bergedorf",
"BSEEA Iasi Institutul Politehnic Buletinul Sectia Electrotehnica Electronica Automatizari",
"BSMMT Iasi Institutul Politehnic Buletinul Sectia Matematica Mecanica Teoretica Fizica",
"BSMT. Iasi Institutul Politehnic Buletinul Sectia Mecanica Tehnica",
"BSolD Byulletin Solnechnye Dannye Akademie Nauk SSSR",
"BSRSL Bulletin de la Societe Royale des Sciences de Liege",
"BSSR. AN BSSR Institut Teplo i Massoobmena Vsesoiuznaia Konferentsiia Teplomassoobmenu Minsk Belorussian SSR Preprint",
"BStaO Byulleten' Stalinabadskoj Astronomicheskoj Observatorii Akademiya Nauk Tadzhikskoj SSR",
"BSTJ. Bell System Technical Journal",
"BTasO Bulletin of the Tashkent Observatory",
"BTE.. British Telecommunications Engineering",
"BToIT Bulletin of the Tokyo Institute of Technology",
"BTok. Bulletin of the Tokyo Astronomical Observatory",
"BTSNU Bulletin of Taras Shevchenko National University of Kyiv Astronomy",
"BTUM. Braunschweig Technische Universitaet Mitteilungen",
"BUAAJ Beijing University Aeronautics and Astronautics Journal",
"BuAkK Budapest Akademiai Kiado",
"BuAsI Bulletin Astronomique, Serie I",
"BuAsR Bulletin Astronomique, Revue Generale des Travaux Astronomiques",
"BuAst Bulletin Astronomique",
"BuAtS Bulletin of the Atomic Scientists",
"BUBes Bulletin of the University of Besancon Observatory",
"BuChr Bulletin Chronometrique (Besancon)",
"BuENS Osaka Prefecture University Bulletin Series Engineering Natural Sciences",
"BUEOP Bulletin of Ukrainian Earth Orientation Parameters Laboratory",
"BuGeo Bulletin of Geosciences",
"BuIPS Bulletin of the Israel Physical Society",
"BuKwa Bulletin of the Kwasan Observatory, Kyoto",
"BuLMS Bulletin of the London Mathematical Society",
"BuLPI Bulletin of the Lebedev Physics Institute",
"BuLyo Bulletin de l'Observatoire de Lyon",
"BuMat Bulletin Mathematique",
"BuONC Bulletin of the Special Astrophysical Observatory, Northern Caucasus",
"BuSSA The Bulletin of the Seismological Society of America",
"BVol. Bulletin of Volcanology",
"BVVSA Bratislava Veda Vydavatelstvo Slovenskej Akademie Vied",
"BYam. Bulletin of the Yamagata University Yamagata Japan",
"ByuRe Byurakan Astrophysical Observatory Armenia USSR Reprints",
"CaASJ Canadian Aeronautics and Space Journal",
"CAD.. Computer-Aided Design",
"CAGHS Correspondance Astronomique, Geographique, Hydrographique et statistique",
"CahPh Cahiers de Physique",
"CaJCh Canadian Journal of Chemistry",
"CaJES Canadian Journal of Earth Sciences",
"CaJPh Canadian Journal of Physics",
"CaJPS Canadian Journal of Physics Supplement",
"CaJRS Canadian Journal of Remote Sensing",
"CANM. Communications in Applied Numerical Methods",
"CAP.. Current Applied Physics",
"CAPJ. Communicating Astronomy with the Public Journal",
"CaRes Cancer Research",
"CarOB Carter Observatory Wellington New Zealand Astronomical Bulletins",
"CAS.. Cambridge Astrophysics Series",
"CASI. CASI Transactions",
"CASJ. Canadian Aeronautics and Space Journal",
"CASJQ Canadian Aeronautics and Space Journal Quarter",
"CBET. Central Bureau Electronic Telegrams",
"CBOAA Comet Bulletin of the Oriental Astronomical Association",
"CCCUK Comet Circular of the Chevchenkov University Kiev",
"CCDA. CCD Astronomy",
"CCM.. Clays and Clay Minerals",
"CCoPh Communications in Computational Physics",
"CCpFS Ceskoslovensky Casopis pro Fyziku Sekce",
"CEAB. Central European Astrophysical Bulletin",
"CEAS. CEAS Space Journal",
"C&E.. Ciel et Espace",
"CEE.. Computers and Electrical Engineering",
"CEEJ. Canadian Electrical Engineering Journal",
"CEEng Civil And Environmental Engineering Reports",
"CEER. Civil And Environmental Engineering Reports",
"CEGB. CEGB Research",
"CEJ.. Chemistry A European Journal",
"CEJE. Central European Journal of Engineering",
"CEJG. Central European Journal of Geosciences",
"CEJGl Central European Journal of Geology",
"CEJPh Central European Journal of Physics",
"CeMDA Celestial Mechanics and Dynamical Astronomy",
"CeMec Celestial Mechanics",
"Cent. Centaurus",
"CEnTp Engineering Thermophysics China",
"CEST. Communications Gillies Inc Electronic Systems in Transportation",
"CESW. Combustion, Explosion and Shock Waves",
"CF... Computers and Fluids",
"CG... Computers and Geosciences",
"CGDAM Conformal Geometry and Dynamics of the American Mathematical Society",
"CGIP. Computer Graphics Image Processing",
"ChA&A Chinese Astronomy and Astrophysics",
"ChA.. Chinese Astronomy",
"Chall Challenges",
"Chaos Chaos",
"ChCom Chemical Communications",
"ChEG. Chemie der Erde / Geochemistry",
"ChEnC Chemical Engineering Communications",
"ChEnN Chemical Engineering News",
"ChEnS Chemical Engineering Science",
"ChGCS Chemosphere - Global Change Science",
"ChGeo Chemical Geology",
"ChIEJ Chinese Institute of Engineers Journal",
"ChJAA Chinese Journal of Astronomy and Astrophysics",
"ChJA. Chinese Journal of Aeronautics",
"ChJAS Chinese Journal of Astronomy and Astrophysics Supplement",
"ChJCP Chinese Journal of Chemical Physics",
"ChJG. Chinese Journal of Geophysics",
"ChJIR Chinese Journal of Infrared Research",
"ChJLB Chinese Journal of Lasers B",
"ChJL. Chinese Journal of Lasers",
"ChJME Chinese Journal of Mechanical Engineering",
"ChJNP Chinese Journal of Nuclear Physics",
"ChJOL Chinese Journal of Oceanology and Limnology",
"ChJPh Chinese Journal of Physics",
"ChJS. Chinese Journal of Semiconductors",
"ChJSS Chinese Journal of Space Science",
"Chmsp Chemosphere",
"ChNew Chandra News",
"CHOCS CHOCS",
"ChOE. China Ocean Engineering",
"ChOpL Chinese Optics Letters",
"ChPAS Republic of China National Science Council Proceedings Applied Sciences",
"ChPhB Chinese Physics B",
"ChPhC Chinese Physics C",
"ChPhL Chinese Physics Letters",
"ChPhy Chinese Physics",
"ChRST China Rept Sci Technol JPRS CST",
"ChRv. Chemical Reviews",
"ChSAJ Chinese Society of Astronautics Journal",
"ChSBu Chinese Science Bulletin",
"ChSMJ Chinese Society of Mechanical Engineers Journal",
"Chsph Chemosphere",
"ChSST Chinese Space Science Technology",
"CiARI Circular of the Astronomisches Recheninstitut",
"CiBAA Circular of the British Astronomical Association",
"CIBu. COSPAR Information Bulletin",
"CIDA. CIDA",
"Ciel. Le Ciel",
"CiInf Circ. Inf.",
"CiPoJ Circumpolar Journal",
"CIPSG Canadian Information Processing Society Graphics Interface",
"CiSSV Circolare Interna della Sezione Stelle Variabili dell'Unione Astrofili Italiani",
"CITM. Chubu Institute Technology Memoirs",
"CiUO. Circular of the Union Observatory Johannesburg",
"CJChE Canadian Journal of Chemical Engineering",
"CJECE Canadian Journal of Electrical Computer Engineering",
"CJLTP Chinese Journal of Low Temperature Physics",
"CJRes Canadian Journal of Research",
"CJSMT Canadian Journal of Science Mathematics and Technology Education",
"CKH.. Chagyo Kenkyu Hokoku (Tea Research Journal)",
"ClCh. Climatic Change",
"ClDy. Climate Dynamics",
"CLic2 Contributions of Lick Observatory, Series II",
"CliPa Climate of the Past",
"CliPD Climate of the Past Discussions",
"ClMin Clay Minerals",
"ClRes Climate Research",
"CLS.. Curved and Layered Structures",
"CMAME Computer Methods in Applied Mechanics and Engineering",
"CMaPh Communications in Mathematical Physics",
"CMDRG Chislennye Metody Dinamike Razrezhennykh Gazov",
"CMMPh Computational Mathematics and Mathematical Physics",
"CmpEn Composites Engineering",
"CmPhy Communications Physics",
"CMPhy Condensed Matter Physics",
"Cmplx Complexity",
"CmpMa Composites Manufacturing",
"CMPNC Cambridge Monographs on Particle Physics, Nuclear Physics and Cosmology",
"CMPPh Cambridge Monographs on Plasma Physics",
"CmpSt Composite Structures",
"CMT.. Continuum Mechanics and Thermodynamics",
"CMwA. Computers and Mathematics with Applications",
"CMWCI Contributions from the Mount Wilson Observatory / Carnegie Institution of Washington",
"CNan. Current Nanoscience",
"CNME. Communications in Numerical Methods in Engineering",
"CNRAe CNR Aeritalia S",
"CNSMP Comet News Service, McDonnell Planetarium",
"CNSNS Communications in Nonlinear Science and Numerical Simulations",
"CoAMP Comments on Atomic and Molecular Physics",
"CoAnk Communications of the Department of Astronomy of Ankara University",
"CoAsi Contributi dell'Osservatorio Astrofisica dell'Universita di Padova in Asiago",
"CoASP Comments on Astrophysics and Space Physics",
"CoAst Communications in Asteroseismology",
"CoBAO Communications of the Byurakan Astrophysical Observatory",
"CoBos Contributions from the Bosscha Observervatory",
"CoBrn Contributions of the Public Observatory and Planetarium in Brno",
"CoCam Contributions from the Cambridge Observatory England",
"CoCMP Comments on Condensed Matter Physics",
"CoCoi Comunicacoes do Observatonio Astronomico da Universidade de Coimbra",
"CoCom Control and Computers",
"CODAB CODATA Bulletin",
"CoDAO Contributions from the Dominion Astrophysical Observatory in Victoria",
"CoDDO Communications from the David Dunlap Observatory",
"CoDun Contributions from the Dunsink Observatory Dublin Ireland",
"Coel. Coelum Periodico Bimestrale per la Divulgazione dell'Astronomia",
"CoFl. Combustion and Flame",
"CoFra Consiglio Nazionale delle Ricerche Italia. Laboratorio di Astrofisica Frascati Roma Contributi",
"CoGG. Contributions to Geophysics and Geodesy",
"CogPh Cogent Physics",
"CoIAP Contributions de l'Institut d'Astrophysique de Paris Serie A",
"CoKit Contributions from the Kitt Peak National Observatory",
"CoKon Commmunications of the Konkoly Observatory Hungary",
"CoKwa Contributions from the Kwasan and Hida Observatories University of Kyoto",
"CoKyo Contributions from the Institute of Astrophysics and Kwasan Observatory Kyoto",
"CoLic Contributions of Lick Observatory",
"CoLon Communications of the University of London Observatory",
"CoLou Contributions of the Louisiana State University Observatory Baton Rouge Louisiana",
"CoLPL Communications of the Lunar and Planetary Laboratory",
"ColSu Colloids and Surfaces",
"ComAC Computational Astrophysics and Cosmology",
"ComAp Comments on Astrophysics",
"CoMar Circulaires de l'Observatoire de Marseille",
"CoMat Communications Materials",
"ComBr Communication Broadcasting",
"CoMcD Contributions from the McDonald Observatory University of Texas Fort Davis",
"CoMil Contributions dell'Osservatorio Astrononia di Milano-Merate",
"ComMP Comments in Modern Physics",
"ComMS Computational Materials Science",
"Commu Communications",
"CoMP. Contributions to Mineralogy and Petrology",
"ComPh Computers in Physics",
"CompJ The Computer Journal",
"CompM Computational Mechanics",
"Compo Composites",
"Compr Computer",
"Compu Computing",
"CoMRA Concepts in Magnetic Resonances A",
"CoMRB Concepts in Magnetic Resonances B",
"ComSE Computing Systems in Engineering",
"ComSo Communications Society",
"ComSp Commercial Space",
"ComST Composites Science Technology",
"COMTR COMSAT Technical Review",
"ConAP Contributions to Atmospheric Physics/Beitraege zur Physik der Atmosphaere",
"ConCP Contemporary Concepts in Physics",
"CoNet Journal of Communications and Networks",
"CONMS Contributions of the Observatory of New Mexico State University, Las Cruces Special Series",
"ConPh Contemporary Physics",
"CoNPP Comments on Nuclear and Particle Physics",
"ConSc Connection Science",
"CoOpt Computer Optics",
"CoORB Communications de l'Observatoire Royal de Belgique",
"COP.. Coherent Optical Phenomena",
"CoPer Contributions of Perkins Observatory",
"CoPhC Computer Physics Communications",
"CoPhR Computer Physics Reports",
"CoPPC Comments on Plasma Physics and Controlled Fusion",
"CoPP. Contributions to Plasma Physics",
"CoPri Contributions from the Princeton University Observatory",
"CoROE Communications from the Royal Observatory Edinburgh",
"CorRe Coral Reefs",
"CoRSE Royal Society Edinburgh Communications Physical Sciences",
"CoRut Contributions from the Rutherford Observatory of Columbia University New York",
"CosEl Cosmic Electrodynamics",
"CoSka Contributions of the Astronomical Observatory Skalnate Pleso",
"CoSkL Contributions of the Astronomical Observatory Skalnate Pleso Letters",
"CoSkS Contributions of the Astronomical Observatory Skalnate Pleso Supplement",
"Cosmo COSMOS",
"CosRe Cosmic Research",
"CosSe Cosmic Search",
"COSSM Current Opinion in Solid State and Materials Science",
"CoStA Communications from the University Observatory St Andrews Scotland",
"CoStr Computers and Structures",
"CoThe Contributions from the Astronomical Department of the University of Thessaloniki",
"CoTok Contributions from the Department of Astronomy University of Tokyo",
"CoTol Contributions from the Cerro Tololo Inter-American Observatory",
"CoTPh Communications in Theoretical Physics",
"CoVVO Contributions of the Van Vleck Observatory",
"CoWas Contributions from the Washburn Observatory of the University of Wisconsin",
"CoWat Contributions of the University of Waterloo Observatory",
"CPAM. Communications in Pure Applied Mathematics",
"CP... Chemical Physics",
"CPh.. Coherent Phenomena",
"CPhD. Cape Photographic Durchmusterung",
"CPL.. Chemical Physics Letters",
"CPMCM Commentationes Physico-Mathematicae et Chemico-Medicae",
"CPM.. Computational Particle Mechanics",
"CPPM. Clinical Physics and Physiological Measurement",
"CPR.. Chemical Physics Reports",
"CPSS. Chemical Physics of Solid Surfaces",
"CQGra Classical and Quantum Gravity",
"CR2.. Academie des Sciences Comptes Rendus Serie Mecanique Physique Chimie Sciences de la Terre et de l Univers",
"CRABS Comptes Rendus de l'Academie Bulgare des Sciences",
"CRASA Academie des Sciences Paris Comptes Rendus Vie Academique Semester Supplement",
"CRAS. Academie des Sciences Paris Comptes Rendus",
"CRASB Academie des Sciences Paris Comptes Rendus Serie B Sciences Physiques",
"CRASE Comptes Rendus de l'Acad&eacute",
"CRASG Academie des Sciences Paris Comptes Rendus Serie Generale La Vie des Sciences",
"CRASM Academie des Sciences Paris Comptes Rendus Serie Sciences Mathematiques",
"CRASP Academie des Sciences Paris Comptes Rendus Serie Physique Astrophysique",
"CRB.. C.R. Acad. Sci. Ser. B1",
"CR... Comptes Rendus Academie des Sciences (serie non specifiee)",
"CRGeo Comptes Rendus Geoscience",
"CRJS. Comptes Rendus sur les Journees de Strasbourg",
"CRLJ. Communications Research Laboratory Journal",
"CRLRv Communications Research Laboratory Review",
"CRMat Comptes Rendus Mathematique",
"CRMec Comptes Rendus Mecanique",
"CRPhy Comptes Rendus Physique",
"CRSPH Compte Rendu des Seances de la Societe de Physique et d'Histoire Naturelle de Geneve",
"CRSSM Critical Reviews in Solid State & Materials Sciences",
"Cryo. Cryogenics",
"CryRp Crystallography Reports",
"CSASG Contributions of the Slovak Academy Sciences Geophysical Institute",
"CSci. Current Science",
"CS&D. Computational Science and Discovery",
"CSE.. Computing in Science and Engineering",
"CSEd. Computer Science Education",
"CSF.. Chaos Solitons and Fractals",
"CSFX. Chaos Solitons and Fractals: X",
"CSMA. Computational Structural Mechanics and Applications",
"CSMPA Ankara University Faculty of Science Communications, Series A2-Ad Physical Sciences and Engineering",
"CSPSE Ankara Universite Faculte des Sciences Communications Serie Mathematiques Physique et Astronomie",
"CSR.. Continental Shelf Research",
"CSSE. Cultural Studies of Science Education",
"CSSP. Circuits Systems and Signal Processing",
"CST.. Combustion Science and Technology",
"C&T.. Ciel et Terre",
"CTE.. Ciencias de la Tierra y del Espacio",
"CTGeo Contemporary Trends in Geoscience",
"CTM.. Combustion Theory and Modelling",
"CTMPC Cambridge Topics in Mineral Physics and Chemistry",
"CTmp. Connaissance des Temps",
"CuCo. Culture and Cosmos",
"CVGIP Computer Vision Graphics and Image Processing",
"CzJPh Czechoslovak Journal of Physics",
"CzJPS Czechoslovak Journal of Physics Supplement",
"CzMJ. Czechoslovak Mathematical Journal",
"DatSJ Data Science Journal",
"Defek Defektoskopiia",
"DefEl Defense Electronics",
"DeHyZ Deutsche Hydrographische Zeitschrift",
"DeScE Defense Science Electronics",
"DFVLR DFVLR",
"DGKBA Deutsche Geodaetische Kommission Bayer. Akad. Wiss.",
"DGKBB Deutsche Geodaetische Kommission Bayer. Akad. Wiss. B",
"DGKGN Deutsche Geodaetische Kommission Gravity Network West Germany DSGN Data Adjustment",
"Dimen Dimensions",
"DImTe Display Imaging Technology",
"DIO.. DIO",
"DiRaG Dinamika razrezhennykh gazov",
"DISA. DISA Information",
"Disc. Discover",
"DISER Disciplinary and Interdisciplinary Science Education Research",
"DiSis Dinamicheskie Sistemy",
"Displ Displays",
"DLGRM DLGR Magnetofluiddyn",
"Dlib. D-Lib Magazine",
"DLRNa DLR Nachrichten",
"DMJ.. Defense Management Journal",
"DnU.. Differentsialnye Uravneniia",
"DoANT Doklady Akademiia Nauk TadzhSSR",
"DoArm Akademiia Nauk Armianskoi SSR Doklady",
"DoAze Akademiia Nauk Azerbaidzhanskoi SSR Doklady",
"DoBan Doklady Bolgarskoi Akademiia Nauk",
"DoBel Akademiia Nauk BSSR Doklady",
"DOIAP Documentation des Observateurs Institut d'Astrophysique de Paris",
"DokAN Doklady Akad Nauk Minerologia USSR",
"DokES Doklady Earth Sciences",
"DokPh Physics - Doklady",
"DorPo Dornier Post",
"DoSSR Akademiia Nauk SSSR Doklady",
"DoTad Akademiia Nauk Tadzhikskoi SSR Doklady",
"DoUkr Akademiia Nauk Ukrains koi RSR Dopovidi Seriia Fiziko Matematichni ta Tekhnichni Nauki",
"DoUzb Akademiia Nauk Uzbekskoi SSR Doklady",
"DPhyG Deutsche Physikalische Gesellschaft",
"DPM.. Dinamika i Prochnost Mashin",
"DRM.. Diamond and Related Materials",
"DSCS. Dynamics and Statistics of the Climate System",
"DSE.. Distributed Systems Engineering",
"DSJ.. Defense Science Journal",
"DSNPR Deep Space Network Progress Report",
"DSO.. Double Star Observer",
"DSP.. Digital Signal Processing",
"DSRA. Deep Sea Research A",
"DSRB. Deep Sea Research B",
"DSR.. Deep Sea Research",
"DSRI. Deep Sea Research Part I: Oceanographic Research",
"DSRII Deep Sea Research Part II: Topical Studies in Oceanography",
"DSRMC Defense Systems Review Military Communications",
"DSROA Deep Sea Research and Oceanographic Abstracts",
"DSSC. Double Star Section Circulars",
"DSSN. Delta Scuti Star Newsletter",
"DudOR Dudley Observatory Reports",
"DunOP Dunsink Observatory Publications",
"DunRe Dunsink Observatory Reprints",
"DWES. Drinking Water Engineering and Science",
"DyAtO Dynamics of Atmospheres and Oceans",
"DynCo Dynamics and Control",
"EaEvS Earth and Evolution Sciences",
"EaFut Earth's Future",
"EaInt Earth Interactions",
"EartD eEarth Discussions",
"Earth eEarth",
"EaSci Earthquake Science",
"EBBT. Emerging Biochemical and Biophysical Techniques",
"EBCi. Eclipsing Binaries Circulars",
"E&C.. Electronics and Communications",
"EcGH. Eclogae geologae Helvetii",
"EcGou Ecole de Goutelas",
"ECLRv Electrical Communication Laboratories Review",
"ECM.. Energy Conversion Management",
"ECMS. Estuarine and Coastal Marine Science",
"ECSS. Estuarine Coastal and Shelf Science",
"E&E.. Elektromashinostroenie i Elektrooborudovanie",
"EEEV. Earthquake Engineering and Engineering Vibration",
"EERSA East Europe Rept Sci Affairs JPRS",
"EERST East European Rept Sci. Technol. JPRS ESA",
"EES.. Environmental Earth Sciences",
"EET.. Electrochemical Energy Technology",
"EExSc Earth and Extraterrestrial Sciences",
"EFM.. Environmental Fluid Mechanics",
"EGSGA E&amp",
"EIUEN ESA IUE Newsletter",
"EJASP EURASIP Journal on Applied Signal Processing",
"EJCM. European Journal of Computational Mechanics",
"EJEE. European Journal of Engineering Education",
"EJMF. European Journal of Mechanics B Fluids",
"EJMin European Journal of Mineralogy",
"EJMS. European Journal of Mechanics Solids",
"EJPh. European Journal of Physics",
"EJSE. European Journal of Science Education",
"EJSM. e-Journal of Soft Materials",
"EJSta Electronic Journal of Statistics",
"EJTP. Electronic Journal of Theoretical Physics",
"Elast Elastic",
"ElBah Elektrische Bahnen",
"Elecm Electromagnetics",
"Elek. Elektronika",
"Eleme Elements",
"Elem. Elektromekhanika",
"EL... EPL (Europhysics Letters)",
"EleSt Electronic Structure",
"ElLC. Electrotechnical Laboratory Circulars",
"ElL.. Electronics Letters",
"ElMod Elektronnoe Modelirovanie",
"ElP.. Electronics Power",
"ElPro Electronic Progress",
"ElTA. Elektronnaia Tekhnika Avtomatike",
"ElUn. El Universo",
"ElW.. Electrowaerme International",
"EMCT. EMC Technology",
"E&M.. Elektrotechnik und Maschinenbau",
"eMetN eMeteorNews",
"EML.. Electronic Materials Letters",
"EM&P. Earth Moon and Planets",
"EnAt. Energia es Atomtechnika",
"EnC.. Energy Conversion",
"Endvr Endeavour",
"EnEng Environmental Engineering",
"Energ Energetika",
"ENews Europhysics News",
"EnFM. Engineering Fracture Mechanics",
"EngAn Engineering Analysis",
"EngCo Engineering Computations",
"EnGeo Environmental Geology",
"EnMan Environmental Management",
"EnOp. Engineering Optimization",
"EnSci Engineering and Science",
"EnST. Environmental Science and Technology",
"EntIS Enterprise Information Systems",
"EnTR. Energy Technology Review",
"Entro Entropie",
"Entrp Entropy",
"EnUK. Energy",
"EOAST Earth-Oriented Applications and Space Technology",
"EObsC Einstein Observatory Catalog of IPC X-ray Sources",
"EOSD. Electro Optical Systems Design",
"EOSTr EOS Transactions",
"EPJA. European Physical Journal A",
"EPJAM EPJ Applied Metamaterials",
"EPJAP European Physical Journal Applied Physics",
"EPJAS European Physical Journal A Supplement",
"EPJB. European Physical Journal B",
"EPJC. European Physical Journal C",
"EPJCS European Physical Journal C Supplement",
"EPJD. European Physical Journal D",
"EPJE. European Physical Journal E",
"EPJH. European Physical Journal H",
"EPJNS EPJ Nuclear Sciences &amp",
"EPJP. European Physical Journal Plus",
"EPJPv EPJ Photovoltaics",
"EPJQT EPJ Quantum Technology",
"EPJST European Physical Journal Special Topics",
"E&PP. Earth and Planetary Physics",
"EPRIJ EPRI Journal",
"EPSC. European Planetary Science Congress",
"EP&S. Earth, Planets, and Space",
"E&PSL Earth and Planetary Science Letters",
"eRad. eRadiant, Journal of the Dutch Meteor Society",
"ERCom Environmental Research Communications",
"ER... Environmental Research",
"ERExp Engineering Research Express",
"ERL.. Environmental Research Letters",
"ErNW. Ergebnisse der exakten Naturwissenschaften",
"ERST. Europe Report Science Technology",
"ESABu ESA Bulletin",
"ESAHR ESA History Study Reports",
"ESAJ. ESA Journal",
"ESASM ESA Scientific & Technical Memoranda",
"ESAST ESA Scientific Technical Review",
"ESATM ESA Training Manual",
"ESC.. ACS Earth and Space Chemistry",
"ESDD. Earth System Dynamics Discussion",
"ESD.. Earth System Dynamics",
"E&S.. Earth in Space",
"ESE.. Earth Systems and Environment",
"ESF.. Earth Science Frontiers",
"ESIL. Eruptive Stars Information Letter",
"ESN.. European Science Notes",
"ESOB. European Southern Observatory ESO Bulletin",
"ESOSP European Southern Observatory Scientific Preprints",
"ESOSR European Southern Observatory Scientific Report",
"ESPL. Earth Surface Processes and Landforms",
"ESRv. Earth Science Reviews",
"ESSDD Earth System Science Data Discussions",
"ESSD. Earth System Science Data",
"E&SS. Earth and Space Science",
"ESSFR IEICE ESS Fundamentals Review",
"EssPh Essays in Physics",
"ESuDD Earth Surface Dynamics Discussions",
"ESuD. Earth Surface Dynamics",
"ETATF Eesti NSV Teaduste Akadeemia Toimetised Fuusika Matemaatika",
"ETRE. Elektrosviaz Telecommunications Radio Engineering Telecommunications",
"ETTRT European Transactions Telecommunications Related Technologies",
"ETWQ. Environmental Toxicology and Water Quality",
"EUCAS EUCASS Proceedings Series",
"EURPE EUREKA: Physics and Engineering",
"EurSS Eurasian Soil Science",
"EuRv. European Review",
"EVest Elektrotehniski Vestnik",
"ExA.. Experimental Astronomy",
"ExFl. Experiments in Fluids",
"ExG.. Exploration Geophysics",
"ExHT. Experimental Heat Transfer",
"ExM.. Experimental Mechanics",
"EXOSA EXOSAT Express",
"ExT.. Experimental Techniques",
"ExTFS Experimental Thermal Fluid Science",
"Extr. Extraction",
"FACM. Functiones et Approximatio Commentarii Mathematici",
"FaDi. Faraday Discussions",
"FaTr. Faraday Transactions",
"FBS.. Few-Body Systems",
"FCPh. Fundamentals of Cosmic Physics",
"F&CRe Flower and Cook Observatory Reprints",
"FCS.. Functional Composites and Structures",
"FFEMS Fatigue and Fracture of Engineering Materials and Structures",
"F&IER Forschung im Ingenieurwesen Engineering Research",
"F&I.. Forschung im Ingenieurwesen",
"FiIO. Fiber and Integrated Optics",
"FiMek Fizicheskaia Mekhanika",
"FiMos Akademiia Nauk SSSR Otdelenie Obshchei Fiziki i Astronomii Nauchnaia Sessiia Moscow USSR Uspekhi Fizicheskikh Nauk",
"FiSSR Akademiia Nauk Tadzhikskoi SSR Fiziko Tekhnicheskii Institut Dyushambe Tadzhik SSR Akademiia Nauk Tadzhikskoi SSR Doklady",
"FiUkr Akademiia Nauk Ukrain skoi RSR Dopovidi Seriia Fiziko Matematichni ta Tekhnichni Nauki",
"FizA. Fizika A",
"FizAO Akademiia Nauk SSSR Fizika Atmosfery i Okeana",
"FizAS Fizika Aerodispersnykh Sistem",
"FizB. Fizika B",
"FizCh Fizyki i Chemii Seria Fizyka",
"FizEl Fizicheskaia Elektronika",
"Fiz.. Fizika",
"FizGV Fizika Goreniia i Vzryva",
"FizKM Fiziko Khimicheskaia Mekhanika Materialov",
"FizKO Fizika i Khimiia Obrabotki Materialov",
"FizMM Fizika Metallov i Metallovedenie",
"FizMS Fizika Mnogochastichnykh Sistem",
"FizNT Fizika Nizkikh Temperatur",
"FizPl Fizika Plazmy",
"FizSz Fizika Sz.",
"FizTT Fizika Tverdogo Tela",
"FizTV Fizika i Tekhnika Vysokikh Davlenii",
"FizZS Fizika Zhidkogo Sostoianiia",
"FlDy. Fluid Dynamics",
"FlDyR Fluid Dynamics Research",
"FlDyT Fluid Dynamics Transactions",
"FlMSR Fluid Mechanics Soviet Research",
"Fluid Fluidika",
"FluQ. Fluids Quarterly",
"FMEC. Frontiers of Mechanical Engineering in China",
"F&M.. Feinwerktechnik und Messtechnik",
"FML.. Functional Materials Letters",
"FNCN. Fullerene Nanotubes and Carbon Nanostructures",
"FNL.. Fluctuation and Noise Letters",
"FoGeo Fotointerpretacja w Geografii",
"FoPh. Foundations of Physics",
"FoPhL Foundations of Physics Letters",
"ForPh Fortschritte der Physik",
"ForPW Fortschritte der Physikalischen Wissenschaften",
"Fract Fractals",
"FrASS Frontiers in Astronomy and Space Sciences",
"FrCh. Frontiers in Chemistry",
"FrEaS Frontiers in Earth Science",
"Freq. Frequenz",
"FrES. Frontiers of Earth Science",
"FRFI. Flug Revue Flugwelt International",
"FrInJ Journal of The Franklin Institute",
"FrMat Frontiers in Materials",
"FrME. Frontiers of Mechanical Engineering",
"FrMS. Frontiers of Materials Science",
"FrP.. Frontiers in Physics",
"FrPhC Frontiers of Physics in China",
"FrPhy Frontiers of Physics",
"FST.. Fullerene Science and Technology",
"FSTJ. Fujitsu Scientific Technical Journal",
"FTC.. Flow, Turbulence and Combustion",
"FTP.. Fundamental Theories of Physics",
"Fut.. Futures",
"Futur Future Spring",
"Gaea. Gaea - Journal of Geoscience",
"GAe.. Geomagnetizm i Aeronomiia",
"Galax Galaxies",
"GalEl Galilean Electrodynamics",
"galx.pGALEX Proposal",
"GAM.. Geophysics and Astrophysics Monographs",
"GaMuM Gesellschaft Angewandte Mathematik und Mechanik Workshop Paris France",
"GApFD Geophysical and Astrophysical Fluid Dynamics",
"GAst. Giornale di Astronomia",
"GATAN Gesellschaft Aerosolforschung Tagung ueber Aerosole Naturwissenschaft Medizin und Technik Messtechnik und technische Anwendung",
"GazA. Gazette Astronomique",
"GazAM Gazette Astronomique Memoires",
"GazT. Gazodinamika i Teploobmen",
"GBioC Global Biogeochemical Cycles",
"GBzG. Gerlands Beitraege zur Geophysik",
"GCarp Geologica Carpathica",
"GCBio Global Change Biology",
"GCN1. GRB Coordinates Network",
"GCN2. GRB Coordinates Network",
"GCNew Galactic Center Newsletter",
"GCN.. GRB Coordinates Network",
"GCNR. GCN Report",
"GCRV. Carnegie Institute Washington D.C. Publication",
"GDS.. Geophysical Developments Series",
"Ge&Ae Geomagnetism and Aeronomy",
"GeAer Geodeziia i Aerofotos",
"GeCar Geodesy and Cartography",
"GeCAS Geochimica et Cosmochimica Acta Supplement",
"GeChr Geochronology",
"GECJR GEC Journal Research",
"GeCoA Geochimica et Cosmochimica Acta",
"GeGe. Geophysica et Geodaetica",
"GeIss Geoinformation Issues",
"GeKaA Geodeziia Kartografiia i Aerofotos",
"GeKar Geodeziia i Kartografiia",
"Gelio Geliotekhnika",
"Gemin GEMINI Newsletter Royal Greenwich Observatory",
"Gen1K Observatoire de Geneve",
"GeoAc Geodinamica Acta",
"GEOCA GEOS Circular on Small-Amplitude Variables",
"GEOCE GEOS Circular on Eclipsing Binaries",
"Geoch Geochemistry",
"GeocI Geochemistry International",
"GeocJ Geochemical Journal",
"GEOCR GEOS Circular on RR Lyr Type Variables",
"GEOCS Semi-Regular Variables",
"Geode Geofisica Internacional",
"GeofI Geofisica Internacional",
"Geo.. Geology",
"GeoGl Geodetski Glasnik",
"GeoIn Geocarto International",
"GeoIs Geomagnitnye Issledovaniia",
"GeoJ. Geophysical Journal",
"GeoJI Geophysical Journal International",
"GeoK. Geodezja i Kartografia",
"Geokh Geokhimiia",
"Geolg Geologos",
"Geolo Geologija",
"Geoma Geomatik",
"GeoM. Geological Magazine",
"Geomo Geomorphology",
"GeoNr Geophysica Norvegica",
"GeoOD Geology of Ore Deposits",
"GeoPA Geofisica Pura e Applicata",
"Geop. Geophysics",
"Geoph Geophysica",
"GeopP Geophysical Prospecting",
"GeoRL Geophysical Research Letters",
"GeoRu Geologische Rundschau",
"GeoSb Geofizicheskii Sbornik",
"Geosc Geosciences",
"GeoSJ Geological Society Journal",
"GEOSN GEOS Note Circulaire",
"Geosp Geosphere",
"GeosR Geoscience Records",
"GeoSu Geophysical Surveys",
"Geote Geotectonics",
"Geot. Geotimes",
"Geoth Geothermics",
"GeoZh Geofizicheskii Zhurnal",
"Gerb. Gerbertvs, International Academic Publication on History of Medieval Science",
"GescJ Geosciences Journal",
"GGG.. Geochemistry, Geophysics, Geosystems",
"GGMit Gauss-Gesellschaft e.V. G&ouml",
"GGMM. Greenhouse Gas Measurement & Management",
"GID.. Geoscientific Instrumentation, Methods and Data Systems Discussions",
"Gidro Gidromekhanika",
"GI... Geoscientific Instrumentation, Methods and Data Systems",
"GiGi. Gidroprivod i Gidropnevmoavtomatika",
"GIPol Geoinformatica Polonica",
"GiSan Gigiena i Sanitariia",
"GKA.. Geodeziia i Kartografiia Aehrofotosemka, L'vov",
"GMDD. Geoscientific Model Development Discussions",
"GMD.. Geoscientific Model Development",
"GML.. Geo-Marine Letters",
"GMMWJ Gesellschaft angewandte Mathematik und Mechanik Jahrestagung Goettingen West Germany Zeitschrift Flugwissenschaften",
"GMS.. Washington DC American Geophysical Union Geophysical Monograph Series",
"GMuD. Gesellschaft Mathematik und Datenverarbeitung mbH Multigrid Methods Special Topics Applications",
"GOAM. Greenwich Observations in Astronomy, Magnetism and Meteorology made at the Royal Observatory, Series 3",
"GOAMM Greenwich Observations in Astronomy, Magnetism and Meteorology made at the Royal Observatory, Series 2",
"GondR Gondwana Research",
"GORO. Greenwich Observations made at the Royal Observatory",
"GPC.. Global and Planetary Change",
"GPSW. GPS World",
"GrAeH Grumman Aerospace Horizons",
"GrCo. Gravitation and Cosmology",
"GReGr General Relativity and Gravitation",
"GriO. Griffith Observer",
"gr.qc arXiv General Relativity and Quantum Cosmology e-prints",
"GrTOn Gravitatsiia i Teoriia Otnositelnosti",
"Grund Grundwasser",
"GSAB. Geological Society of America Bulletin",
"GSAMm Geological Society of America Memoir",
"GSASP Geological Society of America Special Papers",
"GSDJ. Geoscience Data Journal",
"GSEng GeoScience Engineering",
"GSL.. Geoscience Letters",
"GSLSP Geological Society of London Special Publications",
"GTES. Geothermal Energy Science",
"GTPZ. Gigiena Truda i Professionalnye Zabolevaniia",
"GUL.. Geschichte und Lichtwechsel der Veraenderlichen Sterne (Potsdam)",
"GVMK. Gibridnye Vychislitelnye Mashiny i Kompleksy",
"HAAG. Handbook of Astronomy Astrophysics and Geophysics",
"HadJ. Hadronic Journal",
"HadJS Hadronic Journal Supplement",
"HamS. Hamburger Sternwarte Sonderdrucke",
"HarAC Harvard College Observatory Announcement Card",
"HarCi Harvard College Observatory Circular",
"HarMo Harvard Observatory Monographs",
"HarOR Report of the Committee of the Overseers of Harvard College appointed to visit the Observatory",
"HarRe Harvard College Observatory Reprints",
"HARSB Histoire de l'Academie Royale des Sciences et des Belles-Lettres de Berlin",
"HarZi Harthaer Beobachtungs-Zirkular",
"HCHy. Hovering Craft and Hydrofoil",
"HDA.. Handbuch der Astrophysik",
"HDP.. Handbuch der Physik",
"HDSTS Herald of Dagestan State Technical University Technical Sciences",
"HeaPh Health Physics",
"Heavn Heavens",
"HEDP. High Energy Density Physics",
"HelOB Helwan Institute of Astronomy and Geophysics Bulletins",
"HelR. Observatory and Astrophysics Laboratory University of Helsinki Report",
"HemD. Hemel en Dampkring",
"hep.exarXiv High Energy Physics - Experiment e-prints",
"hep.laarXiv High Energy Physics - Lattice e-prints",
"HEPNP High Energy Physics and Nuclear Physics",
"hep.pharXiv High Energy Physics - Phenomenology e-prints",
"hep.tharXiv High Energy Physics - Theory e-prints",
"HESSD Hydrology and Earth System Sciences Discussions",
"HESS. Hydrology and Earth System Sciences",
"HFC.. Hydrogen and Fuel Cells",
"HGSS. History of Geo- and Space Sciences",
"HiA.. Highlights of Astronomy",
"HisSc History of Science",
"HiTec High Technology",
"HMR.. Helgoland Marine Research",
"HMT.. Heat and Mass Transfer",
"Holoc The Holocene",
"HPCRE Handbook on the Physics and Chemistry of Rare Earths",
"HPR.. High Pressure Research",
"HRL.. Hydrological Research Letters",
"HTemS High Temperature Science",
"HTHP. High Temperatures and High Pressures",
"HTJR. Heat Transfer Japanese Research",
"HTMP. High Temperature Materials and Processes",
"HTrEn Heat Transfer Engineering",
"HTSR. Heat Transfer Soviet Research",
"HUFEB Hokkaido University Faculty Engineering Bulletin",
"HUFEM Hokkaido University Faculty Engineering Memoirs",
"HvaOB Hvar Observatory Bulletin",
"HvOBS Hvar Observatory Bulletin Supplement",
"HWM.. Helgol&auml",
"HWP.. Horizons in World Physics",
"HyBio Hydrobiologia",
"HydJ. Hydrogeology Journal",
"HyInt Hyperfine Interactions",
"HyPr. Hydrological Processes",
"IA&A. Ingenieria Aeronautica y Astronautica",
"IadEn Iadernaia Energiia",
"IAESM IEEE Aerospace Electronic Systems Magazine",
"IAFET Instituto de Astronomia y Fisica del Espacio Buenos Aires",
"IAIss Istoriko-Astronomicheskie Issledovaniya",
"IAL1K Institut d'Astronomie de Lausanne",
"IAM.. International Applied Mechanics",
"IANT. International Advances in Nondestructive Testing",
"IAOIT Informo of the Astronomia-Optika Institucio, Universitato de Turku",
"IAPM. IEEE Antennas and Propagation Magazine",
"IAPPP International Amateur-Professional Photoelectric Photometry Communications",
"IASSP IEEE ASSP Magazine",
"IAUCB IAU Commission on Close Binary Stars",
"IAUC. International Astronomical Union Circular",
"IAUDS IAU Commission on Double Stars",
"IAUFM IAU Focus Meeting",
"IAUGA IAU General Assembly",
"IAUIB IAU Information Bulletin",
"IAUIn IAU Commission on Instruments",
"IAUSS IAU Special Session",
"IAUTA Transactions of the International Astronomical Union, Series A",
"IAUTB Transactions of the International Astronomical Union, Series B",
"IAWPL IEEE Antennas and Wireless Propagation Letters",
"IBCP. An International Journal at the Interface Between Chemistry and Physics",
"IBMJ. IBM Journal of Research and Development",
"IBSAE Sovetskaia Antarkticheskaia Ekspeditsiia Informatsionnyi Byulleten",
"IBSH. Informational Bulletin of the Southern Hemisphere",
"IBUAA Informational Bulletin of the Ukrainian Astronomical Association",
"IBVS. Information Bulletin on Variable Stars",
"ICAOB ICAO Bulletin",
"Icar. Icarus",
"ICGA. IEEE Computer Graphics Applications",
"ICHIN Newsletters of the Interdivisional Commission on History of the IAGA",
"ICHMT International Communications in Heat and Mass Transfer",
"ICiSM IEEE Circuits Systems Magazine",
"ICML. International Conference on Machine Learning",
"IComM IEEE Communications Magazine",
"ICQ.. International Comet Quarterly",
"ICSE. Impact of Computing in Science and Engineering",
"ICSEn IEEE Computational Science and Engineering",
"ICSM. IEEE Computer Systems Magazine",
"IDAQP Infinite Dimensional Analysis, Quantum Probability and Related Topics",
"IDTC. IEEE Design Test Computers",
"IEDL. IEEE Electron Device Letters",
"IEEEN IEEE Network",
"IEEEP IEEE Proceedings",
"IEEES IEEE Spectrum",
"IEEP. Institution of Electrical Engineers Proceedings",
"IEERv IEE Reviews",
"IEITC IEICE Transactions on Communications",
"IEITE IEICE Transactions on Electronics",
"IEITF IEICE Transactions on Fundamentals of Electronics Communications and Computer Sciences",
"IEITI IEICE Transactions on Information and Systems",
"IEREJ Institution of Electronic Radio Engineers Journal",
"IER.. Internationale Elektronische Rundschau",
"IESJ. IES Journal",
"IETE. Institution of Electronics Telecommunication Engineers",
"IET.. Instruments and Experimental Techniques",
"IEWS. Stevenage Herts England Peter Peregrinus Ltd IEE Electromagnetic Waves Series",
"IExp. IEEE Expert",
"IFBel Akademiia Nauk Belorusskoi SSR Institut Fiziki Nauchnaia Sessiia Minsk Belorussian SSR Zhurnal Prikladnoi Spektroskopii",
"IGAFS Issledovaniia Geomagnetizmu Aeronomii i Fizike Solntsa",
"IGRSL IEEE Geoscience and Remote Sensing Letters",
"IGRv. International Geology Review",
"IGS.. Orlando FL Academic Press Inc International Geophysics Series",
"IHERv Ishikawajima Harima Engineering Review",
"IHWN. IHW Newsletter",
"IIApN Indian Institute of Astrophysics Newsletter",
"IINA. Istituto Italiano di Navigazione Atti",
"IISys IEEE Intelligent Systems",
"IJAA. International Journal of Astronomy and Astrophysics",
"IJACS International Journal of Adaptive Control and Signal Processing",
"IJAdA International Journal of Adhesion Adhesives",
"IJAEM International Journal of Analytical and Experimental Modal Analysis",
"IJAEO International Journal of Applied Earth Observation and Geoinformation",
"IJA.. International Journal of Astronomy",
"IJAIS International Journal of Applied Information Systems",
"IJAME International Journal of Applied Mechanics and Engineering",
"IJAM. International Journal of Applied Mechanics",
"IJAP. IOSR Journal of Applied Physics",
"IJART International Journal of Advancements in Research &amp",
"IJAsB International Journal of Astrobiology",
"IJASE International Journal of Advanced Structural Engineering",
"IJASS International Journal of Aeronautical and Space Sciences",
"IJBB. International Journal of Bioclimatology Biometeorology",
"IJBC. International Journal of Bifurcation and Chaos",
"IJBm. International Journal of Biometeorology",
"IJCA. International Journal of Computer Applications",
"IJCAT International Journal of Computer Applications and Technology",
"IJCEM International Journal for Computational Methods in Engineering Science and Mechanics",
"IJCFD International Journal of Computational Fluid Dynamics",
"IJC.. International Journal of Control",
"IJCli International Journal of Climatology",
"IJCMB International Journal of Computer Mathematics Section B",
"IJCMS International Journal of Computational Materials Science and Engineering",
"IJDE. International Journal of Digital Earth",
"IJDM. International Journal of Damage Mechanics",
"IJEaS International Journal of Earth Sciences",
"IJEEP International Journal of Emerging Electric Power Systems",
"IJEFM International Journal of Engineering and Fluid Mechanics Spring",
"IJEG. International Journal of Engineering and Geosciences",
"IJE.. International Journal of Electronics",
"IJEnR International Journal of Environmental Research",
"IJERA International Journal of Enginnering Research and Applications",
"IJER. International Journal of Energy Research",
"IJES. International Journal of Engineering Science",
"IJESS IEEE Journal on Exploratory Solid-State Computational Devices and Circuits",
"IJEST IEEE Journal on Emerging and Selected Topics in Circuits and Systems",
"IJFa. International Journal of Fatigue",
"IJFD. International Journal of Fluid Dynamics",
"IJFE. International Journal of Fusion Energy",
"IJFr. International Journal of Fracture",
"IJGA. International Journal of Geomagnetism and Aeronomy",
"IJGeo International Journal of Geophysics",
"IJGI. ISPRS International Journal of Geo-Information",
"IJG.. International Journal of Geosciences",
"IJGMM International Journal of Geometric Methods in Modern Physics",
"IJGNP International Journal of Green Nanotechnology Physics and Chemistry",
"IJGS. International Journal of General Systems",
"IJHE. International Journal of Hydrogen Energy",
"IJHFF International Journal of Heat and Fluid Flow",
"IJHM. International Journal of Hybrid Microelectronics Fall",
"IJHMT International Journal of Heat and Mass Transfer",
"IJIDF International Journal of Image and Data Fusion",
"IJIE. International Journal of Impact Engineering",
"IJIMW International Journal of Infrared and Millimeter Waves",
"IJIST International Journal of Imaging Systems Technology",
"IJMES International Journal of Mathematical Education in Science and Technology",
"IJMF. International Journal of Multiphase Flow",
"IJMHG Indian Journal of Meteorology Hydrology and Geophysics",
"IJMIP International Journal of Mass Spectrometry and Ion Physics",
"IJMMC IEEE Journal on Multiscale and Multiphysics Computational Techniques",
"IJMMD International Journal of Mechanics and Materials in Design",
"IJMM. International Journal of Mini Microcomputers",
"IJMMM International Journal of Minerals, Metallurgy, and Materials",
"IJMoS International Journal of Modelling and Simulation",
"IJMPA International Journal of Modern Physics A",
"IJMPB International Journal of Modern Physics B",
"IJMPC International Journal of Modern Physics C",
"IJMPD International Journal of Modern Physics D",
"IJMPE International Journal of Modern Physics E",
"IJMQE International Journal of Metrology and Quality Engineering",
"IJMSE International Journal of Mars Science and Exploration",
"IJMSI International Journal of Mass Spectrometry and Ion Processes",
"IJMS. International Journal of Mechanical Sciences",
"IJMSp International Journal of Mass Spectrometry",
"IJMW. International Journal of Mine Water",
"IJNA. IMA Journal of Numerical Analysis",
"IJNAM International Journal for Numerical and Analytical Methods in Geomechanics",
"IJNAO International Journal of Naval Architecture and Ocean Engineering",
"IJN.. International Journal of Nanoscience",
"IJNLM International Journal of Non Linear Mechanics",
"IJNME International Journal for Numerical Methods in Engineering",
"IJNMF International Journal for Numerical Methods in Fluids",
"IJNS. International Journal of Neural Systems",
"IJNT. International Journal of Nanotechnology",
"IJOE. IEEE Journal of Oceanic Engineering",
"IJO.. International Journal of Optomechatronics",
"IJOpt International Journal of Optics",
"IJPAM Indian Journal of Pure and Applied Mathematics",
"IJPAP Indian Journal of Pure and Applied Physics",
"IJP.. International Journal of Plasticity",
"IJPRS International Journal of Photogrammetry and Remote Sensing",
"IJQC. International Journal of Quantum Chemistry",
"IJQE. IEEE Journal of Quantum Electronics",
"IJQI. International Journal of Quantum Information",
"IJRA. IEEE Journal of Robotics Automation",
"IJRAI International Journal of Radiation Applications and Instrumentation D Nuclear Tracks and Radiation Measurements",
"IJRFI IEEE Journal of Radio Frequency Identification",
"IJRPC International Journal for Radiation Physics and Chemistry",
"IJRR. International Journal of Robotics Research",
"IJRS. International Journal of Remote Sensing",
"IJRSP Indian Journal of Radio and Space Physics",
"IJSAC IEEE Journal on Selected Areas in Communications",
"IJScA International Journal of Supercomputer Applications",
"IJSC. International Journal of Satellite Communications",
"IJSEd International Journal of Science Education",
"IJSE. International Journal of Solar Energy",
"IJSMD International Journal for Simulation and Multidisciplinary Design Optimization",
"IJSME International Journal of Science and Mathematics Education",
"IJSNM International Journal of Smart and Nano Materials",
"IJSSC IEEE Journal of Solid-State Circuits",
"IJSS. International Journal of Solids and Structures",
"IJSTA IEEE Journal of Selected Topics in Applied Earth Observations and Remote Sensing",
"IJSTQ IEEE Journal of Selected Topics in Quantum Electronics",
"IJSyS International Journal of Systems Science",
"IJTFM IEEJ Transactions on Fundamentals and Materials",
"IJTIA IEEJ Transactions on Industry Applications",
"IJT.. International Journal of Thermophysics",
"IJTJE International Journal of Turbo and Jet Engines",
"IJTPE IEEJ Transactions on Power and Energy",
"IJTP. International Journal of Theoretical Physics",
"IJTSM IEEJ Transactions on Sensors and Micromachines",
"ILCSM IEEE LCS Magazine",
"IllOB Bulletin of the Astronomical Observatory of the University of Illinois",
"ILOMP Publications of the International Latitude Observatory at Mizusawa",
"ILSJ. International Lunar Society Journal",
"ILTS. IEEE LTS",
"IMA.. Institute for Mathematics and Its Applications",
"IMeRv International Metals Reviews",
"IMGWL IEEE Microwave and Guided Wave Letters",
"IMMag IEEE Microwave Magazine",
"IMPA. Interscience Monographs in Physics and Astronomy",
"IMRv. International Materials Reviews",
"imsd.cIEEE MTT-S International Microwave Symposium Digest",
"InAgr International Agrophysics",
"InASP Indian Academy of Sciences Proceedings Section",
"INASR INASAN Science Reports",
"InCh. Inorganic Chemistry",
"InEPS Indian Academy of Sciences Proceedings: Earth and Planetary Sciences",
"InES. Indian Academy of Sciences Proceedings: Section C Engineering Sciences",
"InfCo Information Control",
"InfD. Information Display",
"InFiZ Inzhenerno Fizicheskii Zhurnal",
"InfPh Infrared Physics",
"InFuJ Institute Fuel Journal",
"IngAr Ingenieur Archiv",
"Ingeg Ingegneria",
"InGeo International Geophysics Series",
"INGN. The Newsletter of the Isaac Newton Group of Telescopes",
"InISA Indian Institute of Science Journal of Aeronautical Society of India",
"InISJ Indian Institute of Science Journal",
"InJAE Indian Journal of Aerospace Engineering Division",
"InJET Indian Journal of Electronics Telecommunication Engineering Division",
"InJHS Indian Journal of the History of Science",
"InJME Indian Journal of Mechanical Engineering Division",
"InJPA Indian Journal of Physics Section A",
"InJPB Indian Journal of Physics Section B",
"InJPh Indian Journal of Physics",
"InJP. Indian Journal of Physics and Proceedings of the Indian Assocatiation for the Cultivation of Science",
"InJTP Indian Journal of Theoretical Physics",
"INL.. International Nano Letters",
"InLoP Instytut Lotnictwa Prace",
"InMat Inventiones Mathematicae",
"InMPP Instytut Maszyn Przeplywowych Prace",
"InMS. Indian Academy of Sciences Proceedings Mathematical Sciences",
"InPhT Infrared Physics and Technology",
"INSAP Indian National Science Academy Proceedings Supplement",
"IntaC Inta Conie",
"Inter Interavia",
"INTMK Itogi Nauki i Tekhniki Seriia Meteorologiia i Klimatologiia",
"INTSA Itogi Nauki i Tekhniki Seriia Astronomiia",
"INTSF Itogi Nauki i Tekhniki Seriia Fizika Plazmy",
"INTSI Itogi Nauki i Tekhniki Seriia Issledovanie Kosmicheskogo Prostranstva",
"IntSM Interavia Space Markets",
"INTSO Itogi Nauki i Tekhniki Seriia Okeanologiia",
"INTSR Itogi Nauki i Tekhniki Seriia Radiotekhnika",
"INTSS Itogi Nauki i Tekhniki Seriia Sovremennye Problemy Matematiki",
"INTSV Itogi Nauki i Tekhniki Seriia Vozdushnyi Transport",
"InvPr Inverse Problems",
"IonIs Ionosfernye Issledovaniia",
"Iono. Ionosphere",
"IORAS Anuario publicado pelo Imperial Observatorio do Rio de Janeiro Suplemento",
"IPAUC INTERKOSMOS Prague Astronomicky Ustav Ceskoslovenske Akademie Ved",
"IPBS. Isotopes in the Physical and Biomedical Sciences",
"IPCDT IEE Proceedings E: Computers and Digital Techniques",
"IPCI. IEEE Press Series on Computational Intelligence",
"IPCRS IEE Proceedings F: Communications Radar and Signal Processing",
"IPCSV IEE Proceedings: Communications Speech and Vision",
"IPCTA IEE Proceedings D: Control Theory Applications",
"IPDMC IEEE Press Series on Digital &amp",
"IPElT IEEE Press Series on Electronics Technology",
"IPEPA IEE Proceedings B: Electric Power Applications",
"IPETS IEEE Power and Energy Technology Systems Journal",
"IPEWT IEEE Press Series on Electromagnetic Wave Theory",
"IPGTD IEE Proceedings C: Generation Transmission Distribution",
"IPhoJ IEEE Photonics Journal",
"IPMAP IEE Proceedings H: Microwaves Antennas and Propagation",
"IPM.. Information Processing and Management",
"IPMOA IEE Proceedings H: Microwaves Optics and Antennas",
"IPMS. IEEE Press Series on Microelectronic Systems",
"IPNPR Interplanetary Network Progress Report",
"IPOpt IEE Proceedings J: Optoelectronics",
"Ippa. Ipparchos",
"IPPE. IEEE Press Series on Power Engineering",
"IPPSM IEE Proceedings: Physical Science Measurement and Instrumentation Management and Education Reviews",
"IPRSP IEE Proceedings F: Radar and Signal Processing",
"IPSSE IEE Proceedings: Solid-State Electron Devices",
"IPTHS IEEE Press Telecommunications Handbook Series",
"IPTL. IEEE Photonics Technology Letters",
"IRA.. Infrared Astronomy",
"IrAJ. Irish Astronomical Journal",
"IrAJS Irish Astronomical Journal Supplement",
"IREdu International Review of Education",
"IRETE IRE Transactions on Education",
"IRH.. International Review of Hydrobiology",
"IrJST Iranian Journal of Science Technology",
"IRMBP Institut Royal Meteorologique de Belgique Publications Serie",
"IRNvP International Review of Nuclear Physics",
"IRPC. International Reviews in Physical Chemistry",
"ISAP. ISA Proceedings",
"ISASS Institute of Space and Astronautical Science Report",
"ISAT. ISA Transactions",
"ISBRv International Space Business Review",
"iSci. iScience",
"ISCJS ISRO Satellite Centre Journal of Spacecraft Technology",
"ISenJ IEEE Sensors Journal",
"Isis. Isis. Journal of the History of Science Society",
"IsJAP Istanbul University Faculty of Science Journal of Astronomy Physics",
"IsJT. Israel Journal of Technology",
"ISKZ. Issledovaniya Solntsa i Krasnykh Zvezd",
"IsMTD Issledovaniia Mekhanike i Teploobmenu Dvukhfaznykh Sred",
"ISNL. Information Systems Newsletter",
"ISPAn ISPRS Annals of Photogrammetry, Remote Sensing and Spatial Information Sciences",
"ISPAr ISPRS - International Archives of the Photogrammetry, Remote Sensing and Spatial Information Sciences",
"ISPL. IEEE Signal Processing Letters",
"ISPM. IEEE Signal Processing Magazine",
"ISRAA ISRN Astronomy and Astrophysics",
"IsRvC Istanbul University Faculty Science Review Serie C",
"ISRv. Interdisciplinary Science Reviews",
"ISSIR ISSI Scientific Reports Series",
"IsSRT Israel Space Research and Technology Information Bulletin",
"IssUP Issledovaniia Uprugosti i Plastichnosti",
"IssZK Issledovanie Zemli Fiz Kosmosa",
"IS&T. Instrumentation Science &amp",
"IST.. Issues in Science and Technology",
"ISTSP IEEE Journal of Selected Topics in Signal Processing",
"ISysJ IEEE Systems Journal",
"ITAB. Institut Teoreticheskoi Astronomii Byulleten",
"ITABO Institute of Theoretical Astrophysics, Blindern-Oslo",
"ITAC. IEEE Transactions on Automatic Control",
"ITAer IEEE Transactions on Aerospace",
"ITAES IEEE Transactions on Aerospace Electronic Systems",
"ITANE IEEE Transactions on Aerospace and Navigational Electronics",
"ITAP. IEEE Transactions on Antennas and Propagation",
"ITAS. IEEE Transactions on Applied Superconductivity",
"ITASS IEEE Transactions on Acoustics Speech and Signal Processing",
"ITBE. IEEE Transactions on Biomedical Engineering",
"ITB.. IEEE Transactions on Broadcasting",
"ITCAD IEEE Transactions on Computer Aided Design",
"ITCHM IEEE Transactions on Components Hybrids and Manufacturing Technology",
"ITCJ. ITC Journal",
"ITCmp IEEE Transactions on Computers",
"ITCom IEEE Transactions on Communications",
"ITCS. IEEE Transactions on Circuits Systems",
"ITED. IEEE Transactions on Electron Devices",
"ITEdu IEEE Transactions on Education",
"ITEI. IEEE Transactions on Electrical Insulation",
"ITEIS IEEJ Transactions on Electronics, Information and Systems",
"ITElC IEEE Transactions on Electromagnetic Compatibility",
"ITEM. IEEE Transactions on Engineering Management",
"ITEnC IEEE Transactions on Energy Conversion",
"ITGE. IEEE Transactions on Geoscience Electronics",
"ITGRS IEEE Transactions on Geoscience and Remote Sensing",
"ITIA. IEEE Transactions on Industry Applications",
"ITIEC IEEE Transactions on Industrial Electronics and Control Instrumentation",
"ITIE. IEEE Transactions on Industrial Electronics",
"ITIM. IEEE Transactions on Instrumentation Measurement",
"ITIP. IEEE Transactions on Image Processing",
"ITIT. IEEE Transactions on Information Theory",
"ITJSE Indian Institute of Technology Journal on Section Engineering Technology",
"ITME. IEEE Transactions on Military Electronics",
"ITM.. IEEE Transactions on Magnetics",
"ITMTT IEEE Transactions on Microwave Theory Techniques",
"ITNan IEEE Transactions on Nanotechnology",
"ITN.. IERS Technical Note",
"ITNN. IEEE Transactions on Neural Networks",
"ITNS. IEEE Transactions on Nuclear Science",
"ITPA. Interscience Tracts on Physics and Astronomy",
"ITPAM IEEE Transactions on Pattern Analysis and Machine Intelligence",
"ITPAS IEEE Transactions on Power Apparatus Systems",
"ITPE. IEEE Transactions on Power Electronics",
"ITPHP IEEE Transactions on Parts Hybrids and Packaging",
"ITPS. IEEE Transactions on Plasma Science",
"ITPSy IEEE Transactions on Power Systems",
"ITRA. IEEE Transactions on Robotics Automation",
"ITRFI IEEE Transactions on Radio Frequency Interference",
"ITR.. IEEE Transactions on Reliability",
"ITSE. IEEE Transactions on Sustainable Energy",
"ITSET IEEE Transactions on Space Electronics and Telemetry",
"ITSMC IEEE Transactions on Systems Man and Cybernetics",
"ITSP. IEEE Transactions on Signal Processing",
"ITSU. IEEE Transactions on Sonics Ultrasonics",
"ITTST IEEE Transactions on Terahertz Science and Technology",
"ITUFF IEEE Transactions on Ultrasonics Ferroelectrics and Frequency Control",
"ITUTJ ITU Telecommunication Journal",
"ITVT. IEEE Transactions on Vehicular Technology",
"IUEEN IUE ESA Newsletter",
"IUENN IUE NASA Newsletter",
"IUGG. International Union of Geodesy and Geophysics General Assembly",
"IUMJ. Indiana University Mathematics Journal",
"IzAlm Izvestiya Astrofizicheskogo Instituta Alma-Ata",
"IzAOP Izvestiya Atmospheric and Oceanic Physics",
"IzArm Izvestiya Akademiya Nauk Armyanskoi",
"IzAsh Izvestiya Akademii Nauk Turkmenskoj SSR Ashkhabad",
"IzAvT Izvestiya VUZ Aviatsionnaya Tekhnika",
"IzAze Akademiia Nauk Azerbaidzhanskoi SSR Izvestiia Seriia Fiziko Tekhnicheskikh i Matematicheskikh Nauk",
"IzDus Dushanbe Izdatel Donish",
"IzEhn Izvestiya Astronomicheskoj Engel'gardt obskoj Observatorii Kazan",
"IzET. Izvestiia Energetika i Transport",
"IzFru Frunze Izdatel Ilim",
"IzFZ. Akademiia Nauk SSSR, Izvestiia, Fizika Zemli",
"IzGeo Tbilisi Georgian SSR Izdatel Metsniereba",
"IzGla Izvestiia Glavnoi rossiiskoi astronomicheskoi observatorii",
"IzKie Izvestiya Glavnoj Astronomicheskoj Observatorii Kiev",
"IzKry Izvestiya Ordena Trudovogo Krasnogo Znameni Krymskoj Astrofizicheskoj Observatorii",
"IzLat Akademiia Nauk Latviiskoi SSR Izvestiia Seriia Fizicheskikh i Tekhnicheskikh Nauk",
"IzLen Leningrad, Izdatel'stvo Nauka",
"IzMat Izvestiya: Mathematics",
"IzMin Minsk Izdatel BGU",
"IzMol Akademiia Nauk Moldavskoi SSR Izvestiia Seriia Fiziko Tekhnicheskikh i Matematicheskikh Nauk",
"IzMZG Akademiia Nauk SSSR Izvestiia Mekhanika Zhidkosti i Gaza",
"IzOde Odesskij Gosudarstvennyi Universitet im. I. I. Mechnikova Izvestiya Astronomicheskoj Observatorii",
"IzPSE Izvestiya Physics of the Solid Earth",
"IzPul Izvestiya Glavnoj Astronomicheskoj Observatorii v Pulkove",
"IzRad Izvestiya VUZ Radiofizika",
"IzSF. Izvestiia Akademii Nauk Seriya Fizicheskaya",
"IzSib Akademiia Nauk SSSR Sibirskoe Otdelenie Izvestiia",
"IzSSR Akademiia Nauk SSSR Izvestiia Seriia Fizicheskaia",
"IzTad Izvestiia Akademiia Nauk TadzhSSR",
"IzTas Tashkent Izdatel Fan",
"IzTif Tiflis Izdatel Tbilisskogo Universiteta",
"IzTur Akademiia Nauk Turkmenskoi SSR Izvestiia Seriia Fiziko Tekhnicheskikh Khimicheskikh i Geologicheskikh Nauk",
"IzUkr Akademiia Nauk Ukrainian SSSR Izvestiia Seriia Fizicheskaia",
"IzUzb Akademiia Nauk Uzbekskoi SSR Izvestiia Seriia Fiziko Matematicheskikh Nauk",
"IzVF. Izvestiya Vysshikh Uchebnykh Zavedenij. Fizika",
"IzVGA Izvestiia vuzov. Geodeziia Aehrofotosemka",
"IzVil Vilnius Izdatel Mokslas",
"IzVUZ Izvestiia Vysshaia Uchebn. Zaved., Radiofizika",
"IzYak Vsesoiuznaia Konferentsiia Kosmicheskim Lucham Yakutsk USSR Akademiia Nauk SSSR Izvestiia Seriia Fizicheskaia",
"IzYer Vsesoiuznaia Konferentsiia Kosmicheskim Lucham Yerevan Armenian SSR Aademiia Nauk SSSR Izvestiia Seriia Fizicheskaia",
"JAChS Journal of the American Chemical Society",
"JAco. Journal d'Acoustique",
"JACS. Journal of American Ceramic Society",
"JAdD. Journal of Advanced Dielectrics",
"JAD.. Journal of Astronomical Data",
"JAdR. Journal of Advanced Research",
"JAE.. Journal of Acoustic Emission",
"JAerE Journal of Aerospace Engineering",
"JAerP Journal of Aerospace Power",
"JAerS Journal of Aerosol Science",
"JAESc Journal of Asian Earth Sciences",
"JAESE Journal of Astronomy &amp",
"JAES. Journal of Audio Engineering Society",
"JAfES Journal of African Earth Sciences",
"JAF.. Journal des Astronomes Francais",
"JAGeo Journal of Applied Geodesy",
"JAGI. Journal of Artificial General Intelligence",
"JAG.. Journal of Applied Geophysics",
"JAHH. Journal of Astronomical History and Heritage",
"JAI.. Journal of Astronomical Instrumentation",
"JaIMJ Japan Institute of Metals Journal",
"JAir. Journal of Aircraft",
"JaJAG Japanese Journal of Astronomy and Geophysics",
"JaJAP Japanese Journal of Applied Physics",
"JAllC Journal of Alloys and Compounds",
"JALPO Journal of the Association of Lunar and Planetary Observers, the Strolling Astronomer",
"JAMDS Journal of Advanced Mechanical Design, Systems, and Manufacturing",
"JAMES Journal of Advances in Modeling Earth Systems",
"JAM.. Journal of Applied Mechanics",
"JAMOP Journal of Atomic, Molecular and Optical Physics",
"JAMS. Journal of the American Mathematical Society",
"JAMTP Journal of Applied Mechanics and Technical Physics",
"JAnSc Journal of the Astronautical Sciences",
"JApA. Journal of Astrophysics and Astronomy",
"JApAS Journal of Astrophysics and Astronomy Supplement",
"JApCr Journal of Applied Crystallography",
"JAPE. Journal of Applied Photographic Engineering",
"JApEl Journal of Applied Electrochemistry",
"JAPh. Journal of Applied Physiology",
"JAP.. Journal of Applied Physics",
"JApMa IMA Journal of Applied Mathematics",
"JApMC Journal of Applied Meteorology and Climatology",
"JApMe Journal of Applied Meteorology",
"JApMM Journal of Applied Mathematics and Mechanics",
"JApMw Journal of Applied Metalworking",
"JApSc Journal of Applied Sciences",
"JApSp Journal of Applied Spectroscopy",
"JArEn Journal of Arid Environments",
"JARS. Journal of Applied Remote Sensing",
"JASAC Japan Astronomical Study Association Circulars",
"JASCE Journal of the American Society of Civil Engineers",
"JASEg Journal of the Astronomical Society of Egypt",
"JASE. Journal of Applied Science and Engineering Section on Electrical Power and Information Systems",
"JAsGe NRIAG Journal of Astronomy and Geophysics",
"JASIS Journal of the American Society for Information Science and Technology",
"JASJa Journal of the Acoustical Society of Japan",
"JASMS Journal of The American Society for Mass Spectrometry",
"JAsPh Journal of Astronomy and Physics (Turkey)",
"JASSA Journal of the Astronomical Society of Southern Africa",
"JASS. Journal of Astronomy and Space Sciences",
"JAS.. The Journal of Agricultural Science",
"JASTP Journal of Atmospheric and Solar-Terrestrial Physics",
"JASV. Journal of the Astronomical Society of Victoria Melbourne",
"JASWA Journal of the Astronomical Society of Western Australia",
"JAtC. Journal of Atmospheric Chemistry",
"JATIS Journal of Astronomical Telescopes, Instruments, and Systems",
"JAtOT Journal of Atmospheric and Oceanic Technology",
"JATP. Journal of Atmospheric and Terrestrial Physics",
"JAtS. Journal of Atmospheric Sciences",
"JATSo Journal of the Antique Telescope Society",
"JAuGG Journal of Australian Geology and Geophysics",
"JAVSO Journal of the American Association of Variable Star Observers (JAAVSO)",
"JAWRA Journal of the American Water Resources Association",
"JBAA. Journal of the British Astronomical Association",
"JBall Journal of Ballistics",
"JBAS. Journal of the British Astronomical Society",
"JBASP Jodrell Bank Ann Ser Pt",
"JBH.. Journal of Big History",
"JBiom Journal of Biomechanics",
"JBiop Journal of Biophysics",
"JBIS. Journal of the British Interplanetary Society",
"JBO.. Journal of Biomedical Optics",
"JBR.. Journal of Breath Research",
"JCAMD Journal of Computer-Aided Molecular Design",
"JCAM. Journal of Climate and Applied Meteorology",
"JCAP. Journal of Cosmology and Astroparticle Physics",
"JChEd Journal of Chemical Education",
"JCh.. Journal of Chromatography",
"JChPh Journal of Chemical Physics",
"JChS. Journal of Chromatographic Science",
"JCHyd Journal of Contaminant Hydrology",
"JCIS. Journal of Colloid and Interface Science",
"JCli. Journal of Climate",
"JClim Journal of Climatology",
"JClP. Journal of Clinical Pharmacology",
"JClR. Journal of Climate Research",
"JCMD. Journal of Computer-Aided Materials Design",
"JCM.. Journal of Computational Mathematics",
"JCMSI SICE Journal of Control, Measurement, and System Integration",
"JCoAM Journal of Computational and Applied Mathematics",
"JCoCh Journal of Computational Chemistry",
"JCoMa Journal of Composite Materials",
"JCom. Journal of Communications",
"JComp Journal of Complexity",
"JComS Journal of Computational Science",
"JConP Journal of Contemporary Physics (Armenian Academy of Sciences)",
"JCoPh Journal of Computational Physics",
"JCoSc Journal of Colloid Science",
"JCos. Journal of Cosmology",
"JCP.. Journal de Chimie Physique",
"JCPX. Journal of Computational Physics: X",
"JCrGr Journal of Crystal Growth",
"JCSS. Journal of the Chinese Silicate Society",
"JCSTe Journal of College Science Teaching",
"JCST. Journal of Computational Science and Technology",
"JCTR. Journal of Composites and Technology Research",
"JDBM. Journal of Dynamic Behavior of Materials",
"JDDE. Journal of Dynamics and Differential Equations",
"JDE.. Journal of Differential Equations",
"JDGeo Journal of Differential Geometry",
"JDisT Journal of Display Technology",
"JDSO. Journal of Double Star Observations",
"JDST. Journal of Dispersion Science and Technology",
"JEAA. Journal of Electromagnetic Analysis and Application",
"JEAS. Journal of Engineering and Applied Sciences",
"JECE. Journal of Environmental Conservation Engineering",
"JECS. Journal of Electronic Circuits and Systems",
"JECTC Journal of Electronics Cooling and Thermal Control",
"JEEEA Journal of Electrical and Electronics Engineering Australia",
"JEE.. Journal of Electrical Engineering",
"JEEM. Journal of Environmental and Economics Management",
"JEER. Journal of Engineering Education Research",
"JEET. Journal of Electrical Engineering &amp",
"JEI.. Journal of Electronic Imaging",
"JElas Journal of Elasticity",
"JElCo Electronics Communications of Japan",
"JElEn Electrical Engineering of Japan",
"JElS. Journal of the Electrochemical Society",
"JEMat Journal of Electronic Materials",
"JEMT. Journal of Electron Microscopy Technique",
"JENan Journal of Experimental Nanoscience",
"JEner Journal of Energy",
"JEngM Journal of Engineering and Mechanics",
"JEngS Journal of Engineering Sciences",
"JEnMa Journal of Engineering Mathematics",
"JEnM. Journal of Energetic Materials",
"JenRu Jenaer Rundschau",
"JenRv Jena Review",
"JEnvS Journal of Environmental Sciences",
"JEOS. Journal of the European Optical Society",
"JEP.. Journal of Engineering Physics",
"JEPT. Journal of Engineering Physics and Thermophysics",
"JEPub Journal of Electronic Publishing",
"JESEd Journal of Elementary Science Education",
"JESRP Journal of Electron Spectroscopy and Related Phenomena",
"JESS. Journal of Earth System Science",
"JETAI Journal of Experimental & Theoretical Artificial Intelligence",
"JETh. Journal of Engineering and Thermophysics",
"JETPL Soviet Journal of Experimental and Theoretical Physics Letters",
"JETP. Soviet Journal of Experimental and Theoretical Physics",
"JEWA. Journal of Electromagnetic Waves and Applications",
"JFAA. Journal of Fourier Analysis and Applications",
"JFC.. Journal of Fluid Control",
"JFF.. Journal of Fire Flammability",
"JFM.. Journal of Fluid Mechanics",
"JFS.. Journal of Fluids and Structures",
"JFST. Journal of Fluid Science and Technology",
"JFuA. Journal of Functional Analysis",
"JFuE. Journal of Funsion Energy",
"JGCD. Journal of Guidance Control Dynamics",
"JGeEd Journal of Geoscience Education",
"JGE.. Journal of Geophysics and Engineering",
"JGeod Journal of Geodesy",
"JGeoE Journal of Geological Education",
"JGeo. Journal of Geodynamics",
"JGeop Journal of Geophysics",
"JGeoS Journal of Geodetic Science",
"JGG.. Journal of Geomagnetism and Geoelectricity",
"JGGS. Journal of Geomagnetism and Geoelectricity Supplement",
"JGHyd Journal of Groundwater Hydrology",
"JGIS. Journal of Geographic Information System",
"JG... Journal of Geology",
"JGlac Journal of Glaciology",
"JGP.. Journal of Geometry and Physics",
"JGRA. Journal of Geophysical Research (Space Physics)",
"JGRB. Journal of Geophysical Research (Solid Earth)",
"JGRC. Journal of Geophysical Research (Oceans)",
"JGRD. Journal of Geophysical Research (Atmospheres)",
"JGRE. Journal of Geophysical Research (Planets)",
"JGRF. Journal of Geophysical Research (Earth Surface)",
"JGRG. Journal of Geophysical Research (Biogeosciences)",
"JGR.. Journal of Geophysical Research",
"JGrPh Journal of Gravitational Physics",
"JGRS. Journal of Geophysical Research Supplement",
"JGSJ. Journal of the Geodetic Society of Japan",
"JGS.. Journal of Geographical Systems",
"JGSoc Journal of the Geological Society",
"JGuC. Journal of Guidance Control",
"JGZG. Journal of Geophysics Zeitschrift Geophysik",
"JHA.. Journal for the History of Astronomy",
"JHAS. Journal for the History of Astronomy Supplement",
"JHATD Johns Hopkins APL Technical Digest",
"JHEAp Journal of High Energy Astrophysics",
"JHENP Journal of High Energy and Nuclear Physics",
"JHEP. Journal of High Energy Physics",
"JHTS. Journal of High Temperature Society",
"JHyd. Journal of Hydrology",
"JHyDy Journal of Hydrodynamics",
"JHyMe Journal of Hydrometeorology",
"JHyn. Journal of Hydronautics",
"JIECE Institute of Electronics Communication Engineers of Japan Transactions Section E English",
"JIEEJ Journal of The Institute of Electrical Engineers of Japan",
"JIEIA Journal of The Institution of Engineers (India): Series A",
"JIEIB Journal of The Institution of Engineers (India): Series B",
"JIEIC Journal of The Institution of Engineers (India): Series C",
"JIEID Journal of The Institution of Engineers (India): Series D",
"JIEIE Journal of The Institution of Engineers (India): Series E",
"JIEI. Journal of Industrial Engineering International",
"JIEq. Journal of Integral Equations",
"JIETE Journal of the Institution of Electronics and Telecommunication Engineers",
"JIEx. Journal of Ion Exchange",
"JIMIA Journal of the Institute of Mathematics and Its Applications",
"JIMO. WGN, Journal of the International Meteor Organization",
"JIMSS Journal of Intelligent Material Systems and Structures",
"JIMW. Journal of Infrared and Millimeter Waves",
"JInfo Journal of Informetrics",
"JInst Journal of Instrumentation",
"JIntS Journal of Integer Sequences",
"JIPM. Journal of Information Processing and Management",
"JIPNT Journal of the Institute of Positioning, Navigation and Timing of Japan",
"JIST. Journal of Imaging Science and Technology",
"JJAEE Journal of Japan Association for Earthquake Engineering",
"JJAHS Journal of Japanese Association of Hydrological Sciences",
"JJAPL Japanese Journal of Applied Physics Letters B",
"JJAPR Japanese Journal of Applied Physics Regular Papers Short Notes and Review Papers",
"JJAPS Japanese Journal of Applied Physics Supplement",
"JJSEE Journal of Japanese Society for Engineering Education",
"JJSMS Journal of the Japan Society for Marine Surveys and Technology",
"JJTST Journal of Thermal Science and Technology",
"JKAS. Journal of Korean Astronomical Society",
"JKASS Journal of Korean Astronomical Society Supplement",
"JKPS. Journal of Korean Physical Society",
"JKSAS Journal of the Korean Society for Aeronautical & Space Sciences",
"JLasA Journal of Laser Applications",
"JLCM. Journal of Less Common Metals",
"JLMS. Journal of the London Mathematical Society",
"JLTP. Journal of Low Temperature Physics",
"JLum. Journal of Luminescence",
"JLVEn Journal of Light & Visual Environment",
"JLwT. Journal of Lightwave Technology",
"JMAA. Journal of Mathematical Analysis and Applications",
"JMaCh Journal of Mathematical Chemistry",
"JMagR Journal of Magnetic Resonance",
"JMaMe Journal of Mathematics and Mechanics",
"JMaPh Journal of Mathematics and Physics",
"JMarA Journal of Maritime Archaeology",
"JMaSc Journal of Mathematical Sciences",
"JMatR Journal of Materials Research",
"JMatS Journal of Materials Science",
"JMBM. Journal of the Mechanical Behavior of Materials",
"JMCS. Journal of Mathematical and Computational Science",
"JMecA Journal de Mecanique Appliquee",
"JMecE Journal of Mechanical and Engineering Science",
"JMec. Journal de Mecanique",
"JMecT Journal de Mecanique Theorique et Appliquee",
"JMEM. Journal of Molecular and Engineering Materials",
"JMemS Journal of Microelectromechanical Systems",
"JMeOp Jemna Mechanika Optika",
"JMEP. Journal of Materials Engineering and Performance",
"JMetG Journal of Metamorphic Geology",
"JMet. Journal of Metals",
"JMetR Journal of Meteorological Research",
"JMFM. Journal of Mathematical Fluid Mechanics",
"JMic. Journal of Microscopy",
"JMicP Journal of Micropaleontology",
"JMiMi Journal of Micromechanics and Microengineering",
"JMMM. Journal of Magnetism and Magnetic Materials",
"JMM&M Journal of Micro/Nanolithography, MEMS, and MOEMS",
"JMMPS Japanese Magazine of Mineralogical and Petrological Sciences",
"JMOA. IEE Journal of Microwaves Optics and Acoustics",
"JMoEl Journal of Molecular Electronics",
"JMolE Journal of Molecular Evolution",
"JMOp. Journal of Modern Optics",
"JMoSp Journal of Molecular Spectroscopy",
"JMoSt Journal of Molecular Structure",
"JMPeS Journal of Mineralogical and Petrological Sciences",
"JMPh. Journal of Modern Physics",
"JMP.. Journal of Mathematical Physics",
"JMPMS Journal of Materials Processing and Manufacturing Science",
"JMPS. Journal of Mathematical and Physical Sciences",
"JMPSo Journal of Mechanics Physics of Solids",
"JMRB. Journal of Magnetic Resonance",
"JMR.. Journal of Marine Research",
"JMSA. Journal of Marine Science and Application",
"JMSB. Journal of Macromolecular Science, Part B",
"JMSJ. Journal of the Mineralogical Society of Japan",
"JMS.. Journal of Marine Systems",
"JMSL. Journal of Materials Science Letters",
"JMSME Journal of Materials Science and Materials Electronics",
"JMSp. Journal of Mass Spectrometry",
"JMSTL Journal of Mechanical Systems for Transportation and Logistics",
"JMTAS Journal de Mecanique Theorique et Appliquee Supplement",
"JMTPR Journal of Modern Trends in Physics Research",
"JMuMo Journal of Multiscale Modelling",
"JNano Journal of Nanophotonics",
"JNanU Journal Nanjing Univ",
"JNav. Journal of Navigation",
"JNCS. Journal of Non Crystalline Solids",
"JNCSX Journal of Non Crystalline Solids: X",
"JNE.. Journal of Nondestructive Evaluation",
"JNEng Journal of Neural Engineering",
"JNET. Journal of Non Equilibrium Thermodynamics",
"JNeur Journal of Neurochemistry",
"JNIRE Journal NIRE",
"JNIS. Journal of Near Infrared Spectroscopy",
"JNLM. Journal of Non Linear Mechanics",
"JNMP. Journal of Nonlinear Mathematical Physics",
"JNOPM Journal of Nonlinear Optical Physics and Materials",
"JNR.. Journal of Nanoparticle Research",
"JNS.. Journal of NonLinear Science",
"JNuE. Journal of Nuclear Energy",
"JNuM. Journal of Nuclear Materials",
"JNUNS Journal of Nanjing University (Natural Sciences)",
"JOA.. Journal for Occultation Astronomy",
"JoBaA Jodrell Bank Annals",
"JOC.. Journal of Optical Communications",
"JOCN. Journal of Optical Communications and Networking",
"JoDI. Journal of Digital Information",
"JO... Journal des Observateurs",
"JOL.. Journal of Oceanology and Limnology",
"JOM.. JOM - Journal of the Minerals, Metals and Materials Society",
"JON.. Journal of Optical Networking",
"JOptA Journal of Optics A: Pure and Applied Optics",
"JOptB Journal of Optics B: Quantum and Semiclassical Optics",
"JOpt. Journal of Optics",
"JOptT Journal of Optical Technology",
"JORS. Journal of Open Research Software",
"JOSAA Journal of the Optical Society of America A",
"JOSAB Journal of the Optical Society of America B Optical Physics",
"JOSA. Journal of the Optical Society of America (1917-1983)",
"JOSS. The Journal of Open Source Software",
"JOTA. Journal of Optimization Theory Applications",
"JOUC. Journal of Ocean University of China",
"JPalA Journal of Paleolithic Archaeology",
"JPalg Journal of Palaeogeography",
"JPal. Journal of Paleontology",
"JPall Journal of Palaeolimnology",
"JPApS Journal of Pure Applied Sciences",
"JPAS. Journal of Practical Applications in Space",
"JPCA. Journal of Physical Chemistry A",
"JPCB. Journal of Physical Chemistry B",
"JPCM. Journal of Physics Condensed Matter",
"JPCRD Journal of Physical and Chemical Reference Data",
"JPCS. Journal of Physics and Chemistry of Solids",
"JPDC. Journal of Parallel and Distributed Computing",
"JPE.. Journal of Physics of the Earth",
"JPEle Journal of Power Electronics",
"JPEn. Journal of Physics: Energy",
"JPES. Journal of Power and Energy Systems",
"JPetG Journal of Petroleum Geology",
"JPet. Journal of Petrology",
"JPFR. Journal of Plasma and Fusion Research",
"JPhA. Journal of Physics A Mathematical General",
"JPhB. Journal of Physics B Atomic Molecular Physics",
"JPhCh Journal of Physical Chemistry",
"JPhC. Journal of Physics C Solid State Physics",
"JPhCo Journal of Physics Communications",
"JPhD. Journal of Physics D Applied Physics",
"JPhE. Journal of Physics E Scientific Instruments",
"JPhEn Journal of Photonics for Energy",
"JPhF. Journal of Physics F Metal Physics",
"JPhG. Journal of Physics G Nuclear Physics",
"JPhGS Journal of Physics G Nuclear Physics Supplement",
"JPhM. Journal of Physics: Materials",
"JPhP. Journal of Physics: Photonics",
"JPhSt Journal of Physical Studies",
"JPhSu Supplement au Journal de Physique",
"JPhTA Journal de Physique Theorique et Apliquee",
"JPhy1 Journal de Physique I",
"JPhy2 Journal de Physique II",
"JPhy3 Journal de Physique III",
"JPhy4 Journal de Physique IV",
"JPhyC Journal de Physique Colloque",
"JPhys Journal de Physique",
"JPlPh Journal of Plasma Physics",
"JPLSP Jet Propulsion Lab. Space Programs Summary",
"JPO.. Journal of Physical Oceanography",
"JPoSA Journal of Polymer Science A Polymer Chemistry",
"JPoSB Journal of Polymer Science B Polymer Physics",
"JPoSc Journal of Polymer Science",
"JPoSL Journal of Polymer Science: Polymer Letters Edition",
"JPP.. Journal of Propulsion and Power",
"JPRG. Journal of Photogrammetry, Remote Sensing and Geoinformation Science",
"JPRS. ISPRS Journal of Photogrammetry and Remote Sensing",
"JPSCP JPS Conference Proceedings",
"JPSJ. Journal of the Physical Society of Japan",
"JPS.. Journal of Power Sources",
"JPSJS Journal of the Physical Society of Japan Supplement",
"JPT.. Journal of Propulsion Technology",
"JQS.. Journal of Quaternary Science",
"JQSRT Journal of Quantitative Spectroscopy and Radiative Transfer",
"JQT.. Journal of Quality Technology",
"JRAC. Journal of Radioanalytical Chemistry",
"JRadR Journal of Radiation Research",
"JRAEO Journal and Review of Astronomy Education and Outreach",
"JRAM. Journal fur die reine und angewandte Mathematik",
"JRASA Journal of the Royal Aeronautical Society of London",
"JRASC Journal of the Royal Astronomical Society of Canada",
"JReAt Journal de Recherches Atmospheriques",
"JRE.. Jahrbuch der Radioaktivit&auml",
"JResB Journal of Research Section B Mathematical Sciences B",
"JRes. Journal of Research",
"JRheo Journal of Rheology",
"JRIST Journal of Research Institute of Science and Technology, College of Science and Technology, Nihon University",
"JRNBA Journal of Research of the National Bureau of Standards A Physica and Chemsitry",
"JRNBB Journal of Research of the National Bureau of Standards B Mathematical Sciences",
"JRNBS Journal of Research of the National Bureau of Standards",
"JRNC. Journal of Radioanalytical and Nuclear Chemistry",
"JRoS. Journal of Robotic Systems",
"JRPC. Journal of Reinforced Plastics and Composites",
"JRPhy Journal of Research in Physics",
"JRP.. Journal of Radiological Protection",
"JRScT Journal of Research in Science Teaching",
"JRSp. Journal of Raman Spectroscopy",
"JSAES Journal of South American Earth Sciences",
"JSAPJ Japan Society of Air Pollution Journal",
"JSARA Journal of the Southeastern Association for Research in Astronomy",
"JSAR. Journal of Space Astronomy Research",
"JSASS Japan Society of Aeronautical Space Sciences",
"JSAST Japan Society of Aeronautical Space Sciences Transactions",
"JSCAI Journal of Japan Society of Civil Engineers, Ser. D1 (Architecture of Infrastructure and Environment)",
"JSCAM Journal of Japan Society of Civil Engineers, Ser. A2 (Applied Mechanics (AM))",
"JSCCE Journal of Japan Society of Civil Engineers, Ser. F3 (Civil Engineering Informatics)",
"JSCCM Journal of Japan Society of Civil Engineers, Ser. F4 (Construction and Management)",
"JSCER Journal of Japan Society of Civil Engineers, Ser. G (Environmental Research)",
"JSCGE Journal of Japan Society of Civil Engineers, Ser. C (Geosphere Engineering)",
"JSCHE Journal of Japan Society of Civil Engineers, Ser. B1 (Hydraulic Engineering)",
"JSCHS Journal of Japan Society of Civil Engineers, Ser. D2 (Historical Studies in Civil Engineering)",
"JScI. Journal of Scientific Instruments",
"JSCIP Journal of Japan Society of Civil Engineers, Ser. D3 (Infrastructure Planning and Management)",
"JSCMC Journal of Japan Society of Civil Engineers, Ser. E2 (Materials and Concrete Structures)",
"JSCMJ Japan Society of Composite Materials Journal",
"JSCom Journal of Scientific Computing",
"JSCPE Journal of Japan Society of Civil Engineers, Ser. E1 (Pavement Engineering)",
"JSCPP Journal of Japan Society of Civil Engineers, Ser. F5 (Professional Practices in Civil Engineering)",
"JSCSE Journal of Japan Society of Civil Engineers, Ser. A1 (Structural Engineering &amp",
"JSCSP Journal of Japan Society of Civil Engineers, Ser. F6 (Safety Problem)",
"JSCTE Journal of Japan Society of Civil Engineers, Ser. F1 (Tunnel Engineering)",
"JSCUS Journal of Japan Society of Civil Engineers, Ser. F2 (Underground Space Research)",
"JSDD. Journal of System Design and Dynamics",
"JSD.. Journal of the Structural Division, American Society of Civil Engineers",
"JSedR Journal of Sedimentary Research",
"JSEdT Journal of Science Education and Technology",
"JSeis Journal of Seismology",
"JSemi Journal of Semiconductors",
"JSER. Journal for STEM Education Research",
"JSGeo Journal of Series Geophysics",
"JSG.. Journal of Structural Geology",
"JShR. Journal of Ship Research",
"JSLEJ Japan Society of Lubrication Engineers Journal",
"JSLR. Journal of Soviet Laser Research",
"JSMAJ JASMA Japan Society of Microgravity Application Journal",
"JSMEA JSME International Journal Series A",
"JSMEB JSME International Journal Series B",
"JSMEC JSME International Journal Series C",
"JSMEJ JSME International Journal",
"JSMET JSME Transactions",
"JSM.. Journal of Structural Mechanics",
"JSMME Journal of Solid Mechanics and Materials Engineering",
"JSMSJ Japan Society of Materials Science Journal",
"JSMTE Journal of Statistical Mechanics: Theory and Experiment",
"JSpEn Journal of Space Engineering",
"JSP.. Journal of Statistical Physics",
"JSpRo Journal of Spacecraft and Rockets",
"JSPS. Japan Society of Promotion Science",
"JSPST Journal of The Society of Photographic Science and Technology of Japan",
"JSpT. Journal of Spacecraft Technology",
"JSR.. Journal of Sea Research",
"JSRP. Journal of the Society for Radiological Protection",
"JSSat Journal of Small Satellites",
"JSSCh Journal of Solid State Chemistry France",
"JSSED IEE Journal of Solid-State Electron Devices",
"JStA. Journal of Strain Analysis and Engineering Design",
"JSTEd Journal of Science Teacher Education",
"JSup. Journal of Superconductivity",
"JSV.. Journal of Sound Vibration",
"JSWSC Journal of Space Weather and Space Climate",
"JSymC Journal of Symbolic Computation",
"JTAM. Journal of Theoretical and Applied Mechanics",
"JTAP. Journal of Theoretical and Applied Physics",
"JTCN. Journal of Computatational and Theoretical Nanoscience",
"JTech Journal of Technology",
"JTeEv Journal of Testing Evaluation",
"JTePh Journal of Technical Physics",
"JTF.. Journal of Time and Frequency",
"JThCM Journal of Thermoplastic Composite Materials",
"JTh.. Journal of Thermodynamics",
"JThSc Journal of Thermal Science",
"JThSt Journal of Thermal Stresses",
"JTHT. Journal of Thermophysics and Heat Transfer",
"JTP.. Journal for Technology of Plasticity",
"JTST. Journal of Thermal Spray Technology",
"JTurb Journal of Turbulence",
"JURP. Journal of Undergraduate Reports in Physics",
"JVCIR Journal of Visual Communication and Image Representation",
"JVE.. Journal of Vibration Engineering",
"JVGR. Journal of Volcanology and Geothermal Research",
"JVSJ. Journal of the Vacuum Society of Japan",
"JVSTA Journal of Vacuum Science Technology A: Vacuum Surfaces and Films",
"JVSTB Journal of Vacuum Science Technology B: Microelectronics and Nanometer Structures",
"JVST. Journal of Vacuum Science Technology",
"JWMSE Journal of Women and Minorities in Science and Engineering",
"JWUDF Jahns W&ouml",
"JXST. Journal of X-Ray Science and Technology",
"KazOB Astronomicheskoj Observatorii Kazan Byulleten",
"KEIJ. Kansei Engineering International Journal",
"KernR Kernforschungsanlage Rept Res Results Solid State Nucl Phys",
"KexT. Kexue Tongbao",
"KFNT. Kinematika i Fizika Nebesnykh Tel",
"KFNTS Kinematika i Fizika Nebesnykh Tel Supplement",
"Khago Khagol",
"KharI Kharkov Izdanie IRE AN USSR",
"KhPl. Khimiia Plazmy",
"KiIND Kiev Izdatel Naukova Dumka",
"KiInF Kiev Institut Fiziki AN USSR",
"KiInM Kiev Institut Matematiki AN USSR",
"KiIzT Kiev Izdatel Tekhnika",
"KIMMJ Korean Institute of Metals and Materials Journal",
"KIMS. Knowledge: An Illustrated Magazine of Science",
"KIPME Kiev Institut Problem Modelirovaniia Energetike AN USSR",
"KIzIM Kiev Izdanie Instituta Matematiki AN USSR",
"KIzKU Kazan Izdatel Kazanskogo Universiteta",
"KIzS. Kishinev Izdatel Shtiintsa",
"KIzVS Kiev Izdatel Vishcha Shkola",
"KKR.. Kagaku Kogaku Ronbunshu",
"KlBer Kleinheubacher Berichte",
"KNAB. Koninklijke Nederlandse Akademie van Wetenschappen Proceedings Series B Physical Sciences",
"KNT.. Kosmicheskaia Nauka i Tekhnika",
"KodOB Kodaikanal Observatory Bulletins",
"KodRe Kodaikanal Observatory Reprints",
"KomMe Komety i Meteory",
"KomTs Kometnyj Tsirkulyar",
"KosIs Kosmicheskie Issledovaniia",
"KosIU Kosmicheskie Issledovaniia Ukraine",
"KosLu Kosmicheskie Luchi",
"KosNT Kosmichna Nauka i Tekhnologiya",
"KosRo Kosmicke Rozhledy",
"Kozmo Kozmos",
"KPCB. Kinematics and Physics of Celestial Bodies",
"KPCBS Kinematics and Physics of Celestial Bodies, Supplement",
"KPNON Kitt Peak National Observatory Newsletter",
"KSVH. Kungl. Svenska Vetenskapsakademiens Handlingar",
"KTTM. Khimiia i Tekhnologiia Topliv i Masel",
"KUFEM Kyushu University Faculty Engineering Memoirs",
"KvanE Kvantovaia Elektronika Moscow",
"KVeBB Kleine Veroeffentlichungen der Universitaetssternwarte zu Berlin Babelsberg",
"KVnT. Kibernetika i Vychislitelnaia Tekhnika",
"KyITB Kyushu Institute Technology Bulletin",
"KyoMe Kyoto University Faculty Engineering Memoirs",
"KyUAM Kyushu University Research Institute Applied Mechanics Reports",
"KyUSR Kyushu University Research Institute Industrial Science Reports",
"KyUTR Kyushu University Technology Reports",
"KzSib Akademiia Nauk SSSR Sibirskoi Otdelenie Izvestiia Seriia Tekhnicheskikh Nauk",
"LaEO. Laser Elektro Optik",
"LAES. Letters in Applied and Engineering Sciences",
"LaFoc Laser Focus",
"LaJ.. Lapidary Journal",
"LanB. Landolt B&ouml",
"Langm Langmuir",
"Lapa. Majalah LAPAN",
"LaPhL Laser Physics Letters",
"LaPhy Laser Physics",
"LasJ. Laser Journal",
"LAstr L'Astronomie",
"LatJP Latvian Journal of Physics and Technical Sciences",
"LatME Latviiskii Matematicheskii Ezhegodnik",
"LawOB Laws Observatory Bulletin, University of Missouri",
"LBLRR LBL Research Review",
"LCEC. Luxembourg Commission European Communities",
"LeBAN Leningrad Biblioteka Akademii Nauk SSSR",
"LeEne Leningrad Energoizdat",
"LeGid Leningrad Gidrometeoizdat",
"LeIzE Leningrad Izdatel Energiia",
"LeIzG Leningrad Izdatel Gidrometeoizdat",
"LeIzK Leningrad Izdatel Khimiia",
"LeIzM Leningrad Izdatel Mashinostroenie",
"LeIzN Leningrad Izdatel Nauka",
"LeIzS Leningrad Izdatel Sudostroenie",
"LeIzU Leningrad Izdatel Leningradskogo Universiteta",
"LeLen Leningrad Lenizdat",
"LePub Learned Publishing",
"LeRad Le Radium",
"LERec L'Echo des Recherches",
"LFR.. Lietuvos Fizikos Rinkinys",
"LFTR. LEST Foundation, Technical Report",
"LGUPM Leningradskii Gosudarstvennyi Universitet Problemy Matematicheskoi Fiziki",
"LHBl. La Houille Blanche",
"LHMT. Letters Heat Mass Transfer",
"LicOB Lick Observatory Bulletin",
"LiCr. Liquid Crystals",
"Life. Life",
"LimOc Limnology and Oceanography",
"Litho Lithos",
"LitJP Lithuanian Journal of Physics and Technical Sciences",
"LIVS. Lvov Izdatel Vishcha Shkola",
"LIzNe Leningrad Izdatel Nedra",
"LLabJ Lincoln Laboratory Journal",
"LMaPh Letters in Mathematical Physics",
"LMMP. Lasers in Manufacturing and Materials Processing",
"LNCS. Lecture Notes in Computer Science",
"LNEA. Lecture Notes and Essays in Astrophysics",
"LNEn. Lecture Notes in Engineering, Berlin Springer Verlag",
"LNES. Lecture Notes in Earth Sciences, Berlin Springer Verlag",
"LNM.. Lecture Notes in Mathematics, Berlin Springer Verlag",
"LNP.. Lecture Notes in Physics, Berlin Springer Verlag",
"LNSP. Lecture Notes and Supplements in Physics",
"LockH Lockheed Horizons",
"LOEle L'Onde Electrique",
"LowOB Lowell Observatory Bulletin",
"LPB.. Laser and Particle Beams",
"LPIBu LPI Bulletin",
"LPICo LPI Contributions",
"LPlaC Observatorio Astronomico de La Plata Circular",
"LPlaS Observatorio Astronomico de La Plata Separata Astronomica",
"LPRv. Laser & Photonics Review",
"LPSC. Lunar and Planetary Science Conference Proceedings",
"LRCA. Living Reviews in Computational Astrophysics",
"LR... Luft und Raumfahrt",
"LRR.. Living Reviews in Relativity",
"LRSP. Living Reviews in Solar Physics",
"LSA.. Light: Science & Applications",
"LS... Hamburger Sternw. Warner & Swasey Obs.",
"Lsphe Lithoshere",
"LSSR. Life Sciences and Space Research",
"LTerm La Termotecnica",
"LTP.. Low Temperature Physics",
"LubEn Lubrication Engineering",
"LunOC Lund Observatory Circular",
"LuRaQ Luft und Raumfahrt Quarter",
"LvoTs L'vovskij Ordena Lenina Gosudarstvennyj Universitet Tsirkulyar",
"MAA.. Mediterranean Archaeology and Archaeometry",
"MaCom Mathematics of Computation",
"MaDes Machine Design",
"MadOb Madras Observatory Observations",
"MadOO Madras Observatory Astronomical Observations",
"MaFiz Matematicheskaia Fizika",
"MagFE Magnetic Fusion Energy",
"MagGi Magnitnaia Gidrodinamika",
"MagIs Magnitosfernye Issledovaniia",
"MaHT. Materials at High Temperatures",
"MaMeA Sankt Peterburgskii Universitet Vestnik Seriia Matematika Mekhanika Astronomiia",
"MAMMP Mechanics of Advanced Materials and Modern Processes",
"MaMol Macromolecules",
"ManGe Manuscripta Geodaetica",
"ManRv Manufacturing Review",
"MApAn Methods and Applications of Analysis",
"MaPEJ Mathematical Physics Electronic Journal",
"MApFl Methods and Applications in Fluorescence",
"MaPhS Mathematical Physics Studies",
"MAP.. Meteorology and Atmospheric Physics",
"MaPr. Mathematical Proceedings",
"MAPSE Mission Analysis Program Solar Electric Propulsion MAPSEP",
"MaRBu Materials Research Bulletin",
"MarEc Marine Ecology",
"MarGe Marine Geodesy",
"MarGR Marine Geophysical Research",
"MarMP Marine Micropaleontology",
"MarPG Marine and Petroleum Geology",
"MarRv Marconi Review",
"Mashi Mashinostroenie",
"MatAn Mathematische Annalen",
"MaTeJ ManTech Journal",
"Mate. Materials",
"Mater Materialpruefung",
"MatEv Materials Evaluation",
"MatG. Mathematical Geology",
"math. arXiv Mathematics e-prints",
"math.parXiv Mathematical Physics e-prints",
"MatIs Matematicheskie Issledovaniia",
"MatL. Materials Letters",
"MatM. Mathematical Modelling",
"MatMo The Mathemtical Monthly",
"MatNa Mathematische Nachrichten",
"MAtom Moscow Atomizdat",
"MatPr Mathematical Programming",
"MatRv Mathematical Reviews",
"MatSP Materials Science Poland",
"MatST Materials Science Technology",
"MatTe Materiaux et Techniques",
"MatTh Materials Theory",
"MatTr Materials Transactions JIM",
"MatVe Matematichki Vesnik",
"MatZe Mathematische Zeitschrift",
"MAUTx University of Texas Monographs in Astronomy",
"MAWMN Mainz Akademie Wissenschaften Mathematisch Naturwissenschaftliche Klasse",
"MBB.. Molecular Biology and Biophysics",
"MCBEH Monatliche Correspondenz zur Beforderung der Erd- und Himmels-kunde",
"MCM.. Mechanics of Composite Materials",
"MComM Mathematical and Computer Modelling",
"MComP Methods in Computational Physics",
"MeAar Meddelser fra Ole Romer Observatoriet Aarhus",
"MeApp Meteorological Applications",
"MeARB Academie Royale de Belgique Classe des Sciences Memoires",
"Meas. Measurements",
"MeAut Meres es Automatika",
"Mecc. Meccanica",
"MecEn Mechanical Engineering",
"MecSM Mechanics of Soft Materials",
"MedPh Medical Physics",
"MEdRJ Mathematics Education Research Journal",
"MEE.. Materials of Electronics Engineering",
"MEEP. Monographs on Environment, Earth and Planets",
"MeeRe Kenneth Mees Observatory Reprints",
"MeGen Mededelingen Universiteit te Gent Sterrenkundig Instituut",
"MeGid Meteorologiia i Gidrologiia",
"MEI.. Mathematical Engineering Industry",
"MeInd Mechanics and Industry",
"MekGS Mekhanika Giroskopicheskikh Sistem",
"MekKM Mekhanika Kompozitnykh Materialov",
"MekP. Mekhanika Polimerov",
"MekTT Mekhanika Tverdogo Tela",
"MeLeu Mededelingen van het Astronomisch Instituut van de Katholieke Universiteit Leuven",
"MelOO Melbourne Observatory Observations",
"MeLuF Meddelanden fran Lunds Astronomiska Observatorium Serie I",
"MeLuS Meddelanden fran Lunds Astronomiska Observatorium Serie II",
"MeMaT Mechanism and Machine Theory",
"MEner Moscow Energoizdat",
"MEPS. Marine Ecology Progress Series",
"MeRAu Mesures Regulation Automatisme",
"Mercu Mercury",
"MeReC Mechanics Research Communications",
"MerRe Instituto Venezolano de Astronomia Merida Venezuela",
"MeRR. Meteornoe Rasprostranenie Radiovoln, Kazan",
"MeScR Measurement Science Review",
"MeScT Measurement Science and Technology",
"MeSJJ Meteorological Society of Japan Journal",
"MeSol Mechanics of Solids",
"MeSRM Memoires Scientifiques de la Revue de Metallurgie",
"MeSSR Akademiia Nauk SSSR Mekhanika Zhidkosti i Gaza",
"Metal Metallofizika",
"MetaM Metamaterials",
"MetAP Meteorology Atmospheric Physics",
"Meteo La Meteorologie",
"MeTeS Mechanika Teoretyczna i Stosowana",
"MetHy Meteorology Hydrology JPRS",
"Metic Meteoritics",
"Metik Meteoritika",
"MetIs Meteornye Issledovaniia",
"Metit Meteorites",
"MetMa Meteorological Magazine",
"Met.. Meteorite - The International Quarterly of Meteorites and Meteorite Science",
"MetMo Meteorological Monographs",
"Metoo Meteoor",
"Metro Metrologia",
"MetRT Metallurgical Research &amp",
"MetRu Meteorologische Rundschau",
"MetVy Metody Vychislenii",
"MetZe Meteorologische Zeitschrift",
"MetZp Meteorologicke Zpravy",
"Meu1K Observatoire de Meudon",
"MeUpp Meddelanden fran Astronomiska Observatorium Uppsala",
"MExP. Methods of Experimental Physics",
"MFiNM Matematicheskaia Fizika i Nelineinaia Mekhanika",
"MGeoE Materials and Geoenvironment",
"MGeol Marine Geology",
"MGeo. Manuscr. Geod.",
"MGIMO Moskovskii Gosudarstvennyi Universitet Institut Mekhaniki Otchet",
"MGQG. Marine Geology &amp",
"MGTVM Moskovskij Gosudarstvennyj Tekhnicheskij Universitet Vestnik Seriya Mashinostroenie",
"MGTVP Moskovskij Gosudarstvennyj Tekhnicheskij Universitet Vestnik Seriya Priborostroenie",
"MGUkr Akademiia Nauk Ukrainskoi SSR Morskie Gidrofizicheskie Issledovaniia",
"MGUMN Moskovskii Gosudarstvennyi Universitet Institut Mekhaniki Nauchnye Trudy",
"MHD.. Magnetohydrodynamics",
"MHITR Mitsubishi Heavy Industries Technical Review",
"MiARB Astronomisches Rechen-Institut Heidelberg Mitteilungen Serie B",
"MiARI Astronomisches Rechen-Institut Heidelberg Mitteilungen Serie A",
"MiBas Mitteilungen der Astronomisch-Meteorologischen Anstalt der Universitaet Basel Astronomische Reihe",
"MiBon Mitteilungen der Astronomischen Institute der Universitaet Bonn",
"MiBre Astronomische Mitteilungen der Koeniglichen Universitaets-Sternwarte zu Breslau",
"MicEc Microbial Ecology",
"MicgQ Microgravity Quarterly",
"MicNa Microsystems & Nanoengineering",
"MicST Microgravity Science and Technology",
"MicWa Microwaves",
"MIEBA Moscow Izdatel Energiia Biblioteka Avtomatike",
"MIEBR Moscow Izdatel Energiia Biblioteka Radioelektronike",
"MiElC Military Electronics Countermeasures",
"MiGIR Mitteilungen Geod. Institut Rheinischen Friedrich-Wilhelms-Universitaets. Bonn",
"MiGoe Astronomische Mitteilungen der Universitaets-Sternwarte zu Goettingen",
"MiGra Mitteilungen der Universitaets-Sternwarte Graz",
"MiHam Mitteilungen der Hamburger Sternwarte in Bergedorf",
"MiHar Mitteilungen der Bruno-H.-Buergel-Sternwarte Hartha DDR",
"MiInn Mitteilungen der Sternwarte Innsbruck",
"MiINT Minsk Izdatel Nauka i Tekhnika",
"MiJen Mitteilungen der Universitaets-Sternwarte zu Jena",
"MiJo. Microwave Journal",
"MiKon Mitteilungen der Konkoly Sternwarte Budapest-Szabadsaghegy",
"Mikro Mikroelektronika",
"MikSb Mikroelektronika Sbornik",
"MiMic Microscopy and Microanalysis",
"MIMPE Modern Instrumentation and Measurements in Physics and Engineering",
"MiMue Mitteilungen des Astronomischen Instituts des Universitaet Munster",
"MiMun Mitteilungen der Sternwarte Munchen",
"MINCV Moscow Izdatel Nauka AN SSSR Chteniia imeni Vernadskogo",
"MinDe Mineralium Deposita",
"Miner Mineralogia",
"MINFI Moscow Izdatel Nauka AN SSR Fizicheskii Institut Trudy",
"MINGI Moscow Izdatel Nauka AN SSSR Geologicheskoi Institut Trudy",
"MinJ. Mineralogical Journal",
"MINMI Moscow Izdatel Nauka AN SSSR Matematicheskii Institut Trudy",
"MinM. Mineralogical Magazine",
"MinPe Mineralogy and Petrology",
"MINTF Moscow Izdatel Nauka Teoreticheskaia Fizika",
"MINVS Moscow Izdatel Nauka Vychislitelnaia Seismologiia",
"MiOTL Microwave and Optical Technology Letters",
"MiPot Mitteilungen des Astrophysikalischen Observatoriums Potsdam",
"MiPul Mitteilungen der Nikolai-Hauptsternwarte zu Pulkowo",
"MiRe. Microelectronics Reliability",
"MiSon Mitteilungen der Sternwarte zu Sonneberg",
"MisSp Missiles Spacecraft",
"MISST Moscow Izdatel Sviaz Statisticheskaia Teoriia sviazi",
"MISTr Matematicheskii Institut imeni Steklova Trudy",
"MitAe Max Planck Institut Aeronomie Mitteilungen",
"MitAG Mitteilungen der Astronomischen Gesellschaft Hamburg",
"MiTau Zentralinstitut fuer Astrophysik Mitteilungen des Karl-Schwarzschild-Observatoriums Tautenburg",
"MitSI Mitteilungen Mitt. Staatl. Astr. Sternberg-Inst.",
"MitSZ Astronomischen Mitteilungen Eidgen. Sternwarte Zurich",
"MiTue Mitteilungen des Astronomischen Instituts der Universitaet Tuebingen",
"MitVS Zentralinstitut fuer Astrophysik Sternwarte Sonneberg Mitteilungen ueber Veraenderliche Sterne",
"MiWie Mitteilungen der Universitaets-Sternwarte Wien",
"MIzLI Moscow Izdatel Legkaia Industriia",
"MIzMa Moscow Izdatel Mashinostroenie",
"MIzMe Moscow Izdatel Metallurgiia",
"MIzMU Moscow Izdatel Moskovskogo Universiteta Pt",
"MIzNe Moscow Izdatel Nedra",
"MIZNZ Moscow Izdatel Znanie Novoe Zhizni Nauke Tekhnike Seriia Fizika",
"MIzRS Moscow Izdatel Radio Sviaz",
"MIzSR Moscow Izdatel Sovetskoe Radio",
"MiZur Astronomische Mitteilungen der Eidgen&ouml",
"MIzVS Moscow Izdatel Vysshaia Shkola",
"MJPS. Moldavian Journal of the Physical Sciences",
"MKAtl Astrophysics monographs University of Chicago Press",
"MLST. Marine Life Science & Technology",
"MMAAR Annual Report of the Maria Mitchell Association",
"MmARB Memoires of the Academie Royale de Belgique",
"MmArc Osservazioni e memorie dell'Osservatorio astrofisico di Arcetri",
"MmArS Osservazioni e memorie dell'Osservatorio astrofisico di Arcetri - Appendici",
"MmASI Memoirs of the Astronomical Society of India",
"MMAS. Mathematical Methods in the Applied Sciences",
"MmBAA Memoirs of the British Astronomical Association",
"MmCP. Macromolecular Chemistry and Physics",
"MMFMP Matematicheskie Metody i Fiziko Mekhanicheskie Polia",
"MMI.. Metals and Materials International",
"MmKMO Kakioka Magnetic Observatory Memoirs",
"MmKyo Memoirs Faculty of Sciences University of Kyoto",
"MM... Metals and Materials",
"MmMtS Memoires of the Mount Stromlo Observervatory",
"MMNA. Mathematical Modelling Numerical Analysis",
"MmNap Memorie del R. Osservatorio di Capodimonte in Napoli",
"MmRAS Memoirs of the Royal Astronomical Society",
"MmSAI Memorie della Societa Astronomica Italiana",
"MmSGI Memorie della Societa Geologica Italiana",
"MmSSI Memorie della Societa Degli Spettroscopisti Italiani",
"MmSS. Memorie della Societa Degli Spettroscopisti Italiani, serie 2",
"MMTA. Metallurgical and Materials Transactions A",
"MMTB. Metallurgical and Materials Transactions B",
"MMTE. Metallurgical and Materials Transactions E",
"MMTET Matematicheskoe Modelirovanie i Teoriia Elektricheskikh Tsepei",
"MNRAS Monthly Notices of the Royal Astronomical Society",
"MNSL. Micro and Nano Systems Letters",
"MNSSA Monthly Notes of the Astronomical Society of South Africa",
"MNSSJ Monthly notes of the Astronomical Society of South Africa",
"ModGe Modern Geology",
"ModIn Modern Instrumentation",
"ModPh Modern Physics",
"MoEBA Moscow Energoatomizdat Biblioteka Automatike",
"MoEIT Moskovskii Energeticheskii Institut Trudy",
"MoGid Moscow Gidrometeoizdat",
"MoIKI Moscow Institut Kosmicheskikh Issledovanii AN SSSR",
"MoINI Moscow Izdatel Nauka Issledovaniia Geomagnetizmu Aeronomii i Fizike Solntsa",
"MoIPM Moscow Institut Prikladnoi Matematiki AN SSSR",
"MoIzA Moscow Izdatel Atomizdat",
"MoIzE Moscow Izdatel Energiia",
"MoIzK Moscow Izdatel Khimiia",
"MoIzM Moscow Izdatel Moskovskogo Universiteta",
"MoIzN Moscow Izdatel Nauka",
"MoIzS Moscow Izdatel Sviaz",
"MoIzT Moscow Izdatel Transport",
"MoIzV Moscow Izdatel VINITI",
"MoIzZ Moscow Izdatel Znanie",
"MolAs Molecular Astrophysics",
"MoLLP Moshchnye lazery i lazernaia plazma",
"MolPh Molecular Physics",
"MoMGK Moscow Mezhduvedomstvennyi Geofizicheskii Komitet",
"MoMTN Moscow Mezhdunarodnyi Tsentr Nauchnoi i Tekhnicheskoi Informatsii",
"MonAP Communications du Departement d'Astrophysique de la Faculte des Sciences de Mons Mons Astrophysical Papers",
"Moon. Moon",
"MorGI Morskie Gidrofizicheskie Issledovaniia",
"MoSim Molecular Simulation",
"MosIZ Moscow IZMIRAN",
"MosVI Moscow Voennoe Izdatel",
"MosVo Moscow Voenizdat",
"MotZe Motortechnische Zeitschrift",
"MoVIN Moscow VINITI",
"MoVNT Moscow Vychislitelnyi Tsentr AN SSSR",
"MoVyS Moscow Vysshaia Shkola",
"MPAG. Mathematical Physics, Analysis and Geometry",
"MPARp Max Planck Institut fur Astrophysik Report",
"MPBu. Minor Planet Bulletin",
"MPC.. Minor Planet Circulars",
"MPCPS Mathematical Proceedings of the Cambridge Philosophical Society",
"MPDS. Mechanics and Physics of Discrete Systems",
"MPEC. Minor Planet Electronic Circulars",
"MPERp MPE Report",
"MPFD. Microdevices: Physics and Fabrication Technologies",
"MPLA. Modern Physics Letters A",
"MPLB. Modern Physics Letters B",
"M&P.. Moon and Planets",
"M&PSA Meteoritics and Planetary Science Supplement",
"M&PS. Meteoritics and Planetary Science",
"MRE.. Materials Research Express",
"MROVG Munich R Oldenbourg Verlag GmbH",
"MRRev Magnetic Resonance Review",
"MRSBu MRS Bulletin",
"MRSSP Materials Research Society Symposia Proceedings",
"MSAIQ Societa Astronomica Italiana Memorie Quarter",
"MSAIS Memorie della Societa Astronomica Italiana Supplementi",
"MSB.. Methods in Subnuclear Physics",
"MSCTN Meteorological Satellite Center Technical Note",
"MSE.. Multiscale Science and Engineering",
"MSEnA Materials Science and Engineering A",
"MSEnB Materials Science and Engineering B",
"MSEnC Materials Science and Engineering C",
"MSEng Materials Science and Engineering",
"MSEnR Materials Science and Engineering R Reports",
"MSF.. Materials Science Forum",
"MSHT. Metal Science and Heat Treatment",
"MSHTM Metal Science and Heat Treatment of Metals",
"MSMFR Milano Seminario Matematico e Fisico Rendiconti",
"MSM.. Mechanics of Structures and Machines",
"MSMSE Modelling Simul. Mater. Sci. Eng.",
"Msngr The Messenger",
"MSPE. Management Systems in Production Engineering",
"MSRSL Memoires of the Societe Royale des Sciences de Liege",
"MSRv. Mass Spectrometry Reviews",
"MSSP. Mechanical Systems and Signal Processing",
"MsT.. Masters Thesis",
"MTA.. Metallurgical Transactions A",
"MTB.. Metallurgical Transactions B",
"MTDM. Mechanics of Time-Dependent Materials",
"MTEng Microscale Thermophysical Engineering",
"MT... Metallurgical Transactions",
"MTObM Metallovedenie i Termicheskaia Obrabotka Metallov",
"MtoIs Meteorologicheskie Issledovaniia",
"MTPMM Metallurgical Transactions Physical Metallurgy Materials Science",
"MTRMA Meteor Forschungsergebnisse Reihe B Meteorologie und Aeronomie",
"MtSOM Mount Stromlo Observatory Mimeographs",
"MtWAR Mount Wilson and Palomar Observatory Annual Report",
"MulSE Multiscale Science and Engineering",
"MuMat Multifunctional Materials",
"MUPB. Moscow University Physics Bulletin",
"MURJE Mehran University Research Journal of Engineering and Technology",
"MUSS. Muenchen Universitaets Schriften Serie",
"MUVSK Moskovskii Universitet Vestnik Seriia Khimiia",
"MVMP. Methoden und Verfahren der Mathematischen Physik",
"MVSFA Moskovskii Universitet Vestnik Seriia Fizika Astronomiia",
"MVSMM Moskovskii Universitet Vestnik Seriia Matematika Mekhanika",
"MWE.. Mine Water and The Environment",
"MWGBI Mannheim West Germany Bibliographisches Institut AG",
"MWOAR Mount Wilson Observatory Annual Report",
"MWRv. Monthly Weather Review",
"NaAIJ Nanjing Aeronautical Institute Journal",
"NacEl Nachrichten Elektronik",
"NacZe Nachrichtentechnische Zeitschrift",
"NaGe. National Geographic",
"NanMe Nanomanufacturing and Metrology",
"NanoA Nanoscale Advances",
"NanoF Nano Futures",
"NanoH Nanoscale Horizons",
"NanoL Nano Letters",
"Nanop Nanophotonics",
"NanoR Nanoscale Reports",
"Nanos Nanoscale",
"Nanot Nanotechnology",
"Nansp Nanospectroscopy",
"NanSy Nanoelectromechanical Systems",
"Nanth Nanothermoelectrics",
"NapCo Osservatorio Astronomico di Capodimonte Napoli Contributi Astronomici",
"NaPho Nature Photonics",
"NASCL NASA Circular Letter",
"NASRP NASA Reference Publication",
"NASSP NASA Special Publication",
"NASTM NASA Technical Memo",
"NatAs Nature Astronomy",
"NatBi Nature Biotechnology",
"NatCC Nature Climate Change",
"NatCh Nature Chemistry",
"NatCo Nature Communications",
"NatEn Nature Energy",
"NatGe Nature Geoscience",
"NatH. Natural History",
"NATi. Nordisk Astronomisk Tidsskrift",
"NatMa Nature Materials",
"NATM. Nonlinear Analysis Theory Methods Applications",
"NatNa Nature Nanotechnology",
"NatPh Nature Physics",
"NatRM Nature Reviews Materials",
"NatRP Nature Reviews Physics",
"NatSc Natural Science",
"NatSR Scientific Reports",
"Natur Nature",
"NavAu Navigation Australia",
"Navig Navigation",
"NavPa Navigation Paris",
"NAZ.. Nachrichtenblatt der Astronomischen Zentralstelle Heidelberg",
"NBSSP National Bureau of Standards Special Publication",
"NBSTN National Bureau of Standards Technical Note",
"NCE.. Noise Control Engineering Journal",
"NCimA Nuovo Cimento A Serie",
"NCimB Nuovo Cimento B Serie",
"NCimC Nuovo Cimento C Geophysics Space Physics C",
"NCimD Nuovo Cimento D Serie",
"NCim. Il Nuovo Cimento",
"NCimL Nuovo Cimento Lettere",
"NCimR Nuovo Cimento Rivista Serie",
"NCimS Nuovo Cimento Serie",
"NCNS. Network: Computation in Neural Systems",
"NDS.. Nuclear Data Sheets",
"NDTI. Nondestructive Testing and Evaluation International",
"NDT.. Nuclear Data Tables",
"NeuL. Neuroscience Letters",
"NewA. New Astronomy",
"NewAR New Astronomy Reviews",
"NewSc New Scientist",
"NewSp New Space",
"NGFAW Nachrichtentechnische Gesellschaft Fachtagung ueber Antennen",
"NHCWP North Hollywood Calif Western Periodicals Co",
"NHESD Natural Hazards and Earth System Sciences Discussions",
"NHESS Natural Hazards and Earth System Sciences",
"NHTA. Numerical Heat Transfer Part A - Applications",
"NHTB. Numerical Heat Transfer Part B - Fundamentals",
"Nic1K Observatoire de Nice",
"nicm.rSpace Telescope NICMOS Instrument Science Report",
"NihOC Nihondaira Observatory Circular",
"NIMPA Nuclear Instruments and Methods in Physics Research A",
"NIMPB Nuclear Instruments and Methods in Physics Research B",
"NIMPR Nuclear Instruments and Methods in Physics Research",
"NInfo Nauchnye Informatsii",
"NINT. Nablyud. Iskusstvennykh Nebesnykh Tel",
"NISTJ National Institute of Standards and Technology Journal of Research",
"NISZ. Nabliudeniia Iskusstvennykh Sputnikov Zemli",
"NIUNA Napoli Istituto Universitario Navale Annali",
"NJMM. Neues Jahrbuch Mineralogie Monatshefte",
"NJPh. New Journal of Physics",
"NJSR. Netherlands Journal of Sea Research",
"NKG.. Nihon Kessho Gakkaishi",
"NLE.. Nonlinear Engineering",
"NML.. Nano-Micro Letters",
"NMTE. Nanoscale and Microscale Thermophysical Engineering",
"NN... Neural Networks",
"noao.pNOAO Proposal",
"NoDef Not Defined",
"NOGB. Nachr. Olbers-Ges. Bremen",
"NOHIC Nizamiah JAPAL Rangapur Observatories Hyderabad India Contributions",
"NoIGG Novosibirsk Institut Geologii i Geofiziki SO AN SSSR",
"NoIzN Novosibirsk Izdatel Nauka",
"Nonli Nonlinearity",
"NoPar Notes et Informations",
"NOSCA Observaciones Astronomicas Hechas en el Observatorio de Santiago de Chile",
"nova.pAAS Nova Highlights",
"NovIG Novosibirsk Institut Gidrodinamiki SO AN SSSR Dinamika Sploshnoi Sredy",
"NPAE. Nuclear Physics and Atomic Energy",
"NPGD. Nonlinear Processes in Geophysics Discussions",
"NPGeo Nonlinear Processes in Geophysics",
"NPhS. Nature Physical Science",
"npjAM npj Asia Materials",
"npjCA npj Climate and Atmospheric Science",
"npjCM npj Computational Mathematics",
"npjMG npj Microgravity",
"npjQI npj Quantum Information",
"npjQM npj Quantum Materials",
"npjRM npj Regenerative Medicine",
"npjSL npj Scientific of Learning",
"NPNDS Neutron Physics and Nuclear Data in Science and Technology",
"NPPP. Nuclear and Particle Physics Proceedings",
"NPPSB Nonequilibrium Problems in the Physical Sciences and Biology",
"NPUJ. Northwestern Polytechnical University Journal",
"NRA&A Nouvelle Revue d'Aeronautique et d'Astronautique",
"NRAON National Radio Astronomy Observatory Newsletter",
"nrao.pNational Radio Astronomy Observatory Press Release",
"NRAOP National Radio Astronomy Observatory Publications",
"NRAOR National Radio Astronomy Observatory Reprints",
"NRAOW National Radio Astronomy Observatory Workshop",
"NRL.. Nanoscale Research Letters",
"NROA. Nouvelle Revue d'Optique Appliquee",
"NROpt Nouvelle Revue d'Optique",
"NRRv. Naval Research Reviews",
"NRvEE Nature Reviews Earth and Environment",
"NRvHM New Review of Hypermedia and Multimedia",
"NSAP. Nonlinear, Statistical and Applied Physics",
"NSE.. Nuclear Science Engineering",
"NSMMT Nanoscale Systems Mathematical Modeling Theory and Applications",
"NSM.. Novel Superconducting Materials",
"NSSDC NSSDC Publication",
"NSTBL Notes Scientifiques et Techniques du Bureau des Longitudes",
"NSTIM Notes Scientifiques et Techniques de l'Institut de Mecanique Celeste",
"NTA.. Nonlinear Theory and Its Applications, IEICE",
"NTCo. Nondestructive Testing Communications",
"NTE.. Nondestructive Testing and Evaluation",
"NTN.. New Technology News",
"NTTRv NTT Review",
"NTvA. Novaya tekhn. v astron.",
"NUAAJ Nanjing University Aeronautics and Astronautics Journal",
"NuAlg Numerical Algorithms",
"NucFS Nuclear Fusion Special Supplement",
"NucFu Nuclear Fusion",
"NucIM Nuclear Instruments and Methods",
"nucl.earXiv Nuclear Experiment e-prints",
"nucl.tarXiv Nuclear Theory e-prints",
"NucPh Nuclear Physics",
"NucTe Nuclear Technology",
"NucTF Nuclear Technology Fusion",
"NUDTJ National University Defense Technology Journal",
"NuEnD Nuclear Engineering and Design",
"NUFEM Nagoya University Faculty Engineering Memoirs",
"NuGeo Nuclear Geophysics",
"NuMat Numerische Mathematik",
"NumHT Numerical Heat Transfer",
"NuPhA Nuclear Physics A",
"NuPhB Nuclear Physics B",
"NuPhS Nuclear Physics B Proceedings Supplements",
"NURIA Nagoya University Research Institute of Atmospherics Proceedings",
"NUSEM Nagoya University School Engineering Memoirs",
"NVS.. Nachrichtenblatt der Vereinigung der Sternfreunde",
"NWGot Nachrichten von der Gesellschaft der Wissenschaften zu Goettingen, Mathematisch-Physikalische Klasse",
"NW... Naturwissenschaften",
"NYASA Annals of the New York Academy of Sciences",
"NZJS. New Zealand Journal of Science",
"OAcJ. The Open Acoustics Journal",
"OACSC Observatorio Astronomico de Cordoba, Serie Contribuciones",
"OAeEJ The Open Aerospace Engineering Journal",
"OAJ.. The Open Astronomy Journal",
"OAORP Observations astronomiques faites a l'Observatoire royal de Paris",
"OAPJ. The Open Applied Physics Journal",
"OAP.. Odessa Astronomical Publications",
"OASJ. The Open Atmospheric Science Journal",
"OAst. Open Astronomy",
"OAWMN Oesterreichische Akademie Wissenschaften Mathematisch naturwissenschaftliche Klasse Sitzungsberichte Abteilung",
"OBN1K Observatoire de Besancon - CNES",
"Obser Observation pi",
"Obs.. The Observatory",
"ObVyS Obzory Vysokotemperaturnoi Sverkhprovodimosti",
"OCAM. Optimal Control Applications and Methods",
"OccN. Occultation Newsletter, International Occultation Timing Association (IOTA)",
"OcDyn Ocean Dynamics",
"Ocean Oceanus Summer",
"OcEng Ocean Engineering",
"Ocgy. Oceanology",
"OcMod Ocean Modelling",
"OCMPJ The Open Condensed Matter Physics Journal",
"OCPJ. The Open Chemical Physics Journal",
"OcScD Ocean Science Discussions",
"OcSci Ocean Science",
"OCSC. OAA Compututer Section Circular",
"OCzAS Ondrejov Czechoslovakia Czechoslovak Academy Sciences CAS Astronomical Institute Publications",
"Oecol Oecologia",
"OED.. El Observador de Estrellas Dobles",
"OEJV. Open European Journal on Variable Stars",
"OEng. Open Engineering",
"OERv. Opto-Electronics Review",
"OExpr Optics Express",
"OGC.. The Open Geology Journal",
"OGeo. Open Geosciences",
"OHJ.. The Open Hydrology Journal",
"OIDP. Optoelectronics, Instrumentation and Data Processing",
"OISNP Oxford Pergamon Press International Series on Natural Philosophy",
"OISTS Oxford Pergamon Press International Tables Selected Constants",
"OJA.. Open Journal of Acoustics",
"OJAp. The Open Journal of Astrophysics",
"OJAS. Open Journal of Applied Sciences",
"OJBp. Open Journal of Biophysics",
"OJFD. Open Journal of Fluid Dynamics",
"OJGeo Open Journal of Geology",
"OJMic Open Journal of Microphysics",
"Okean Okeanologiia",
"OLEB. Origins of Life and Evolution of the Biosphere",
"OMatS Open Material Sciences",
"OMEJ. The Open Mechanical Engineering Journal",
"OMExp Optical Materials Express",
"OMJ.. The Open Mechanics Journal",
"OMnJ. The Open Mineralogy Journal",
"OMN.. Optofluidics, Microfluidics and Nanofluidics",
"OMPJ. The Open Mineral Processing Journal",
"OMX.. Optical Materials: X",
"ONCP. Old and New Concepts of Physics",
"ONERA ONERA TP",
"ONJ.. The Open Nanoscience Journal",
"ONMJ. The Open Numerical Methods Journal",
"ONPPJ The Open Nuclear &amp",
"ONRAS Occasional Notes of the Royal Astronomical Society",
"OOcJ. The Open Oceanagraphy Journalurnal",
"OOEJ. The Open Ocean Engineering Journal",
"OOJ.. The Open Optics Journal",
"OOPS. Fundamentalnye Osnovy Opticheskoi Pamiati i Sredy",
"OOVRO Observations Owens Valley Radio Observatory",
"OPalJ The Open Paleontology Journal",
"OpAtO Optika Atmosfery i Okeana",
"OpAt. Optika Atmosfery",
"OPCJ. The Open Physical Chemistry Journal",
"OPhyJ Open Physics Journal",
"OPhy. Open Physics",
"OPJ.. Optics and Photonics Journal",
"OpMeP Optiko Mekhanicheskaia Promyshlennost",
"OPPJ. The Open Plasma Physics Journal",
"OPP.. Organic Photonics and Photovoltaics",
"OpPuT Optoelektronika i Poluprovodnikovaia Tekhnika",
"OpSCN Optical Sciences Center Newsletter",
"OpSp. Optika i Spektroskopiia",
"OptCo Optics Communications",
"OptEL Optoelectronics Letters",
"OptEn Optical Engineering",
"Optfl Optofluidics",
"OptFT Optical Fiber Technology",
"Optic Optica",
"Optik Optik",
"OptLE Optics and Lasers in Engineering",
"OptL. Optics Letters",
"OptLT Optics Laser Technology",
"OptMa Optical Materials",
"OptNa Optical Nanoscopy",
"OptN. Optics News",
"OptPE Optical Physics and Engineering",
"OptPN Optics & Photonics News",
"OptRv Optical Review",
"OptSp Optics and Spectroscopy",
"OQEle Optical and Quantum Electronics",
"OREJ. The Open Renewable Energy Journal",
"OrGeo Organic Geochemistry",
"Orion Orion: Zeitschrift f&uuml",
"Ori.. Orione",
"OrLi. Origins of Life",
"OrNav Ortung und Navigation",
"ORROE Occasional Reports of the Royal Observatory Edinburgh",
"ORSJ. The Open Remote Sensing Journal",
"OSFOT Observatoire de la Soci&eacute",
"OSID. Open Systems and Information Dynamics",
"Osir. Osiris",
"OSJaJ Oceanographical Society of Japan Journal",
"OSJ.. Ocean Science Journal",
"OslR. Institute of Theoretical Astrophysics Blindern Oslo Reports",
"OSpeJ The Open Spectroscopy Journal",
"OSPJ. The Open Signal Processing Journal",
"OSSJ. The Open Surface Science Journal",
"oss..pNASA OSS Proposal",
"OSUC. Observationes Astronomicas Insitutas in Specula Universitatis Caesareae Dorpatensis",
"OSuJ. The Open Superconductors Journal",
"OsUTR Osaka University Technology Reports",
"OtObI Otbor i Obrabotka Informatsii",
"O&T.. Observations et Travaux",
"OtPI. Otbor i Peredacha Informatsii",
"OVS.. Observation of Variable Stars",
"OxfOO Oxford University Observatory Observations",
"PABei Progress in Astronomy",
"PAB.. Publications of The Astrophysics Branch Ottawa",
"PadCR Osservatorio Astronomico di Padova Comunicazioni e Rassegne",
"PADEU Publications of the Astronomy Department of the Eotvos Lorand University",
"PAIB. Publications of the Astronomy Institute of Bonn",
"PAICU Publications of the Astronomical Institute of the Charles University",
"PAICz Publications of the Astronomical Institute of the Czechoslovak Academy of Sciences",
"PAIJ. Physics &amp",
"PAIKH Publikationen des Astrophysikalischen Instituts Koenigstuhl-Heidelberg",
"Palai PALAIOS",
"PAllO Publications of the Allegheny Observatory of the University of Pittsburgh",
"PalOc Paleoceanography",
"PAM.. Physics of Atoms and Molecules",
"PAN.. Physics of Atomic Nuclei",
"PAOS. Publications of the Astronomical Observatory of Sarajevo",
"PApCh Pure & Applied Chemistry",
"PApGe Pure and Applied Geophysics",
"PAPhS Proceedings of the American Philosophical Society",
"PApOp Pure Applied Optics",
"PA... Popular Astronomy",
"PApPh Pure and Applied Physics",
"ParC. Parallel Computing",
"PaReL Pattern Recognition Letters",
"PASAM Polish Academy of Science Arch Mech",
"PASA. Publications of the Astronomical Society of Australia",
"PASAS Polish Academy of Science Artificial Satellites",
"PASAu Proceedings of the Astronomical Society of Australia",
"PASIG Polish Academy of Sciences Institute of Geophysics Publications",
"PASJ. Publications of the Astronomical Society of Japan",
"PASK. Publications of the Academy of Science Kasakstan Sect. Astrobotanics",
"PASP. Publications of the Astronomical Society of the Pacific",
"PASRB Publications of the Astronomical Society Rudjer Boskovic",
"PAth. Publications of the Laborotory of Astronomy University of Athens",
"PATid PATid___Popular Astronomisk Tidskrift",
"PAUTx University of Texas Publications in Astronomy",
"PAZh. Pisma v Astronomicheskii Zhurnal",
"PBeiO Publications of the Beijing Astronomical Observatory",
"PBosO Publications of the Bosscha Observatory Lembang Indonesia",
"PBrn. Publications of the Astronomical Institute of the University of Borneo",
"PCAS. Proceedings of the California Academy of Sciences",
"PCat. Publications of Osservatorio Astrofisico di Catania",
"PCCP. Physical Chemistry Chemical Physics (Incorporating Faraday Transactions)",
"PCEA. Physics and Chemistry of the Earth A",
"PCEB. Physics and Chemistry of the Earth B",
"PCEC. Physics and Chemistry of the Earth C",
"PCED. Physics and Chemistry of the Earth Delta",
"PCE.. Physics and Chemistry of the Earth",
"PCHEI Physics in Collision: High-Energy ee/ep/pp Interactions",
"PCinO Publications of the Cincinnati Observatory",
"PCMLA Physics and Chemistry of Materials with Low-Dimensional Structures Series A",
"PCMLB Physics and Chemistry of Materials with Low-Dimensional Structures Series B",
"PCMLC Physics and Chemistry of Materials with Low-Dimensional Structures Series C",
"PCMLD Physics and Chemistry of Materials with Low-Dimensional Structures",
"PCM.. Physics and Chemistry of Minerals",
"PCMPS Protection and Control of Modern Power Systems",
"PCooO Publications of the Cook Observatory",
"PCopO Publikationer og mindre Meddeler fra Kobenhavns Observatorium",
"PCPS. Proceedings of the Cambridge Philosophical Society",
"PCSE. Physical Chemistry: Science and Engineering",
"PCS.. Physics and Chemistry in Space",
"PCTM. Physikalisch-Chemische Trenn- und Messmethoden",
"PCZNN Politechnika Czestochowska Zeszyty Naukowe Nauki Techniczne Mechanika",
"PDAO. Publications of the Dominion Astrophysical Observatory Victoria",
"PDAUC Publications of the Department of Astronomy University of Chile",
"PDDO. Publications of the David Dunlap Observatory",
"PDHO. Publications of Debrecen Heliophysical Observatory",
"PDiff Powder Diffraction",
"PDO.. Publications of the Dominion Observatory Ottawa",
"PDreO Publications of the Dresden Observatory",
"PDSS. NASA Planetary Data System",
"PDU.. Physics of the Dark Universe",
"PEEI. Physics and Evolution of the Earth's Interior",
"PEFPN Physica Energiae Fortis et Physica Nuclearis",
"PEPI. Physics of the Earth and Planetary Interiors",
"PEPS. Progress in Earth and Planetary Science",
"PerCo Perkins Observatory Contributions",
"PerMS Perceptual Motor Skills",
"PerOC Perth Observatory Communication",
"PFG.. PFG - Journal of Photogrammetry, Remote Sensing and Geoinformation Science",
"PFP.. Philosophy and Foundations of Physics",
"PFR.. Plasma and Fusion Research",
"PGAOI Pulkovo Glavnaia Astronomicheskaia Observatoriia Izvestiia",
"PGC.. Papers on Global Change IGBP",
"PGenA Publications of the Observatoire Geneve Series A",
"PGenB Publications of the Observatoire Geneve Series B",
"PgE.. Photogrammetric Engineering",
"PgERS Photogrammetric Engineering and Remote Sensing",
"PGLO. Publications of the Goethe Link Observatory",
"PGooO Publications of the Goodsell Observatory, Carleton College",
"Pg... Photogrammetria",
"PGro. Publications of the Kapteyn Astronomical Laboratory Groningen",
"PGZNM Politechnika Gdanska Zeszyty Naukowe Mechanika",
"PhApp Physics and its Applications",
"PhaTr Phase Transitions, A Multinational Journal",
"PhBio Physical Biology",
"PhB.. Physics Bulletin",
"PhChE Physics and Chemistry of Earth",
"PhChH PhysicoChemical Hydrodynamics",
"PhDT. Ph.D. Thesis",
"PhFlA Physics of Fluids A",
"PhFlB Physics of Fluids B",
"PhFl. Physics of Fluids",
"PhiJR Philips Journal Research",
"PhInt Photo Interpretation",
"PhiRR Philips Research Reports",
"PhiTR Philips Technical Review",
"PhLA. Physics Letters A",
"PhLB. Physics Letters B",
"PhLC. Physics Letters Section C Physics Reports C",
"PhLF. Physics Laser Fusion",
"PhL.. Physics Letters",
"PhLRv Physics of Life Reviews",
"PhMet Physics of Metals",
"PhNan Photonics and Nanostructures",
"Phoen Phoenix Mitteilungsblatt fuer Veraenderlichenbeobachter",
"PhoSp Photonics Spectra",
"Phot. Photoniques",
"PhPl. Physics of Plasmas",
"PhP.. Physics in Perspective",
"PhPro Physics Procedia",
"PhQE. Physics of Quantum Electronics",
"PhR.. Physics Reports",
"PhRvA Physical Review A",
"PhRvB Physical Review B",
"PhRvC Physical Review C",
"PhRvD Physical Review D",
"PhRvE Physical Review E",
"PhRvF Physical Review Fluids",
"PhRvI Physical Review Series I",
"PhRvL Physical Review Letters",
"PhRvM Physical Review Materials",
"PhRv. Physical Review",
"PhRvP Physical Review Applied",
"PhRvR Physical Review Research",
"PhRvS Physical Review Accelerators and Beams",
"PhRvX Physical Review X",
"PhSen Photonic Sensors",
"PhSRv Physical Sciences Reviews",
"PhSS. Physics of the Solid State",
"PhST. Physica Scripta Volume T",
"PhTea The Physics Teacher",
"PhTec Physics in Technology",
"PhT.. Physics Today",
"PhuZ. Physik in unserer Zeit",
"PhyA. Physica A Statistical Mechanics and its Applications",
"PhyBC Physica B+C",
"PhyBl Physikalische Bl&auml",
"PhyB. Physica B Condensed Matter",
"PhyC. Physica C Superconductivity",
"PhyD. Physica D Nonlinear Phenomena",
"PhyEd Physics Education",
"PhyE. Physica E Low-Dimensional Systems and Nanostructures",
"PhyEs Physics Essays",
"PhyG. Physikalische Gesellschaft",
"PhyGZ Physikalische Gesellschaft Z&uuml",
"PhyIn Physics International",
"PhylS Physiologist Supplement",
"PhyMe Physical Mesomechanics",
"PhyM. Physiological Measurement",
"PhyN. Physics Notes",
"PhyNr Physica Norvegica",
"PhyNY Physics New York",
"PhyOJ Physics Online Journal",
"PhyO. Physics Open",
"Phy.. Physica",
"PhyR. Physical Research",
"PhySB Physica Scripta B",
"physicarXiv Physics e-prints",
"Physi Physics",
"PhyS. Physica Scripta",
"PhyU. Physics Uspekhi",
"PhyW. Physics World",
"PhyZ. Physikalische Zeitschrift",
"PIAGL Publications de l'Institut d'Astronomie et de Geophysique Georges Lemaitre",
"PIAHS Proceedings of the International Association of Hydrological Sciences",
"PIASE Proceedings of the Indian Academy of Science, Earth and Planetary Sciences",
"PIGP. Proceedings of the Institute of General Physics, Adademy of the Sciences of Russia",
"PILOM Proceedings of the International Latitude Observatory at Mizusawa",
"PINSA Proceedings of the Indian National Science Academy Part A",
"PINSB Proceedings of the Indian National Science Academy Part B",
"PIRE. Proceedings of the IRE",
"PIstO Publications of the Istanbul University Observatory",
"PJAB. Proceeding of the Japan Academy, Series B",
"PJGeo Pakistan Journal of Geology",
"PJMPE Polish Journal of Medical Physics And Engineering",
"PKAO. Pyublikatskii Kievskoj Astronomicheskoj Observatorii",
"PKAS. Publication of Korean Astronomical Society",
"PKCat Publ. House Czech. Acad. Sci.",
"PKirO Publications of the Kirkwood Observatory of Indiana University",
"PKM.. Physik der Kondensierten Materie",
"PKUJ. Publikationen der Kaiserlichen Universitaets-Sternwarte Jurjew",
"PlAst Planetary Astronomy",
"PLDS. Physics of Low-Dimensional Structures",
"PLicO Publications of Lick Observatory",
"PLoSO PLoS ONE",
"PlPh. Plasma Physics",
"PlPhR Plasma Physics Reports",
"PLPla Observatory Astronomical La Plata Series Astronomies",
"PlREx Plasma Research Express",
"PlR.. Planetary Report",
"PLSCB PLoS Computational Biology",
"PlSci Planetary Science",
"PlST. Plasma Science and Technology",
"PMagA Philosophical Magazine, Part A",
"PMagB Philosophical Magazine, Part B",
"PMagL Philosophical Magazine Letters",
"PMag. Philosophical Magazine",
"PManO Publications of the Manila Observatory",
"PMatP Progress in Mathematical Physics",
"PMB.. Physics in Medicine and Biology",
"PMcCO Publications of the Leander McCormick Observatory",
"PMCPA PMC Physics A",
"PMCPB PMC Physics B",
"PMCPC PMC Physics C",
"PMetP Progress in Metal Physics",
"PMetR Papers in Meteorological Research",
"PMG.. Papers Meteorology Geophysics",
"PMMin Proper Motion Survey, University of Minnesota",
"PMM.. Physics of Metals and Metallography",
"PMO.. Perth Meridien Observations",
"PMP.. Powder Metallurgy Progress",
"PMRP. Progress in Medical Radiation Physics",
"PMTF. PMTF Zhurnal Prikladnoi Mekhaniki i Tekhnicheskoi Fiziki",
"PMtv. Facultad de Humanidades y Ciencias Universidad de la Republica Montevideo",
"PMunO Publications of the Munich Observatory",
"PNAOC Publications of the National Astronomical Observatories of China",
"PNAOJ Publications of the National Astronomical Observatory of Japan",
"PNAS. Proceedings of the National Academy of Science",
"PNAU. Proceedings of National Aviation University",
"PnGid Pnevmatika i Gidravlika",
"PNSBP Proceedings of the National Society of Black Physicists",
"PNSci Progress in Natural Science",
"PNSC. Proceedings of the National Science Council",
"POANC Publications of the Observatorie Astronomie Nacional Cerro Calan",
"PoAn. Postepy Astronautyki",
"PoAst Postepy Astronomii Krakow",
"POBeo Publications de l'Observatoire Astronomique de Beograd",
"POBol Publications of dell'Osservatorio Astronomie de Bologna",
"PoCom Polymer Composites",
"PODE. Dun Echt Observatory Publications",
"POHel Publications of the Astronomical Observatory Helsinki",
"POHP. Publications of the Observatoire Haute-Provence",
"PolAt Pollution Atmospherique",
"PolPh Polymer Physics",
"PolPP Poluprovodnikovye Pribory i ikh Primenenie",
"PolRe National Institute Polar Research Memoirs",
"PolSc Polar Science",
"PolSi Poliarnye Siianiia",
"PolTM Poluprovodnikovaia Tekhnika i Mikroelektronika",
"POLyo Publications of the Observatoire de Lyon",
"Polyt Polytechnica",
"PomAK Pomiary Automatyka Kontrola",
"PoMec Polymer Mechanics",
"POMic Publications of Michigan Observatory",
"POMil Pubblicazioni dell'Osservatorio Astronomico di Milano-Merate",
"POMin Publications of the Astronomical Observatory University of Minnesota",
"POPad Pubblicazioni dell'Osservatorio Astronomico di Padova",
"POPot Publikationen des Astrophysikalischen Observatoriums zu Potsdam",
"POrCo Progress in Organic Coatings",
"PorMe Poroshkovaia Metallurgiia",
"PoS.. Proceedings of Science",
"POStr Publication de l'Observatoire de Strasbourg",
"POTor Pubblicazioni Varie Fuori Serie dell'Osservatorio Astronomico di Torino",
"PotUr Potins d'Uranie",
"POVRO Publications of the Owens Valley Observatory",
"POxf. Publications University of Oxford Department of Astrophysics",
"PPCAS Publication of the Pomona College Astronomical Society",
"PPCF. Plasma Physics and Controlled Fusion",
"PPcPp Progress in Photochemistry and Photophysics",
"PPEE. Periodica Polytechnica Electrical Engineering",
"PPhI. Particle Physics Insights",
"PPh.. Papers in Physics",
"PPHTS Physical Properties of High Temperature Superconductors",
"PPME. Periodica Polytechnica Mechanical Engineering",
"PPMtO Publications of the Purple Mountain Observatory",
"PPNL. Physics of Particles and Nuclei Letters",
"PPN.. Physics of Particles and Nuclei",
"PPPLR Princeton Plasma Physics Laboratory Report",
"PPP.. Palaeogeography Palaeoclimatology Palaeoecology",
"PPSA. Proceedings of the Physical Society A",
"PPSB. Proceedings of the Physical Society B",
"PPSL. Proceedings of the Physical Society of London",
"PPS.. Proceedings of the Physical Society",
"PPTE. Periodica Polytechnica Transportation Engineering",
"PQE.. Progress in Quantum Electronics",
"PraAc Prague Academia",
"PrAA. Progress in Astronautics and Aeronautics",
"PrAeS Progress in Aerospace Sciences",
"PrAiA Problemy Arktiki i Antarktiki",
"Prama Pramana",
"PrA.. Progress in Astronomy",
"PrAst Practical Astronomy",
"PrAtO Leningrad Gidrometeoizdat Sovremennye Problemy Atmosfernoi Optiki",
"PrBio Problemy Bioniki",
"PrCmg Problems of Cosmogeny",
"PRCO. Publications of the Riverview College Observatory",
"PrDRV Problemy Difraktsii i Rasprostraneniia Voln",
"PrECS Progress in Energy and Combustion Science",
"PrEM. Probabilistic Engineering Mechanics",
"PrEne Progress in Energy",
"PrEPS Procedia Earth and Planetary Science",
"PreR. Precambrian Research",
"PrExP Propellants and Explosives Pyrotechnics",
"PrEx. Propellants and Explosives",
"PrFA. Problemy Fiziki Atmosfery",
"PrFKL Problemy Iadernoi Fiziki i Kosmicheskikh Luchei",
"PRFVT Plastiques Renforces Fibres de Verre Textile",
"PRIAA Proceedings of the Royal Irish Academy Section A",
"PRIAN Proceedings of the Research Institute of Atmospherics, Nagoya University",
"Prib. Priborostroenie",
"PrICA Proceedings of the ICA",
"PriMM Prikladnaia Matematika i Mekhanika",
"PriMP Prikladnaia Matematika i Programmirovanie",
"PriM. Prikladnaia Mekhanika",
"PRI.. Physics Research International",
"Prir. Priroda",
"PriTE Pribory i Tekhnika Eksperimenta",
"Priv. Private Communication",
"PrKFi Problemy Kosmicheskoi Fiziki",
"PrMas Problemy Mashinostroeniia",
"PrMS. Progress in Materials Science",
"PRNAA Proceedings of the Royal Netherlands Academy of Arts and Sciences",
"PrOce Progress in Oceanography",
"PROE. Publications of the Royal Observatory of Edinburgh",
"PrOpt Progess in Optics",
"ProTe Promyshlennaia Teplotekhnika",
"PRPER Physical Review Physics Education Research",
"PrPG. Progress in Physical Geography",
"PrPh. Progress in Physics",
"PrPNP Progress in Particle and Nuclear Physics",
"PRP.. Pattern Recognition in Physics",
"PrPro Problemy Prochnosti",
"PrSP. Problemy Sluchainogo Poiska",
"PrSS. Progress In Surface Science",
"PRSTP Physical Review Special Topics Physics Education",
"PrTE. Problemy Tekhnicheskoi Elektrodinamiki",
"PrTGE Problemy Teorii Gravitatsii i Elementarnykh Chastits",
"PrTPT Problemy Teploenergetiki i Prikladnoi Teplofiziki",
"PrUkr Akademiia Nauk Ukrains koi RSR Dopovidi Matematika Prirodoznavstvo Tekhnichni Nauki",
"PrVP. Proceedings of Vibration Problems",
"PSAIL Pubblicazioni della Stazione Astronomica Internazionale di Latitudine",
"PSAO. Publications of the Shaanxi Astronomical Observatory",
"PSCDS Publication Speciale du Centre de Donnees Stellaires",
"PSCEC Physical Sciences Series of the Commission of European Communities",
"PSci. Pour la Science",
"PShaO Publications of the Shaanxi Astronomy Observatory",
"PSJ.. The Planetary Science Journal",
"PSL.. Physics of Solids and Liquids",
"PSprO Publications of the Sproul Observatory",
"PSSAR Physica Status Solidi Applied Research",
"PSSBR Physica Status Solidi B Basic Research",
"PSSCR Physica Status Solidi C Current Topics",
"PSSNN Poliarnye Siianiia i Svechenie Nochnogo Neba",
"P&SS. Planetary and Space Science",
"PSSRR Physica Status Solidi Rapid Research Letters",
"PSST. Plasma Sources Science Technology",
"PSZNM Politechnika Slaska Zeszyty Naukowe Mechanika",
"PTarO Publications of the Tartu Astrofizica Observatory",
"PTasO Publications of the Tashkent Astronomical Observatory",
"PTCP. Progress in Theoretical Chemistry and Physics",
"PTEP. Progress of Theoretical and Experimental Physics",
"PThPh Progress of Theoretical Physics",
"PThPS Progress of Theoretical Physics Supplement",
"PTPPB Physics and Technology of Particle and Photon Beams",
"PUAMA Poznan Uniwersytet im Adama Mickiewicza Seria Akustyka",
"PUAMF Poznan Uniwersytet im Adama Mickiewicza Seria Fizyka",
"PUAms Publications of the Astronomical Institute of the University of Amsterdam",
"PUPFA Publications of the University of Pennsylvania Flower Astronomical Observatory",
"PUSK. Publication der Koeniglichen Sternwarte in Kiel",
"PUSNO Publications of the U.S. Naval Observatory Second Series",
"PVasO Publications of the Vassar College Observatory",
"PVSS. Royal Astronomical Society of New Zealand Publications of Variable Star Section",
"PVVO. Publications of the Van Vleck Observatory",
"PWasO Publications of the Washburn Observatory",
"PWHHO Publications of West Hendon House Observatory, Sunderland",
"PWP.. Physics of Wave Phenomena",
"PW&SO Publications of the Warner & Swasey Observatory",
"PYerO Publications of the Yerkes Observatory",
"PYunO Publications of the Yunnan Observatory",
"PZETF Pisma v Zhurnal Eksperimentalnoi i Teoreticheskoi Fiziki",
"PZhTF Pisma v Zhurnal Tekhnischeskoi Fiziki",
"PZ... Peremennye Zvezdy",
"PZP.. Peremennye Zvezdy Prilozhenie",
"QApMa Quarterly of Applied Mathematics",
"QBSA. Quarterly Bulletin on Solar Activity",
"QBS.. Quantum Beam Science",
"QJMAM Quarterly Journal of Mechanics and Applied Mathematics",
"QJMat The Quarterly Journal of Mathematics",
"QJPAM The Quarterly Journal of Pure and Applied Mathematics",
"QJRAS Quarterly Journal of the Royal Astronomical Society",
"QJRMS Quarterly Journal of the Royal Meteorological Society",
"QMQM. Quantum Measurements and Quantum Metrology",
"QREI. Quality Reliability Engineering International",
"QSRv. Quaternary Science Reviews",
"QS&T. Quantum Science and Technology",
"QuEle Quantum Electronics",
"QuFin Quantitative Finance",
"QuInt Quaternary International",
"QuIP. Quantum Information Processing",
"QuOpt Quantum Optics",
"QuRes Quaternary Research",
"RAA.. Research in Astronomy and Astrophysics",
"RadA. Radio Astronomy: Journal of the Society of Amateur Radio Astronomers,",
"RadEf Radiation Effects",
"Radel Radioehlektronika",
"RadIn Radio industry",
"RadM. Radiation Measurements",
"Rad.. Radiant, Journal of the Dutch Meteor Society",
"RadR. Radiation Research",
"RaEE. Radio and Electronic Engineer",
"RaEl. Radiotekhnika i Elektronika",
"RaF.. Radiofizika",
"RALR. Rutherford Appleton Laboratory Report",
"RAOU. Recherches Astronomiques de l'Observatoire d'Utrecht",
"RaPC. Radiation Physics and Chemistry",
"RA... Ricerche Astronomiche",
"RaRLJ Radio Research Laboratory, Journal",
"RaRLR Radio Research Laboratory, Review",
"RAROC Results of Astronomical Observations made at the Royal Observatory, Cape of Good Hope",
"RArtR Rock Art Research",
"RaSc. Radio Science",
"RaT.. Radiotekhnika",
"RBrFi Revista Brasileira de Fisica",
"RCD.. Regular and Chaotic Dynamics",
"RCMS. Rapid Communications in Mass Spectrometry",
"RDTM. Radiation Detection Technology and Methods",
"Rech. La Recherche",
"REDS. Radiation Effects and Defects in Solids",
"REEP. Radio Engineering and Electronic Physics",
"REES. Renewable Energy and Environmental Sustainability",
"RELEA Latin American Journal of Astronomy Education",
"RemS. Remote Sensing",
"ReNEv Research in Nondestructive Evaluation",
"ResPh Results in Physics",
"RF... Raumfahrtforschung",
"RFrG. Revue Francaise de Geotechnique",
"RFrM. Revue Francaise de Mecanique",
"RGAO. Astronomical Observations made at the Royal Observatory at Greenwich",
"RGG.. Reports on Geodesy and Geoinformatics",
"RGOB. Royal Greenwich Observatory Bulletins",
"RGRH. Rep. Hydrograph. Res. Japan",
"RHRJ. Report of Hydrographic Researches in Japan",
"RIG.. Rivista Italiana di Geofisica",
"Rise. Rise Hvezd",
"RJARA Russian Journal of Astrophysical Research Series A",
"RJMP. Russian Journal of Mathematical Physics",
"RJPCA Russian Journal of Physical Chemistry A",
"RLOpt Research Letters in Optics",
"RLPhy Research Letters in Physics",
"RLSFN Rendiconti Lincei. Scienze Fisiche e Naturali",
"RMFMR Rock Mechanics Felsmechanik Mecanique des Roches",
"RMRE. Rock Mechanics and Rock Engineering",
"RMTME USSR Rept Machine Tools Metalworking Equipment JPRS UMM",
"RMxAA Revista Mexicana de Astronomia y Astrofisica",
"RMxFE Revista Mexicana de Fisica E",
"RMxF. Revista Mexicana de Fisica",
"RMxFS Revista Mexicana de Fisica Supplement",
"RNAAS Research Notes of the American Astronomical Society",
"RNAOJ Report of the National Astronomical Observatory of Japan",
"RNAO. Resultados del Observatorio Nacional Argentino",
"RNISZ Rezultaty Nabliudenii Iskusstvennykh Sputnikov Zemli",
"RNOST Research News & Opportunities in Science and Theology",
"RoAJ. Romanian Astronomical Journal",
"ROAn. Royal Observatory Annals",
"Robot Robotica",
"ROCi. Republic Observatory Johannesburg Circular",
"ROCor Resultados del Observatorio Nacional Argentino en Cordoba",
"Roczn Rocznik Astronomiczny Observatorjum Krakowskiego Krakow",
"RoDok Rossijskaya Akademiya Nauk Doklady",
"RoIE. Rossiiskaia Akademiia Nauk Izvestiia Energetika",
"RoIET Rozprawy Inzynierskie Engineering Transactions",
"RoIMT Rossijskaya Akademiya Nauk Izvestiya Mekhanika Tverdogo Tela",
"RoIMZ Rossiiskaia Akademiia Nauk Izvestiia Mekhanika Zhidkosti i Gaza",
"RoIn. Rozprawy Inzynierskie",
"RoISF Rossiiskaia Akademiia Nauk Izvestiia Seriia Fizicheskaia",
"RoIzF Rossijskaya Akademiya Nauk Izvestiya Seriya Fizicheskaya",
"RoJPh Romanian Journal of Physics",
"ROLun Reports of the Lund Observatory",
"RomCo Osservatorio Astronomico di Roma su Monte Mario Contributi Scientifici",
"RoRPh Romanian Reports in Physics",
"RosOB Observatorio Astronomico Municipal de Rosario Argentia  Boletin",
"RpBAM USSR Report Space Biology Aerospace Medicine JPRS USB",
"RpCCA USSR Report Cybernetics Computers Automation Technology JPRS UCC",
"RpEEE USSR Rept Electron Elec Eng JPRS UEE",
"RpEE. USSR Rept Eng Equipment JPRS UEQ",
"RpEn. USSR Rept Energy JPRS UEN",
"RpESc USSR Report Earth Sciences JPRS UES",
"RPFSU Research Papers Faculty of Materials Science and Technology Slovak University of Technology",
"RpMP. Reports on Mathematical Physics",
"RpMSM USSR Rept Mater Sci Met JPRS",
"RpPhM USSR Rept Phys Math JPRS UPM",
"RPPh. Reports on Progress in Physics",
"RPRA. Radio Physics and Radio Astronomy",
"RpSBA USSR Rept Space Biol Aerospace Med Sep",
"RpScT JPRS Report Science Technology USSR Space",
"RpSpR USSR Report Space",
"RpTr. USSR Rept Transportation JPRS UTR",
"R&QE. Radiophysics and Quantum Electronics",
"RRDAP Recent Research Development in Applied Physics",
"RRDBB Recent Research Development in Biophysics and Biochemistry",
"RRDBC Recent Research Development in Biophysical Chemistry",
"RRDCP Recent Research Development in Chemical Physics",
"RRDPC Recent Research Development in Physical Chemistry",
"RRDPF Recent Research Development in Physics of Fluids",
"RRDP. Recent Research Development in Physics",
"RRDSP Recent Research Development in Statistical Physics",
"RRMPA Revue Roumaine de Mathematiques Pures et Appliquees",
"RRPRA Russian Radio Physics and Radio Astronomy",
"RRP.. Research Reports in Physics",
"RScEd Research in Science Education",
"RScI. Review of Scientific Instruments",
"RSCT. Transactions of the Royal Society of Canada",
"RSEMS Remote Sensing Electro Magnetic Spectrum",
"RSEnv Remote Sensing of Environment",
"RSEPS Proceedings of the Royal Society of Edinburgh",
"RSESS Remote Sensing in Earth Systems Sciences",
"RSET. Transaction of the Royal Society of Edinburgh",
"RSN&R Royal Society of London Notes & Records",
"RSNSW Journal and Proceedings of the Royal Society of New South Wales",
"RSOS. Royal Society Open Science",
"RSPSA Proceedings of the Royal Society of London Series A",
"RSPSB Proceedings of the Royal Society of London Series B",
"RSPS. Proceedings of the Royal Society of London Series I",
"RSPTA Philosophical Transactions of the Royal Society of London Series A",
"RSPTB Philosophical Transactions of the Royal Society of London Series B",
"RSPT. Philosophical Transactions of the Royal Society of London Series I",
"RSPUT Report Series of the Department of Physics and Science, University of Turku",
"RSQ.. Remote Sensing Quarterly",
"RSTEd Research in Science and Technological Education",
"RST.. Revue Scientifique et Technique CECLES CERS",
"RTP.. Research Trends in Physics",
"RTRE. Radiotekhnika Tecommunications Radio Engineering Radio Engineering",
"RTrTe Revista Transporturilor si Telecomunicatiilor",
"RTSRE Robotic Telescope, Student Research and Education Proceedings",
"RuAer Russian Aeronautics",
"RuCRv Russian Chemical Reviews",
"RuGG. Russian Geology and Geophysics",
"Ruimt Ruimtevaart",
"RuMaS Russian Mathematical Surveys",
"RuMet Russian Metallurgy",
"RuPhJ Russian Physics Journal",
"RvAc. Revue d'Acoustique",
"RvAMS Reviews on Advanced Materials Science",
"RvAqS Reviews in Aquatic Sciences",
"RvA.. Revista Astronomica Organo de la Asociacion Argengina Amigos de la Astronomia Buenos Aires",
"RvAST Reviews of Accelerator Science and Technology",
"RvCF. Revista Colombiana de Fisica",
"RvGeo Reviews of Geophysics",
"RvGeS Reviews of Geophysics Supplement",
"RvGSP Reviews of Geophysics and Space Physics",
"RvMad Revista Real Acad. Ciencias Exact. Fis. Nat. Madrid",
"RvMaP Reviews in Mathematical Physics",
"RvMA. Reviews in Modern Astronomy",
"RvMG. Reviews in Mineralogy and Geochemistry",
"RvMin Reviews of Mineralogy",
"RvMPP Reviews of Modern Plasma Physics",
"RvMP. Reviews of Modern Physics",
"RvMPS Reviews of Modern Physics Supplement",
"RvOp. Reviews of Optics",
"RvPA. Revue de Physique Appliquee",
"RvPD. Revue du Palais de la Decouverte",
"RvPhy Reviews in Physics",
"RvPP. Reviews of Plasma Physics",
"RvPT. Review of Physics in Technology",
"RvRP. Revue Roumaine de Physique",
"RvRRL Reviews of the Radio Research Laboratory",
"RvRST Revue Roumaine des Sciences Techniques Serie de Mecanique Appliquee",
"RvT.. Revue Technique Thomson CSF",
"RvTS. Rivista Tecnica Selenia",
"RWPWZ Rostock Wilhelm Pieck Universitaet Wissenschaftliche Zeitschrift Mathematisch Naturwissenschaftliche Reihe",
"RWTHA Rheinisch Westfaelische Technische Hochschule Aerodynamisches Institut Abhandlungen",
"rxte.pRXTE Proposal",
"RZh.. Referationyj Zhurnal",
"SAAOC South African Astronomical Observatory Circular",
"SAAOR South African Astronomical Observatory Republic",
"Sadha Sadhana",
"SAERI Seoul Korea Atomic Energy Research Institute",
"SAJPh South African Journal of Physics",
"SAJSc South African Journal of Science",
"SAMPJ SAMPE Journal",
"SAMPQ SAMPE Quarterly",
"SAnAp Supplements aux Annales d'Astrophysique",
"SanS. Separata Universidad de Chile Departamento de Astronomia Santiago",
"SANUG Srpska Akademiia Nauka i Umetnosti Glas Odeljenje Tekhnichkikh Nauka",
"SAOSR SAO Special Report",
"SASn. Studia Astronomica Sinica",
"SASS. Society for Astronomical Sciences Annual Symposium",
"SatCo Satellite Communications",
"SBARM SBARMO Bulletin",
"SbMat Sbornik: Mathematics",
"SBuil Sustainable Buildings",
"SCA.. Studii si Cercetari de Astronomie Bucuresti",
"SCB.. Seminars in Cancer Biology",
"ScChA Science in China A: Mathematics",
"ScChB Science in China B: Chemistry",
"ScChD Science China Earth Sciences",
"ScChE Science in China E: Technological Sciences",
"ScChG Science in China: Physics, Mechanics and Astronomy",
"ScChM Science in China e-Engineering & Materials Science",
"ScEdR Science Education Research",
"Sc&Ed Science & Education",
"SchpJ Scholarpedia",
"SciAm Scientific American",
"SciA. Science Advances",
"SciB. Scientia (Bologna)",
"SciDi Science Dimension",
"SciDr Scientific Drilling",
"SciEd Science Education",
"SciIn Science and Innovation",
"SciMo The Scientific Monthly",
"Scim. Scientometrics",
"SciNa The Science of Nature",
"SciN. Science News",
"Sci.. Science",
"SciSn Scientia Sinica",
"Scis. Sciences",
"ScMM. Scripta Metallurgica et Materialia",
"SCMP. Studies in Condensed Matter Physics",
"ScM.. Scripta Metallurgica",
"SCoA. Smithsonian Contributions to Astrophysics",
"SCoK. Smithsonian Contributions to Knowledge",
"SCPMA Science China Physics, Mechanics, and Astronomy",
"ScPPL SciPost Physics Lecture Notes",
"ScPPP SciPost Physics Proceedings",
"ScPP. SciPost Physics",
"ScPr. Science Progress",
"ScReE Scholarly Research Exchange",
"SCSA. Science and Culture Series: Astrophysics",
"SCSMP Science China Series Mathematics Physics Astronomy Technological Sciences",
"SCSP. Science and Culture Series: Physics",
"ScTea The Science Teacher",
"ScTEn Science of the Total Environment",
"Sc&Te Sciences et Techniques",
"SeAc. Sensors and Actuators",
"SECM. Science and Engineering of Composite Materials",
"SedG. Sedimentary Geology",
"Sedim Sedimentology",
"SEEJ. Society of Environmental Engineers Journal",
"SEGeo Seismology and Exploration Geophysics",
"SeiKa Seikei-Kakou",
"Semic Semiconductors",
"SenAR Sendai Astronomiaj Raportoj",
"SenIm Sensing and Imaging",
"SerAJ Serbian Astronomical Journal",
"SeScT Semiconductor Science Technology",
"SFCh. Science Foundation in China",
"SFPTB Societe Francaise de Photogrammetrie et de Teledetection Bulletin",
"SFSN. Scripta Faculty Science Nat. Ujep Brunensis Physica",
"SGC.. Stratigraphy and Geological Correlation",
"SGeo. Surveys in Geophysics",
"SGORS Studies in Geophysical Optics and Remote Sensing",
"S&GS. Science and Global Security",
"SHAN. Society for History of Astronomy News",
"SHEP. Surveys in High Energy Physics",
"SHH.. Stochastic Hydrology and Hydraulics",
"ShMeS Shape Memory and Superelasticity",
"SHMPS Sources in the History of Mathematics and Physical Sciences",
"SHM.. Self-Healing Materials",
"SHPMP Studies in the History and Philosophy of Modern Physics",
"ShWav Shock Waves",
"SIAMR SIAM Review",
"SIAM. Society of Industrial and Applied Mathematics",
"SIBAN Sofia Izdatel Bolgarskoi Akademii Nauk",
"SIDPQ SID Proceedings Quarter",
"SiFoE Siemens Forschungs und Entwicklungsberichte",
"SiFTZ Sibirskii Fiziko Tekhnicheskii Zhurnal",
"SIGMA SIGMA",
"SigPr Signal Processing",
"Sig.. Signal",
"SiMol Single Molecules",
"SImpa Software Impacts",
"Simul Simulation",
"SISN. Science Information Systems Newsletter",
"SiSSR Akademiia Nauk SSSR Sibirskoe Otdelenie Izvestiia Seriia Tekhnicheskie Nauki",
"Situ. Situ",
"SJADS SIAM Journal on Applied Dynamical Systems",
"SJAM. SIAM Journal of Applied Mathematics",
"SJCE. Slovak Journal of Civil Engineering",
"SJCO. SIAM Journal of Control Optimization",
"SJMA. SIAM Journal of Mathematical Analysis",
"SJNA. SIAM Journal on Numerical Analysis",
"SJRUE Scientific Journal of Riga Technical University. Environmental and Climate Technologies",
"SJRUP Scientific Journal of Riga Technical University. Power and Electrical Engineering",
"SkInq Skeptical Inquirer",
"SkyN. Sky News",
"SlaOb Slaboproudy Obzor",
"SLSci Space Life Sciences",
"SMArc Solid Mechanics Archives",
"SMaS. Smart Material Structures",
"SMat. Soft Matter",
"SmCES Smithsonian Contributions to the Earth Sciences",
"Smith Smithsonian",
"SMSPS Stephan Mueller Special Publication Series",
"SMS.. Scientific Modeling and Simulation SMNS",
"SMTS. Soprotivlenie Materialov i Teoriia Sooruzhenii",
"SNG.. Schweizerische Naturforschende Gesellschaft",
"SoByu Soobshcheniya Byurakanskoj Observatorii Akademiya Nauk Armyanskoj SSR Erevan",
"SoCe. Solar Cells",
"SoEnM Solar Energy Materials",
"SoEn. Solar Energy",
"SoftX SoftwareX",
"SoGru Akademiia Nauk Gruzii Soobshcheniia",
"SOILD SOIL Discussions",
"SoilS Soil Science",
"SoKie Sonderdrucke der Sternwarte Kiel",
"SOLA. SOLA - Scientific Online Letters on the Atmosphere",
"SolED Solid Earth Discussions",
"SolE. Solid Earth",
"SoMue Sonderdrucke Universitaet Muenster Astronomisches Institut",
"Sonne Sonne",
"SoPh. Solar Physics",
"SoSAO Soobshcheniya Spetsial'noj Astrofizicheskoj Observatorii",
"SoShe Soobshchenie Shemakhinskoj Astrofizicheskoj Observatorii",
"SoSht Soobshcheniya Gosudarstvennogo Astronomicheskogo Instituta",
"SoSyR Solar System Research",
"SouSt Southern Stars",
"SovAe Soviet Aeronomii",
"Space Space",
"Spark Spark, the AAS Education Newsletter",
"SPBra Scientific Proceedings Faculty of Mechanical Engineering STU in Bratislava",
"SpCoB Space Communication Broadcasting",
"SpCom Space Communications",
"SpecL Spectroscopy Letters",
"SpEd. Space Education",
"SpFl. Spaceflight",
"SPhAc Soviet Physics Acoustics",
"SPhD. Soviet Physics Doklady",
"Spika Spika",
"Spin. Spin",
"SPJCE Selected Scientific Papers - Journal of Civil Engineering",
"SpMar Space Markets",
"SpMME Space Medicine Medical Engineering",
"SpPol Space Policy",
"SpPow Space Power",
"SpRBu Space Research Bulgaria",
"SpReT Space Research Today",
"SPRMD Space Power - Resources, Manufacturing and  Development",
"SpScT Space Science and Technology",
"SPTP. Soviet Physics Technical Physics",
"SpT.. Space Technology",
"SPTS. Sensor Physics and Technology Series",
"sptz.pSpitzer Proposal",
"Spvw. Spaceview",
"SpWd. Space World",
"SpWdU Space World U",
"SpWdW Space World W",
"SpWdY Space World Y",
"SpWea Space Weather",
"SrLJP Sri Lankan Journal of Physics",
"SRL.. Surface Review and Letters",
"SRMO. Specula Regia Monachiensi Observationes astronomicae",
"SRPI. Safety and Reliability of Power Industry",
"SRToh Sci. Rep. Tohoku Univ. Eighth Ser.",
"SRXPh SRX Physics",
"SSASJ Soil Science Society of America Journal",
"SScEd Studies in Science Education",
"SSCom Solid State Communications",
"SSCP. Springer Verlag Springer Series on Chemical Physics",
"SScT. Speculations in Science and Technology",
"SSEle Solid State Electronics",
"SSEp. Springer Verlag Springer Series on Electrophysics",
"SSGSR Springer Verlag Springer Series on Group Geophysics Space Research",
"SSHMP Sources and Studies in the History of Mathematics and Physical Sciences",
"SSI.. Space Science Instrumentation",
"SSOS. Springer Verlag Springer Series on Optical Sciences",
"SSPAR Solid State Physics Advances in Research and Applications",
"SSPAS Solid State Physics Advances in Research and Applications Supplement",
"SSPMA Scientia Sinica Physica, Mechanica &amp",
"SSPRv Space and Solar Power Review",
"SSRvA Soviet Scientific Reviews A Physics Reviews",
"SSRvC Soviet Scientific Reviews C Mathematical Physics Reviews",
"SSRvD Soviet Scientific Reviews D Physicochemical Biology Reviews",
"SSRv. Space Science Reviews",
"SSSAJ Soil Science Society of America Journal",
"SSSci Solid State Sciences",
"SSSMP Scientia Sinica Series Mathematical Physical Technical Sciences",
"SSSSc Springer Series in Surface Sciences",
"SSS.. Social Studies of Science",
"SSSSS Springer Verlag Springer Series on Solid State Sciences",
"SSSyn Springer Verlag Springer Series on Synergetics",
"SSTec Solid State Technology",
"SSTor Studia Societatis Scientiarum Torunensis Sectio F Astronomia",
"SSWP. Springer Verlag Springer Series on Wave Phenomena",
"STAdM Science and Technology of Advanced Materials",
"StaGP Starlink General Paper",
"StAM. Studies in Applied Mathematics",
"StarB Starlink Bulletin",
"StarC Starlink Cookbook",
"StarD StarDate Magazine",
"StarG Starlink Guide",
"StaSc Statistical Science",
"StaSN Starlink System Note",
"StAst Strolling Astronomer",
"StaUN Starlink User Note",
"StCeF Studii si Cercetari de Fizica",
"StCeM Studii si Cercetari Matematice",
"StCMA Studii si Cercetary de Mecanica Aplicata",
"STECF Space Telescope European Coordinating Facility Newsletter",
"Sterb Der Sternenbote Monatsschrift fuer Oesterreichs Amateur-astronomen",
"STERJ Solar Terrestrial and Environmental Research Japan",
"Stern Die Sterne",
"Sterz Sternzeit Mitteilungen der Astrnomischen Vereinigungen Aachen",
"StGeo Studies in Geophysics",
"StGG. Studia Geophysica et Geodaetica",
"StGM. Studia Geotechnica et Mechanica",
"StHCG Studies in High Energy Physics Cosmology and Gravitation",
"StHEP Studies in High Energy Physics",
"StHMP Studies in the History of Mathematics and the Physical Sciences",
"STIA. NASA STI/Recon Technical Report A",
"STICA Space Technology Industrial and Commercial Applications",
"Stiin Stiinta",
"STIN. NASA STI/Recon Technical Report N",
"stis.rSpace Telescope STIS Instrument Science Report",
"StMat Strength of Materials",
"StMet Statistical Methodology",
"STMP. Springer Tracts in Modern Physics",
"StNws ASTM Standardization News",
"StoAn Stockholms Observatoriums Annaler",
"StoOR Stockholms Observatoriums Reports",
"STP.. Solar-Terrestrial Physics",
"Strai Strain",
"StReL Staub Reinhaltung Luft",
"Stroj Strojarstvo",
"StrOp Structural Optimization",
"S&T.. Sky and Telescope",
"StSky Star Sky",
"STSSP Selected Topics in Solid State Physics",
"Sttur Studies in turbulence",
"StuMa Studia Mathematica",
"STVF. Samoletostroenie Tekhnika Vozdushnogo Flota",
"suba.pSubaru Proposal",
"SuEa. Sustainable Earth",
"SuMi. Superlattices and Microstructures",
"SunGe Sun and Geosphere",
"Sunwo Sunworld",
"SurIA Surface and Interface Analysis",
"SurSc Surface Science",
"SurSL Surface Science Letters",
"SurSR Surface Science Reports",
"SurSS Surface Science Spectra",
"SuScT Superconductor Science Technology",
"Sust. Sustainability",
"SuTMP Surface Topography: Metrology and Properties",
"SUVSR Scandinavian Union of Amateur Astronomers Variable Star Section",
"SvAer Soviet Aeronautics",
"SvAL. Soviet Astronomy Letters",
"SvApM Soviet Applied Mechanics",
"SvA.. Soviet Astronomy",
"SVD.. Shock Vibration Digest",
"SvGeo Soviet Geologia",
"SVICB Shock Vibration Information Center Shock Vibration Bulletin",
"SVICD Shock Vibration Information Center Shock Vibration Digest",
"SVICI Shock Vibration Information Center Shock Vibration Inform Digest",
"SVICP Shock Vibration Information Center Shock Vibration Computer Programs",
"SvJNP Soviet Journal of Nuclear Physics",
"SvJOT Soviet Journal of Optical Technology",
"SvJPP Soviet Journal of Plasma Physics",
"SvJQE Soviet Journal of Quantum Electronics",
"SVPCS Springer Verlag Springer Series on Physics Chemistry Space",
"SvPhA Soviet Physics Astronomy",
"SvPhJ Soviet Physics Journal",
"SvPhU Soviet Physics Uspekhi",
"SvPro Svarochnoe Proizvodstvo",
"SvRP. Soviet Radiophysics",
"SvUNT Sverdlovsk Uralskii Nauchnyi Tsentr AN SSSR",
"S&W.. Sterne und Weltraum",
"SydOP Sydney Observatory Papers",
"SyTec Systems Technology",
"SZF.. Solnechno-Zemnaya Fizika",
"SZPA. SIRIUS. Zeitschrift fuer Populaere Astronomie",
"TAASS Topics in Astrophysics, Astrononmy, and Space Science",
"TAEMm Tokyo Metropolitan College Aeronautical Engineering Memoirs",
"TamCo Astronomical Contributions from the University of South Florida Tampa",
"TAM.. Theoretical and Applied Mechanics",
"TANEs Tartu Akademiia Nauk Estonskoi SSR",
"TApPh Topics in Applied Physics",
"TAPS. Transactions of the American Philosophical Society",
"TarOT Tartu Astrofuusika Observatoorium Teated",
"TBBM. Techniques of Biochemical and Biophysical Morphology",
"TCaPS Transactions of the Cambridge Philosophical Society",
"TCD.. The Cryosphere Discussions",
"TCPh. Topics in Current Physics",
"TCry. The Cryosphere",
"TDAPR Telecommunications and Data Acquisition Progress Report",
"Tech. Technology",
"TecN. Technical News",
"TecRv Technology Review",
"Tecto Tectonics",
"Tectp Tectonophysics",
"TeEng Technological Engineering,",
"TekEl Tekhnicheskaia Elektrodinamika",
"Telet Telettra S",
"TelIn Telematics Informatics",
"TellA Tellus Series A",
"TellB Tellus Series B Chemical and Physical Meteorology B",
"Tell. Tellus",
"TeLoA Technika Lotnicza i Astronautyczna",
"TeMAE Terrestrial Magnetism and Atmospheric Electricity (Journal of Geophysical Research)",
"TeMag Terrestrial Magnetism (Journal of Geophysical Research)",
"TeNov Terra Nova",
"TeoEl Teoreticheskaia Elektrotekhnika",
"TeoPM Teoreticheskaia i Prikladnaia Mekhanika",
"TeoVP Teoriia Veroiatnostei i ee Primeneniia",
"TePhL Technical Physics Letters",
"Teplo Teploenergetika",
"Tepsg Teplofizicheskie svoistva gazov",
"TepT. Teplofizika i Teplotekhnika",
"TepVT Teplofizika Vysokikh Temperatur",
"TerCo Osservatorio Astronomico di Collurania Teramo Contributi",
"TerMm Osservatorio Astronomico di Collurania Teramo Memorie ed Osservazioni",
"TerNC Osservatorio Astronomico di Collurania Teramo Note e Comunicazioni",
"Tesla TESLA Electronics",
"TETB. Thyssen Edelstahl Technische Berichte",
"TFFAP Teoriia Funktsii Funktsionalnyi Analiz i ikh Prilozheniia",
"TFizG Teploobmen i Fizicheskaia Gazodinamika",
"Th&Ae Thermophysics and Aeromechanics",
"ThAFM Theoretical and Applied Fracture Mechanics",
"ThApC Theoretical and Applied Climatology",
"ThAst Theoretical Astrophysics",
"ThCFD Theoretical and Computational Fluid Dynamics",
"ThEng Thermal Engineering",
"TIOA. Tomsk Institut Optiki Atmosfery CO AN SSSR",
"TISCI Transactions of the Institute of Systems, Control and Information Engineers",
"TITas Tsirkulyar Astronomicheskogo Instituta Akademiya Nauk Uzbekskoj SSR",
"TIUCS Transactions of the International Union for Cooperation in Solar Research",
"TIzSS Tbilisi Izdatel Sabchota Sakartvelo",
"TJAu. Telecommunication Journal of Australia",
"TJJPT Tuijin Jishu Journal of Propulsion Technology",
"TJPh. Turkish Journal of Physics",
"TJSAI Transactions of the Japanese Society for Artificial Intelligence",
"TJSIE Transactions of The Japanese Society of Irrigation, Drainage and Rural Engineering",
"TLHSQ Transactions of the Literary and Historical Society of Quebec",
"TMatR Translational Materials Research",
"TMKF. Technische Mitteilungen Krupp Forschungsberichte",
"TMOPR Telecommunications and Mission Operations Progress Report",
"TMPGO Tagung ueber Mathematische Probleme Geodaesie Oberwolfach West Germany Bulleting Geodesique",
"TMP.. Theoretical and Mathematical Physics",
"TNEK. Teplovye Napriazheniia Elementakh Konstruktsii",
"TNKS. Tochnost i Nadezhnost Kiberneticheskikh Sistem",
"TNSAN Transient Name Server AstroNote",
"TNSCR Transient Name Server Classification Report",
"TNSFR Transient Name Server Fast Radio Bursts",
"TNSTR Transient Name Server Discovery Report",
"ToASC Torino Accademia delle Scienze Classe di Scienze Fisiche Matematiche e Naturali Atti",
"ToIzL Technisch oekonomische Informationen zivilen Luftfahrt",
"TokAB Tokyo Astronomical Bulletin",
"TokRe Tokyo Astronomical Observatory Reprints",
"TOMar Travaux de l'Observatoire de Marseille",
"TosRv Toshiba Review",
"TouCE Toulouse Cepadues Editions",
"TOYal Transactions of the Astronomical Observatory of Yale University",
"TPAG. Theory and Practice of Applied Geophysics",
"TPhCh Topics in Physical Chemistry",
"TPhy. Techniques of Physics",
"TRACE Transactions of the Japan Society of Refrigerating and Air Conditioning Engineers",
"TrAeR Transactions on Aerospace Research",
"TraGe Travaux Geophysiques",
"TrAGU Transactions, American Geophysical Union",
"TrAlm Trudy Astrofizicheskogo Instituta Alma-Ata",
"TrDus Trudy Instituta Astrofiziki Dushanbe",
"TreP. Osservatorio Privato Specola Ariel Treviso Italia Pubblicazione",
"TRET. Telecommunications and Radio Engineering Telecommunications",
"TrGeo Treatise on Geochemistry",
"TrGRC Geothermal Resources Council Transactions",
"TrGru Tiflis Izdatel Metsniereba Akademiia Nauk Gruzinskoi SSR Matematicheskii Institut Trudy",
"TriP. Osservatorio Astronomico di Trieste Pubblicazioni",
"TrITA Institut Teoreticheskoi Astronomii Trudy",
"TriTr STLE Tribology Transactions",
"TrKaz Trudy Kazanskaia Gorodkoj Astronomicheskoj Observatorii",
"TrKra Seminar Kraevym Zadacham Trudy",
"TrLen Trudy Astronomicheskoj Observatorii Leningrad",
"TrLit Trudy Akademiia Nauk Litovskoi",
"TrMMO Trudy Moskovskoe Matematicheskoe Obshchestvo",
"TrOS. Transactions of the Optical Society",
"TrPet Trudy Seminar imeni G Petrovskogo",
"TrPul Trudy Glavnoj Astronomicheskoj Observatorii v Pulkovo",
"TrRig Trudy Astrofiz. Lab. Riga",
"TrSht Trudy Gosudarstvennogo Astronomicheskogo Instituta",
"TrSpT Transactions of Space Technology Japan",
"TrSSR Trudy Akademiia Nauk SSSR Fizicheskii Institut",
"TrSta Trudy Instituta Astrofiziki Stalinabad",
"TrTas Trudy Tashkentskoj Astronomicheskoj Observatorii",
"TrTIM Tiflis Izdatel Metsniereba Akademiia Nauk Gruzinskoi SSR Institut Geofiziki Trudy",
"TrTsA TsAGI Trudy",
"TrTsI TsIAM Trudy",
"TSDMO Tellus Series Dynamic Meteorology and Oceanography",
"TSE.. Thermal Science and Engineering",
"TSF.. Thin Solid Films",
"TsHUJ Tsing Hua University Journal",
"TSICE Transactions of the Society of Instrument and Control Engineers",
"TsLvo Tsirkulyar Astronomicheskoj Observatorii Lvov",
"TsPul Tsirkulyary Glavnoj Astronomicheskoj Observatorii i Pulkove",
"TSRSG Tohoku University Science Reports Series Geophysics",
"TsShe Tsirkulyar Shemakhinskoj Astrofizicheskoj Observatorii",
"TSSLW Travaux de la Societe des Sciences et des Letters de Wroclaw",
"TsSta Tsirkulyar Stalinabadskoj Astronomicheskoj Observatorii",
"TsTas Tsirkulyar Tashkentskoj Astronomicheskoj Observatorii",
"TsVse Tsirkulyar Vses. astron.-geod. o-va",
"TTP.. Trends in Theoretical Physics",
"TTSP. Transport Theory and Statistical Physics",
"TUAID Tuebingen Universitaet Astronomisches Institut Diplomarbeit",
"TUASB Tokyo University Institute of Space and Aeronautical Science Bulletin",
"TUASR Tokyo University Institute of Space and Aeronautical Science Report",
"TUFEJ Tokyo University Faculty of Engineering Journal Series",
"TUFER Tokyo Denki University Faculty of Engineering Research Reports",
"TUISR Tokyo University Institute Industrial Science Report",
"TUnGG Technische Univ Geodesy Global Geodyn",
"TurTe Turbulentnye techeniia",
"TvOC. Transvaal Observatory Circular",
"UCAFR Universitas Comeniana Acta Facultatis Rerum Naturalium Physica",
"UCLAP Astronomical Papers University of California Los Angeles",
"UECBu University Electro Communications Bulletin",
"UGC.. Nova Acta Regiae Soc. Sci. Upsaliensis Ser. V",
"UGSJR U S Geological Survey Journal Research",
"UISTS San Diego CA Univelt Inc Science Technology Series",
"UkFiZ Ukrainskii Fizicheskii Zhurnal",
"UkJPO Ukrainian Journal of Physical Optics",
"UkMaZ Ukrainskii Matematicheskii Zhurnal",
"UltIm Ultrasonic Imaging",
"Ultmi Ultramicroscopy",
"Ultra Ultrasonics",
"UMAM. Uspekhi Mekhaniki Advances Mechanics",
"UMIB. Unione Matematica Italiana Bollettino",
"Umsch Umschau",
"UMt1K Universite de Montpellier",
"UNAer Universita di Napoli Aeritalia S",
"UnECR University Electro Communications Reports",
"UniCl Universe Classroom",
"Unive Universitas",
"Univ. Universe",
"UNPSA United Nations Programme on Space Applications",
"UppAn Uppsala Astronomical Observatory Annals",
"UppOR Uppsala Astronomical Observatory Reports",
"Urani Urania (Krakow)",
"UrBar Urania (Bracelona)",
"UsFiN Uspekhi Fizicheskikh Nauk",
"USGSP U.S. Geological Survey Professional Paper",
"USGS. U.S. Geological Survey Report",
"USNOA Astronomical Observations made at the U.S. Naval Observatory",
"USNOC U.S. Naval Observatory Circulars",
"USNOM Astronomical and Meteorological Observations made at the U.S. Naval Observatory",
"USNOO Observations made at the U.S. Naval Observatory",
"USOC. Unified System Orbit Computation USOC",
"UtMat Utilitas Mathematica",
"UtrOv Utrechtse Sterrekundige Overdrukken",
"Vacuu Vacuum",
"VAC.. Voies Aviation Civile Fall Winter",
"VADMT VKI New Approaches in the Description and Modeling of Turbulence",
"VADVS VKI Advanced Design of Ventilation Systems",
"VAFC. VKI Axial Flow Compressors",
"VAG.. Vierteljahresschrift der Astronomischen Gesellschaft",
"VANTS Voprosy Atomnoi Nauki i Tekhniki Seriia Fizika Plazmy i Problemy Upravliaemykh Termoiadernykh Reaktsii",
"Vasio Vasiona",
"VatAR Specola Astronomica Vaticana Annual Reports",
"VatCo Specola Astronomica Vaticana Comunicazione",
"VatMA Specola Astronomica Vaticana Miscellanea Astronomica",
"VatOP Vatican Observatory Publications",
"VatPS Specola Astronomica Vaticana Pubblicazioni Serie Seconda",
"VatRA Specola Astronomica Vaticana Richerche Astronomiche",
"VatRS Specola Astronomica Vaticana Ricerche Spettroscopiche",
"VA... Vistas in Astronomy",
"VBLT. VKI Boundary Layers in Turbomachines",
"VCCPP VKI Combined Cycles for Power Plants",
"VCFDI VKI Computational Fluid Dynamics for Industrial Flows",
"VCGFV VKI Computer Graphics Flow Visualization and Computational Fluid Dynamics",
"VDIF. VDI Forschungsheft",
"VDIZF VDI Zeitschriften Fortschritt Berichte Reihe Stroemungstechnik",
"VDIZ. VDI Z",
"VeABD Veroeffentlichungen des Astronomischen Rechen-Instituts zu Berlin-Dahlem",
"VeARI Veroeffentlichungen des Astronomischen Rechen-Instituts Heidelberg",
"VeBab Veroeffentlichungen der Sternwarte Babelsberg",
"VeBam Veroeffentlichungen der Remeis-Sternwarte zu Bamberg",
"VeBB. Veroeffentlichungen der Universitaetssternwarte zu Berlin-Babelsberg",
"VeBKI Veroeffentlichungen des Bayerische Kommission Int. Erdmessung",
"VeBoc Veroeffentlichungen des Astronomischen Instituts der Ruhr-Universitaet Bochum",
"VeBon Veroeffentlichungen des Astronomisches Institute der Universitaet Bonn",
"VeFra Veroeffentlichungen des Astronomisches Institute der Universitaet Frankfurt",
"VeGG. Veroeffentlichungen der Geod. Geophys",
"VeGoe Veroeffentlichungen der Universitaets-Sternwarte zu Goettingen",
"VeHei Veroeffentlichungen der Badischen Sternwarte zu Heidelberg",
"VeJen Veroeffentlichungen der Universitaets-Sternwarte zu Jena",
"VeKAB Veroeffentlichungen des Koeniglichen Astronomischen Rechen-Instituts zu Berlin",
"VeKar Veroeffentlichungen der Grossherzoglichen Sternwarte zu Karlsruhe",
"VeKaz Akademiia Nauk Kazakhskoi SSR Vestnik",
"VeKha Vestnik Khar'kov Universitet",
"VeKie Vestnik Kievskogo Universiteta Seriya Astronomii",
"VeKoe Veroeffentlichungen der Universitaets-Sternwarte Koenigsberg Pr.",
"VeLdn Verslag van den staat der Sterrewacht te Leiden",
"VeLei Veroeffentlichungen der Universitaetssternwarte zu Leipzig",
"VeLen Leningradskii Universitet Vestnik Matematika Mekhanika Astronomiia",
"VeLGU Vestnik LGU",
"VeMos Vestnik Moskovskogo Universiteta Seriya 3 Fizika Astronomiya",
"VeMun Veroeffentlichungen der Sternwarte Munchen",
"VeNav Akademiia Navuk BSSR Vestsi Seryia Fizika Tekhnichnykh Navuk",
"Verme Vermessungstechnik",
"Vertf Vertiflite",
"Vert. Vertica",
"Vesmi Vesmir",
"VeSon Veroeffentlichungen der Sternwarte Sonneberg",
"VeSSR Akademiia Nauk SSSR Vestnik",
"VETT. Voprosy Elektroniki Tverdogo Tela",
"VeWFS Veroeffentlichung der Wilhelm Foerster Sterwarte",
"VeZPE Veroffentlichungen des Zentralinstituts Physik der Erde",
"VGTET VKI Gas Turbine Engine Transient Behaviour",
"VIAEA Vienna International Atomic Energy Agency",
"VICFD VKI An Introduction to Computational Fluid Dynamics",
"ViGeo Vissha Geodeziia",
"ViHei Veroeffentlichungen der Badischen Landes-Sternwarte zu Heidelberg",
"VIHE. VKI Industrial Heat Exchangers",
"VilCo Villanova University Observatory Contributions",
"VilOB Vilnius Astronomijos Observatorijos Biuletenis",
"VIMT. VKI An Introduction to Modeling Turbulence",
"VISBD Vibration Inst Shock Vibration Digest",
"VisKi Visnik Kiiv. Univ., Fiz.-Mat. Nauki, Astron",
"ViUkr Akademiia Nauk Ukrains koi RSR Visnik",
"VJS.. Virginia Journal of Science",
"VKAWA Verhandelingen der Koninklijke Akademie van Wetenschappen te Amsterdam",
"VKha. Vestnik Khar'kovskogo Universiteta",
"VKie. Veroeffentlichungen der Universitaets-Sternwarte Kiel",
"VKILV VKI Laser Velocimetry",
"VKIMT VKI Measurement and Techniques",
"VKIRT VKI Radial Turbines",
"VKISP VKI Spacecraft Propulsion",
"VMATP VKI Modeling and Applications of Transport Phenomena in Porous Media",
"VMed. Vierteljahrschrift f&uuml",
"VMHT. VKI Methodology Hypersonic Testing",
"VMKAN Verslagen en Mededeelingen der Kon. Academie van Wetenschappen, Afd. Natuurkunde",
"VMOIP Voprosy Metrologicheskogo Obespecheniia Izmereniia Parametrov Tekhnologicheskikh Lazerov",
"VMSAI Video Memorie della Societa Astronomica Italiana",
"VMTA. VKI Measurement Techniques in Aerodynamics",
"VNGG. VKI Numerical Grid Generation",
"VNG.. Vierteljahrsschrift der Naturforschenden Gesellschaft in Z&uuml",
"VNMFT VKI Numerical Methods for Flows in Turbomachinery",
"VnMP. Vychislitelnye Metody i Programmirovanie",
"VnPM. Vychislitelnaia i Prikladnaia Matematika",
"VopDP Voprosy Dinamiki i Prochnosti",
"VopGA Voprosy Gidrodinamiki Atmosfery",
"VopK. Voprosy Kibernetiki",
"VopTP Voprosy Teorii Plazmy",
"VossZ Vossische Zeitung",
"VoTAS Voprosy Teorii Atomnykh Stolknovenii",
"VPIDV VKI Particle Image Displacement Velocimetry",
"VSD.. Vehicle System Dynamics, International Journal of Vehicle Mechanics and Mobility",
"VSSCi Royal Astronomical Society of New Zealand Variable Star Section Circulars",
"VTJ.. Vitro Technical Journal",
"VTSAU Voprosy Teorii Sistem Avtomaticheskogo Upravleniia",
"VTSF. VKI Turbulent Shear Flows",
"VVRD. VKI Vibration Rotor Dynamics",
"WaMot Wave Motion",
"WASP. Water Air and Soil Pollution",
"WatWa Water Waves",
"WavEl Wave Electronics",
"WBWA. Weltraumfahrt. Beitraege zur Weltraumforschung und Astronautik",
"WCD.. Weather and Climate Dynamics",
"WCRp. World Climate Report",
"WCS.. Weather, Climate and Society",
"WearB Wear B",
"Wear. Wear",
"WeiEn Weight Engineering",
"WeldJ Welding Journal",
"Welt. Die Weltall",
"Werk. Werkgroepnieuws",
"wfc..rSpace Telescope WFC Instrument Science Report",
"WFINw IAU Working Group on Wide-Field Imaging, Newsletter",
"wfir.pNASA WFIRST Proposal",
"wfpc.rSpace Telescope WFPC2 Instrument Science Report",
"WiEng Wind Engineering",
"WiEn. Wind Energy",
"WinAR Annual Report of the Windsor Observatory, New South Wales",
"WisBB Monatsber. Deutsch. Akad Wissenschaftliche Berlin",
"WisBT Wissenschaftliche Berichte AEG Telefunken",
"WisZe Wissenschaftliche Zeitschrift",
"WJCMP World Journal of Condensed Matter Physics",
"WJM.. World Journal of Mechanics",
"WJNSE World Journal of Nano Science and Engineering",
"WJNST World Journal of Nuclear Science and Technology",
"wps..pNASA WPS Proposal",
"WRCM. Waves in Random and Complex Media",
"WRM.. Waves in Random Media",
"WRR.. Water Resources Research",
"WSAAA Workshop Series of the Asociacion Argentina de Astronomia",
"W&S.. Waerme und Stoffuebertragung",
"Wszec Wszechswiat",
"WtFor Weather and Forecasting",
"Wthr. Weather",
"Wuli. Wuli",
"xmm..pXMM-Newton Press Release",
"xmm..pXMM-Newton Proposal",
"XRS.. X-ray Spectrometry",
"YaFiz Yadernaya Fizika",
"YalAR Annual report of the Astronomer of the Winchester Observatory of Yale College",
"YalRY Reports for the year presented by the Board of Managers of the Observatory of Yale University to the President and Fellows",
"YamC. Yamamoto Circular",
"yCatp VizieR Online Data Catalog (other)",
"yCat. VizieR Online Data Catalog",
"YerOB Bulletin of the Yerkes Observatory of the University of Chicago",
"YUFEM Yamaguchi University Faculty of Engineering Memoirs",
"YUTR. Yamaguchi University Technology Reports",
"ZaDN. Zagadnienia Drgan Nieliniowych",
"ZAGeo Zeitschrift fur Angewandte Geographie",
"ZaLab Zavodskaia Laboratoriia",
"ZaMM. Zeitschrift Angewandte Mathematik und Mechanik",
"ZaMP. Zeitschrift Angewandte Mathematik und Physik",
"ZAPhy Zeitschrift fur Angewandte Physik",
"ZaTsA TsAGI Uchenye Zapiski",
"ZA... Zeitschrift fur Astrophysik",
"ZEAPC Zeitschrift f&uuml",
"ZeIE. Zeitschrift elektrische Informations und Energietechnik",
"ZeMet Zeitschrift fur Meteorologie",
"ZemVs Zemlia i Vselennaia",
"Zenit Zenit",
"ZePAN Zeitschrift Physik Atomic Nuclei",
"ZEVGA Zeitschrift fur Eisenbahnwesen und Verkehrstechnik Glasers Annalen",
"ZFlu. Zeitschrift fur Flugwissenschaften",
"ZFlWe Zeitschrift fur Flugwissenschaften und Weltraumforschung",
"ZGeo. Zeitschrift fur Geophysik",
"ZGlGl Zeitschrift fur Gletscherkunde und Glazialgeologie",
"ZGmS. Zeitschrift fur Geomorphologie Supplement",
"ZGm.. Zeitschrift fur Geomorphologie",
"ZhETF Zhurnal Eksperimentalnoi i Teoreticheskoi Fiziki",
"ZhPhy Zhurnal Physik",
"ZhPmR ZhETF Pisma Redaktsiiu",
"ZhPS. Zhurnal Prikladnoi Spektroskopii",
"ZhTFi Zhurnal Tekhnicheskoi Fiziki",
"ZiZa. Ziran Zazhi",
"ZKMP. Zeitschrift fur Kristallographie Mineralogie und Petrographie",
"ZKS.. Zeitschrift fur Kristallographie Supplements",
"ZK... Zeitschrift fur Kristallographie",
"ZMetl Zeitschrift fur Metallkunde",
"ZMP.. Zeitschrift f&uuml",
"ZNatA Zeitschrift Naturforschung Teil A",
"ZNPFK Zhurnal Nauchnoi i Prikladnoi Fotografii i Kinematografii",
"ZPCF. Zeitschrift fur Physikalische Chemie Frankfurt",
"ZPCNF Zeitschrift fur Physikalische Chemie Neue Folge",
"ZPCW. Zeitschrift fur Physikalische Chemie Wiesbaden",
"ZPC.. Zeitschrift fur Physikalische Chemie",
"ZPhyA Zeitschrift fur Physik A Hadrons and Nuclei",
"ZPhyB Zeitschrift fur Physik B Condensed Matter",
"ZPhyC Zeitschrift fur Physik C Particles and Fields",
"ZPhyD Zeitschrift fur Physik D Atoms Molecules Clusters",
"ZPhy. Zeitschrift fur Physik",
"Zprav Zpravodaj VZLU",
"ZvDeb Zvaigsnota Debess",
"ZVer. Zeitschrift Vermessungswes.",
"ZVMMF Zhurnal Vychislitelnoi Matematiki i Matematicheskoi Fiziki",
"ZWer. Zeitschrift Werkstofftechnik",
"TDM.. 2D Materials",
"TDR.. 3D Research",
};
const int njournals = sizeof( journals ) / sizeof( journals[0] );
