% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_read.R
\name{bi_read}
\alias{bi_read}
\title{Bi Read}
\usage{
bi_read(read, vars, dims, missval.threshold, coord_name, vector, thin, verbose)
}
\arguments{
\item{read}{either a path to a NetCDF file, or a NetCDF connection created using \code{nc_open}, or a \code{\link{libbi}} object from which to read the output}

\item{vars}{variables to read; if not given, all will be read}

\item{dims}{factors for dimensions}

\item{missval.threshold}{upper threshold for the likelihood}

\item{coord_name}{name of coord dimension (if any)}

\item{vector}{if TRUE, will return results as vectors, not data.frames}

\item{thin}{thinning (keep only 1/thin of samples)}

\item{verbose}{if TRUE, will print variables as they are read}
}
\value{
list of results
}
\description{
This function reads all variable from a NetCDF file or the output of a
\code{\link{libbi}} object.
The file can be specified as a string to the filepath, in which
case a NetCDF connection is opened, or directly as a NetCDF connection.
}
\examples{
example_output_file <- system.file(package="rbi", "example_output.nc")
d <- bi_read(example_output_file)
}

