% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actor.R
\name{ActorDigest}
\alias{ActorDigest}
\alias{get_acdig_data}
\alias{get_acdig_value}
\alias{put_acdig_data}
\alias{put_acdig_value}
\alias{read_acdig_value}
\alias{write_acdig_value}
\alias{create_acdig_keys}
\title{Read and write Actor Digest Data}
\usage{
get_acdig_data(x, z, dimension, db)

get_acdig_value(x, z, dimension, db)

put_acdig_data(values, x, z, dimension, db)

put_acdig_value(value, x, z, dimension, db)

read_acdig_value(rawdata)

write_acdig_value(value)

create_acdig_keys(x, z, dimension)
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{db}{A bedrockdb object.}

\item{values}{A list of character vectors.
If \code{x} is missing, the names of \code{values} will be taken as the keys.}

\item{value}{A character vector.}

\item{rawdata}{A raw vector.}
}
\value{
\code{get_acdig_values()} returns a vector of actor keys.
\code{get_acdig_data()} returns a named list of the of the values
returned by \code{get_acdig_value()}.
}
\description{
Actor digests store a list of all entities in a chunk; however
they are not chunk data and use their own prefix. The key format
for actor digest data is acdig:x:z:dimension.

\code{get_acdig_data()} and \code{get_acdig_value()} load ActorDigest
data from \code{db}.  \code{get_acdig_value()} supports loading
only a single value.

\code{put_acdig_data()} and \code{put_acdig_value()} store ActorDigest data into \code{db}.

\code{read_acdig_value()} and \code{write_acdig_value()} decode and encode
ActorDigest data respectively.

\code{create_acdig_keys()} creates keys for ActorDigest data.
}
\seealso{
\link{Actors}, \link{Entity}
}
