% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{bedrock_random}
\alias{bedrock_random}
\alias{bedrock_random_seed}
\alias{bedrock_random_state}
\alias{bedrock_random_get_uint}
\alias{bedrock_random_get_int}
\alias{bedrock_random_get_float}
\alias{bedrock_random_get_double}
\title{Random Number Generation for Minecraft}
\usage{
bedrock_random_seed(value)

bedrock_random_state(new_state = NULL)

bedrock_random_get_uint(n, max)

bedrock_random_get_int(n, min, max)

bedrock_random_get_float(n, min, max)

bedrock_random_get_double(n)
}
\arguments{
\item{value}{a scalar integer}

\item{new_state}{a raw vector}

\item{n}{number of observations.}

\item{min, max}{lower and upper limits of the distribution. Must be finite.
If only one is specified, it is taken as \code{max}. If neither is specified,
the default range is used.}
}
\description{
Bedrock Edition's central random number algorithm is MT19937. However, R's
MT19937 code is not compatible with Bedrock's. These routines provide an API
that is compatible with Bedrock's.

\code{bedrock_random_seed()} seeds the random number generator.

\code{bedrock_random_state()} returns the current state of the random number
generator as a raw vector.

\code{bedrock_random_get_uint()} returns a 32-bit random integer.
Default range is \verb{[0, 2^32-1]}.

\code{bedrock_random_get_int()} returns a 31-bit random integer.
Default range is \verb{[0, 2^31-1]}.

\code{bedrock_random_get_float()} returns a random real number.
Default range is \verb{[0.0, 1.0)}.

\code{bedrock_random_get_double()} returns a random real number
Default range is \verb{[0.0, 1.0)}.
}
\examples{
# seed the global random number generator
bedrock_random_seed(5490L)

# save and restore rng state
saved_state <- bedrock_random_state()
bedrock_random_get_uint(10)
bedrock_random_state(saved_state)
bedrock_random_get_uint(10)
}
