% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{age.pMC}
\alias{age.pMC}
\title{Calculate pMC values from C14 ages}
\usage{
age.pMC(mn, sdev, ratio = 100, decimals = 3)
}
\arguments{
\item{mn}{Reported mean of the 14C age.}

\item{sdev}{Reported error of the 14C age.}

\item{ratio}{Most modern-date values are reported against \code{100}. If it is against \code{1} instead, use \code{1} here.}

\item{decimals}{Amount of decimals required for the pMC value.}
}
\value{
pMC values from C14 ages.
}
\description{
Calculate pMC values from radiocarbon ages
}
\details{
Post-bomb dates are often reported as pMC or percent modern carbon. Since Bacon expects radiocarbon ages, 
this function can be used to calculate pMC values from radiocarbon ages. The reverse function of \link{pMC.age}.
}
\examples{
  age.pMC(-2000, 20)
  age.pMC(-2000, 20, 1)
}
\references{
Blaauw, M. and Christen, J.A., Flexible paleoclimate age-depth models using an autoregressive 
gamma process. Bayesian Anal. 6 (2011), no. 3, 457--474. 
\url{https://projecteuclid.org/euclid.ba/1339616472}
}
\seealso{
\url{http://www.chrono.qub.ac.uk/blaauw/manualBacon_2.3.pdf}
}
\author{
Maarten Blaauw, J. Andres Christen
}
