% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_shadow.R
\name{add_shadow}
\alias{add_shadow}
\title{Add Shadow}
\usage{
add_shadow(hillshade, shadowmap, max_darken = 0.7)
}
\arguments{
\item{hillshade}{A three-dimensional RGB array or 2D matrix of shadow intensities.}

\item{shadowmap}{A matrix that incidates the intensity of the shadow at that point. 0 is full darkness, 1 is full light.}

\item{max_darken}{Default 0.7. The lower limit for how much the image will be darkened. 0 is completely black,
1 means the shadow map will have no effect.}
}
\value{
Shaded texture map.
}
\description{
Multiplies a texture array or shadow map by a shadow map.
}
\examples{
#Raytrace the `volcano` elevation map and add that shadow to the output of sphere_shade()
shadowmap = ray_shade(volcano)

volcano \%>\%
 sphere_shade() \%>\%
 add_shadow(shadowmap) \%>\%
 plot_map()
 
#Increase the intensity of the shadow:
volcano \%>\%
 sphere_shade() \%>\%
 add_shadow(shadowmap,0.3) \%>\%
 plot_map()
}
