% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst.R
\name{convert-fst}
\alias{convert-fst}
\alias{convert_fst_to_hdf5}
\alias{convert_fst_to_csv}
\title{Convert 'fst' files to other formats}
\usage{
convert_fst_to_hdf5(fst_path, hdf5_path, exclude_names = NULL)

convert_fst_to_csv(fst_path, csv_path, exclude_names = NULL)
}
\arguments{
\item{fst_path}{path to 'fst' file}

\item{hdf5_path}{path to 'HDF5' file; if file exists before the conversion,
the file will be erased first. Please make sure the files are backed up.}

\item{exclude_names}{table names to exclude}

\item{csv_path}{path to 'csv' file; if file exists before the conversion,
the file will be erased first. Please make sure the files are backed up.}
}
\value{
\code{convert_fst_to_hdf5} will return a list of data saved to 'HDF5';
\code{convert_fst_to_csv} returns the normalized 'csv' path.
}
\description{
'HDF5', 'csv' are common file formats that can be easily
read into 'Matlab' or 'Python'
}
