% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd-niftyreg.R
\name{niftyreg_coreg}
\alias{niftyreg_coreg}
\alias{cmd_run_niftyreg_coreg}
\title{Register 'CT' to 'MR' images via \code{'NiftyReg'}}
\usage{
niftyreg_coreg(
  ct_path,
  mri_path,
  coreg_path = NULL,
  reg_type = c("rigid", "affine", "nonlinear"),
  interp = c("trilinear", "cubic", "nearest"),
  verbose = TRUE,
  ...
)

cmd_run_niftyreg_coreg(
  subject,
  ct_path,
  mri_path,
  reg_type = c("rigid", "affine", "nonlinear"),
  interp = c("trilinear", "cubic", "nearest"),
  verbose = TRUE,
  dry_run = FALSE,
  ...
)
}
\arguments{
\item{ct_path, mri_path}{absolute paths to 'CT' and 'MR' image files}

\item{coreg_path}{registration path, where to save results; default is
the parent folder of \code{ct_path}}

\item{reg_type}{registration type, choices are \code{'rigid'},
\code{'affine'}, or \code{'nonlinear'}}

\item{interp}{how to interpolate when sampling volumes, choices are
\code{'trilinear'}, \code{'cubic'}, or \code{'nearest'}}

\item{verbose}{whether to verbose command; default is true}

\item{...}{other arguments passed to \code{\link[ravetools]{register_volume}}}

\item{subject}{'RAVE' subject}

\item{dry_run}{whether to dry-run the script and to print out the command
instead of executing the code; default is false}
}
\value{
Nothing is returned from the function. However, several files will
be generated at the 'CT' path:
\describe{
\item{\code{'ct_in_t1.nii'}}{aligned 'CT' image; the image is
also re-sampled into 'MRI' space}
\item{\code{'CT_IJK_to_MR_RAS.txt'}}{transform matrix from volume 'IJK'
space in the original 'CT' to the 'RAS' anatomical coordinate in 'MR'
scanner}
\item{\code{'CT_RAS_to_MR_RAS.txt'}}{transform matrix from scanner 'RAS'
space in the original 'CT' to 'RAS' in 'MR' scanner space}
}
}
\description{
Supports 'Rigid', 'affine', or 'non-linear' transformation
}
